/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.conflict.tags;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.swing.table.DefaultTableModel;
import org.openstreetmap.josm.command.ChangeCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.RelationToChildReference;
import org.openstreetmap.josm.gui.conflict.tags.RelationMemberConflictDecision;
import org.openstreetmap.josm.gui.conflict.tags.RelationMemberConflictDecisionType;
import org.openstreetmap.josm.gui.util.GuiHelper;

public class RelationMemberConflictResolverModel
extends DefaultTableModel {
    public static final String NUM_CONFLICTS_PROP = RelationMemberConflictResolverModel.class.getName() + ".numConflicts";
    protected final List<RelationMemberConflictDecision> decisions = new ArrayList<RelationMemberConflictDecision>();
    protected Collection<Relation> relations;
    private int numConflicts;
    private final PropertyChangeSupport support = new PropertyChangeSupport(this);

    public boolean isResolvedCompletely() {
        return this.numConflicts == 0;
    }

    public int getNumConflicts() {
        return this.numConflicts;
    }

    protected void updateNumConflicts() {
        int count = 0;
        for (RelationMemberConflictDecision decision : this.decisions) {
            if (decision.isDecided()) continue;
            ++count;
        }
        int oldValue = this.numConflicts;
        this.numConflicts = count;
        if (this.numConflicts != oldValue) {
            this.support.firePropertyChange(this.getProperty(), oldValue, this.numConflicts);
        }
    }

    protected String getProperty() {
        return NUM_CONFLICTS_PROP;
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.support.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.support.removePropertyChangeListener(l);
    }

    @Override
    public int getRowCount() {
        return this.getNumDecisions();
    }

    @Override
    public Object getValueAt(int row, int column) {
        if (this.decisions == null) {
            return null;
        }
        RelationMemberConflictDecision d = this.decisions.get(row);
        switch (column) {
            case 0: {
                return d.getRelation();
            }
            case 1: {
                return Integer.toString(d.getPos() + 1);
            }
            case 2: {
                return d.getRole();
            }
            case 3: {
                return d.getOriginalPrimitive();
            }
            case 4: {
                return d.getDecision();
            }
        }
        return null;
    }

    @Override
    public void setValueAt(Object value, int row, int column) {
        RelationMemberConflictDecision d = this.decisions.get(row);
        switch (column) {
            case 2: {
                d.setRole((String)value);
                break;
            }
            case 4: {
                d.decide((RelationMemberConflictDecisionType)((Object)value));
                this.refresh();
            }
        }
        this.fireTableDataChanged();
    }

    protected void populate(Relation relation, OsmPrimitive primitive) {
        for (int i = 0; i < relation.getMembersCount(); ++i) {
            if (!relation.getMember(i).refersTo(primitive)) continue;
            this.decisions.add(new RelationMemberConflictDecision(relation, i));
        }
    }

    public void populate(Collection<Relation> relations, Collection<? extends OsmPrimitive> memberPrimitives) {
        this.decisions.clear();
        relations = relations == null ? new LinkedList<Relation>() : relations;
        memberPrimitives = memberPrimitives == null ? new LinkedList() : memberPrimitives;
        for (Relation r : relations) {
            for (OsmPrimitive p : memberPrimitives) {
                this.populate(r, p);
            }
        }
        this.relations = relations;
        this.refresh();
    }

    public void populate(Collection<RelationToChildReference> references) {
        references = references == null ? new LinkedList() : references;
        this.decisions.clear();
        this.relations = new HashSet<Relation>(references.size());
        for (RelationToChildReference reference : references) {
            this.decisions.add(new RelationMemberConflictDecision(reference.getParent(), reference.getPosition()));
            this.relations.add(reference.getParent());
        }
        this.refresh();
    }

    public RelationMemberConflictDecision getDecision(int row) {
        return this.decisions.get(row);
    }

    public int getNumDecisions() {
        return this.decisions == null ? 0 : this.decisions.size();
    }

    public void refresh() {
        this.updateNumConflicts();
        GuiHelper.runInEDTAndWait(new Runnable(){

            @Override
            public void run() {
                RelationMemberConflictResolverModel.this.fireTableDataChanged();
            }
        });
    }

    public void applyRole(String role) {
        role = role == null ? "" : role;
        for (RelationMemberConflictDecision decision : this.decisions) {
            decision.setRole(role);
        }
        this.refresh();
    }

    protected RelationMemberConflictDecision getDecision(Relation relation, int pos) {
        for (RelationMemberConflictDecision decision : this.decisions) {
            if (!decision.matches(relation, pos)) continue;
            return decision;
        }
        return null;
    }

    protected Command buildResolveCommand(Relation relation, OsmPrimitive newPrimitive) {
        Relation modifiedRelation = new Relation(relation);
        modifiedRelation.setMembers(null);
        boolean isChanged = false;
        block4: for (int i = 0; i < relation.getMembersCount(); ++i) {
            RelationMember member = relation.getMember(i);
            RelationMemberConflictDecision decision = this.getDecision(relation, i);
            if (decision == null) {
                modifiedRelation.addMember(member);
                continue;
            }
            switch (decision.getDecision()) {
                case KEEP: {
                    RelationMember newMember = new RelationMember(decision.getRole(), newPrimitive);
                    modifiedRelation.addMember(newMember);
                    isChanged |= !member.equals(newMember);
                    continue block4;
                }
                case REMOVE: {
                    isChanged = true;
                    continue block4;
                }
            }
        }
        if (isChanged) {
            return new ChangeCommand(relation, modifiedRelation);
        }
        return null;
    }

    public List<Command> buildResolutionCommands(OsmPrimitive newPrimitive) {
        LinkedList<Command> command = new LinkedList<Command>();
        for (Relation relation : this.relations) {
            Command cmd = this.buildResolveCommand(relation, newPrimitive);
            if (cmd == null) continue;
            command.add(cmd);
        }
        return command;
    }

    protected boolean isChanged(Relation relation, OsmPrimitive newPrimitive) {
        block4: for (int i = 0; i < relation.getMembersCount(); ++i) {
            RelationMemberConflictDecision decision = this.getDecision(relation, i);
            if (decision == null) continue;
            switch (decision.getDecision()) {
                case REMOVE: {
                    return true;
                }
                case KEEP: {
                    if (!relation.getMember(i).getRole().equals(decision.getRole())) {
                        return true;
                    }
                    if (relation.getMember(i).getMember() == newPrimitive) continue block4;
                    return true;
                }
            }
        }
        return false;
    }

    public Set<Relation> getModifiedRelations(OsmPrimitive newPrimitive) {
        HashSet<Relation> ret = new HashSet<Relation>();
        for (Relation relation : this.relations) {
            if (!this.isChanged(relation, newPrimitive)) continue;
            ret.add(relation);
        }
        return ret;
    }
}

