/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.conflict.tags;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.TagCollection;
import org.openstreetmap.josm.gui.SideButton;
import org.openstreetmap.josm.gui.conflict.tags.TagConflictResolver;
import org.openstreetmap.josm.gui.conflict.tags.TagConflictResolverModel;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.WindowGeometry;

public class PasteTagsConflictResolverDialog
extends JDialog
implements PropertyChangeListener {
    private static final Map<OsmPrimitiveType, String> PANE_TITLES = new HashMap<OsmPrimitiveType, String>();
    private TagConflictResolver allPrimitivesResolver;
    private Map<OsmPrimitiveType, TagConflictResolver> resolvers;
    private JTabbedPane tpResolvers;
    private Mode mode;
    private boolean canceled = false;
    private ImageIcon iconResolved;
    private ImageIcon iconUnresolved;
    private StatisticsTableModel statisticsModel;
    private JPanel pnlTagResolver;

    public PasteTagsConflictResolverDialog(Component owner) {
        super((Window)JOptionPane.getFrameForComponent(owner), Dialog.ModalityType.DOCUMENT_MODAL);
        this.build();
        this.iconResolved = ImageProvider.get("dialogs/conflict", "tagconflictresolved");
        this.iconUnresolved = ImageProvider.get("dialogs/conflict", "tagconflictunresolved");
    }

    protected final void build() {
        this.setTitle(I18n.tr("Conflicts in pasted tags", new Object[0]));
        this.allPrimitivesResolver = new TagConflictResolver();
        this.resolvers = new HashMap<OsmPrimitiveType, TagConflictResolver>();
        for (OsmPrimitiveType type : OsmPrimitiveType.dataValues()) {
            this.resolvers.put(type, new TagConflictResolver());
            this.resolvers.get((Object)type).getModel().addPropertyChangeListener(this);
        }
        this.tpResolvers = new JTabbedPane();
        this.getContentPane().setLayout(new GridBagLayout());
        this.mode = null;
        GridBagConstraints gc = new GridBagConstraints();
        gc.gridx = 0;
        gc.gridy = 0;
        gc.fill = 2;
        gc.weightx = 1.0;
        gc.weighty = 0.0;
        this.getContentPane().add((Component)this.buildSourceAndTargetInfoPanel(), gc);
        gc.gridx = 0;
        gc.gridy = 1;
        gc.fill = 1;
        gc.weightx = 1.0;
        gc.weighty = 1.0;
        this.pnlTagResolver = new JPanel();
        this.getContentPane().add((Component)this.pnlTagResolver, gc);
        gc.gridx = 0;
        gc.gridy = 2;
        gc.fill = 2;
        gc.weightx = 1.0;
        gc.weighty = 0.0;
        this.getContentPane().add((Component)this.buildButtonPanel(), gc);
    }

    protected JPanel buildButtonPanel() {
        JPanel pnl = new JPanel();
        pnl.setLayout(new FlowLayout(1));
        ApplyAction applyAction = new ApplyAction();
        this.allPrimitivesResolver.getModel().addPropertyChangeListener(applyAction);
        for (OsmPrimitiveType type : this.resolvers.keySet()) {
            this.resolvers.get((Object)type).getModel().addPropertyChangeListener(applyAction);
        }
        pnl.add(new SideButton(applyAction));
        CancelAction cancelAction = new CancelAction();
        pnl.add(new SideButton(cancelAction));
        return pnl;
    }

    protected JPanel buildSourceAndTargetInfoPanel() {
        JPanel pnl = new JPanel();
        pnl.setLayout(new BorderLayout());
        this.statisticsModel = new StatisticsTableModel();
        pnl.add((Component)new StatisticsInfoTable(this.statisticsModel), "Center");
        return pnl;
    }

    protected void initResolver(OsmPrimitiveType type, TagCollection tc, Map<OsmPrimitiveType, Integer> targetStatistics) {
        this.resolvers.get((Object)type).getModel().populate(tc, tc.getKeysWithMultipleValues());
        this.resolvers.get((Object)type).getModel().prepareDefaultTagDecisions();
        if (!tc.isEmpty() && targetStatistics.get((Object)type) != null && targetStatistics.get((Object)type) > 0) {
            this.tpResolvers.add(PANE_TITLES.get((Object)type), this.resolvers.get((Object)type));
        }
    }

    public void populate(TagCollection tagsForAllPrimitives, Map<OsmPrimitiveType, Integer> sourceStatistics, Map<OsmPrimitiveType, Integer> targetStatistics) {
        this.mode = Mode.RESOLVING_ONE_TAGCOLLECTION_ONLY;
        tagsForAllPrimitives = tagsForAllPrimitives == null ? new TagCollection() : tagsForAllPrimitives;
        sourceStatistics = sourceStatistics == null ? new HashMap() : sourceStatistics;
        targetStatistics = targetStatistics == null ? new HashMap() : targetStatistics;
        this.allPrimitivesResolver.getModel().populate(tagsForAllPrimitives, tagsForAllPrimitives.getKeysWithMultipleValues());
        this.allPrimitivesResolver.getModel().prepareDefaultTagDecisions();
        this.pnlTagResolver.setLayout(new BorderLayout());
        this.pnlTagResolver.removeAll();
        this.pnlTagResolver.add((Component)this.allPrimitivesResolver, "Center");
        this.statisticsModel.reset();
        StatisticsInfo info = new StatisticsInfo();
        info.numTags = tagsForAllPrimitives.getKeys().size();
        info.sourceInfo.putAll(sourceStatistics);
        info.targetInfo.putAll(targetStatistics);
        this.statisticsModel.append(info);
        this.validate();
    }

    protected int getNumResolverTabs() {
        return this.tpResolvers.getTabCount();
    }

    protected TagConflictResolver getResolver(int idx) {
        return (TagConflictResolver)this.tpResolvers.getComponentAt(idx);
    }

    public void populate(TagCollection tagsForNodes, TagCollection tagsForWays, TagCollection tagsForRelations, Map<OsmPrimitiveType, Integer> sourceStatistics, Map<OsmPrimitiveType, Integer> targetStatistics) {
        int numTargets;
        StatisticsInfo info;
        tagsForNodes = tagsForNodes == null ? new TagCollection() : tagsForNodes;
        tagsForWays = tagsForWays == null ? new TagCollection() : tagsForWays;
        TagCollection tagCollection = tagsForRelations = tagsForRelations == null ? new TagCollection() : tagsForRelations;
        if (tagsForNodes.isEmpty() && tagsForWays.isEmpty() && tagsForRelations.isEmpty()) {
            this.populate(null, null, null);
            return;
        }
        this.tpResolvers.removeAll();
        this.initResolver(OsmPrimitiveType.NODE, tagsForNodes, targetStatistics);
        this.initResolver(OsmPrimitiveType.WAY, tagsForWays, targetStatistics);
        this.initResolver(OsmPrimitiveType.RELATION, tagsForRelations, targetStatistics);
        this.pnlTagResolver.setLayout(new BorderLayout());
        this.pnlTagResolver.removeAll();
        this.pnlTagResolver.add((Component)this.tpResolvers, "Center");
        this.mode = Mode.RESOLVING_TYPED_TAGCOLLECTIONS;
        this.validate();
        this.statisticsModel.reset();
        if (!tagsForNodes.isEmpty()) {
            info = new StatisticsInfo();
            info.numTags = tagsForNodes.getKeys().size();
            int n = numTargets = targetStatistics.get((Object)OsmPrimitiveType.NODE) == null ? 0 : targetStatistics.get((Object)OsmPrimitiveType.NODE);
            if (numTargets > 0) {
                info.sourceInfo.put(OsmPrimitiveType.NODE, sourceStatistics.get((Object)OsmPrimitiveType.NODE));
                info.targetInfo.put(OsmPrimitiveType.NODE, numTargets);
                this.statisticsModel.append(info);
            }
        }
        if (!tagsForWays.isEmpty()) {
            info = new StatisticsInfo();
            info.numTags = tagsForWays.getKeys().size();
            int n = numTargets = targetStatistics.get((Object)OsmPrimitiveType.WAY) == null ? 0 : targetStatistics.get((Object)OsmPrimitiveType.WAY);
            if (numTargets > 0) {
                info.sourceInfo.put(OsmPrimitiveType.WAY, sourceStatistics.get((Object)OsmPrimitiveType.WAY));
                info.targetInfo.put(OsmPrimitiveType.WAY, numTargets);
                this.statisticsModel.append(info);
            }
        }
        if (!tagsForRelations.isEmpty()) {
            info = new StatisticsInfo();
            info.numTags = tagsForRelations.getKeys().size();
            int n = numTargets = targetStatistics.get((Object)OsmPrimitiveType.RELATION) == null ? 0 : targetStatistics.get((Object)OsmPrimitiveType.RELATION);
            if (numTargets > 0) {
                info.sourceInfo.put(OsmPrimitiveType.RELATION, sourceStatistics.get((Object)OsmPrimitiveType.RELATION));
                info.targetInfo.put(OsmPrimitiveType.RELATION, numTargets);
                this.statisticsModel.append(info);
            }
        }
        for (int i = 0; i < this.getNumResolverTabs(); ++i) {
            if (this.getResolver(i).getModel().isResolvedCompletely()) continue;
            this.tpResolvers.setSelectedIndex(i);
            break;
        }
    }

    protected void setCanceled(boolean canceled) {
        this.canceled = canceled;
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    @Override
    public void setVisible(boolean visible) {
        if (visible) {
            new WindowGeometry(this.getClass().getName() + ".geometry", WindowGeometry.centerOnScreen(new Dimension(400, 300))).applySafe(this);
        } else if (this.isShowing()) {
            new WindowGeometry(this).remember(this.getClass().getName() + ".geometry");
        }
        super.setVisible(visible);
    }

    public TagCollection getResolution() {
        return this.allPrimitivesResolver.getModel().getResolution();
    }

    public TagCollection getResolution(OsmPrimitiveType type) {
        if (type == null) {
            return null;
        }
        return this.resolvers.get((Object)type).getModel().getResolution();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals(TagConflictResolverModel.NUM_CONFLICTS_PROP)) {
            TagConflictResolverModel model = (TagConflictResolverModel)evt.getSource();
            for (int i = 0; i < this.tpResolvers.getTabCount(); ++i) {
                TagConflictResolver resolver = (TagConflictResolver)this.tpResolvers.getComponentAt(i);
                if (model != resolver.getModel()) continue;
                this.tpResolvers.setIconAt(i, (Boolean)evt.getNewValue() != false ? this.iconResolved : this.iconUnresolved);
            }
        }
    }

    static {
        PANE_TITLES.put(OsmPrimitiveType.NODE, I18n.tr("Tags from nodes", new Object[0]));
        PANE_TITLES.put(OsmPrimitiveType.WAY, I18n.tr("Tags from ways", new Object[0]));
        PANE_TITLES.put(OsmPrimitiveType.RELATION, I18n.tr("Tags from relations", new Object[0]));
    }

    private static class StatisticsInfoTable
    extends JPanel {
        private JTable infoTable;

        protected void build(StatisticsTableModel model) {
            this.infoTable = new JTable(model, new StatisticsTableColumnModel());
            this.infoTable.setShowHorizontalLines(true);
            this.infoTable.setShowVerticalLines(false);
            this.infoTable.setEnabled(false);
            this.setLayout(new BorderLayout());
            this.add((Component)this.infoTable, "Center");
        }

        public StatisticsInfoTable(StatisticsTableModel model) {
            this.build(model);
        }

        @Override
        public Insets getInsets() {
            Insets insets = super.getInsets();
            insets.bottom = 20;
            return insets;
        }
    }

    private static class StatisticsInfoRenderer
    extends JLabel
    implements TableCellRenderer {
        private StatisticsInfoRenderer() {
        }

        protected void reset() {
            this.setIcon(null);
            this.setText("");
            this.setFont(UIManager.getFont("Table.font"));
        }

        protected void renderNumTags(StatisticsInfo info) {
            if (info == null) {
                return;
            }
            this.setText(I18n.trn("{0} tag", "{0} tags", info.numTags, info.numTags));
        }

        protected void renderStatistics(Map<OsmPrimitiveType, Integer> stat) {
            if (stat == null) {
                return;
            }
            if (stat.isEmpty()) {
                return;
            }
            if (stat.size() == 1) {
                this.setIcon(ImageProvider.get(stat.keySet().iterator().next()));
            } else {
                this.setIcon(ImageProvider.get("data", "object"));
            }
            StringBuilder text = new StringBuilder();
            for (Map.Entry<OsmPrimitiveType, Integer> entry : stat.entrySet()) {
                int numPrimitives;
                OsmPrimitiveType type = entry.getKey();
                int n = numPrimitives = entry.getValue() == null ? 0 : entry.getValue();
                if (numPrimitives == 0) continue;
                String msg = "";
                switch (type) {
                    case NODE: {
                        msg = I18n.trn("{0} node", "{0} nodes", numPrimitives, numPrimitives);
                        break;
                    }
                    case WAY: {
                        msg = I18n.trn("{0} way", "{0} ways", numPrimitives, numPrimitives);
                        break;
                    }
                    case RELATION: {
                        msg = I18n.trn("{0} relation", "{0} relations", numPrimitives, numPrimitives);
                    }
                }
                if (text.length() > 0) {
                    text.append(", ");
                }
                text.append(msg);
            }
            this.setText(text.toString());
        }

        protected void renderFrom(StatisticsInfo info) {
            this.renderStatistics(info.sourceInfo);
        }

        protected void renderTo(StatisticsInfo info) {
            this.renderStatistics(info.targetInfo);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.reset();
            if (value == null) {
                return this;
            }
            if (row == 0) {
                this.setFont(this.getFont().deriveFont(1));
                this.setText((String)value);
            } else {
                StatisticsInfo info = (StatisticsInfo)value;
                switch (column) {
                    case 0: {
                        this.renderNumTags(info);
                        break;
                    }
                    case 1: {
                        this.renderFrom(info);
                        break;
                    }
                    case 2: {
                        this.renderTo(info);
                    }
                }
            }
            return this;
        }
    }

    private static class StatisticsTableModel
    extends DefaultTableModel {
        private static final String[] HEADERS = new String[]{I18n.tr("Paste ...", new Object[0]), I18n.tr("From ...", new Object[0]), I18n.tr("To ...", new Object[0])};
        private List<StatisticsInfo> data = new ArrayList<StatisticsInfo>();

        @Override
        public Object getValueAt(int row, int column) {
            if (row == 0) {
                return HEADERS[column];
            }
            if (row - 1 < this.data.size()) {
                return this.data.get(row - 1);
            }
            return null;
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return false;
        }

        @Override
        public int getRowCount() {
            if (this.data == null) {
                return 1;
            }
            return this.data.size() + 1;
        }

        public void reset() {
            this.data.clear();
        }

        public void append(StatisticsInfo info) {
            this.data.add(info);
            this.fireTableDataChanged();
        }
    }

    private static class StatisticsTableColumnModel
    extends DefaultTableColumnModel {
        public StatisticsTableColumnModel() {
            StatisticsInfoRenderer renderer = new StatisticsInfoRenderer();
            TableColumn col = null;
            col = new TableColumn(0);
            col.setHeaderValue(I18n.tr("Paste ...", new Object[0]));
            col.setResizable(true);
            col.setCellRenderer(renderer);
            this.addColumn(col);
            col = new TableColumn(1);
            col.setHeaderValue(I18n.tr("From ...", new Object[0]));
            col.setResizable(true);
            col.setCellRenderer(renderer);
            this.addColumn(col);
            col = new TableColumn(2);
            col.setHeaderValue(I18n.tr("To ...", new Object[0]));
            col.setResizable(true);
            col.setCellRenderer(renderer);
            this.addColumn(col);
        }
    }

    public static class StatisticsInfo {
        public int numTags;
        public Map<OsmPrimitiveType, Integer> sourceInfo = new HashMap<OsmPrimitiveType, Integer>();
        public Map<OsmPrimitiveType, Integer> targetInfo = new HashMap<OsmPrimitiveType, Integer>();
    }

    class ApplyAction
    extends AbstractAction
    implements PropertyChangeListener {
        public ApplyAction() {
            this.putValue("ShortDescription", I18n.tr("Apply resolved conflicts", new Object[0]));
            this.putValue("Name", I18n.tr("Apply", new Object[0]));
            this.putValue("SmallIcon", ImageProvider.get("ok"));
            this.updateEnabledState();
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            PasteTagsConflictResolverDialog.this.setVisible(false);
        }

        protected void updateEnabledState() {
            if (PasteTagsConflictResolverDialog.this.mode == null) {
                this.setEnabled(false);
            } else if (PasteTagsConflictResolverDialog.this.mode.equals((Object)Mode.RESOLVING_ONE_TAGCOLLECTION_ONLY)) {
                this.setEnabled(PasteTagsConflictResolverDialog.this.allPrimitivesResolver.getModel().isResolvedCompletely());
            } else {
                boolean enabled = true;
                for (OsmPrimitiveType type : PasteTagsConflictResolverDialog.this.resolvers.keySet()) {
                    enabled &= ((TagConflictResolver)PasteTagsConflictResolverDialog.this.resolvers.get((Object)type)).getModel().isResolvedCompletely();
                }
                this.setEnabled(enabled);
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals(TagConflictResolverModel.NUM_CONFLICTS_PROP)) {
                this.updateEnabledState();
            }
        }
    }

    class CancelAction
    extends AbstractAction {
        public CancelAction() {
            this.putValue("ShortDescription", I18n.tr("Cancel conflict resolution", new Object[0]));
            this.putValue("Name", I18n.tr("Cancel", new Object[0]));
            this.putValue("SmallIcon", ImageProvider.get("", "cancel"));
            this.setEnabled(true);
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            PasteTagsConflictResolverDialog.this.setVisible(false);
            PasteTagsConflictResolverDialog.this.setCanceled(true);
        }
    }

    private static enum Mode {
        RESOLVING_ONE_TAGCOLLECTION_ONLY,
        RESOLVING_TYPED_TAGCOLLECTIONS;

    }
}

