/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.conflict.tags;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.openstreetmap.josm.command.ChangePropertyCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Tag;
import org.openstreetmap.josm.data.osm.TagCollection;
import org.openstreetmap.josm.gui.conflict.tags.MultiValueDecisionType;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;

public class MultiValueResolutionDecision {
    private MultiValueDecisionType type;
    private TagCollection tags;
    private String value;
    private static final String[] SUMMABLE_KEYS = new String[]{"capacity(:.+)?", "step_count"};

    public MultiValueResolutionDecision() {
        this.type = MultiValueDecisionType.UNDECIDED;
        this.tags = new TagCollection();
        this.autoDecide();
    }

    public MultiValueResolutionDecision(TagCollection tags) throws IllegalArgumentException {
        CheckParameterUtil.ensureParameterNotNull(tags, "tags");
        if (tags.isEmpty()) {
            throw new IllegalArgumentException(MessageFormat.format("Parameter ''{0}'' must not be empty.", "tags"));
        }
        if (tags.getKeys().size() != 1) {
            throw new IllegalArgumentException(MessageFormat.format("Parameter ''{0}'' with tags for exactly one key expected. Got {1}.", "tags", tags.getKeys().size()));
        }
        this.tags = tags;
        this.autoDecide();
    }

    protected final void autoDecide() {
        this.type = MultiValueDecisionType.UNDECIDED;
        if (this.tags.size() == 1 && this.tags.getValues().contains("")) {
            this.type = MultiValueDecisionType.KEEP_NONE;
        } else if (this.tags.size() == 1) {
            this.type = MultiValueDecisionType.KEEP_ONE;
            this.value = this.tags.getValues().iterator().next();
        }
    }

    public void keepNone() {
        this.type = MultiValueDecisionType.KEEP_NONE;
    }

    public void keepAll() {
        this.type = MultiValueDecisionType.KEEP_ALL;
    }

    public void sumAllNumeric() {
        this.type = MultiValueDecisionType.SUM_ALL_NUMERIC;
    }

    public void keepOne(String value) throws IllegalArgumentException, IllegalStateException {
        CheckParameterUtil.ensureParameterNotNull(value, "value");
        if (!this.tags.getValues().contains(value)) {
            throw new IllegalStateException(I18n.tr("Tag collection does not include the selected value ''{0}''.", value));
        }
        this.value = value;
        this.type = MultiValueDecisionType.KEEP_ONE;
    }

    public void setNew(String value) {
        if (value == null) {
            value = "";
        }
        this.value = value;
        this.type = MultiValueDecisionType.KEEP_ONE;
    }

    public void undecide() {
        this.type = MultiValueDecisionType.UNDECIDED;
    }

    public String getChosenValue() throws IllegalStateException {
        switch (this.type) {
            case UNDECIDED: {
                throw new IllegalStateException(I18n.tr("Not decided yet.", new Object[0]));
            }
            case KEEP_ONE: {
                return this.value;
            }
            case SUM_ALL_NUMERIC: {
                return this.tags.getSummedValues(this.getKey());
            }
            case KEEP_ALL: {
                return this.tags.getJoinedValues(this.getKey());
            }
        }
        return null;
    }

    public List<String> getValues() {
        ArrayList<String> ret = new ArrayList<String>(this.tags.getValues());
        ret.remove("");
        ret.remove(null);
        Collections.sort(ret);
        return ret;
    }

    public String getKey() {
        return this.tags.getKeys().iterator().next();
    }

    public boolean canKeepNone() {
        return this.tags.getValues().contains("");
    }

    public boolean canKeepAll() {
        return this.getValues().size() > 1;
    }

    public boolean canSumAllNumeric() {
        if (!this.canKeepAll()) {
            return false;
        }
        for (String key : SUMMABLE_KEYS) {
            if (!this.getKey().matches(key)) continue;
            return true;
        }
        return false;
    }

    public boolean isDecided() {
        return !this.type.equals((Object)MultiValueDecisionType.UNDECIDED);
    }

    public MultiValueDecisionType getDecisionType() {
        return this.type;
    }

    public void applyTo(OsmPrimitive primitive) {
        if (primitive == null) {
            return;
        }
        if (!this.isDecided()) {
            throw new IllegalStateException(I18n.tr("Not decided yet.", new Object[0]));
        }
        String key = this.tags.getKeys().iterator().next();
        if (this.type.equals((Object)MultiValueDecisionType.KEEP_NONE)) {
            primitive.remove(key);
        } else {
            primitive.put(key, this.getChosenValue());
        }
    }

    public void applyTo(Collection<? extends OsmPrimitive> primitives) {
        if (primitives == null) {
            return;
        }
        for (OsmPrimitive osmPrimitive : primitives) {
            if (osmPrimitive == null) continue;
            this.applyTo(osmPrimitive);
        }
    }

    public Command buildChangeCommand(OsmPrimitive primitive) {
        CheckParameterUtil.ensureParameterNotNull(primitive, "primitive");
        if (!this.isDecided()) {
            throw new IllegalStateException(I18n.tr("Not decided yet.", new Object[0]));
        }
        String key = this.tags.getKeys().iterator().next();
        return new ChangePropertyCommand(primitive, key, this.getChosenValue());
    }

    public Command buildChangeCommand(Collection<? extends OsmPrimitive> primitives) {
        CheckParameterUtil.ensureParameterNotNull(primitives, "primitives");
        if (!this.isDecided()) {
            throw new IllegalStateException(I18n.tr("Not decided yet.", new Object[0]));
        }
        String key = this.tags.getKeys().iterator().next();
        return new ChangePropertyCommand(primitives, key, this.getChosenValue());
    }

    public Tag getResolution() {
        switch (this.type) {
            case SUM_ALL_NUMERIC: {
                return new Tag(this.getKey(), this.tags.getSummedValues(this.getKey()));
            }
            case KEEP_ALL: {
                return new Tag(this.getKey(), this.tags.getJoinedValues(this.getKey()));
            }
            case KEEP_ONE: {
                return new Tag(this.getKey(), this.value);
            }
            case KEEP_NONE: {
                return new Tag(this.getKey(), "");
            }
        }
        return null;
    }
}

