/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.conflict.tags;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.HierarchyBoundsListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.ExpertToggleAction;
import org.openstreetmap.josm.command.ChangePropertyCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.corrector.UserCancelException;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.TagCollection;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.ConditionalOptionPaneUtil;
import org.openstreetmap.josm.gui.DefaultNameFormatter;
import org.openstreetmap.josm.gui.SideButton;
import org.openstreetmap.josm.gui.conflict.tags.RelationMemberConflictDecision;
import org.openstreetmap.josm.gui.conflict.tags.RelationMemberConflictDecisionType;
import org.openstreetmap.josm.gui.conflict.tags.RelationMemberConflictResolver;
import org.openstreetmap.josm.gui.conflict.tags.RelationMemberConflictResolverModel;
import org.openstreetmap.josm.gui.conflict.tags.TagConflictResolutionUtil;
import org.openstreetmap.josm.gui.conflict.tags.TagConflictResolver;
import org.openstreetmap.josm.gui.conflict.tags.TagConflictResolverModel;
import org.openstreetmap.josm.gui.help.ContextSensitiveHelpAction;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.MultiMap;
import org.openstreetmap.josm.tools.Predicates;
import org.openstreetmap.josm.tools.Utils;
import org.openstreetmap.josm.tools.WindowGeometry;

public class CombinePrimitiveResolverDialog
extends JDialog {
    private static CombinePrimitiveResolverDialog instance;
    private AutoAdjustingSplitPane spTagConflictTypes;
    private TagConflictResolver pnlTagConflictResolver;
    protected RelationMemberConflictResolver pnlRelationMemberConflictResolver;
    private boolean canceled;
    private JPanel pnlButtons;
    protected OsmPrimitive targetPrimitive;
    private ContextSensitiveHelpAction helpAction;
    private SideButton btnApply;

    @Deprecated
    public static synchronized CombinePrimitiveResolverDialog getInstance() {
        if (instance == null) {
            GuiHelper.runInEDTAndWait(new Runnable(){

                @Override
                public void run() {
                    instance = new CombinePrimitiveResolverDialog(Main.parent);
                }
            });
        }
        return instance;
    }

    public OsmPrimitive getTargetPrimitmive() {
        return this.targetPrimitive;
    }

    public void setTargetPrimitive(final OsmPrimitive primitive) {
        this.targetPrimitive = primitive;
        GuiHelper.runInEDTAndWait(new Runnable(){

            @Override
            public void run() {
                CombinePrimitiveResolverDialog.this.updateTitle();
                if (primitive instanceof Way) {
                    CombinePrimitiveResolverDialog.this.pnlRelationMemberConflictResolver.initForWayCombining();
                } else if (primitive instanceof Node) {
                    CombinePrimitiveResolverDialog.this.pnlRelationMemberConflictResolver.initForNodeMerging();
                }
            }
        });
    }

    protected void updateTitle() {
        if (this.targetPrimitive == null) {
            this.setTitle(I18n.tr("Conflicts when combining primitives", new Object[0]));
            return;
        }
        if (this.targetPrimitive instanceof Way) {
            this.setTitle(I18n.tr("Conflicts when combining ways - combined way is ''{0}''", this.targetPrimitive.getDisplayName(DefaultNameFormatter.getInstance())));
            this.helpAction.setHelpTopic(HelpUtil.ht("/Action/CombineWay#ResolvingConflicts"));
            this.getRootPane().putClientProperty("help", HelpUtil.ht("/Action/CombineWay#ResolvingConflicts"));
        } else if (this.targetPrimitive instanceof Node) {
            this.setTitle(I18n.tr("Conflicts when merging nodes - target node is ''{0}''", this.targetPrimitive.getDisplayName(DefaultNameFormatter.getInstance())));
            this.helpAction.setHelpTopic(HelpUtil.ht("/Action/MergeNodes#ResolvingConflicts"));
            this.getRootPane().putClientProperty("help", HelpUtil.ht("/Action/MergeNodes#ResolvingConflicts"));
        }
    }

    protected final void build() {
        this.getContentPane().setLayout(new BorderLayout());
        this.updateTitle();
        this.spTagConflictTypes = new AutoAdjustingSplitPane(0);
        this.spTagConflictTypes.setTopComponent(this.buildTagConflictResolverPanel());
        this.spTagConflictTypes.setBottomComponent(this.buildRelationMemberConflictResolverPanel());
        this.pnlButtons = this.buildButtonPanel();
        this.getContentPane().add((Component)this.pnlButtons, "South");
        this.addWindowListener(new AdjustDividerLocationAction());
        HelpUtil.setHelpContext(this.getRootPane(), HelpUtil.ht("/"));
    }

    protected JPanel buildTagConflictResolverPanel() {
        this.pnlTagConflictResolver = new TagConflictResolver();
        return this.pnlTagConflictResolver;
    }

    protected JPanel buildRelationMemberConflictResolverPanel() {
        this.pnlRelationMemberConflictResolver = new RelationMemberConflictResolver(new RelationMemberConflictResolverModel());
        return this.pnlRelationMemberConflictResolver;
    }

    protected ApplyAction buildApplyAction() {
        return new ApplyAction();
    }

    protected JPanel buildButtonPanel() {
        JPanel pnl = new JPanel(new FlowLayout(1));
        ApplyAction applyAction = this.buildApplyAction();
        this.pnlTagConflictResolver.getModel().addPropertyChangeListener(applyAction);
        this.pnlRelationMemberConflictResolver.getModel().addPropertyChangeListener(applyAction);
        this.btnApply = new SideButton(applyAction);
        this.btnApply.setFocusable(true);
        pnl.add(this.btnApply);
        CancelAction cancelAction = new CancelAction();
        pnl.add(new SideButton(cancelAction));
        this.helpAction = new ContextSensitiveHelpAction();
        pnl.add(new SideButton(this.helpAction));
        return pnl;
    }

    public CombinePrimitiveResolverDialog(Component parent) {
        super((Window)JOptionPane.getFrameForComponent(parent), Dialog.ModalityType.DOCUMENT_MODAL);
        this.build();
    }

    public TagConflictResolverModel getTagConflictResolverModel() {
        return this.pnlTagConflictResolver.getModel();
    }

    public RelationMemberConflictResolverModel getRelationMemberConflictResolverModel() {
        return this.pnlRelationMemberConflictResolver.getModel();
    }

    public boolean isResolvedCompletely() {
        return this.getTagConflictResolverModel().isResolvedCompletely() && this.getRelationMemberConflictResolverModel().isResolvedCompletely();
    }

    protected List<Command> buildTagChangeCommand(OsmPrimitive primitive, TagCollection tc) {
        LinkedList<Command> cmds = new LinkedList<Command>();
        for (String key : tc.getKeys()) {
            if (tc.hasUniqueEmptyValue(key)) {
                if (primitive.get(key) == null) continue;
                cmds.add(new ChangePropertyCommand(primitive, key, null));
                continue;
            }
            String value = tc.getJoinedValues(key);
            if (value.equals(primitive.get(key))) continue;
            cmds.add(new ChangePropertyCommand(primitive, key, value));
        }
        return cmds;
    }

    public List<Command> buildResolutionCommands() {
        Command cmd;
        LinkedList<Command> cmds = new LinkedList<Command>();
        TagCollection allResolutions = this.getTagConflictResolverModel().getAllResolutions();
        if (!allResolutions.isEmpty()) {
            cmds.addAll(this.buildTagChangeCommand(this.targetPrimitive, allResolutions));
        }
        for (String p : OsmPrimitive.getDiscardableKeys()) {
            if (this.targetPrimitive.get(p) == null) continue;
            cmds.add(new ChangePropertyCommand(this.targetPrimitive, p, null));
        }
        if (this.getRelationMemberConflictResolverModel().getNumDecisions() > 0) {
            cmds.addAll(this.getRelationMemberConflictResolverModel().buildResolutionCommands(this.targetPrimitive));
        }
        if ((cmd = this.pnlRelationMemberConflictResolver.buildTagApplyCommands(this.getRelationMemberConflictResolverModel().getModifiedRelations(this.targetPrimitive))) != null) {
            cmds.add(cmd);
        }
        return cmds;
    }

    protected void prepareDefaultTagDecisions() {
        this.getTagConflictResolverModel().prepareDefaultTagDecisions();
    }

    protected void prepareDefaultRelationDecisions() {
        RelationMemberConflictResolverModel model = this.getRelationMemberConflictResolverModel();
        HashMap<Relation, Integer> numberOfKeepResolutions = new HashMap<Relation, Integer>();
        MultiMap<OsmPrimitive, Relation> resolvedRelationsPerPrimitive = new MultiMap<OsmPrimitive, Relation>();
        for (int i = 0; i < model.getNumDecisions(); ++i) {
            RelationMemberConflictDecision decision = model.getDecision(i);
            Relation r = decision.getRelation();
            OsmPrimitive p = decision.getOriginalPrimitive();
            if (!numberOfKeepResolutions.containsKey(r)) {
                decision.decide(RelationMemberConflictDecisionType.KEEP);
                numberOfKeepResolutions.put(r, 1);
                resolvedRelationsPerPrimitive.put(p, r);
                continue;
            }
            Integer keepResolutions = (Integer)numberOfKeepResolutions.get(r);
            Collection resolvedRelations = Utils.firstNonNull(resolvedRelationsPerPrimitive.get(p), Collections.emptyList());
            if (keepResolutions <= Utils.filter(resolvedRelations, Predicates.equalTo(r)).size()) {
                decision.decide(RelationMemberConflictDecisionType.KEEP);
                numberOfKeepResolutions.put(r, keepResolutions + 1);
                resolvedRelationsPerPrimitive.put(p, r);
                continue;
            }
            decision.decide(RelationMemberConflictDecisionType.REMOVE);
            resolvedRelationsPerPrimitive.put(p, r);
        }
        model.refresh();
    }

    public void prepareDefaultDecisions() {
        this.prepareDefaultTagDecisions();
        this.prepareDefaultRelationDecisions();
    }

    protected JPanel buildEmptyConflictsPanel() {
        JPanel pnl = new JPanel(new BorderLayout());
        pnl.add(new JLabel(I18n.tr("No conflicts to resolve", new Object[0])));
        return pnl;
    }

    protected void prepareGUIBeforeConflictResolutionStarts() {
        RelationMemberConflictResolverModel relModel = this.getRelationMemberConflictResolverModel();
        TagConflictResolverModel tagModel = this.getTagConflictResolverModel();
        this.getContentPane().removeAll();
        if (relModel.getNumDecisions() > 0 && tagModel.getNumDecisions() > 0) {
            this.spTagConflictTypes.setTopComponent(this.pnlTagConflictResolver);
            this.spTagConflictTypes.setBottomComponent(this.pnlRelationMemberConflictResolver);
            this.getContentPane().add((Component)this.spTagConflictTypes, "Center");
        } else if (relModel.getNumDecisions() > 0) {
            this.getContentPane().add((Component)this.pnlRelationMemberConflictResolver, "Center");
        } else if (tagModel.getNumDecisions() > 0) {
            this.getContentPane().add((Component)this.pnlTagConflictResolver, "Center");
        } else {
            this.getContentPane().add((Component)this.buildEmptyConflictsPanel(), "Center");
        }
        this.getContentPane().add((Component)this.pnlButtons, "South");
        this.validate();
        int numTagDecisions = this.getTagConflictResolverModel().getNumDecisions();
        int numRelationDecisions = this.getRelationMemberConflictResolverModel().getNumDecisions();
        if (numTagDecisions > 0 && numRelationDecisions > 0) {
            this.spTagConflictTypes.setDividerLocation(0.5);
        }
        this.pnlRelationMemberConflictResolver.prepareForEditing();
    }

    protected void setCanceled(boolean canceled) {
        this.canceled = canceled;
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    @Override
    public void setVisible(boolean visible) {
        if (visible) {
            this.prepareGUIBeforeConflictResolutionStarts();
            new WindowGeometry(this.getClass().getName() + ".geometry", WindowGeometry.centerInWindow(Main.parent, new Dimension(600, 400))).applySafe(this);
            this.setCanceled(false);
            this.btnApply.requestFocusInWindow();
        } else if (this.isShowing()) {
            new WindowGeometry(this).remember(this.getClass().getName() + ".geometry");
        }
        super.setVisible(visible);
    }

    public static List<Command> launchIfNecessary(TagCollection tagsOfPrimitives, Collection<? extends OsmPrimitive> primitives, Collection<? extends OsmPrimitive> targetPrimitives) throws UserCancelException {
        CheckParameterUtil.ensureParameterNotNull(tagsOfPrimitives, "tagsOfPrimitives");
        CheckParameterUtil.ensureParameterNotNull(primitives, "primitives");
        CheckParameterUtil.ensureParameterNotNull(targetPrimitives, "targetPrimitives");
        TagCollection completeWayTags = new TagCollection(tagsOfPrimitives);
        TagConflictResolutionUtil.combineTigerTags(completeWayTags);
        TagConflictResolutionUtil.normalizeTagCollectionBeforeEditing(completeWayTags, primitives);
        TagCollection tagsToEdit = new TagCollection(completeWayTags);
        TagConflictResolutionUtil.completeTagCollectionForEditing(tagsToEdit);
        Set<Relation> parentRelations = OsmPrimitive.getParentRelations(primitives);
        if (!ExpertToggleAction.isExpert()) {
            if (!completeWayTags.isApplicableToPrimitive()) {
                CombinePrimitiveResolverDialog.informAboutTagConflicts(primitives, completeWayTags);
            }
            if (!parentRelations.isEmpty()) {
                CombinePrimitiveResolverDialog.informAboutRelationMembershipConflicts(primitives, parentRelations);
            }
        }
        CombinePrimitiveResolverDialog dialog = CombinePrimitiveResolverDialog.getInstance();
        dialog.getTagConflictResolverModel().populate(tagsToEdit, completeWayTags.getKeysWithMultipleValues());
        dialog.getRelationMemberConflictResolverModel().populate(parentRelations, primitives);
        dialog.prepareDefaultDecisions();
        if (targetPrimitives.size() == 1) {
            dialog.setTargetPrimitive(targetPrimitives.iterator().next());
        } else {
            dialog.setTargetPrimitive(null);
        }
        if (!dialog.isResolvedCompletely()) {
            dialog.setVisible(true);
            if (dialog.isCanceled()) {
                throw new UserCancelException();
            }
        }
        LinkedList<Command> cmds = new LinkedList<Command>();
        for (OsmPrimitive osmPrimitive : targetPrimitives) {
            dialog.setTargetPrimitive(osmPrimitive);
            cmds.addAll(dialog.buildResolutionCommands());
        }
        return cmds;
    }

    protected static void informAboutRelationMembershipConflicts(Collection<? extends OsmPrimitive> primitives, Set<Relation> parentRelations) throws UserCancelException {
        String msg = I18n.trn("You are about to combine {1} object, which is part of {0} relation:<br/>{2}Combining these objects may break this relation. If you are unsure, please cancel this operation.<br/>If you want to continue, you are shown a dialog to decide how to adapt the relation.<br/><br/>Do you want to continue?", "You are about to combine {1} objects, which are part of {0} relations:<br/>{2}Combining these objects may break these relations. If you are unsure, please cancel this operation.<br/>If you want to continue, you are shown a dialog to decide how to adapt the relations.<br/><br/>Do you want to continue?", parentRelations.size(), parentRelations.size(), primitives.size(), DefaultNameFormatter.getInstance().formatAsHtmlUnorderedList(parentRelations));
        if (!ConditionalOptionPaneUtil.showConfirmationDialog("combine_tags", Main.parent, "<html>" + msg + "</html>", I18n.tr("Combine confirmation", new Object[0]), 0, 3, 0)) {
            throw new UserCancelException();
        }
    }

    protected static void informAboutTagConflicts(Collection<? extends OsmPrimitive> primitives, final TagCollection normalizedTags) throws UserCancelException {
        String conflicts = Utils.joinAsHtmlUnorderedList(Utils.transform(normalizedTags.getKeysWithMultipleValues(), new Utils.Function<String, String>(){

            @Override
            public String apply(String key) {
                return I18n.tr("{0} ({1})", key, Utils.join(I18n.tr(", ", new Object[0]), Utils.transform(normalizedTags.getValues(key), new Utils.Function<String, String>(){

                    @Override
                    public String apply(String x) {
                        return x == null || x.isEmpty() ? I18n.tr("<i>missing</i>", new Object[0]) : x;
                    }
                })));
            }
        }));
        String msg = I18n.trn("You are about to combine {0} objects, but the following tags are used conflictingly:<br/>{1}If these objects are combined, the resulting object may have unwanted tags.<br/>If you want to continue, you are shown a dialog to fix the conflicting tags.<br/><br/>Do you want to continue?", "You are about to combine {0} objects, but the following tags are used conflictingly:<br/>{1}If these objects are combined, the resulting object may have unwanted tags.<br/>If you want to continue, you are shown a dialog to fix the conflicting tags.<br/><br/>Do you want to continue?", primitives.size(), primitives.size(), conflicts);
        if (!ConditionalOptionPaneUtil.showConfirmationDialog("combine_tags", Main.parent, "<html>" + msg + "</html>", I18n.tr("Combine confirmation", new Object[0]), 0, 3, 0)) {
            throw new UserCancelException();
        }
    }

    static class AutoAdjustingSplitPane
    extends JSplitPane
    implements HierarchyBoundsListener,
    PropertyChangeListener {
        private double dividerLocation;

        public AutoAdjustingSplitPane(int newOrientation) {
            super(newOrientation);
            this.addPropertyChangeListener("dividerLocation", this);
            this.addHierarchyBoundsListener(this);
        }

        @Override
        public void ancestorResized(HierarchyEvent e) {
            this.setDividerLocation((int)(this.dividerLocation * (double)this.getHeight()));
        }

        @Override
        public void ancestorMoved(HierarchyEvent e) {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals("dividerLocation")) {
                int newVal = (Integer)evt.getNewValue();
                if (this.getHeight() != 0) {
                    this.dividerLocation = (double)newVal / (double)this.getHeight();
                }
            }
        }
    }

    class AdjustDividerLocationAction
    extends WindowAdapter {
        AdjustDividerLocationAction() {
        }

        @Override
        public void windowOpened(WindowEvent e) {
            int numTagDecisions = CombinePrimitiveResolverDialog.this.getTagConflictResolverModel().getNumDecisions();
            int numRelationDecisions = CombinePrimitiveResolverDialog.this.getRelationMemberConflictResolverModel().getNumDecisions();
            if (numTagDecisions > 0 && numRelationDecisions > 0) {
                CombinePrimitiveResolverDialog.this.spTagConflictTypes.setDividerLocation(0.5);
            }
        }
    }

    protected class ApplyAction
    extends AbstractAction
    implements PropertyChangeListener {
        public ApplyAction() {
            this.putValue("ShortDescription", I18n.tr("Apply resolved conflicts", new Object[0]));
            this.putValue("Name", I18n.tr("Apply", new Object[0]));
            this.putValue("SmallIcon", ImageProvider.get("ok"));
            this.updateEnabledState();
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            CombinePrimitiveResolverDialog.this.setVisible(false);
            CombinePrimitiveResolverDialog.this.pnlTagConflictResolver.rememberPreferences();
        }

        protected final void updateEnabledState() {
            this.setEnabled(CombinePrimitiveResolverDialog.this.pnlTagConflictResolver.getModel().getNumConflicts() == 0 && CombinePrimitiveResolverDialog.this.pnlRelationMemberConflictResolver.getModel().getNumConflicts() == 0);
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals(TagConflictResolverModel.NUM_CONFLICTS_PROP)) {
                this.updateEnabledState();
            }
            if (evt.getPropertyName().equals(RelationMemberConflictResolverModel.NUM_CONFLICTS_PROP)) {
                this.updateEnabledState();
            }
        }
    }

    class CancelAction
    extends AbstractAction {
        public CancelAction() {
            this.putValue("ShortDescription", I18n.tr("Cancel conflict resolution", new Object[0]));
            this.putValue("Name", I18n.tr("Cancel", new Object[0]));
            this.putValue("SmallIcon", ImageProvider.get("", "cancel"));
            this.setEnabled(true);
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            CombinePrimitiveResolverDialog.this.setCanceled(true);
            CombinePrimitiveResolverDialog.this.setVisible(false);
        }
    }
}

