/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.conflict.pair.tags;

import java.awt.Adjustable;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.openstreetmap.josm.data.conflict.Conflict;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.gui.conflict.pair.IConflictResolver;
import org.openstreetmap.josm.gui.conflict.pair.MergeDecisionType;
import org.openstreetmap.josm.gui.conflict.pair.tags.MergedTableCellRenderer;
import org.openstreetmap.josm.gui.conflict.pair.tags.MineTableCellRenderer;
import org.openstreetmap.josm.gui.conflict.pair.tags.TagMergeColumnModel;
import org.openstreetmap.josm.gui.conflict.pair.tags.TagMergeModel;
import org.openstreetmap.josm.gui.conflict.pair.tags.TheirTableCellRenderer;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class TagMerger
extends JPanel
implements IConflictResolver {
    private JTable mineTable;
    private JTable mergedTable;
    private JTable theirTable;
    private final TagMergeModel model = new TagMergeModel();
    AdjustmentSynchronizer adjustmentSynchronizer;

    protected JScrollPane embeddInScrollPane(JTable table) {
        JScrollPane pane = new JScrollPane(table);
        this.adjustmentSynchronizer.synchronizeAdjustment(pane.getVerticalScrollBar());
        return pane;
    }

    protected JScrollPane buildMineTagTable() {
        this.mineTable = new JTable(this.model, new TagMergeColumnModel(new MineTableCellRenderer()));
        this.mineTable.setName("table.my");
        return this.embeddInScrollPane(this.mineTable);
    }

    protected JScrollPane buildTheirTable() {
        this.theirTable = new JTable(this.model, new TagMergeColumnModel(new TheirTableCellRenderer()));
        this.theirTable.setName("table.their");
        return this.embeddInScrollPane(this.theirTable);
    }

    protected JScrollPane buildMergedTable() {
        this.mergedTable = new JTable(this.model, new TagMergeColumnModel(new MergedTableCellRenderer()));
        this.mergedTable.setName("table.merged");
        return this.embeddInScrollPane(this.mergedTable);
    }

    protected final void build() {
        GridBagConstraints gc = new GridBagConstraints();
        this.setLayout(new GridBagLayout());
        this.adjustmentSynchronizer = new AdjustmentSynchronizer();
        gc.gridx = 0;
        gc.gridy = 0;
        gc.gridwidth = 1;
        gc.gridheight = 1;
        gc.fill = 0;
        gc.anchor = 10;
        gc.weightx = 0.0;
        gc.weighty = 0.0;
        gc.insets = new Insets(10, 0, 10, 0);
        JLabel lbl = new JLabel(I18n.tr("My version (local dataset)", new Object[0]));
        this.add((Component)lbl, gc);
        gc.gridx = 2;
        gc.gridy = 0;
        gc.gridwidth = 1;
        gc.gridheight = 1;
        gc.fill = 0;
        gc.anchor = 10;
        gc.weightx = 0.0;
        gc.weighty = 0.0;
        lbl = new JLabel(I18n.tr("Merged version", new Object[0]));
        this.add((Component)lbl, gc);
        gc.gridx = 4;
        gc.gridy = 0;
        gc.gridwidth = 1;
        gc.gridheight = 1;
        gc.fill = 0;
        gc.anchor = 10;
        gc.weightx = 0.0;
        gc.weighty = 0.0;
        gc.insets = new Insets(0, 0, 0, 0);
        lbl = new JLabel(I18n.tr("Their version (server dataset)", new Object[0]));
        this.add((Component)lbl, gc);
        gc.gridx = 0;
        gc.gridy = 1;
        gc.gridwidth = 1;
        gc.gridheight = 1;
        gc.fill = 1;
        gc.anchor = 23;
        gc.weightx = 0.3;
        gc.weighty = 1.0;
        this.add((Component)this.buildMineTagTable(), gc);
        gc.gridx = 1;
        gc.gridy = 1;
        gc.gridwidth = 1;
        gc.gridheight = 1;
        gc.fill = 0;
        gc.anchor = 10;
        gc.weightx = 0.0;
        gc.weighty = 0.0;
        KeepMineAction keepMineAction = new KeepMineAction();
        this.mineTable.getSelectionModel().addListSelectionListener(keepMineAction);
        JButton btnKeepMine = new JButton(keepMineAction);
        btnKeepMine.setName("button.keepmine");
        this.add((Component)btnKeepMine, gc);
        gc.gridx = 2;
        gc.gridy = 1;
        gc.gridwidth = 1;
        gc.gridheight = 1;
        gc.fill = 1;
        gc.anchor = 23;
        gc.weightx = 0.3;
        gc.weighty = 1.0;
        this.add((Component)this.buildMergedTable(), gc);
        gc.gridx = 3;
        gc.gridy = 1;
        gc.gridwidth = 1;
        gc.gridheight = 1;
        gc.fill = 0;
        gc.anchor = 10;
        gc.weightx = 0.0;
        gc.weighty = 0.0;
        KeepTheirAction keepTheirAction = new KeepTheirAction();
        JButton btnKeepTheir = new JButton(keepTheirAction);
        btnKeepTheir.setName("button.keeptheir");
        this.add((Component)btnKeepTheir, gc);
        gc.gridx = 4;
        gc.gridy = 1;
        gc.gridwidth = 1;
        gc.gridheight = 1;
        gc.fill = 1;
        gc.anchor = 23;
        gc.weightx = 0.3;
        gc.weighty = 1.0;
        this.add((Component)this.buildTheirTable(), gc);
        this.theirTable.getSelectionModel().addListSelectionListener(keepTheirAction);
        DoubleClickAdapter dblClickAdapter = new DoubleClickAdapter();
        this.mineTable.addMouseListener(dblClickAdapter);
        this.theirTable.addMouseListener(dblClickAdapter);
        gc.gridx = 2;
        gc.gridy = 2;
        gc.gridwidth = 1;
        gc.gridheight = 1;
        gc.fill = 0;
        gc.anchor = 10;
        gc.weightx = 0.0;
        gc.weighty = 0.0;
        UndecideAction undecidedAction = new UndecideAction();
        this.mergedTable.getSelectionModel().addListSelectionListener(undecidedAction);
        JButton btnUndecide = new JButton(undecidedAction);
        btnUndecide.setName("button.undecide");
        this.add((Component)btnUndecide, gc);
    }

    public TagMerger() {
        this.build();
    }

    public TagMergeModel getModel() {
        return this.model;
    }

    private void selectNextConflict(int[] rows) {
        int max = rows[0];
        for (int row : rows) {
            if (row <= max) continue;
            max = row;
        }
        int index = this.model.getFirstUndecided(max + 1);
        if (index == -1) {
            index = this.model.getFirstUndecided(0);
        }
        this.mineTable.getSelectionModel().setSelectionInterval(index, index);
        this.theirTable.getSelectionModel().setSelectionInterval(index, index);
    }

    @Override
    public void deletePrimitive(boolean deleted) {
        MergeDecisionType decision = deleted ? MergeDecisionType.KEEP_MINE : MergeDecisionType.UNDECIDED;
        for (int i = 0; i < this.model.getRowCount(); ++i) {
            this.model.decide(i, decision);
        }
    }

    @Override
    public void populate(Conflict<? extends OsmPrimitive> conflict) {
        this.model.populate(conflict.getMy(), conflict.getTheir());
        for (JTable table : new JTable[]{this.mineTable, this.theirTable}) {
            int index = table.getRowCount() > 0 ? 0 : -1;
            table.getSelectionModel().setSelectionInterval(index, index);
        }
    }

    class UndecideAction
    extends AbstractAction
    implements ListSelectionListener {
        public UndecideAction() {
            ImageIcon icon = ImageProvider.get("dialogs/conflict", "tagundecide");
            if (icon != null) {
                this.putValue("SmallIcon", icon);
                this.putValue("Name", "");
            } else {
                this.putValue("Name", I18n.tr("Undecide", new Object[0]));
            }
            this.putValue("ShortDescription", I18n.tr("Mark the selected tags as undecided", new Object[0]));
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            int[] rows = TagMerger.this.mergedTable.getSelectedRows();
            if (rows == null || rows.length == 0) {
                return;
            }
            TagMerger.this.model.decide(rows, MergeDecisionType.UNDECIDED);
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            this.setEnabled(TagMerger.this.mergedTable.getSelectedRowCount() > 0);
        }
    }

    class DoubleClickAdapter
    extends MouseAdapter {
        DoubleClickAdapter() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            MergeDecisionType mergeDecision;
            if (e.getClickCount() != 2) {
                return;
            }
            JTable table = null;
            if (e.getSource() == TagMerger.this.mineTable) {
                table = TagMerger.this.mineTable;
                mergeDecision = MergeDecisionType.KEEP_MINE;
            } else if (e.getSource() == TagMerger.this.theirTable) {
                table = TagMerger.this.theirTable;
                mergeDecision = MergeDecisionType.KEEP_THEIR;
            } else if (e.getSource() == TagMerger.this.mergedTable) {
                table = TagMerger.this.mergedTable;
                mergeDecision = MergeDecisionType.UNDECIDED;
            } else {
                return;
            }
            int row = table.rowAtPoint(e.getPoint());
            TagMerger.this.model.decide(row, mergeDecision);
        }
    }

    static class AdjustmentSynchronizer
    implements AdjustmentListener {
        private final List<Adjustable> synchronizedAdjustables = new ArrayList<Adjustable>();

        public void synchronizeAdjustment(Adjustable adjustable) {
            if (adjustable == null) {
                return;
            }
            if (this.synchronizedAdjustables.contains(adjustable)) {
                return;
            }
            this.synchronizedAdjustables.add(adjustable);
            adjustable.addAdjustmentListener(this);
        }

        @Override
        public void adjustmentValueChanged(AdjustmentEvent e) {
            for (Adjustable a : this.synchronizedAdjustables) {
                if (a == e.getAdjustable()) continue;
                a.setValue(e.getValue());
            }
        }
    }

    class KeepTheirAction
    extends AbstractAction
    implements ListSelectionListener {
        public KeepTheirAction() {
            ImageIcon icon = ImageProvider.get("dialogs/conflict", "tagkeeptheir");
            if (icon != null) {
                this.putValue("SmallIcon", icon);
                this.putValue("Name", "");
            } else {
                this.putValue("Name", ">");
            }
            this.putValue("ShortDescription", I18n.tr("Keep the selected key/value pairs from the server dataset", new Object[0]));
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            int[] rows = TagMerger.this.theirTable.getSelectedRows();
            if (rows == null || rows.length == 0) {
                return;
            }
            TagMerger.this.model.decide(rows, MergeDecisionType.KEEP_THEIR);
            TagMerger.this.selectNextConflict(rows);
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            this.setEnabled(TagMerger.this.theirTable.getSelectedRowCount() > 0);
        }
    }

    class KeepMineAction
    extends AbstractAction
    implements ListSelectionListener {
        public KeepMineAction() {
            ImageIcon icon = ImageProvider.get("dialogs/conflict", "tagkeepmine");
            if (icon != null) {
                this.putValue("SmallIcon", icon);
                this.putValue("Name", "");
            } else {
                this.putValue("Name", ">");
            }
            this.putValue("ShortDescription", I18n.tr("Keep the selected key/value pairs from the local dataset", new Object[0]));
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            int[] rows = TagMerger.this.mineTable.getSelectedRows();
            if (rows == null || rows.length == 0) {
                return;
            }
            TagMerger.this.model.decide(rows, MergeDecisionType.KEEP_MINE);
            TagMerger.this.selectNextConflict(rows);
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            this.setEnabled(TagMerger.this.mineTable.getSelectedRowCount() > 0);
        }
    }
}

