/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.conflict.pair.tags;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.swing.table.DefaultTableModel;
import org.openstreetmap.josm.command.conflict.TagConflictResolveCommand;
import org.openstreetmap.josm.data.conflict.Conflict;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.gui.conflict.pair.MergeDecisionType;
import org.openstreetmap.josm.gui.conflict.pair.tags.TagMergeItem;

public class TagMergeModel
extends DefaultTableModel {
    public static final String PROP_NUM_UNDECIDED_TAGS = TagMergeModel.class.getName() + ".numUndecidedTags";
    private final List<TagMergeItem> tagMergeItems = new ArrayList<TagMergeItem>();
    private final List<PropertyChangeListener> listeners = new ArrayList<PropertyChangeListener>();
    private int numUndecidedTags = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        List<PropertyChangeListener> list = this.listeners;
        synchronized (list) {
            if (listener == null) {
                return;
            }
            if (this.listeners.contains(listener)) {
                return;
            }
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        List<PropertyChangeListener> list = this.listeners;
        synchronized (list) {
            if (listener == null) {
                return;
            }
            if (!this.listeners.contains(listener)) {
                return;
            }
            this.listeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireNumUndecidedTagsChanged(int oldValue, int newValue) {
        PropertyChangeEvent evt = new PropertyChangeEvent(this, PROP_NUM_UNDECIDED_TAGS, oldValue, newValue);
        List<PropertyChangeListener> list = this.listeners;
        synchronized (list) {
            for (PropertyChangeListener l : this.listeners) {
                l.propertyChange(evt);
            }
        }
    }

    protected void refreshNumUndecidedTags() {
        int newValue = 0;
        for (TagMergeItem item : this.tagMergeItems) {
            if (!MergeDecisionType.UNDECIDED.equals((Object)item.getMergeDecision())) continue;
            ++newValue;
        }
        int oldValue = this.numUndecidedTags;
        this.numUndecidedTags = newValue;
        this.fireNumUndecidedTagsChanged(oldValue, this.numUndecidedTags);
    }

    public void populate(OsmPrimitive my, OsmPrimitive their) {
        this.tagMergeItems.clear();
        HashSet<String> keys = new HashSet<String>();
        keys.addAll(my.keySet());
        keys.addAll(their.keySet());
        for (String key : keys) {
            String myValue = my.get(key);
            String theirValue = their.get(key);
            if (myValue != null && theirValue != null && myValue.equals(theirValue)) continue;
            this.tagMergeItems.add(new TagMergeItem(key, my, their));
        }
        this.fireTableDataChanged();
        this.refreshNumUndecidedTags();
    }

    public void addItem(TagMergeItem item) {
        if (item != null) {
            this.tagMergeItems.add(item);
            this.fireTableDataChanged();
            this.refreshNumUndecidedTags();
        }
    }

    protected void rememberDecision(int row, MergeDecisionType decision) {
        TagMergeItem item = this.tagMergeItems.get(row);
        item.decide(decision);
    }

    public void decide(int row, MergeDecisionType decision) {
        this.rememberDecision(row, decision);
        this.fireTableRowsUpdated(row, row);
        this.refreshNumUndecidedTags();
    }

    public void decide(int[] rows, MergeDecisionType decision) {
        if (rows == null || rows.length == 0) {
            return;
        }
        for (int row : rows) {
            this.rememberDecision(row, decision);
        }
        this.fireTableDataChanged();
        this.refreshNumUndecidedTags();
    }

    @Override
    public int getRowCount() {
        return this.tagMergeItems == null ? 0 : this.tagMergeItems.size();
    }

    @Override
    public Object getValueAt(int row, int column) {
        return this.tagMergeItems.get(row);
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return false;
    }

    public TagConflictResolveCommand buildResolveCommand(Conflict<? extends OsmPrimitive> conflict) {
        return new TagConflictResolveCommand(conflict, this.tagMergeItems);
    }

    public boolean isResolvedCompletely() {
        for (TagMergeItem item : this.tagMergeItems) {
            if (!item.getMergeDecision().equals((Object)MergeDecisionType.UNDECIDED)) continue;
            return false;
        }
        return true;
    }

    public int getNumResolvedConflicts() {
        int n = 0;
        for (TagMergeItem item : this.tagMergeItems) {
            if (item.getMergeDecision().equals((Object)MergeDecisionType.UNDECIDED)) continue;
            ++n;
        }
        return n;
    }

    public int getFirstUndecided(int startIndex) {
        for (int i = startIndex; i < this.tagMergeItems.size(); ++i) {
            if (this.tagMergeItems.get(i).getMergeDecision() != MergeDecisionType.UNDECIDED) continue;
            return i;
        }
        return -1;
    }
}

