/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.conflict.pair.relation;

import java.util.List;
import java.util.Map;
import javax.swing.table.DefaultTableModel;
import org.openstreetmap.josm.command.conflict.RelationMemberConflictResolverCommand;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.gui.conflict.pair.ListMergeModel;
import org.openstreetmap.josm.gui.conflict.pair.ListRole;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;

public class RelationMemberListMergeModel
extends ListMergeModel<RelationMember> {
    @Override
    public boolean isEqualEntry(RelationMember e1, RelationMember e2) {
        return e1.equals(e2);
    }

    @Override
    protected void buildMergedEntriesTableModel() {
        this.mergedEntriesTableModel = new ListMergeModel.EntriesTableModel(this, ListRole.MERGED_ENTRIES){
            {
                RelationMemberListMergeModel relationMemberListMergeModel2 = x0;
                relationMemberListMergeModel2.getClass();
                super(x1);
            }

            @Override
            public boolean isCellEditable(int row, int column) {
                switch (column) {
                    case 1: {
                        return true;
                    }
                }
                return false;
            }
        };
    }

    @Override
    protected void setValueAt(DefaultTableModel model, Object value, int row, int col) {
        if (model == this.getMergedTableModel() && col == 1) {
            RelationMember memberOld = (RelationMember)this.getMergedEntries().get(row);
            RelationMember memberNew = new RelationMember((String)value, memberOld.getMember());
            this.getMergedEntries().remove(row);
            this.getMergedEntries().add(row, memberNew);
            this.fireModelDataChanged();
        }
    }

    public void populate(Relation my, Relation their, Map<PrimitiveId, PrimitiveId> mergedMap) {
        this.initPopulate(my, their, mergedMap);
        for (RelationMember n : my.getMembers()) {
            this.getMyEntries().add(n);
        }
        for (RelationMember n : their.getMembers()) {
            this.getTheirEntries().add(n);
        }
        if (this.myAndTheirEntriesEqual()) {
            for (RelationMember m : this.getMyEntries()) {
                this.getMergedEntries().add(this.cloneEntryForMergedList(m));
            }
            this.setFrozen(true);
        } else {
            this.setFrozen(false);
        }
        this.fireModelDataChanged();
    }

    @Override
    protected RelationMember cloneEntryForMergedList(RelationMember entry) {
        return new RelationMember(entry.getRole(), this.getMyPrimitive(entry));
    }

    @Override
    public OsmPrimitive getMyPrimitive(RelationMember entry) {
        return this.getMyPrimitiveById(entry.getMember());
    }

    public RelationMemberConflictResolverCommand buildResolveCommand(Relation my, Relation their) {
        CheckParameterUtil.ensureParameterNotNull(my, "my");
        CheckParameterUtil.ensureParameterNotNull(their, "their");
        if (!this.isFrozen()) {
            throw new IllegalArgumentException(I18n.tr("Merged nodes not frozen yet. Cannot build resolution command", new Object[0]));
        }
        List<RelationMember> entries = this.getMergedEntries();
        return new RelationMemberConflictResolverCommand(my, their, entries);
    }
}

