/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.conflict.pair;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultListSelectionModel;
import javax.swing.table.DefaultTableModel;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.gui.HelpAwareOptionPane;
import org.openstreetmap.josm.gui.conflict.pair.ComparePairType;
import org.openstreetmap.josm.gui.conflict.pair.ListMergeModel;
import org.openstreetmap.josm.gui.conflict.pair.ListRole;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.widgets.OsmPrimitivesTableModel;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Utils;

public abstract class ListMergeModel<T extends PrimitiveId>
extends Observable {
    public static final String FROZEN_PROP = ListMergeModel.class.getName() + ".frozen";
    protected Map<ListRole, ArrayList<T>> entries = new HashMap<ListRole, ArrayList<T>>();
    protected ListMergeModel.ListMergeModel.ListMergeModel.EntriesTableModel myEntriesTableModel;
    protected ListMergeModel.ListMergeModel.ListMergeModel.EntriesTableModel theirEntriesTableModel;
    protected ListMergeModel.ListMergeModel.ListMergeModel.EntriesTableModel mergedEntriesTableModel;
    protected ListMergeModel.ListMergeModel.ListMergeModel.EntriesSelectionModel myEntriesSelectionModel;
    protected ListMergeModel.ListMergeModel.ListMergeModel.EntriesSelectionModel theirEntriesSelectionModel;
    protected ListMergeModel.ListMergeModel.ListMergeModel.EntriesSelectionModel mergedEntriesSelectionModel;
    private final List<PropertyChangeListener> listeners;
    private boolean isFrozen = false;
    private final ListMergeModel.ComparePairListModel comparePairListModel;
    private DataSet myDataset;
    private Map<PrimitiveId, PrimitiveId> mergedMap;

    protected abstract T cloneEntryForMergedList(T var1);

    public abstract boolean isEqualEntry(T var1, T var2);

    protected abstract void setValueAt(DefaultTableModel var1, Object var2, int var3, int var4);

    public OsmPrimitive getMyPrimitive(T entry) {
        return this.getMyPrimitiveById((PrimitiveId)entry);
    }

    public final OsmPrimitive getMyPrimitiveById(PrimitiveId entry) {
        OsmPrimitive result = this.myDataset.getPrimitiveById(entry);
        if (result == null && this.mergedMap != null) {
            PrimitiveId id = this.mergedMap.get(entry);
            if (id == null && entry instanceof OsmPrimitive) {
                id = this.mergedMap.get(((OsmPrimitive)entry).getPrimitiveId());
            }
            if (id != null) {
                result = this.myDataset.getPrimitiveById(id);
            }
        }
        return result;
    }

    protected void buildMyEntriesTableModel() {
        this.myEntriesTableModel = new EntriesTableModel(ListRole.MY_ENTRIES);
    }

    protected void buildTheirEntriesTableModel() {
        this.theirEntriesTableModel = new EntriesTableModel(ListRole.THEIR_ENTRIES);
    }

    protected void buildMergedEntriesTableModel() {
        this.mergedEntriesTableModel = new EntriesTableModel(ListRole.MERGED_ENTRIES);
    }

    protected List<T> getMergedEntries() {
        return this.entries.get((Object)ListRole.MERGED_ENTRIES);
    }

    protected List<T> getMyEntries() {
        return this.entries.get((Object)ListRole.MY_ENTRIES);
    }

    protected List<T> getTheirEntries() {
        return this.entries.get((Object)ListRole.THEIR_ENTRIES);
    }

    public int getMyEntriesSize() {
        return this.getMyEntries().size();
    }

    public int getMergedEntriesSize() {
        return this.getMergedEntries().size();
    }

    public int getTheirEntriesSize() {
        return this.getTheirEntries().size();
    }

    public ListMergeModel() {
        for (ListRole role : ListRole.values()) {
            this.entries.put(role, new ArrayList());
        }
        this.buildMyEntriesTableModel();
        this.buildTheirEntriesTableModel();
        this.buildMergedEntriesTableModel();
        this.myEntriesSelectionModel = new EntriesSelectionModel(this.entries.get((Object)ListRole.MY_ENTRIES));
        this.theirEntriesSelectionModel = new EntriesSelectionModel(this.entries.get((Object)ListRole.THEIR_ENTRIES));
        this.mergedEntriesSelectionModel = new EntriesSelectionModel(this.entries.get((Object)ListRole.MERGED_ENTRIES));
        this.listeners = new ArrayList<PropertyChangeListener>();
        this.comparePairListModel = new ComparePairListModel();
        this.setFrozen(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        List<PropertyChangeListener> list = this.listeners;
        synchronized (list) {
            if (listener != null && !this.listeners.contains(listener)) {
                this.listeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        List<PropertyChangeListener> list = this.listeners;
        synchronized (list) {
            if (listener != null && this.listeners.contains(listener)) {
                this.listeners.remove(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireFrozenChanged(boolean oldValue, boolean newValue) {
        List<PropertyChangeListener> list = this.listeners;
        synchronized (list) {
            PropertyChangeEvent evt = new PropertyChangeEvent(this, FROZEN_PROP, oldValue, newValue);
            for (PropertyChangeListener listener : this.listeners) {
                listener.propertyChange(evt);
            }
        }
    }

    public final void setFrozen(boolean isFrozen) {
        boolean oldValue = this.isFrozen;
        this.isFrozen = isFrozen;
        this.fireFrozenChanged(oldValue, this.isFrozen);
    }

    public final boolean isFrozen() {
        return this.isFrozen;
    }

    public OsmPrimitivesTableModel getMyTableModel() {
        return this.myEntriesTableModel;
    }

    public OsmPrimitivesTableModel getTheirTableModel() {
        return this.theirEntriesTableModel;
    }

    public OsmPrimitivesTableModel getMergedTableModel() {
        return this.mergedEntriesTableModel;
    }

    public ListMergeModel.ListMergeModel.ListMergeModel.EntriesSelectionModel getMySelectionModel() {
        return this.myEntriesSelectionModel;
    }

    public ListMergeModel.ListMergeModel.ListMergeModel.EntriesSelectionModel getTheirSelectionModel() {
        return this.theirEntriesSelectionModel;
    }

    public ListMergeModel.ListMergeModel.ListMergeModel.EntriesSelectionModel getMergedSelectionModel() {
        return this.mergedEntriesSelectionModel;
    }

    protected void fireModelDataChanged() {
        this.myEntriesTableModel.fireTableDataChanged();
        this.theirEntriesTableModel.fireTableDataChanged();
        this.mergedEntriesTableModel.fireTableDataChanged();
        this.setChanged();
        this.notifyObservers();
    }

    protected void copyToTop(ListRole role, int[] rows) {
        this.copy(role, rows, 0);
        this.mergedEntriesSelectionModel.setSelectionInterval(0, rows.length - 1);
    }

    public void copyMyToTop(int[] rows) {
        this.copyToTop(ListRole.MY_ENTRIES, rows);
    }

    public void copyTheirToTop(int[] rows) {
        this.copyToTop(ListRole.THEIR_ENTRIES, rows);
    }

    public void copyToEnd(ListRole source, int[] rows) {
        this.copy(source, rows, this.getMergedEntriesSize());
        this.mergedEntriesSelectionModel.setSelectionInterval(this.getMergedEntriesSize() - rows.length, this.getMergedEntriesSize() - 1);
    }

    public void copyMyToEnd(int[] rows) {
        this.copyToEnd(ListRole.MY_ENTRIES, rows);
    }

    public void copyTheirToEnd(int[] rows) {
        this.copyToEnd(ListRole.THEIR_ENTRIES, rows);
    }

    public void clearMerged() {
        this.getMergedEntries().clear();
        this.fireModelDataChanged();
    }

    protected final void initPopulate(OsmPrimitive my, OsmPrimitive their, Map<PrimitiveId, PrimitiveId> mergedMap) {
        CheckParameterUtil.ensureParameterNotNull(my, "my");
        CheckParameterUtil.ensureParameterNotNull(their, "their");
        this.myDataset = my.getDataSet();
        this.mergedMap = mergedMap;
        this.getMergedEntries().clear();
        this.getMyEntries().clear();
        this.getTheirEntries().clear();
    }

    protected void alertCopyFailedForDeletedPrimitives(List<PrimitiveId> deletedIds) {
        ArrayList<String> items = new ArrayList<String>();
        for (int i = 0; i < Math.min(5, deletedIds.size()); ++i) {
            items.add(deletedIds.get(i).toString());
        }
        if (deletedIds.size() > 5) {
            items.add(I18n.tr("{0} more...", deletedIds.size() - 5));
        }
        StringBuilder sb = new StringBuilder();
        sb.append("<html>");
        sb.append(I18n.tr("The following objects could not be copied to the target object<br>because they are deleted in the target dataset:", new Object[0]));
        sb.append(Utils.joinAsHtmlUnorderedList(items));
        sb.append("</html>");
        HelpAwareOptionPane.showOptionDialog(Main.parent, sb.toString(), I18n.tr("Merging deleted objects failed", new Object[0]), 2, HelpUtil.ht("/Dialog/Conflict#MergingDeletedPrimitivesFailed"));
    }

    private void copy(ListRole sourceRole, int[] rows, int position) {
        if (position < 0 || position > this.getMergedEntriesSize()) {
            throw new IllegalArgumentException("Position must be between 0 and " + this.getMergedEntriesSize() + " but is " + position);
        }
        ArrayList<PrimitiveId> newItems = new ArrayList<PrimitiveId>(rows.length);
        List source = this.entries.get((Object)sourceRole);
        ArrayList<PrimitiveId> deletedIds = new ArrayList<PrimitiveId>();
        for (int row : rows) {
            PrimitiveId entry = (PrimitiveId)source.get(row);
            OsmPrimitive primitive = this.getMyPrimitive(entry);
            if (!primitive.isDeleted()) {
                PrimitiveId clone = this.cloneEntryForMergedList(entry);
                newItems.add(clone);
                continue;
            }
            deletedIds.add(primitive.getPrimitiveId());
        }
        this.getMergedEntries().addAll(position, newItems);
        this.fireModelDataChanged();
        if (!deletedIds.isEmpty()) {
            this.alertCopyFailedForDeletedPrimitives(deletedIds);
        }
    }

    public void copyAll(ListRole source) {
        this.getMergedEntries().clear();
        int[] rows = new int[this.entries.get((Object)source).size()];
        for (int i = 0; i < rows.length; ++i) {
            rows[i] = i;
        }
        this.copy(source, rows, 0);
    }

    protected void copyBeforeCurrent(ListRole source, int[] rows, int current) {
        this.copy(source, rows, current);
        this.mergedEntriesSelectionModel.setSelectionInterval(current, current + rows.length - 1);
    }

    public void copyMyBeforeCurrent(int[] rows, int current) {
        this.copyBeforeCurrent(ListRole.MY_ENTRIES, rows, current);
    }

    public void copyTheirBeforeCurrent(int[] rows, int current) {
        this.copyBeforeCurrent(ListRole.THEIR_ENTRIES, rows, current);
    }

    protected void copyAfterCurrent(ListRole source, int[] rows, int current) {
        this.copy(source, rows, current + 1);
        this.mergedEntriesSelectionModel.setSelectionInterval(current + 1, current + rows.length - 1);
        this.notifyObservers();
    }

    public void copyMyAfterCurrent(int[] rows, int current) {
        this.copyAfterCurrent(ListRole.MY_ENTRIES, rows, current);
    }

    public void copyTheirAfterCurrent(int[] rows, int current) {
        this.copyAfterCurrent(ListRole.THEIR_ENTRIES, rows, current);
    }

    public void moveUpMerged(int[] rows) {
        if (rows == null || rows.length == 0) {
            return;
        }
        if (rows[0] == 0) {
            return;
        }
        List<T> mergedEntries = this.getMergedEntries();
        for (int row : rows) {
            PrimitiveId n = (PrimitiveId)mergedEntries.get(row);
            mergedEntries.remove(row);
            mergedEntries.add(row - 1, n);
        }
        this.fireModelDataChanged();
        this.notifyObservers();
        this.mergedEntriesSelectionModel.clearSelection();
        for (int row : rows) {
            this.mergedEntriesSelectionModel.addSelectionInterval(row - 1, row - 1);
        }
    }

    public void moveDownMerged(int[] rows) {
        if (rows == null || rows.length == 0) {
            return;
        }
        List<T> mergedEntries = this.getMergedEntries();
        if (rows[rows.length - 1] == mergedEntries.size() - 1) {
            return;
        }
        for (int i = rows.length - 1; i >= 0; --i) {
            int row = rows[i];
            PrimitiveId n = (PrimitiveId)mergedEntries.get(row);
            mergedEntries.remove(row);
            mergedEntries.add(row + 1, n);
        }
        this.fireModelDataChanged();
        this.notifyObservers();
        this.mergedEntriesSelectionModel.clearSelection();
        for (int row : rows) {
            this.mergedEntriesSelectionModel.addSelectionInterval(row + 1, row + 1);
        }
    }

    public void removeMerged(int[] rows) {
        if (rows == null || rows.length == 0) {
            return;
        }
        List<T> mergedEntries = this.getMergedEntries();
        for (int i = rows.length - 1; i >= 0; --i) {
            mergedEntries.remove(rows[i]);
        }
        this.fireModelDataChanged();
        this.notifyObservers();
        this.mergedEntriesSelectionModel.clearSelection();
    }

    protected boolean myAndTheirEntriesEqual() {
        if (this.getMyEntriesSize() != this.getTheirEntriesSize()) {
            return false;
        }
        for (int i = 0; i < this.getMyEntriesSize(); ++i) {
            if (this.isEqualEntry((PrimitiveId)this.getMyEntries().get(i), (PrimitiveId)this.getTheirEntries().get(i))) continue;
            return false;
        }
        return true;
    }

    public ListMergeModel.ComparePairListModel getComparePairListModel() {
        return this.comparePairListModel;
    }

    public class ComparePairListModel
    extends AbstractListModel<ComparePairType>
    implements ComboBoxModel<ComparePairType> {
        private int selectedIdx;
        private final List<ComparePairType> compareModes = new ArrayList<ComparePairType>();

        public ComparePairListModel() {
            this.compareModes.add(ComparePairType.MY_WITH_THEIR);
            this.compareModes.add(ComparePairType.MY_WITH_MERGED);
            this.compareModes.add(ComparePairType.THEIR_WITH_MERGED);
            this.selectedIdx = 0;
        }

        @Override
        public ComparePairType getElementAt(int index) {
            if (index < this.compareModes.size()) {
                return this.compareModes.get(index);
            }
            throw new IllegalArgumentException(I18n.tr("Unexpected value of parameter ''index''. Got {0}.", index));
        }

        @Override
        public int getSize() {
            return this.compareModes.size();
        }

        @Override
        public Object getSelectedItem() {
            return this.compareModes.get(this.selectedIdx);
        }

        @Override
        public void setSelectedItem(Object anItem) {
            int i = this.compareModes.indexOf(anItem);
            if (i < 0) {
                throw new IllegalStateException(I18n.tr("Item {0} not found in list.", anItem));
            }
            this.selectedIdx = i;
            ListMergeModel.this.fireModelDataChanged();
        }

        public ComparePairType getSelectedComparePair() {
            return this.compareModes.get(this.selectedIdx);
        }
    }

    protected class EntriesSelectionModel
    extends DefaultListSelectionModel {
        private final List<T> entries;

        public EntriesSelectionModel(ArrayList<T> nodes) {
            this.entries = nodes;
        }

        @Override
        public void addSelectionInterval(int index0, int index1) {
            if (this.entries.isEmpty()) {
                return;
            }
            if (index0 > this.entries.size() - 1) {
                return;
            }
            index0 = Math.min(this.entries.size() - 1, index0);
            index1 = Math.min(this.entries.size() - 1, index1);
            super.addSelectionInterval(index0, index1);
        }

        @Override
        public void insertIndexInterval(int index, int length, boolean before) {
            if (this.entries.isEmpty()) {
                return;
            }
            if (before) {
                int newindex = Math.min(this.entries.size() - 1, index);
                if (newindex < index - length) {
                    return;
                }
                super.insertIndexInterval(newindex, length -= index - newindex, before);
            } else {
                if (index > this.entries.size() - 1) {
                    return;
                }
                length = Math.min(this.entries.size() - 1 - index, length);
                super.insertIndexInterval(index, length, before);
            }
        }

        @Override
        public void moveLeadSelectionIndex(int leadIndex) {
            if (this.entries.isEmpty()) {
                return;
            }
            leadIndex = Math.max(0, leadIndex);
            leadIndex = Math.min(this.entries.size() - 1, leadIndex);
            super.moveLeadSelectionIndex(leadIndex);
        }

        @Override
        public void removeIndexInterval(int index0, int index1) {
            if (this.entries.isEmpty()) {
                return;
            }
            index0 = Math.max(0, index0);
            index0 = Math.min(this.entries.size() - 1, index0);
            index1 = Math.max(0, index1);
            index1 = Math.min(this.entries.size() - 1, index1);
            super.removeIndexInterval(index0, index1);
        }

        @Override
        public void removeSelectionInterval(int index0, int index1) {
            if (this.entries.isEmpty()) {
                return;
            }
            index0 = Math.max(0, index0);
            index0 = Math.min(this.entries.size() - 1, index0);
            index1 = Math.max(0, index1);
            index1 = Math.min(this.entries.size() - 1, index1);
            super.removeSelectionInterval(index0, index1);
        }

        @Override
        public void setAnchorSelectionIndex(int anchorIndex) {
            if (this.entries.isEmpty()) {
                return;
            }
            anchorIndex = Math.min(this.entries.size() - 1, anchorIndex);
            super.setAnchorSelectionIndex(anchorIndex);
        }

        @Override
        public void setLeadSelectionIndex(int leadIndex) {
            if (this.entries.isEmpty()) {
                return;
            }
            leadIndex = Math.min(this.entries.size() - 1, leadIndex);
            super.setLeadSelectionIndex(leadIndex);
        }

        @Override
        public void setSelectionInterval(int index0, int index1) {
            if (this.entries.isEmpty()) {
                return;
            }
            index0 = Math.max(0, index0);
            index0 = Math.min(this.entries.size() - 1, index0);
            index1 = Math.max(0, index1);
            index1 = Math.min(this.entries.size() - 1, index1);
            super.setSelectionInterval(index0, index1);
        }
    }

    public class EntriesTableModel
    extends DefaultTableModel
    implements OsmPrimitivesTableModel {
        private final ListRole role;

        public EntriesTableModel(ListRole role) {
            this.role = role;
        }

        @Override
        public int getRowCount() {
            int count = Math.max(ListMergeModel.this.getMyEntries().size(), ListMergeModel.this.getMergedEntries().size());
            count = Math.max(count, ListMergeModel.this.getTheirEntries().size());
            return count;
        }

        @Override
        public Object getValueAt(int row, int column) {
            if (row < ListMergeModel.this.entries.get((Object)this.role).size()) {
                return ListMergeModel.this.entries.get((Object)this.role).get(row);
            }
            return null;
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return false;
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            ListMergeModel.this.setValueAt(this, value, row, col);
        }

        public ListMergeModel<T> getListMergeModel() {
            return ListMergeModel.this;
        }

        public boolean isParticipatingInCurrentComparePair() {
            return ListMergeModel.this.getComparePairListModel().getSelectedComparePair().isParticipatingIn(this.role);
        }

        public boolean isSamePositionInOppositeList(int row) {
            if (!this.isParticipatingInCurrentComparePair()) {
                throw new IllegalStateException(I18n.tr("List in role {0} is currently not participating in a compare pair.", this.role.toString()));
            }
            if (row >= this.getEntries().size()) {
                return false;
            }
            if (row >= this.getOppositeEntries().size()) {
                return false;
            }
            PrimitiveId e1 = (PrimitiveId)this.getEntries().get(row);
            PrimitiveId e2 = (PrimitiveId)this.getOppositeEntries().get(row);
            return ListMergeModel.this.isEqualEntry(e1, e2);
        }

        public boolean isIncludedInOppositeList(int row) {
            if (!this.isParticipatingInCurrentComparePair()) {
                throw new IllegalStateException(I18n.tr("List in role {0} is currently not participating in a compare pair.", this.role.toString()));
            }
            if (row >= this.getEntries().size()) {
                return false;
            }
            PrimitiveId e1 = (PrimitiveId)this.getEntries().get(row);
            for (PrimitiveId e2 : this.getOppositeEntries()) {
                if (!ListMergeModel.this.isEqualEntry(e1, e2)) continue;
                return true;
            }
            return false;
        }

        protected List<T> getEntries() {
            return ListMergeModel.this.entries.get((Object)this.role);
        }

        protected List<T> getOppositeEntries() {
            ListRole opposite = ListMergeModel.this.getComparePairListModel().getSelectedComparePair().getOppositeRole(this.role);
            return ListMergeModel.this.entries.get((Object)opposite);
        }

        public ListRole getRole() {
            return this.role;
        }

        @Override
        public OsmPrimitive getReferredPrimitive(int idx) {
            Object value = this.getValueAt(idx, 1);
            if (value instanceof OsmPrimitive) {
                return (OsmPrimitive)value;
            }
            if (value instanceof RelationMember) {
                return ((RelationMember)value).getMember();
            }
            Main.error("Unknown object type: " + value);
            return null;
        }
    }
}

