/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.conflict.pair;

import org.openstreetmap.josm.gui.conflict.pair.ListRole;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Utils;

public enum ComparePairType {
    MY_WITH_THEIR(I18n.tr("My with Their", new Object[0]), new ListRole[]{ListRole.MY_ENTRIES, ListRole.THEIR_ENTRIES}),
    MY_WITH_MERGED(I18n.tr("My with Merged", new Object[0]), new ListRole[]{ListRole.MY_ENTRIES, ListRole.MERGED_ENTRIES}),
    THEIR_WITH_MERGED(I18n.tr("Their with Merged", new Object[0]), new ListRole[]{ListRole.THEIR_ENTRIES, ListRole.MERGED_ENTRIES});

    private final String displayName;
    private ListRole[] participatingRoles;

    private ComparePairType(String displayName, ListRole[] participatingRoles) {
        this.displayName = displayName;
        this.participatingRoles = Utils.copyArray(participatingRoles);
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public boolean isParticipatingIn(ListRole role) {
        for (ListRole r : this.participatingRoles) {
            if (!r.equals((Object)role)) continue;
            return true;
        }
        return false;
    }

    public ListRole[] getParticipatingRoles() {
        return this.participatingRoles;
    }

    public ListRole getOppositeRole(ListRole role) {
        if (!this.isParticipatingIn(role)) {
            throw new IllegalStateException(I18n.tr("Role {0} is not participating in compare pair {1}.", role.toString(), this.toString()));
        }
        if (this.participatingRoles[0].equals((Object)role)) {
            return this.participatingRoles[1];
        }
        return this.participatingRoles[0];
    }
}

