/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.bbox;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Collection;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import org.openstreetmap.gui.jmapviewer.interfaces.TileSource;
import org.openstreetmap.josm.gui.bbox.SlippyMapBBoxChooser;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.ImageProvider;

public class SourceButton
extends JComponent {
    private TileSource[] sources;
    private final ImageIcon enlargeImage;
    private final ImageIcon shrinkImage;
    private final Dimension hiddenDimension;
    private int barWidth;
    private Dimension shownDimension;
    private Font font;
    private boolean isEnlarged = false;
    private int currentMap;
    private final SlippyMapBBoxChooser slippyMapBBoxChooser;
    private final MouseListener mouseListener = new MouseAdapter(){

        @Override
        public void mouseReleased(MouseEvent e) {
            if (e.getButton() == 1) {
                Point point = e.getPoint();
                if (SourceButton.this.isEnlarged) {
                    if (SourceButton.this.barWidth < point.x && point.y < SourceButton.this.shrinkImage.getIconHeight()) {
                        SourceButton.this.toggle();
                    } else {
                        int result = (point.y - 5) / 20;
                        if (result >= 0 && result < SourceButton.this.sources.length) {
                            SourceButton.this.slippyMapBBoxChooser.toggleMapSource(SourceButton.this.sources[result]);
                            SourceButton.this.currentMap = result;
                            SourceButton.this.toggle();
                        }
                    }
                } else {
                    SourceButton.this.toggle();
                }
            }
        }
    };

    public SourceButton(SlippyMapBBoxChooser slippyMapBBoxChooser, Collection<TileSource> sources) {
        this.slippyMapBBoxChooser = slippyMapBBoxChooser;
        this.setSources(sources);
        this.enlargeImage = ImageProvider.get("layer-switcher-maximize");
        this.shrinkImage = ImageProvider.get("layer-switcher-minimize");
        this.hiddenDimension = new Dimension(this.enlargeImage.getIconWidth(), this.enlargeImage.getIconHeight());
        this.setPreferredSize(this.hiddenDimension);
        this.addMouseListener(this.mouseListener);
    }

    public final void setSources(Collection<TileSource> sources) {
        CheckParameterUtil.ensureParameterNotNull(sources, "sources");
        this.sources = sources.toArray(new TileSource[sources.size()]);
        this.shownDimension = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void paintComponent(Graphics graphics) {
        Graphics2D g = (Graphics2D)graphics.create();
        try {
            this.calculateShownDimension();
            g.setFont(this.font);
            if (this.isEnlarged) {
                g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                int radioButtonSize = 10;
                g.setColor(new Color(0, 0, 139, 179));
                g.fillRoundRect(0, 0, this.barWidth + this.shrinkImage.getIconWidth(), this.sources.length * 20 + 5 + 5, 10, 10);
                for (int i = 0; i < this.sources.length; ++i) {
                    g.setColor(Color.WHITE);
                    g.fillOval(5, 5 + i * 20 + 6, radioButtonSize, radioButtonSize);
                    g.drawString(this.sources[i].getName(), 5 + radioButtonSize + 5, 5 + i * 20 + g.getFontMetrics().getHeight());
                    if (this.currentMap != i) continue;
                    g.setColor(Color.BLACK);
                    g.fillOval(6, 12 + i * 20, radioButtonSize - 2, radioButtonSize - 2);
                }
                g.drawImage(this.shrinkImage.getImage(), this.barWidth, 0, null);
            } else {
                g.drawImage(this.enlargeImage.getImage(), 0, 0, null);
            }
        }
        finally {
            g.dispose();
        }
    }

    public void toggle() {
        this.isEnlarged = !this.isEnlarged;
        this.calculateShownDimension();
        this.setPreferredSize(this.isEnlarged ? this.shownDimension : this.hiddenDimension);
        this.revalidate();
    }

    public void setCurrentMap(TileSource tileSource) {
        for (int i = 0; i < this.sources.length; ++i) {
            if (!this.sources[i].equals(tileSource)) continue;
            this.currentMap = i;
            return;
        }
        this.currentMap = 0;
    }

    private void calculateShownDimension() {
        if (this.shownDimension == null) {
            this.font = this.getFont().deriveFont(1).deriveFont(15.0f);
            int textWidth = 0;
            FontMetrics fm = this.getFontMetrics(this.font);
            for (TileSource source : this.sources) {
                int width = fm.stringWidth(source.getName());
                if (width <= textWidth) continue;
                textWidth = width;
            }
            this.barWidth = textWidth + 50;
            this.shownDimension = new Dimension(this.barWidth + this.shrinkImage.getIconWidth(), this.sources.length * 20 + 5 + 5);
        }
    }
}

