/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.bbox;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.JOptionPane;
import javax.swing.SpringLayout;
import org.openstreetmap.gui.jmapviewer.Coordinate;
import org.openstreetmap.gui.jmapviewer.JMapViewer;
import org.openstreetmap.gui.jmapviewer.MapMarkerDot;
import org.openstreetmap.gui.jmapviewer.MemoryTileCache;
import org.openstreetmap.gui.jmapviewer.OsmTileLoader;
import org.openstreetmap.gui.jmapviewer.interfaces.MapMarker;
import org.openstreetmap.gui.jmapviewer.interfaces.TileLoader;
import org.openstreetmap.gui.jmapviewer.interfaces.TileSource;
import org.openstreetmap.gui.jmapviewer.tilesources.AbstractTMSTileSource;
import org.openstreetmap.gui.jmapviewer.tilesources.MapQuestOpenAerialTileSource;
import org.openstreetmap.gui.jmapviewer.tilesources.MapQuestOsmTileSource;
import org.openstreetmap.gui.jmapviewer.tilesources.OsmTileSource;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.Version;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.imagery.ImageryInfo;
import org.openstreetmap.josm.data.imagery.ImageryLayerInfo;
import org.openstreetmap.josm.data.preferences.StringProperty;
import org.openstreetmap.josm.gui.bbox.BBoxChooser;
import org.openstreetmap.josm.gui.bbox.SizeButton;
import org.openstreetmap.josm.gui.bbox.SlippyMapControler;
import org.openstreetmap.josm.gui.bbox.SourceButton;
import org.openstreetmap.josm.gui.layer.TMSLayer;
import org.openstreetmap.josm.tools.I18n;

public class SlippyMapBBoxChooser
extends JMapViewer
implements BBoxChooser {
    private static CopyOnWriteArrayList<TileSourceProvider> providers = new CopyOnWriteArrayList();
    private static final StringProperty PROP_MAPSTYLE;
    public static final String RESIZE_PROP;
    private TileLoader cachedLoader;
    private OsmTileLoader uncachedLoader;
    private final SizeButton iSizeButton;
    private final SourceButton iSourceButton;
    private Bounds bbox;
    Point iSelectionRectStart;
    Point iSelectionRectEnd;

    public static void addTileSourceProvider(TileSourceProvider tileSourceProvider) {
        providers.addIfAbsent(tileSourceProvider);
    }

    public SlippyMapBBoxChooser() {
        debug = Main.isDebugEnabled();
        SpringLayout springLayout = new SpringLayout();
        this.setLayout(springLayout);
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("User-Agent", Version.getInstance().getFullAgentString());
        this.cachedLoader = TMSLayer.loaderFactory.makeTileLoader(this, headers);
        this.uncachedLoader = new OsmTileLoader(this);
        this.uncachedLoader.headers.putAll(headers);
        this.setZoomContolsVisible(Main.pref.getBoolean("slippy_map_chooser.zoomcontrols", false));
        this.setMapMarkerVisible(false);
        this.setMinimumSize(new Dimension(350, 175));
        this.setBounds(new Rectangle(this.getMinimumSize()));
        if (this.cachedLoader == null) {
            this.setFileCacheEnabled(false);
        } else {
            this.setFileCacheEnabled(Main.pref.getBoolean("slippy_map_chooser.file_cache", true));
        }
        this.setMaxTilesInMemory(Main.pref.getInteger("slippy_map_chooser.max_tiles", 1000));
        List<TileSource> tileSources = this.getAllTileSources();
        this.iSourceButton = new SourceButton(this, tileSources);
        this.add(this.iSourceButton);
        springLayout.putConstraint("East", (Component)this.iSourceButton, 0, "East", (Component)this);
        springLayout.putConstraint("North", (Component)this.iSourceButton, 30, "North", (Component)this);
        this.iSizeButton = new SizeButton(this);
        this.add(this.iSizeButton);
        String mapStyle = PROP_MAPSTYLE.get();
        boolean foundSource = false;
        for (TileSource source : tileSources) {
            if (!source.getName().equals(mapStyle)) continue;
            this.setTileSource(source);
            this.iSourceButton.setCurrentMap(source);
            foundSource = true;
            break;
        }
        if (!foundSource) {
            this.setTileSource(tileSources.get(0));
            this.iSourceButton.setCurrentMap(tileSources.get(0));
        }
        new SlippyMapControler(this, this);
    }

    private List<TileSource> getAllTileSources() {
        ArrayList<TileSource> tileSources = new ArrayList<TileSource>();
        for (TileSourceProvider provider : providers) {
            tileSources.addAll(provider.getTileSources());
        }
        return tileSources;
    }

    public boolean handleAttribution(Point p, boolean click) {
        return this.attribution.handleAttribution(p, click);
    }

    protected Point getTopLeftCoordinates() {
        return new Point(this.center.x - this.getWidth() / 2, this.center.y - this.getHeight() / 2);
    }

    @Override
    public void paint(Graphics g) {
        try {
            super.paint(g);
            if (this.iSelectionRectStart != null && this.iSelectionRectEnd != null) {
                int zoomDiff = 22 - this.zoom;
                Point tlc = this.getTopLeftCoordinates();
                int x_min = (this.iSelectionRectStart.x >> zoomDiff) - tlc.x;
                int y_min = (this.iSelectionRectStart.y >> zoomDiff) - tlc.y;
                int x_max = (this.iSelectionRectEnd.x >> zoomDiff) - tlc.x;
                int y_max = (this.iSelectionRectEnd.y >> zoomDiff) - tlc.y;
                int w = x_max - x_min;
                int h = y_max - y_min;
                g.setColor(new Color(0.9f, 0.7f, 0.7f, 0.6f));
                g.fillRect(x_min, y_min, w, h);
                g.setColor(Color.BLACK);
                g.drawRect(x_min, y_min, w, h);
            }
        }
        catch (Exception e) {
            Main.error(e);
        }
    }

    public final void setFileCacheEnabled(boolean enabled) {
        if (enabled) {
            this.setTileLoader(this.cachedLoader);
        } else {
            this.setTileLoader(this.uncachedLoader);
        }
    }

    public final void setMaxTilesInMemory(int tiles) {
        ((MemoryTileCache)this.getTileCache()).setCacheSize(tiles);
    }

    public void setSelection(Point aStart, Point aEnd) {
        if (aStart == null || aEnd == null || aStart.x == aEnd.x || aStart.y == aEnd.y) {
            return;
        }
        Point p_max = new Point(Math.max(aEnd.x, aStart.x), Math.max(aEnd.y, aStart.y));
        Point p_min = new Point(Math.min(aEnd.x, aStart.x), Math.min(aEnd.y, aStart.y));
        Point tlc = this.getTopLeftCoordinates();
        int zoomDiff = 22 - this.zoom;
        Point pEnd = new Point(p_max.x + tlc.x, p_max.y + tlc.y);
        Point pStart = new Point(p_min.x + tlc.x, p_min.y + tlc.y);
        pEnd.x <<= zoomDiff;
        pEnd.y <<= zoomDiff;
        pStart.x <<= zoomDiff;
        pStart.y <<= zoomDiff;
        this.iSelectionRectStart = pStart;
        this.iSelectionRectEnd = pEnd;
        Coordinate l1 = this.getPosition(p_max);
        Coordinate l2 = this.getPosition(p_min);
        Bounds b = new Bounds(new LatLon(Math.min(l2.getLat(), l1.getLat()), LatLon.toIntervalLon(Math.min(l1.getLon(), l2.getLon()))), new LatLon(Math.max(l2.getLat(), l1.getLat()), LatLon.toIntervalLon(Math.max(l1.getLon(), l2.getLon()))));
        Bounds oldValue = this.bbox;
        this.bbox = b;
        this.repaint();
        this.firePropertyChange(BBOX_PROP, oldValue, this.bbox);
    }

    public void resizeSlippyMap() {
        boolean large = this.iSizeButton.isEnlarged();
        this.firePropertyChange(RESIZE_PROP, !large, large);
    }

    public void toggleMapSource(TileSource tileSource) {
        this.tileController.setTileCache(new MemoryTileCache());
        this.setTileSource(tileSource);
        PROP_MAPSTYLE.put(tileSource.getName());
    }

    @Override
    public Bounds getBoundingBox() {
        return this.bbox;
    }

    @Override
    public void setBoundingBox(Bounds bbox) {
        if (bbox == null || bbox.getMinLat() == 0.0 && bbox.getMinLon() == 0.0 && bbox.getMaxLat() == 0.0 && bbox.getMaxLon() == 0.0) {
            this.bbox = null;
            this.iSelectionRectStart = null;
            this.iSelectionRectEnd = null;
            this.repaint();
            return;
        }
        this.bbox = bbox;
        double minLon = bbox.getMinLon();
        double maxLon = bbox.getMaxLon();
        if (bbox.crosses180thMeridian()) {
            minLon -= 360.0;
        }
        int y1 = this.tileSource.LatToY(bbox.getMinLat(), 22);
        int y2 = this.tileSource.LatToY(bbox.getMaxLat(), 22);
        int x1 = this.tileSource.LonToX(minLon, 22);
        int x2 = this.tileSource.LonToX(maxLon, 22);
        this.iSelectionRectStart = new Point(Math.min(x1, x2), Math.min(y1, y2));
        this.iSelectionRectEnd = new Point(Math.max(x1, x2), Math.max(y1, y2));
        MapMarkerDot xmin_ymin = new MapMarkerDot(bbox.getMinLat(), bbox.getMinLon());
        MapMarkerDot xmax_ymax = new MapMarkerDot(bbox.getMaxLat(), bbox.getMaxLon());
        ArrayList<MapMarker> marker = new ArrayList<MapMarker>(2);
        marker.add(xmin_ymin);
        marker.add(xmax_ymax);
        this.setMapMarkerList(marker);
        this.setDisplayToFitMapMarkers();
        this.zoomOut();
        this.repaint();
    }

    public final void refreshTileSources() {
        this.iSourceButton.setSources(this.getAllTileSources());
    }

    static {
        SlippyMapBBoxChooser.addTileSourceProvider(new TileSourceProvider(){

            @Override
            public List<TileSource> getTileSources() {
                return Arrays.asList(new OsmTileSource.Mapnik(), new OsmTileSource.CycleMap(), new MapQuestOsmTileSource(), new MapQuestOpenAerialTileSource());
            }
        });
        SlippyMapBBoxChooser.addTileSourceProvider(new TMSTileSourceProvider());
        PROP_MAPSTYLE = new StringProperty("slippy_map_chooser.mapstyle", "Mapnik");
        RESIZE_PROP = SlippyMapBBoxChooser.class.getName() + ".resize";
    }

    public static class TMSTileSourceProvider
    implements TileSourceProvider {
        static final Set<String> existingSlippyMapUrls = new HashSet<String>();

        @Override
        public List<TileSource> getTileSources() {
            if (!TMSLayer.PROP_ADD_TO_SLIPPYMAP_CHOOSER.get().booleanValue()) {
                return Collections.emptyList();
            }
            ArrayList<TileSource> sources = new ArrayList<TileSource>();
            for (ImageryInfo info : ImageryLayerInfo.instance.getLayers()) {
                if (existingSlippyMapUrls.contains(info.getUrl())) continue;
                try {
                    TileSource source = AbstractTMSTileSource.getTileSource(info);
                    if (source == null) continue;
                    sources.add(source);
                }
                catch (IllegalArgumentException ex) {
                    if (ex.getMessage() == null || ex.getMessage().isEmpty()) continue;
                    JOptionPane.showMessageDialog(Main.parent, ex.getMessage(), I18n.tr("Warning", new Object[0]), 2);
                }
            }
            return sources;
        }

        public static void addExistingSlippyMapUrl(String url) {
            existingSlippyMapUrls.add(url);
        }

        static {
            existingSlippyMapUrls.add("https://{switch:a,b,c}.tile.openstreetmap.org/{zoom}/{x}/{y}.png");
            existingSlippyMapUrls.add("http://tile.opencyclemap.org/cycle/{zoom}/{x}/{y}.png");
            existingSlippyMapUrls.add("http://otile{switch:1,2,3,4}.mqcdn.com/tiles/1.0.0/osm/{zoom}/{x}/{y}.png");
            existingSlippyMapUrls.add("http://oatile{switch:1,2,3,4}.mqcdn.com/tiles/1.0.0/sat/{zoom}/{x}/{y}.png");
        }
    }

    public static interface TileSourceProvider {
        public List<TileSource> getTileSources();
    }
}

