/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.actionsupport;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.widgets.UrlLabel;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class AlignImageryPanel
extends JPanel {
    public AlignImageryPanel(boolean oneLine) {
        Font font = this.getFont().deriveFont(0, 14.0f);
        JLabel nagLabel = new JLabel(I18n.tr("Aerial imagery might be misaligned. Please check its offset using GPS tracks!", new Object[0]));
        UrlLabel detailsList = new UrlLabel(I18n.tr("http://wiki.openstreetmap.org/wiki/Using_Imagery", new Object[0]), I18n.tr("Details...", new Object[0]));
        nagLabel.setFont(font);
        detailsList.setFont(font);
        JButton closeButton = new JButton(ImageProvider.get("misc", "black_x"));
        closeButton.setContentAreaFilled(false);
        closeButton.setRolloverEnabled(true);
        closeButton.setBorderPainted(false);
        closeButton.setToolTipText(I18n.tr("Hide this message and never show it again", new Object[0]));
        closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (Main.isDisplayingMapView()) {
                    Main.map.removeTopPanel(AlignImageryPanel.class);
                    Main.pref.put("imagery.offsetnagging", false);
                }
            }
        });
        this.setLayout(new GridBagLayout());
        if (!oneLine) {
            this.add((Component)nagLabel, GBC.std(1, 1).fill());
            this.add((Component)detailsList, GBC.std(1, 2).fill());
            this.add((Component)closeButton, GBC.std(2, 1).span(1, 2).anchor(13));
        } else {
            this.add((Component)nagLabel, GBC.std(1, 1).fill());
            this.add((Component)detailsList, GBC.std(2, 1).fill());
            this.add((Component)closeButton, GBC.std(3, 1).anchor(13));
        }
        this.setBorder(new CompoundBorder(new EtchedBorder(1), new EmptyBorder(12, 12, 12, 12)));
        this.setBackground(new Color(224, 236, 249));
    }

    public static void addNagPanelIfNeeded() {
        if (Main.isDisplayingMapView() && !Main.pref.getBoolean("expert") && Main.pref.getBoolean("imagery.offsetnagging", true) && Main.map.getTopPanel(AlignImageryPanel.class) == null) {
            double w = Toolkit.getDefaultToolkit().getScreenSize().getWidth();
            AlignImageryPanel p = new AlignImageryPanel(w > 1300.0);
            Main.map.addTopPanel(p);
        }
    }
}

