/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import java.util.LinkedList;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JSeparator;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import org.openstreetmap.josm.data.Version;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.gui.progress.ProgressRenderer;
import org.openstreetmap.josm.gui.progress.SwingRenderingProgressMonitor;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Utils;
import org.openstreetmap.josm.tools.WindowGeometry;

public class SplashScreen
extends JFrame {
    private final SwingRenderingProgressMonitor progressMonitor;

    public SplashScreen() {
        this.setUndecorated(true);
        JPanel contentPane = (JPanel)this.getContentPane();
        EtchedBorder margin = new EtchedBorder(1, Color.white, Color.gray);
        contentPane.setBorder(margin);
        JPanel innerContentPane = new JPanel();
        innerContentPane.setBorder(new EmptyBorder(10, 10, 2, 10));
        contentPane.add(innerContentPane);
        innerContentPane.setLayout(new GridBagLayout());
        JLabel logo = new JLabel(new ImageIcon(ImageProvider.get("logo.png").getImage().getScaledInstance(128, 129, 4)));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridheight = 2;
        gbc.insets = new Insets(0, 0, 0, 70);
        innerContentPane.add((Component)logo, gbc);
        JLabel caption = new JLabel("JOSM \u2013 " + I18n.tr("Java OpenStreetMap Editor", new Object[0]));
        caption.setFont(GuiHelper.getTitleFont());
        gbc.gridheight = 1;
        gbc.gridx = 1;
        gbc.insets = new Insets(30, 0, 0, 0);
        innerContentPane.add((Component)caption, gbc);
        JLabel version = new JLabel(I18n.tr("Version {0}", Version.getInstance().getVersionString()));
        gbc.gridy = 1;
        gbc.insets = new Insets(0, 0, 0, 0);
        innerContentPane.add((Component)version, gbc);
        JSeparator separator = new JSeparator(0);
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.gridwidth = 2;
        gbc.fill = 2;
        gbc.insets = new Insets(15, 0, 5, 0);
        innerContentPane.add((Component)separator, gbc);
        SplashScreenProgressRenderer progressRenderer = new SplashScreenProgressRenderer();
        gbc.gridy = 3;
        gbc.insets = new Insets(0, 0, 10, 0);
        innerContentPane.add((Component)progressRenderer, gbc);
        this.progressMonitor = new SwingRenderingProgressMonitor(progressRenderer);
        this.pack();
        WindowGeometry.centerOnScreen(this.getSize(), "gui.geometry").applySafe(this);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent event) {
                SplashScreen.this.setVisible(false);
            }
        });
    }

    public ProgressMonitor getProgressMonitor() {
        return this.progressMonitor;
    }

    private static class SplashScreenProgressRenderer
    extends JPanel
    implements ProgressRenderer {
        private JLabel lblTaskTitle;
        private JLabel lblCustomText;
        private JProgressBar progressBar;
        private LinkedList<String> messages = new LinkedList<String>(Arrays.asList("", "", ""));
        private long time = System.currentTimeMillis();

        protected void build() {
            this.setLayout(new GridBagLayout());
            GridBagConstraints gc = new GridBagConstraints();
            gc.gridx = 0;
            gc.gridy = 0;
            gc.fill = 2;
            gc.weightx = 1.0;
            gc.weighty = 0.0;
            gc.insets = new Insets(5, 0, 0, 0);
            this.lblTaskTitle = new JLabel(" ");
            this.add((Component)this.lblTaskTitle, gc);
            gc.gridx = 0;
            gc.gridy = 1;
            gc.fill = 2;
            gc.weightx = 1.0;
            gc.weighty = 0.0;
            gc.insets = new Insets(5, 0, 0, 0);
            this.lblCustomText = new JLabel(" "){

                @Override
                public Dimension getPreferredSize() {
                    Dimension d = super.getPreferredSize();
                    if (d.width < 600) {
                        d.width = 600;
                    }
                    d.height *= 3;
                    return d;
                }
            };
            this.add((Component)this.lblCustomText, gc);
            gc.gridx = 0;
            gc.gridy = 2;
            gc.fill = 2;
            gc.weightx = 1.0;
            gc.weighty = 0.0;
            gc.insets = new Insets(5, 0, 0, 0);
            this.progressBar = new JProgressBar(0);
            this.add((Component)this.progressBar, gc);
        }

        public SplashScreenProgressRenderer() {
            this.build();
        }

        @Override
        public void setCustomText(String message) {
            if (message.isEmpty()) {
                message = " ";
            }
            this.lblCustomText.setText(message);
            this.repaint();
        }

        @Override
        public void setIndeterminate(boolean indeterminate) {
            this.progressBar.setIndeterminate(indeterminate);
            this.repaint();
        }

        @Override
        public void setMaximum(int maximum) {
            this.progressBar.setMaximum(maximum);
            this.repaint();
        }

        @Override
        public void setTaskTitle(String taskTitle) {
            while (this.messages.size() >= 3) {
                this.messages.removeFirst();
            }
            long now = System.currentTimeMillis();
            String prevMessageTitle = this.messages.getLast();
            if (!prevMessageTitle.isEmpty() && now >= this.time) {
                this.messages.removeLast();
                this.messages.add(I18n.tr("{0} ({1})", prevMessageTitle, Utils.getDurationString(now - this.time)));
            }
            this.time = now;
            if (!taskTitle.isEmpty()) {
                this.messages.add(taskTitle);
            }
            StringBuilder html = new StringBuilder();
            int i = 0;
            for (String m : this.messages) {
                html.append("<p class=\"entry").append(++i).append("\">").append(m).append("</p>");
            }
            this.lblTaskTitle.setText("<html><style>.entry1{color:#CCCCCC;}.entry2{color:#999999;}.entry3{color:#000000;}</style>" + html + "</html>");
            this.repaint();
        }

        @Override
        public void setValue(int value) {
            this.progressBar.setValue(value);
            this.repaint();
        }
    }
}

