/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.plaf.basic.BasicArrowButton;
import org.openstreetmap.josm.tools.Destroyable;
import org.openstreetmap.josm.tools.ImageProvider;

public class SideButton
extends JButton
implements Destroyable {
    private PropertyChangeListener propertyChangeListener;

    public SideButton(Action action) {
        super(action);
        this.fixIcon(action);
        this.doStyle();
    }

    public SideButton(Action action, boolean usename) {
        super(action);
        if (!usename) {
            this.setText(null);
            this.fixIcon(action);
            this.doStyle();
        }
    }

    public SideButton(Action action, String imagename) {
        super(action);
        this.setIcon(SideButton.makeIcon(imagename));
        this.doStyle();
    }

    private void fixIcon(Action action) {
        Icon i;
        if (action != null) {
            this.propertyChangeListener = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if (evt.getPropertyName() == "SmallIcon") {
                        SideButton.this.fixIcon(null);
                    }
                }
            };
            action.addPropertyChangeListener(this.propertyChangeListener);
        }
        if ((i = this.getIcon()) instanceof ImageIcon && i.getIconHeight() != 20) {
            this.setIcon(SideButton.getScaledImage(((ImageIcon)i).getImage()));
        }
    }

    private static ImageIcon getScaledImage(Image im) {
        int newWidth = im.getWidth(null) * 20 / im.getHeight(null);
        return new ImageIcon(im.getScaledInstance(newWidth, 20, 4));
    }

    public static ImageIcon makeIcon(String imagename) {
        Image im = ImageProvider.get("dialogs", imagename).getImage();
        return SideButton.getScaledImage(im);
    }

    private void doStyle() {
        this.setLayout(new BorderLayout());
        this.setIconTextGap(2);
        this.setMargin(new Insets(-1, 0, -1, 0));
    }

    public void createArrow(ActionListener listener) {
        this.setMargin(new Insets(0, 0, 0, 0));
        BasicArrowButton arrowButton = new BasicArrowButton(5, null, null, Color.BLACK, null);
        arrowButton.setBorder(BorderFactory.createEmptyBorder());
        this.add((Component)arrowButton, "East");
        arrowButton.addActionListener(listener);
    }

    @Override
    public void destroy() {
        Action action = this.getAction();
        if (action instanceof Destroyable) {
            ((Destroyable)((Object)action)).destroy();
        }
        if (action != null) {
            if (this.propertyChangeListener != null) {
                action.removePropertyChangeListener(this.propertyChangeListener);
            }
            this.setAction(null);
        }
    }
}

