/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui;

import java.awt.Component;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.LinkedList;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.SelectByInternalPointAction;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.NavigatableComponent;

public class SelectionManager
implements MouseListener,
MouseMotionListener,
PropertyChangeListener {
    private final SelectionEnded selectionEndedListener;
    private Point mousePosStart;
    private Point mousePos;
    private final NavigatableComponent nc;
    private boolean aspectRatio;
    private boolean lassoMode;
    private Polygon lasso = new Polygon();

    public SelectionManager(SelectionEnded selectionEndedListener, boolean aspectRatio, NavigatableComponent navComp) {
        this.selectionEndedListener = selectionEndedListener;
        this.aspectRatio = aspectRatio;
        this.nc = navComp;
    }

    public void register(NavigatableComponent eventSource, boolean lassoMode) {
        this.lassoMode = lassoMode;
        eventSource.addMouseListener(this);
        eventSource.addMouseMotionListener(this);
        this.selectionEndedListener.addPropertyChangeListener(this);
        eventSource.addPropertyChangeListener("scale", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (SelectionManager.this.mousePosStart != null) {
                    SelectionManager.this.paintRect();
                    SelectionManager.this.mousePos = (SelectionManager.this.mousePosStart = null);
                }
            }
        });
    }

    public void unregister(Component eventSource) {
        eventSource.removeMouseListener(this);
        eventSource.removeMouseMotionListener(this);
        this.selectionEndedListener.removePropertyChangeListener(this);
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (e.getButton() == 1 && e.getClickCount() > 1 && Main.main.getCurrentDataSet() != null) {
            SelectByInternalPointAction.performSelection(Main.map.mapView.getEastNorth(e.getX(), e.getY()), (e.getModifiersEx() & 0x40) > 0, (e.getModifiersEx() & 0x80) > 0);
        } else if (e.getButton() == 1) {
            this.mousePosStart = this.mousePos = e.getPoint();
            this.lasso.reset();
            this.lasso.addPoint(this.mousePosStart.x, this.mousePosStart.y);
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        int buttonPressed = e.getModifiersEx() & 0x1400;
        if (buttonPressed != 0) {
            if (this.mousePosStart == null) {
                this.mousePosStart = this.mousePos = e.getPoint();
            }
            if (!this.lassoMode) {
                this.paintRect();
            }
        }
        if (buttonPressed == 1024) {
            this.mousePos = e.getPoint();
            if (this.lassoMode) {
                this.paintLasso();
            } else {
                this.paintRect();
            }
        } else if (buttonPressed == 5120) {
            this.mousePosStart.x += e.getX() - this.mousePos.x;
            this.mousePosStart.y += e.getY() - this.mousePos.y;
            this.mousePos = e.getPoint();
            this.paintRect();
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        Rectangle r;
        if (e.getButton() != 1) {
            return;
        }
        if (this.mousePos == null || this.mousePosStart == null) {
            return;
        }
        if (!this.lassoMode) {
            this.nc.requestClearRect();
            r = this.getSelectionRectangle();
            this.lasso = this.rectToPolygon(r);
        } else {
            this.nc.requestClearPoly();
            this.lasso.addPoint(this.mousePos.x, this.mousePos.y);
            r = this.lasso.getBounds();
        }
        this.mousePosStart = null;
        this.mousePos = null;
        if ((e.getModifiersEx() & 0x1000) == 0) {
            this.selectionEndedListener.selectionEnded(r, e);
        }
    }

    private void paintRect() {
        if (this.mousePos == null || this.mousePosStart == null || this.mousePos == this.mousePosStart) {
            return;
        }
        this.nc.requestPaintRect(this.getSelectionRectangle());
    }

    private void paintLasso() {
        if (this.mousePos == null || this.mousePosStart == null || this.mousePos == this.mousePosStart) {
            return;
        }
        this.lasso.addPoint(this.mousePos.x, this.mousePos.y);
        this.nc.requestPaintPoly(this.lasso);
    }

    private Rectangle getSelectionRectangle() {
        int x = this.mousePosStart.x;
        int y = this.mousePosStart.y;
        int w = this.mousePos.x - this.mousePosStart.x;
        int h = this.mousePos.y - this.mousePosStart.y;
        if (w < 0) {
            x += w;
            w = -w;
        }
        if (h < 0) {
            y += h;
            h = -h;
        }
        if (this.aspectRatio) {
            double aspectRatio = (double)this.nc.getWidth() / (double)this.nc.getHeight();
            if ((double)w / (double)h < aspectRatio) {
                int neww = (int)((double)h * aspectRatio);
                if (this.mousePos.x < this.mousePosStart.x) {
                    x += w - neww;
                }
                w = neww;
            } else {
                int newh = (int)((double)w / aspectRatio);
                if (this.mousePos.y < this.mousePosStart.y) {
                    y += h - newh;
                }
                h = newh;
            }
        }
        return new Rectangle(x, y, w, h);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("active".equals(evt.getPropertyName()) && !((Boolean)evt.getNewValue()).booleanValue() && this.mousePosStart != null) {
            this.paintRect();
            this.mousePosStart = null;
            this.mousePos = null;
        }
    }

    public Collection<OsmPrimitive> getSelectedObjects(boolean alt) {
        LinkedList<OsmPrimitive> selection = new LinkedList<OsmPrimitive>();
        boolean clicked = false;
        Rectangle bounding = this.lasso.getBounds();
        if (bounding.height <= 2 && bounding.width <= 2) {
            clicked = true;
        }
        if (clicked) {
            Point center = new Point(this.lasso.xpoints[0], this.lasso.ypoints[0]);
            OsmPrimitive osm = this.nc.getNearestNodeOrWay(center, OsmPrimitive.isSelectablePredicate, false);
            if (osm != null) {
                selection.add(osm);
            }
        } else {
            for (Node n : this.nc.getCurrentDataSet().getNodes()) {
                if (!n.isSelectable() || !this.lasso.contains(this.nc.getPoint2D(n))) continue;
                selection.add(n);
            }
            block1: for (Way w : this.nc.getCurrentDataSet().getWays()) {
                if (!w.isSelectable() || w.getNodesCount() == 0) continue;
                if (alt) {
                    for (Node n : w.getNodes()) {
                        if (n.isIncomplete() || !this.lasso.contains(this.nc.getPoint2D(n))) continue;
                        selection.add(w);
                        continue block1;
                    }
                    continue;
                }
                boolean allIn = true;
                for (Node n : w.getNodes()) {
                    if (n.isIncomplete() || this.lasso.contains(this.nc.getPoint(n))) continue;
                    allIn = false;
                    break;
                }
                if (!allIn) continue;
                selection.add(w);
            }
        }
        return selection;
    }

    private Polygon rectToPolygon(Rectangle r) {
        Polygon poly = new Polygon();
        poly.addPoint(r.x, r.y);
        poly.addPoint(r.x, r.y + r.height);
        poly.addPoint(r.x + r.width, r.y + r.height);
        poly.addPoint(r.x + r.width, r.y);
        return poly;
    }

    public void setLassoMode(boolean lassoMode) {
        this.lassoMode = lassoMode;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    public static interface SelectionEnded {
        public void selectionEnded(Rectangle var1, MouseEvent var2);

        public void addPropertyChangeListener(PropertyChangeListener var1);

        public void removePropertyChangeListener(PropertyChangeListener var1);
    }
}

