/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui;

import java.awt.Component;
import java.awt.EventQueue;
import java.io.IOException;
import javax.swing.SwingUtilities;
import org.openstreetmap.josm.gui.ExceptionDialogUtil;
import org.openstreetmap.josm.gui.progress.PleaseWaitProgressMonitor;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.gui.progress.ProgressTaskId;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.tools.BugReportExceptionHandler;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.xml.sax.SAXException;

public abstract class PleaseWaitRunnable
implements Runnable,
ProgressMonitor.CancelListener {
    private boolean canceled = false;
    private boolean ignoreException;
    private final String title;
    protected final ProgressMonitor progressMonitor;

    public PleaseWaitRunnable(String title) {
        this(title, false);
    }

    public PleaseWaitRunnable(String title, boolean ignoreException) {
        this(title, new PleaseWaitProgressMonitor(title), ignoreException);
    }

    public PleaseWaitRunnable(Component parent, String title, boolean ignoreException) throws IllegalArgumentException {
        CheckParameterUtil.ensureParameterNotNull(parent, "parent");
        this.title = title;
        this.progressMonitor = new PleaseWaitProgressMonitor(parent, title);
        this.ignoreException = ignoreException;
    }

    public PleaseWaitRunnable(String title, ProgressMonitor progressMonitor, boolean ignoreException) {
        this.title = title;
        this.progressMonitor = progressMonitor == null ? new PleaseWaitProgressMonitor(title) : progressMonitor;
        this.ignoreException = ignoreException;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doRealRun() {
        block16: {
            try {
                ProgressTaskId oldTaskId = null;
                try {
                    this.progressMonitor.addCancelListener(this);
                    this.progressMonitor.beginTask(this.title);
                    oldTaskId = this.progressMonitor.getProgressTaskId();
                    this.progressMonitor.setProgressTaskId(this.canRunInBackground());
                    try {
                        this.realRun();
                    }
                    catch (Throwable throwable) {
                        if (EventQueue.isDispatchThread()) {
                            this.finish();
                        } else {
                            EventQueue.invokeAndWait(new Runnable(){

                                @Override
                                public void run() {
                                    PleaseWaitRunnable.this.finish();
                                }
                            });
                        }
                        throw throwable;
                    }
                    if (EventQueue.isDispatchThread()) {
                        this.finish();
                    } else {
                        EventQueue.invokeAndWait(new /* invalid duplicate definition of identical inner class */);
                    }
                    this.progressMonitor.finishTask();
                    this.progressMonitor.removeCancelListener(this);
                    this.progressMonitor.setProgressTaskId(oldTaskId);
                }
                catch (Throwable throwable) {
                    this.progressMonitor.finishTask();
                    this.progressMonitor.removeCancelListener(this);
                    this.progressMonitor.setProgressTaskId(oldTaskId);
                    if (this.progressMonitor instanceof PleaseWaitProgressMonitor) {
                        ((PleaseWaitProgressMonitor)this.progressMonitor).close();
                    }
                    if (EventQueue.isDispatchThread()) {
                        this.afterFinish();
                    } else {
                        EventQueue.invokeAndWait(new Runnable(){

                            @Override
                            public void run() {
                                PleaseWaitRunnable.this.afterFinish();
                            }
                        });
                    }
                    throw throwable;
                }
                if (this.progressMonitor instanceof PleaseWaitProgressMonitor) {
                    ((PleaseWaitProgressMonitor)this.progressMonitor).close();
                }
                if (EventQueue.isDispatchThread()) {
                    this.afterFinish();
                } else {
                    EventQueue.invokeAndWait(new /* invalid duplicate definition of identical inner class */);
                }
            }
            catch (Exception e) {
                if (this.ignoreException) break block16;
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (e instanceof RuntimeException) {
                            BugReportExceptionHandler.handleException(e);
                        } else {
                            ExceptionDialogUtil.explainException(e);
                        }
                    }
                });
            }
        }
    }

    protected void afterFinish() {
    }

    @Override
    public final void run() {
        if (this.canceled) {
            return;
        }
        if (EventQueue.isDispatchThread()) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    PleaseWaitRunnable.this.doRealRun();
                }
            }).start();
        } else {
            this.doRealRun();
        }
    }

    @Override
    public void operationCanceled() {
        this.cancel();
    }

    protected abstract void cancel();

    protected abstract void realRun() throws SAXException, IOException, OsmTransferException;

    protected abstract void finish();

    public ProgressMonitor getProgressMonitor() {
        return this.progressMonitor;
    }

    public ProgressTaskId canRunInBackground() {
        return null;
    }
}

