/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui;

import java.awt.Component;
import javax.swing.DefaultListCellRenderer;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.ListCellRenderer;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.history.HistoryOsmPrimitive;
import org.openstreetmap.josm.gui.DefaultNameFormatter;
import org.openstreetmap.josm.tools.ImageProvider;

public class OsmPrimitivRenderer
implements ListCellRenderer<OsmPrimitive>,
TableCellRenderer {
    private DefaultNameFormatter formatter = DefaultNameFormatter.getInstance();
    private DefaultListCellRenderer defaultListCellRenderer = new DefaultListCellRenderer();
    private DefaultTableCellRenderer defaultTableCellRenderer = new DefaultTableCellRenderer();

    @Override
    public Component getListCellRendererComponent(JList<? extends OsmPrimitive> list, OsmPrimitive value, int index, boolean isSelected, boolean cellHasFocus) {
        Component def = this.defaultListCellRenderer.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
        return this.renderer(def, value);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        Component def = this.defaultTableCellRenderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        if (value instanceof OsmPrimitive) {
            return this.renderer(def, (OsmPrimitive)value);
        }
        if (value instanceof HistoryOsmPrimitive) {
            return this.renderer(def, (HistoryOsmPrimitive)value);
        }
        return def;
    }

    private Component renderer(Component def, OsmPrimitive value) {
        if (value != null && def instanceof JLabel) {
            ((JLabel)def).setText(this.getComponentText(value));
            ImageIcon icon = ImageProvider.get(value.getDisplayType());
            if (icon != null) {
                ((JLabel)def).setIcon(icon);
            } else {
                Main.warn("Null icon for " + (Object)((Object)value.getDisplayType()));
            }
            ((JLabel)def).setToolTipText(this.getComponentToolTipText(value));
        }
        return def;
    }

    private Component renderer(Component def, HistoryOsmPrimitive value) {
        if (value != null && def instanceof JLabel) {
            ((JLabel)def).setText(value.getDisplayName(DefaultNameFormatter.getInstance()));
            ((JLabel)def).setIcon(ImageProvider.get(value.getType()));
            ((JLabel)def).setToolTipText(this.formatter.buildDefaultToolTip(value));
        }
        return def;
    }

    protected String getComponentText(OsmPrimitive value) {
        return value.getDisplayName(DefaultNameFormatter.getInstance());
    }

    protected String getComponentToolTipText(OsmPrimitive value) {
        return this.formatter.buildDefaultToolTip(value);
    }
}

