/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.RoundRectangle2D;
import java.util.LinkedList;
import java.util.Queue;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.Notification;
import org.openstreetmap.josm.gui.help.HelpBrowser;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

class NotificationManager {
    private Timer hideTimer;
    private Timer pauseTimer;
    private Timer unfreezeDelayTimer;
    private boolean running;
    private Notification currentNotification;
    private NotificationPanel currentNotificationPanel;
    private final Queue<Notification> queue;
    private static int pauseTime = Main.pref.getInteger("notification-default-pause-time-ms", 300);
    static int defaultNotificationTime = Main.pref.getInteger("notification-default-time-ms", 5000);
    private long displayTimeStart;
    private long elapsedTime;
    private static NotificationManager INSTANCE = null;
    private final Color PANEL_SEMITRANSPARENT = new Color(224, 236, 249, 230);
    private final Color PANEL_OPAQUE = new Color(224, 236, 249);

    public static synchronized NotificationManager getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new NotificationManager();
        }
        return INSTANCE;
    }

    public NotificationManager() {
        this.queue = new LinkedList<Notification>();
        this.hideTimer = new Timer(defaultNotificationTime, new HideEvent());
        this.hideTimer.setRepeats(false);
        this.pauseTimer = new Timer(pauseTime, new PauseFinishedEvent());
        this.pauseTimer.setRepeats(false);
        this.unfreezeDelayTimer = new Timer(10, new UnfreezeEvent());
        this.unfreezeDelayTimer.setRepeats(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void showNotification(Notification note) {
        Queue<Notification> queue = this.queue;
        synchronized (queue) {
            this.queue.add(note);
            this.processQueue();
        }
    }

    private void processQueue() {
        int y;
        int x;
        if (this.running) {
            return;
        }
        this.currentNotification = this.queue.poll();
        if (this.currentNotification == null) {
            return;
        }
        this.currentNotificationPanel = new NotificationPanel(this.currentNotification);
        this.currentNotificationPanel.validate();
        int MARGIN = 5;
        JFrame parentWindow = (JFrame)Main.parent;
        Dimension size = this.currentNotificationPanel.getPreferredSize();
        if (Main.isDisplayingMapView() && Main.map.mapView.getHeight() > 0) {
            MapView mv = Main.map.mapView;
            Point mapViewPos = SwingUtilities.convertPoint(mv.getParent(), mv.getX(), mv.getY(), Main.parent);
            x = mapViewPos.x + MARGIN;
            y = mapViewPos.y + mv.getHeight() - Main.map.statusLine.getHeight() - size.height - MARGIN;
        } else {
            x = MARGIN;
            y = parentWindow.getHeight() - Main.toolbar.control.getSize().height - size.height - MARGIN;
        }
        parentWindow.getLayeredPane().add(this.currentNotificationPanel, JLayeredPane.POPUP_LAYER, 0);
        this.currentNotificationPanel.setLocation(x, y);
        this.currentNotificationPanel.setSize(size);
        this.currentNotificationPanel.setVisible(true);
        this.running = true;
        this.elapsedTime = 0L;
        this.startHideTimer();
    }

    private void startHideTimer() {
        int remaining = (int)((long)this.currentNotification.getDuration() - this.elapsedTime);
        if (remaining < 300) {
            remaining = 300;
        }
        this.displayTimeStart = System.currentTimeMillis();
        this.hideTimer.setInitialDelay(remaining);
        this.hideTimer.restart();
    }

    public static class RoundedPanel
    extends JPanel {
        public RoundedPanel() {
            this.setOpaque(false);
        }

        @Override
        protected void paintComponent(Graphics graphics) {
            Graphics2D g = (Graphics2D)graphics;
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g.setColor(this.getBackground());
            float lineWidth = 1.4f;
            RoundRectangle2D.Float rect = new RoundRectangle2D.Float(lineWidth / 2.0f + (float)this.getInsets().left, lineWidth / 2.0f + (float)this.getInsets().top, (float)this.getWidth() - lineWidth / 2.0f - (float)this.getInsets().left - (float)this.getInsets().right, (float)this.getHeight() - lineWidth / 2.0f - (float)this.getInsets().top - (float)this.getInsets().bottom, 20.0f, 20.0f);
            g.fill(rect);
            g.setColor(this.getForeground());
            g.setStroke(new BasicStroke(lineWidth));
            g.draw(rect);
            super.paintComponent(graphics);
        }
    }

    private class NotificationPanel
    extends JPanel {
        private JPanel innerPanel;

        public NotificationPanel(Notification note) {
            this.setVisible(false);
            this.build(note);
        }

        public void setNotificationBackground(Color c) {
            this.innerPanel.setBackground(c);
        }

        private void build(final Notification note) {
            JButton btnClose = new JButton(new HideAction());
            btnClose.setPreferredSize(new Dimension(50, 50));
            btnClose.setMargin(new Insets(0, 0, 1, 1));
            btnClose.setContentAreaFilled(false);
            JToolBar tbClose = new JToolBar();
            tbClose.setFloatable(false);
            tbClose.setBorderPainted(false);
            tbClose.setOpaque(false);
            tbClose.add(btnClose);
            JToolBar tbHelp = null;
            if (note.getHelpTopic() != null) {
                JButton btnHelp = new JButton(I18n.tr("Help", new Object[0]));
                btnHelp.setIcon(ImageProvider.get("help"));
                btnHelp.setToolTipText(I18n.tr("Show help information", new Object[0]));
                HelpUtil.setHelpContext(btnHelp, note.getHelpTopic());
                btnHelp.addActionListener(new AbstractAction(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                HelpBrowser.setUrlForHelpTopic(note.getHelpTopic());
                            }
                        });
                    }
                });
                btnHelp.setOpaque(false);
                tbHelp = new JToolBar();
                tbHelp.setFloatable(false);
                tbHelp.setBorderPainted(false);
                tbHelp.setOpaque(false);
                tbHelp.add(btnHelp);
            }
            this.setOpaque(false);
            this.innerPanel = new RoundedPanel();
            this.innerPanel.setBackground(NotificationManager.this.PANEL_SEMITRANSPARENT);
            this.innerPanel.setForeground(Color.BLACK);
            GroupLayout layout = new GroupLayout(this.innerPanel);
            this.innerPanel.setLayout(layout);
            layout.setAutoCreateGaps(true);
            layout.setAutoCreateContainerGaps(true);
            this.innerPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            this.add(this.innerPanel);
            JLabel icon = null;
            if (note.getIcon() != null) {
                icon = new JLabel(note.getIcon());
            }
            Component content = note.getContent();
            GroupLayout.SequentialGroup hgroup = layout.createSequentialGroup();
            if (icon != null) {
                hgroup.addComponent(icon);
            }
            if (tbHelp != null) {
                hgroup.addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(content).addComponent(tbHelp));
            } else {
                hgroup.addComponent(content);
            }
            hgroup.addComponent(tbClose);
            GroupLayout.ParallelGroup vgroup = layout.createParallelGroup();
            if (icon != null) {
                vgroup.addComponent(icon);
            }
            vgroup.addComponent(content);
            vgroup.addComponent(tbClose);
            layout.setHorizontalGroup(hgroup);
            if (tbHelp != null) {
                layout.setVerticalGroup(layout.createSequentialGroup().addGroup(vgroup).addComponent(tbHelp));
            } else {
                layout.setVerticalGroup(vgroup);
            }
            FreezeMouseListener freeze = new FreezeMouseListener();
            this.addMouseListenerToAllChildComponents(this, freeze);
        }

        private void addMouseListenerToAllChildComponents(Component comp, MouseListener listener) {
            comp.addMouseListener(listener);
            if (comp instanceof Container) {
                for (Component c : ((Container)comp).getComponents()) {
                    this.addMouseListenerToAllChildComponents(c, listener);
                }
            }
        }

        class FreezeMouseListener
        extends MouseAdapter {
            FreezeMouseListener() {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                if (NotificationManager.this.unfreezeDelayTimer.isRunning()) {
                    NotificationManager.this.unfreezeDelayTimer.stop();
                } else {
                    NotificationManager.this.hideTimer.stop();
                    NotificationManager.this.elapsedTime += System.currentTimeMillis() - NotificationManager.this.displayTimeStart;
                    NotificationManager.this.currentNotificationPanel.setNotificationBackground(NotificationManager.this.PANEL_OPAQUE);
                    NotificationManager.this.currentNotificationPanel.repaint();
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
                NotificationManager.this.unfreezeDelayTimer.restart();
            }
        }

        class HideAction
        extends AbstractAction {
            public HideAction() {
                this.putValue("SmallIcon", ImageProvider.get("misc", "grey_x"));
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                new HideEvent().actionPerformed(null);
            }
        }
    }

    private class UnfreezeEvent
    implements ActionListener {
        private UnfreezeEvent() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (NotificationManager.this.currentNotificationPanel != null) {
                NotificationManager.this.currentNotificationPanel.setNotificationBackground(NotificationManager.this.PANEL_SEMITRANSPARENT);
                NotificationManager.this.currentNotificationPanel.repaint();
            }
            NotificationManager.this.startHideTimer();
        }
    }

    private class PauseFinishedEvent
    implements ActionListener {
        private PauseFinishedEvent() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent e) {
            Queue queue = NotificationManager.this.queue;
            synchronized (queue) {
                NotificationManager.this.running = false;
                NotificationManager.this.processQueue();
            }
        }
    }

    private class HideEvent
    implements ActionListener {
        private HideEvent() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            NotificationManager.this.hideTimer.stop();
            if (NotificationManager.this.currentNotificationPanel != null) {
                NotificationManager.this.currentNotificationPanel.setVisible(false);
                ((JFrame)Main.parent).getLayeredPane().remove(NotificationManager.this.currentNotificationPanel);
                NotificationManager.this.currentNotificationPanel = null;
            }
            NotificationManager.this.pauseTimer.restart();
        }
    }
}

