/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui;

import java.awt.Component;
import javax.swing.Icon;
import javax.swing.UIManager;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.NotificationManager;
import org.openstreetmap.josm.gui.widgets.JMultilineLabel;

public class Notification {
    public static final int DEFAULT_CONTENT_WIDTH = 350;
    public static final int TIME_SHORT = Main.pref.getInteger("notification-time-short-ms", 3000);
    public static final int TIME_DEFAULT = Main.pref.getInteger("notification-time-default-ms", 5000);
    public static final int TIME_LONG = Main.pref.getInteger("notification-time-long-ms", 10000);
    public static final int TIME_VERY_LONG = Main.pref.getInteger("notification-time-very_long-ms", 20000);
    private Component content;
    private int duration = NotificationManager.defaultNotificationTime;
    private Icon icon;
    private String helpTopic;

    public Notification() {
    }

    public Notification(String msg) {
        this();
        this.setContent(msg);
    }

    public Notification setContent(Component content) {
        this.content = content;
        return this;
    }

    public Notification setContent(String msg) {
        JMultilineLabel lbl = new JMultilineLabel(msg);
        lbl.setMaxWidth(350);
        this.content = lbl;
        return this;
    }

    public Notification setDuration(int duration) {
        this.duration = duration;
        return this;
    }

    public Notification setIcon(Icon icon) {
        this.icon = icon;
        return this;
    }

    public Notification setIcon(int messageType) {
        switch (messageType) {
            case 0: {
                return this.setIcon(UIManager.getIcon("OptionPane.errorIcon"));
            }
            case 1: {
                return this.setIcon(UIManager.getIcon("OptionPane.informationIcon"));
            }
            case 2: {
                return this.setIcon(UIManager.getIcon("OptionPane.warningIcon"));
            }
            case 3: {
                return this.setIcon(UIManager.getIcon("OptionPane.questionIcon"));
            }
            case -1: {
                return this.setIcon(null);
            }
        }
        throw new IllegalArgumentException("Unknown message type!");
    }

    public Notification setHelpTopic(String helpTopic) {
        this.helpTopic = helpTopic;
        return this;
    }

    public Component getContent() {
        return this.content;
    }

    public int getDuration() {
        return this.duration;
    }

    public Icon getIcon() {
        return this.icon;
    }

    public String getHelpTopic() {
        return this.helpTopic;
    }

    public void show() {
        NotificationManager.getInstance().showNotification(this);
    }
}

