/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui;

import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.nio.charset.StandardCharsets;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.TreeMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.zip.CRC32;
import javax.swing.JComponent;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.ProjectionBounds;
import org.openstreetmap.josm.data.SystemOfMeasurement;
import org.openstreetmap.josm.data.ViewportData;
import org.openstreetmap.josm.data.coor.CachedLatLon;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.BBox;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.WaySegment;
import org.openstreetmap.josm.data.osm.visitor.BoundingXYVisitor;
import org.openstreetmap.josm.data.osm.visitor.paint.PaintColors;
import org.openstreetmap.josm.data.preferences.IntegerProperty;
import org.openstreetmap.josm.data.projection.Projection;
import org.openstreetmap.josm.data.projection.Projections;
import org.openstreetmap.josm.gui.download.DownloadDialog;
import org.openstreetmap.josm.gui.help.Helpful;
import org.openstreetmap.josm.gui.mappaint.MapPaintStyles;
import org.openstreetmap.josm.gui.mappaint.mapcss.MapCSSStyleSource;
import org.openstreetmap.josm.gui.preferences.projection.ProjectionPreference;
import org.openstreetmap.josm.tools.Predicate;
import org.openstreetmap.josm.tools.Utils;

public class NavigatableComponent
extends JComponent
implements Helpful {
    public Predicate<OsmPrimitive> isSelectablePredicate = new Predicate<OsmPrimitive>(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean evaluate(OsmPrimitive prim) {
            if (!prim.isSelectable()) {
                return false;
            }
            MapCSSStyleSource.STYLE_SOURCE_LOCK.readLock().lock();
            try {
                boolean bl = !MapPaintStyles.getStyles().get(prim, NavigatableComponent.this.getDist100Pixel(), NavigatableComponent.this).isEmpty();
                return bl;
            }
            finally {
                MapCSSStyleSource.STYLE_SOURCE_LOCK.readLock().unlock();
            }
        }
    };
    public static final IntegerProperty PROP_SNAP_DISTANCE = new IntegerProperty("mappaint.node.snap-distance", 10);
    public static final String PROPNAME_CENTER = "center";
    public static final String PROPNAME_SCALE = "scale";
    private static final CopyOnWriteArrayList<ZoomChangeListener> zoomChangeListeners = new CopyOnWriteArrayList();
    private static final CopyOnWriteArrayList<SoMChangeListener> somChangeListeners = new CopyOnWriteArrayList();
    private double scale = Main.getProjection().getDefaultZoomInPPD();
    protected EastNorth center = this.calculateDefaultCenter();
    private final Object paintRequestLock = new Object();
    private Rectangle paintRect = null;
    private Polygon paintPoly = null;
    protected ViewportData initialViewport;
    private Stack<ZoomData> zoomUndoBuffer = new Stack();
    private Stack<ZoomData> zoomRedoBuffer = new Stack();
    private Date zoomTimestamp = new Date();
    private LinkedList<CursorInfo> cursors = new LinkedList();

    public static void removeZoomChangeListener(ZoomChangeListener listener) {
        zoomChangeListeners.remove(listener);
    }

    public static void addZoomChangeListener(ZoomChangeListener listener) {
        if (listener != null) {
            zoomChangeListeners.addIfAbsent(listener);
        }
    }

    protected static void fireZoomChanged() {
        for (ZoomChangeListener l : zoomChangeListeners) {
            l.zoomChanged();
        }
    }

    public static void removeSoMChangeListener(SoMChangeListener listener) {
        somChangeListeners.remove(listener);
    }

    public static void addSoMChangeListener(SoMChangeListener listener) {
        if (listener != null) {
            somChangeListeners.addIfAbsent(listener);
        }
    }

    protected static void fireSoMChanged(String oldSoM, String newSoM) {
        for (SoMChangeListener l : somChangeListeners) {
            l.systemOfMeasurementChanged(oldSoM, newSoM);
        }
    }

    public NavigatableComponent() {
        this.setLayout(null);
    }

    protected DataSet getCurrentDataSet() {
        return Main.main.getCurrentDataSet();
    }

    private EastNorth calculateDefaultCenter() {
        Bounds b = DownloadDialog.getSavedDownloadBounds();
        if (b == null) {
            b = Main.getProjection().getWorldBoundsLatLon();
        }
        return Main.getProjection().latlon2eastNorth(b.getCenter());
    }

    public static String getDistText(double dist) {
        return NavigatableComponent.getSystemOfMeasurement().getDistText(dist);
    }

    public static String getDistText(double dist, NumberFormat format, double threshold) {
        return NavigatableComponent.getSystemOfMeasurement().getDistText(dist, format, threshold);
    }

    public static String getAreaText(double area) {
        return NavigatableComponent.getSystemOfMeasurement().getAreaText(area);
    }

    public static String getAreaText(double area, NumberFormat format, double threshold) {
        return NavigatableComponent.getSystemOfMeasurement().getAreaText(area, format, threshold);
    }

    public String getDist100PixelText() {
        return NavigatableComponent.getDistText(this.getDist100Pixel());
    }

    public double getDist100Pixel() {
        int w = this.getWidth() / 2;
        int h = this.getHeight() / 2;
        LatLon ll1 = this.getLatLon(w - 50, h);
        LatLon ll2 = this.getLatLon(w + 50, h);
        return ll1.greatCircleDistance(ll2);
    }

    public EastNorth getCenter() {
        return this.center;
    }

    public double getScale() {
        return this.scale;
    }

    public EastNorth getEastNorth(int x, int y) {
        return new EastNorth(this.center.east() + ((double)x - (double)this.getWidth() / 2.0) * this.scale, this.center.north() - ((double)y - (double)this.getHeight() / 2.0) * this.scale);
    }

    public ProjectionBounds getProjectionBounds() {
        return new ProjectionBounds(new EastNorth(this.center.east() - (double)this.getWidth() / 2.0 * this.scale, this.center.north() - (double)this.getHeight() / 2.0 * this.scale), new EastNorth(this.center.east() + (double)this.getWidth() / 2.0 * this.scale, this.center.north() + (double)this.getHeight() / 2.0 * this.scale));
    }

    public ProjectionBounds getMaxProjectionBounds() {
        Bounds b = this.getProjection().getWorldBoundsLatLon();
        return new ProjectionBounds(this.getProjection().latlon2eastNorth(b.getMin()), this.getProjection().latlon2eastNorth(b.getMax()));
    }

    public Bounds getRealBounds() {
        return new Bounds(this.getProjection().eastNorth2latlon(new EastNorth(this.center.east() - (double)this.getWidth() / 2.0 * this.scale, this.center.north() - (double)this.getHeight() / 2.0 * this.scale)), this.getProjection().eastNorth2latlon(new EastNorth(this.center.east() + (double)this.getWidth() / 2.0 * this.scale, this.center.north() + (double)this.getHeight() / 2.0 * this.scale)));
    }

    public LatLon getLatLon(int x, int y) {
        return this.getProjection().eastNorth2latlon(this.getEastNorth(x, y));
    }

    public LatLon getLatLon(double x, double y) {
        return this.getLatLon((int)x, (int)y);
    }

    public Bounds getLatLonBounds(Rectangle r) {
        EastNorth p1 = this.getEastNorth(r.x, r.y);
        EastNorth p2 = this.getEastNorth(r.x + r.width, r.y + r.height);
        Bounds result = new Bounds(Main.getProjection().eastNorth2latlon(p1));
        double eastMin = Math.min(p1.east(), p2.east());
        double eastMax = Math.max(p1.east(), p2.east());
        double northMin = Math.min(p1.north(), p2.north());
        double northMax = Math.max(p1.north(), p2.north());
        double deltaEast = (eastMax - eastMin) / 10.0;
        double deltaNorth = (northMax - northMin) / 10.0;
        for (int i = 0; i < 10; ++i) {
            result.extend(Main.getProjection().eastNorth2latlon(new EastNorth(eastMin + (double)i * deltaEast, northMin)));
            result.extend(Main.getProjection().eastNorth2latlon(new EastNorth(eastMin + (double)i * deltaEast, northMax)));
            result.extend(Main.getProjection().eastNorth2latlon(new EastNorth(eastMin, northMin + (double)i * deltaNorth)));
            result.extend(Main.getProjection().eastNorth2latlon(new EastNorth(eastMax, northMin + (double)i * deltaNorth)));
        }
        return result;
    }

    public AffineTransform getAffineTransform() {
        return new AffineTransform(1.0 / this.scale, 0.0, 0.0, -1.0 / this.scale, (double)this.getWidth() / 2.0 - this.center.east() / this.scale, (double)this.getHeight() / 2.0 + this.center.north() / this.scale);
    }

    public Point2D getPoint2D(EastNorth p) {
        if (null == p) {
            return new Point();
        }
        double x = (p.east() - this.center.east()) / this.scale + (double)(this.getWidth() / 2);
        double y = (this.center.north() - p.north()) / this.scale + (double)(this.getHeight() / 2);
        return new Point2D.Double(x, y);
    }

    public Point2D getPoint2D(LatLon latlon) {
        if (latlon == null) {
            return new Point();
        }
        if (latlon instanceof CachedLatLon) {
            return this.getPoint2D(((CachedLatLon)latlon).getEastNorth());
        }
        return this.getPoint2D(this.getProjection().latlon2eastNorth(latlon));
    }

    public Point2D getPoint2D(Node n) {
        return this.getPoint2D(n.getEastNorth());
    }

    public Point getPoint(EastNorth p) {
        Point2D d = this.getPoint2D(p);
        return new Point((int)d.getX(), (int)d.getY());
    }

    public Point getPoint(LatLon latlon) {
        Point2D d = this.getPoint2D(latlon);
        return new Point((int)d.getX(), (int)d.getY());
    }

    public Point getPoint(Node n) {
        Point2D d = this.getPoint2D(n);
        return new Point((int)d.getX(), (int)d.getY());
    }

    public void zoomTo(EastNorth newCenter, double newScale) {
        this.zoomTo(newCenter, newScale, false);
    }

    public void zoomTo(EastNorth newCenter, double newScale, boolean initial) {
        Bounds b = this.getProjection().getWorldBoundsLatLon();
        LatLon cl = Projections.inverseProject(newCenter);
        boolean changed = false;
        double lat = cl.lat();
        double lon = cl.lon();
        if (lat < b.getMinLat()) {
            changed = true;
            lat = b.getMinLat();
        } else if (lat > b.getMaxLat()) {
            changed = true;
            lat = b.getMaxLat();
        }
        if (lon < b.getMinLon()) {
            changed = true;
            lon = b.getMinLon();
        } else if (lon > b.getMaxLon()) {
            changed = true;
            lon = b.getMaxLon();
        }
        if (changed) {
            newCenter = Projections.project(new LatLon(lat, lon));
        }
        int width = this.getWidth() / 2;
        int height = this.getHeight() / 2;
        LatLon l1 = new LatLon(b.getMinLat(), lon);
        LatLon l2 = new LatLon(b.getMaxLat(), lon);
        EastNorth e1 = this.getProjection().latlon2eastNorth(l1);
        EastNorth e2 = this.getProjection().latlon2eastNorth(l2);
        double d = e2.north() - e1.north();
        if (height > 0 && d < (double)height * newScale) {
            double newScaleH = d / (double)height;
            e1 = this.getProjection().latlon2eastNorth(new LatLon(lat, b.getMinLon()));
            e2 = this.getProjection().latlon2eastNorth(new LatLon(lat, b.getMaxLon()));
            d = e2.east() - e1.east();
            if (width > 0 && d < (double)width * newScale) {
                newScale = Math.max(newScaleH, d / (double)width);
            }
        } else if (height > 0 && newScale < (d /= l1.greatCircleDistance(l2) * (double)height * 10.0)) {
            newScale = d;
        }
        if (!newCenter.equals(this.center) || this.scale != newScale) {
            if (!initial) {
                this.pushZoomUndo(this.center, this.scale);
            }
            this.zoomNoUndoTo(newCenter, newScale, initial);
        }
    }

    private void zoomNoUndoTo(EastNorth newCenter, double newScale, boolean initial) {
        if (!newCenter.equals(this.center)) {
            EastNorth oldCenter = this.center;
            this.center = newCenter;
            if (!initial) {
                this.firePropertyChange(PROPNAME_CENTER, oldCenter, newCenter);
            }
        }
        if (this.scale != newScale) {
            double oldScale = this.scale;
            this.scale = newScale;
            if (!initial) {
                this.firePropertyChange(PROPNAME_SCALE, oldScale, newScale);
            }
        }
        if (!initial) {
            this.repaint();
            NavigatableComponent.fireZoomChanged();
        }
    }

    public void zoomTo(EastNorth newCenter) {
        this.zoomTo(newCenter, this.scale);
    }

    public void zoomTo(LatLon newCenter) {
        this.zoomTo(Projections.project(newCenter));
    }

    public void smoothScrollTo(LatLon newCenter) {
        this.smoothScrollTo(Projections.project(newCenter));
    }

    public void smoothScrollTo(EastNorth newCenter) {
        int fps = 20;
        int speed = 1500;
        if (!newCenter.equals(this.center)) {
            final EastNorth oldCenter = this.center;
            double distance = newCenter.distance(oldCenter) / this.scale;
            double milliseconds = distance / (double)this.getWidth() * 1500.0;
            final double frames = milliseconds * 20.0 / 1000.0;
            final EastNorth finalNewCenter = newCenter;
            new Thread(){

                @Override
                public void run() {
                    int i = 0;
                    while ((double)i < frames) {
                        NavigatableComponent.this.zoomTo(oldCenter.interpolate(finalNewCenter, (double)(i + 1) / frames));
                        try {
                            Thread.sleep(50L);
                        }
                        catch (InterruptedException ex) {
                            Main.warn("InterruptedException in " + NavigatableComponent.class.getSimpleName() + " during smooth scrolling");
                        }
                        ++i;
                    }
                }
            }.start();
        }
    }

    public void zoomToFactor(double x, double y, double factor) {
        double newScale = this.scale * factor;
        this.zoomTo(new EastNorth(this.center.east() - (x - (double)this.getWidth() / 2.0) * (newScale - this.scale), this.center.north() + (y - (double)this.getHeight() / 2.0) * (newScale - this.scale)), newScale);
    }

    public void zoomToFactor(EastNorth newCenter, double factor) {
        this.zoomTo(newCenter, this.scale * factor);
    }

    public void zoomToFactor(double factor) {
        this.zoomTo(this.center, this.scale * factor);
    }

    public void zoomTo(ProjectionBounds box) {
        int h;
        int w = this.getWidth() - 20;
        if (w < 20) {
            w = 20;
        }
        if ((h = this.getHeight() - 20) < 20) {
            h = 20;
        }
        double scaleX = (box.maxEast - box.minEast) / (double)w;
        double scaleY = (box.maxNorth - box.minNorth) / (double)h;
        double newScale = Math.max(scaleX, scaleY);
        this.zoomTo(box.getCenter(), newScale);
    }

    public void zoomTo(Bounds box) {
        this.zoomTo(new ProjectionBounds(this.getProjection().latlon2eastNorth(box.getMin()), this.getProjection().latlon2eastNorth(box.getMax())));
    }

    public void zoomTo(ViewportData viewport) {
        if (viewport == null) {
            return;
        }
        if (viewport.getBounds() != null) {
            BoundingXYVisitor box = new BoundingXYVisitor();
            box.visit(viewport.getBounds());
            this.zoomTo(box);
        } else {
            this.zoomTo(viewport.getCenter(), viewport.getScale(), true);
        }
    }

    public void zoomTo(BoundingXYVisitor box) {
        if (box == null) {
            box = new BoundingXYVisitor();
        }
        if (box.getBounds() == null) {
            box.visit(this.getProjection().getWorldBoundsLatLon());
        }
        if (!box.hasExtend()) {
            box.enlargeBoundingBox();
        }
        this.zoomTo(box.getBounds());
    }

    private void pushZoomUndo(EastNorth center, double scale) {
        Date now = new Date();
        if ((double)(now.getTime() - this.zoomTimestamp.getTime()) > Main.pref.getDouble("zoom.undo.delay", 1.0) * 1000.0) {
            this.zoomUndoBuffer.push(new ZoomData(center, scale));
            if (this.zoomUndoBuffer.size() > Main.pref.getInteger("zoom.undo.max", 50)) {
                this.zoomUndoBuffer.remove(0);
            }
            this.zoomRedoBuffer.clear();
        }
        this.zoomTimestamp = now;
    }

    public void zoomPrevious() {
        if (!this.zoomUndoBuffer.isEmpty()) {
            ZoomData zoom = this.zoomUndoBuffer.pop();
            this.zoomRedoBuffer.push(new ZoomData(this.center, this.scale));
            this.zoomNoUndoTo(zoom.getCenterEastNorth(), zoom.getScale(), false);
        }
    }

    public void zoomNext() {
        if (!this.zoomRedoBuffer.isEmpty()) {
            ZoomData zoom = this.zoomRedoBuffer.pop();
            this.zoomUndoBuffer.push(new ZoomData(this.center, this.scale));
            this.zoomNoUndoTo(zoom.getCenterEastNorth(), zoom.getScale(), false);
        }
    }

    public boolean hasZoomUndoEntries() {
        return !this.zoomUndoBuffer.isEmpty();
    }

    public boolean hasZoomRedoEntries() {
        return !this.zoomRedoBuffer.isEmpty();
    }

    private BBox getBBox(Point p, int snapDistance) {
        return new BBox(this.getLatLon(p.x - snapDistance, p.y - snapDistance), this.getLatLon(p.x + snapDistance, p.y + snapDistance));
    }

    private Map<Double, List<Node>> getNearestNodesImpl(Point p, Predicate<OsmPrimitive> predicate) {
        TreeMap<Double, List<Node>> nearestMap = new TreeMap<Double, List<Node>>();
        DataSet ds = this.getCurrentDataSet();
        if (ds != null) {
            double snapDistanceSq = PROP_SNAP_DISTANCE.get().intValue();
            snapDistanceSq *= snapDistanceSq;
            for (Node n : ds.searchNodes(this.getBBox(p, PROP_SNAP_DISTANCE.get()))) {
                List<Object> nlist;
                double d;
                if (!predicate.evaluate(n)) continue;
                double dist = this.getPoint2D(n).distanceSq(p);
                if (!(d < snapDistanceSq)) continue;
                if (nearestMap.containsKey(dist)) {
                    nlist = nearestMap.get(dist);
                } else {
                    nlist = new LinkedList();
                    nearestMap.put(dist, nlist);
                }
                nlist.add(n);
            }
        }
        return nearestMap;
    }

    public final List<Node> getNearestNodes(Point p, Collection<Node> ignore, Predicate<OsmPrimitive> predicate) {
        Map<Double, List<Node>> nlists;
        List<Node> nearestList = Collections.emptyList();
        if (ignore == null) {
            ignore = Collections.emptySet();
        }
        if (!(nlists = this.getNearestNodesImpl(p, predicate)).isEmpty()) {
            Double minDistSq = null;
            for (Map.Entry<Double, List<Node>> entry : nlists.entrySet()) {
                Double distSq = entry.getKey();
                List<Node> nlist = entry.getValue();
                nlist.removeAll(ignore);
                if (minDistSq == null) {
                    if (nlist.isEmpty()) continue;
                    minDistSq = distSq;
                    nearestList = new ArrayList<Node>();
                    nearestList.addAll(nlist);
                    continue;
                }
                if (!(distSq - minDistSq < 16.0)) continue;
                nearestList.addAll(nlist);
            }
        }
        return nearestList;
    }

    public final List<Node> getNearestNodes(Point p, Predicate<OsmPrimitive> predicate) {
        return this.getNearestNodes(p, null, predicate);
    }

    public final Node getNearestNode(Point p, Predicate<OsmPrimitive> predicate, boolean useSelected) {
        return this.getNearestNode(p, predicate, useSelected, null);
    }

    public final Node getNearestNode(Point p, Predicate<OsmPrimitive> predicate, boolean useSelected, Collection<OsmPrimitive> preferredRefs) {
        Map<Double, List<Node>> nlists = this.getNearestNodesImpl(p, predicate);
        if (nlists.isEmpty()) {
            return null;
        }
        if (preferredRefs != null && preferredRefs.isEmpty()) {
            preferredRefs = null;
        }
        Node ntsel = null;
        Node ntnew = null;
        Node ntref = null;
        boolean useNtsel = useSelected;
        double minDistSq = nlists.keySet().iterator().next();
        for (Map.Entry<Double, List<Node>> entry : nlists.entrySet()) {
            Double distSq = entry.getKey();
            for (Node nd : entry.getValue()) {
                if (ntsel == null && nd.isSelected()) {
                    ntsel = nd;
                    useNtsel |= distSq == minDistSq;
                }
                if (ntref == null && preferredRefs != null && distSq == minDistSq) {
                    List<OsmPrimitive> ndRefs = nd.getReferrers();
                    for (OsmPrimitive ref : preferredRefs) {
                        if (!ndRefs.contains(ref)) continue;
                        ntref = nd;
                        break;
                    }
                }
                if (ntnew != null || !nd.isNew() || !(distSq - minDistSq < 1.0)) continue;
                ntnew = nd;
            }
        }
        if (ntsel != null && useNtsel) {
            return ntsel;
        }
        if (ntref != null) {
            return ntref;
        }
        if (ntnew != null) {
            return ntnew;
        }
        return nlists.values().iterator().next().get(0);
    }

    public final Node getNearestNode(Point p, Predicate<OsmPrimitive> predicate) {
        return this.getNearestNode(p, predicate, true);
    }

    private Map<Double, List<WaySegment>> getNearestWaySegmentsImpl(Point p, Predicate<OsmPrimitive> predicate) {
        TreeMap<Double, List<WaySegment>> nearestMap = new TreeMap<Double, List<WaySegment>>();
        DataSet ds = this.getCurrentDataSet();
        if (ds != null) {
            double snapDistanceSq = Main.pref.getInteger("mappaint.segment.snap-distance", 10);
            snapDistanceSq *= snapDistanceSq;
            for (Way w : ds.searchWays(this.getBBox(p, Main.pref.getInteger("mappaint.segment.snap-distance", 10)))) {
                if (!predicate.evaluate(w)) continue;
                Node lastN = null;
                int i = -2;
                for (Node n : w.getNodes()) {
                    double b;
                    ++i;
                    if (n.isDeleted() || n.isIncomplete()) continue;
                    if (lastN == null) {
                        lastN = n;
                        continue;
                    }
                    Point2D A2 = this.getPoint2D(lastN);
                    Point2D B = this.getPoint2D(n);
                    double c = A2.distanceSq(B);
                    double a = p.distanceSq(B);
                    double perDistSq = Double.longBitsToDouble(Double.doubleToLongBits(a - (a - (b = p.distanceSq(A2)) + c) * (a - b + c) / 4.0 / c) >> 32 << 32);
                    if (perDistSq < snapDistanceSq && a < c + snapDistanceSq && b < c + snapDistanceSq) {
                        List<WaySegment> wslist;
                        if (nearestMap.containsKey(perDistSq)) {
                            wslist = (List)nearestMap.get(perDistSq);
                        } else {
                            wslist = new LinkedList();
                            nearestMap.put(perDistSq, wslist);
                        }
                        wslist.add(new WaySegment(w, i));
                    }
                    lastN = n;
                }
            }
        }
        return nearestMap;
    }

    public final List<WaySegment> getNearestWaySegments(Point p, Collection<WaySegment> ignore, Predicate<OsmPrimitive> predicate) {
        ArrayList<WaySegment> nearestList = new ArrayList<WaySegment>();
        LinkedList unselected = new LinkedList();
        for (List<WaySegment> wss : this.getNearestWaySegmentsImpl(p, predicate).values()) {
            for (WaySegment ws : wss) {
                (ws.way.isSelected() ? nearestList : unselected).add((WaySegment)ws);
            }
            nearestList.addAll(unselected);
            unselected.clear();
        }
        if (ignore != null) {
            nearestList.removeAll(ignore);
        }
        return nearestList;
    }

    public final List<WaySegment> getNearestWaySegments(Point p, Predicate<OsmPrimitive> predicate) {
        return this.getNearestWaySegments(p, null, predicate);
    }

    public final WaySegment getNearestWaySegment(Point p, Predicate<OsmPrimitive> predicate, boolean useSelected) {
        WaySegment wayseg = null;
        WaySegment ntsel = null;
        for (List<WaySegment> wslist : this.getNearestWaySegmentsImpl(p, predicate).values()) {
            if (wayseg != null && ntsel != null) break;
            for (WaySegment ws : wslist) {
                if (wayseg == null) {
                    wayseg = ws;
                }
                if (ntsel != null || !ws.way.isSelected()) continue;
                ntsel = ws;
            }
        }
        return ntsel != null && useSelected ? ntsel : wayseg;
    }

    public final WaySegment getNearestWaySegment(Point p, Predicate<OsmPrimitive> predicate, boolean use_selected, Collection<OsmPrimitive> preferredRefs) {
        WaySegment wayseg = null;
        WaySegment ntsel = null;
        WaySegment ntref = null;
        if (preferredRefs != null && preferredRefs.isEmpty()) {
            preferredRefs = null;
        }
        block0: for (List<WaySegment> wslist : this.getNearestWaySegmentsImpl(p, predicate).values()) {
            for (WaySegment ws : wslist) {
                if (wayseg == null) {
                    wayseg = ws;
                }
                if (ntsel == null && ws.way.isSelected()) {
                    ntsel = ws;
                    break block0;
                }
                if (ntref != null || preferredRefs == null) continue;
                for (Node nd : ws.way.getNodes()) {
                    if (!preferredRefs.contains(nd)) continue;
                    ntref = ws;
                    break block0;
                }
                List<OsmPrimitive> wayRefs = ws.way.getReferrers();
                for (OsmPrimitive ref : preferredRefs) {
                    if (!(ref instanceof Relation) || !wayRefs.contains(ref)) continue;
                    ntref = ws;
                    break block0;
                }
            }
        }
        if (ntsel != null && use_selected) {
            return ntsel;
        }
        if (ntref != null) {
            return ntref;
        }
        return wayseg;
    }

    public final WaySegment getNearestWaySegment(Point p, Predicate<OsmPrimitive> predicate) {
        return this.getNearestWaySegment(p, predicate, true);
    }

    public final List<Way> getNearestWays(Point p, Collection<Way> ignore, Predicate<OsmPrimitive> predicate) {
        ArrayList<Way> nearestList = new ArrayList<Way>();
        HashSet<Way> wset = new HashSet<Way>();
        for (List<WaySegment> wss : this.getNearestWaySegmentsImpl(p, predicate).values()) {
            for (WaySegment ws : wss) {
                if (!wset.add(ws.way)) continue;
                nearestList.add(ws.way);
            }
        }
        if (ignore != null) {
            nearestList.removeAll(ignore);
        }
        return nearestList;
    }

    public final List<Way> getNearestWays(Point p, Predicate<OsmPrimitive> predicate) {
        return this.getNearestWays(p, null, predicate);
    }

    public final Way getNearestWay(Point p, Predicate<OsmPrimitive> predicate) {
        WaySegment nearestWaySeg = this.getNearestWaySegment(p, predicate);
        return nearestWaySeg == null ? null : nearestWaySeg.way;
    }

    public final List<OsmPrimitive> getNearestNodesOrWays(Point p, Collection<OsmPrimitive> ignore, Predicate<OsmPrimitive> predicate) {
        List<OsmPrimitive> nearestList = Collections.emptyList();
        OsmPrimitive osm = this.getNearestNodeOrWay(p, predicate, false);
        if (osm != null) {
            if (osm instanceof Node) {
                nearestList = new ArrayList<Node>(this.getNearestNodes(p, predicate));
            } else if (osm instanceof Way) {
                nearestList = new ArrayList<Way>(this.getNearestWays(p, predicate));
            }
            if (ignore != null) {
                nearestList.removeAll(ignore);
            }
        }
        return nearestList;
    }

    public final List<OsmPrimitive> getNearestNodesOrWays(Point p, Predicate<OsmPrimitive> predicate) {
        return this.getNearestNodesOrWays(p, null, predicate);
    }

    private boolean isPrecedenceNode(Node osm, Point p, boolean use_selected) {
        if (osm != null) {
            if (!(p.distanceSq(this.getPoint2D(osm)) > 16.0)) {
                return true;
            }
            if (osm.isTagged()) {
                return true;
            }
            if (use_selected && osm.isSelected()) {
                return true;
            }
        }
        return false;
    }

    public final OsmPrimitive getNearestNodeOrWay(Point p, Predicate<OsmPrimitive> predicate, boolean use_selected) {
        DataSet ds = this.getCurrentDataSet();
        Collection<OsmPrimitive> sel = use_selected && ds != null ? ds.getSelected() : null;
        OsmPrimitive osm = this.getNearestNode(p, predicate, use_selected, sel);
        if (this.isPrecedenceNode((Node)osm, p, use_selected)) {
            return osm;
        }
        WaySegment ws = use_selected ? this.getNearestWaySegment(p, predicate, use_selected, sel) : this.getNearestWaySegment(p, predicate, use_selected);
        if (ws == null) {
            return osm;
        }
        if (ws.way.isSelected() && use_selected || osm == null) {
            osm = ws.way;
        } else {
            Point2D wp2;
            int maxWaySegLenSq = 3 * PROP_SNAP_DISTANCE.get();
            maxWaySegLenSq *= maxWaySegLenSq;
            Point2D wp1 = this.getPoint2D(ws.way.getNode(ws.lowerIndex));
            if (wp1.distanceSq(wp2 = this.getPoint2D(ws.way.getNode(ws.lowerIndex + 1))) < (double)maxWaySegLenSq && p.distanceSq(NavigatableComponent.project(0.5, wp1, wp2)) < p.distanceSq(this.getPoint2D((Node)osm))) {
                osm = ws.way;
            }
        }
        return osm;
    }

    public static double perDist(Point2D pt, Point2D a, Point2D b) {
        if (pt != null && a != null && b != null) {
            double pd = (a.getX() - pt.getX()) * (b.getX() - a.getX()) - (a.getY() - pt.getY()) * (b.getY() - a.getY());
            return Math.abs(pd) / a.distance(b);
        }
        return 0.0;
    }

    public static Point2D project(Point2D pt, Point2D a, Point2D b) {
        if (pt != null && a != null && b != null) {
            double r = ((pt.getX() - a.getX()) * (b.getX() - a.getX()) + (pt.getY() - a.getY()) * (b.getY() - a.getY())) / a.distanceSq(b);
            return NavigatableComponent.project(r, a, b);
        }
        return null;
    }

    public static Point2D project(double r, Point2D a, Point2D b) {
        Point2D.Double ret = null;
        if (a != null && b != null) {
            ret = new Point2D.Double(a.getX() + r * (b.getX() - a.getX()), a.getY() + r * (b.getY() - a.getY()));
        }
        return ret;
    }

    public final List<OsmPrimitive> getAllNearest(Point p, Collection<OsmPrimitive> ignore, Predicate<OsmPrimitive> predicate) {
        ArrayList<OsmPrimitive> nearestList = new ArrayList<OsmPrimitive>();
        HashSet<Way> wset = new HashSet<Way>();
        for (List<WaySegment> list : this.getNearestWaySegmentsImpl(p, predicate).values()) {
            for (WaySegment ws : list) {
                if (!wset.add(ws.way)) continue;
                nearestList.add(ws.way);
            }
        }
        for (List<Comparable<WaySegment>> list : this.getNearestNodesImpl(p, predicate).values()) {
            nearestList.addAll(list);
        }
        HashSet<OsmPrimitive> parentRelations = new HashSet<OsmPrimitive>();
        for (OsmPrimitive o : nearestList) {
            for (OsmPrimitive r : o.getReferrers()) {
                if (!(r instanceof Relation) || !predicate.evaluate(r)) continue;
                parentRelations.add(r);
            }
        }
        nearestList.addAll(parentRelations);
        if (ignore != null) {
            nearestList.removeAll(ignore);
        }
        return nearestList;
    }

    public final List<OsmPrimitive> getAllNearest(Point p, Predicate<OsmPrimitive> predicate) {
        return this.getAllNearest(p, null, predicate);
    }

    public Projection getProjection() {
        return Main.getProjection();
    }

    @Override
    public String helpTopic() {
        String n = this.getClass().getName();
        return n.substring(n.lastIndexOf(46) + 1);
    }

    public int getViewID() {
        String x = this.center.east() + "_" + this.center.north() + "_" + this.scale + "_" + this.getWidth() + "_" + this.getHeight() + "_" + this.getProjection().toString();
        CRC32 id = new CRC32();
        id.update(x.getBytes(StandardCharsets.UTF_8));
        return (int)id.getValue();
    }

    public static SystemOfMeasurement getSystemOfMeasurement() {
        SystemOfMeasurement som = SystemOfMeasurement.ALL_SYSTEMS.get(ProjectionPreference.PROP_SYSTEM_OF_MEASUREMENT.get());
        if (som == null) {
            return SystemOfMeasurement.METRIC;
        }
        return som;
    }

    public static void setSystemOfMeasurement(String somKey) {
        if (!SystemOfMeasurement.ALL_SYSTEMS.containsKey(somKey)) {
            throw new IllegalArgumentException("Invalid system of measurement: " + somKey);
        }
        String oldKey = ProjectionPreference.PROP_SYSTEM_OF_MEASUREMENT.get();
        if (ProjectionPreference.PROP_SYSTEM_OF_MEASUREMENT.put(somKey)) {
            NavigatableComponent.fireSoMChanged(oldKey, somKey);
        }
    }

    public void setNewCursor(Cursor cursor, Object reference) {
        if (!this.cursors.isEmpty()) {
            CursorInfo l = this.cursors.getLast();
            if (l != null && l.cursor == cursor && l.object == reference) {
                return;
            }
            this.stripCursors(reference);
        }
        this.cursors.add(new CursorInfo(cursor, reference));
        this.setCursor(cursor);
    }

    public void setNewCursor(int cursor, Object reference) {
        this.setNewCursor(Cursor.getPredefinedCursor(cursor), reference);
    }

    public void resetCursor(Object reference) {
        if (this.cursors.isEmpty()) {
            this.setCursor(null);
            return;
        }
        CursorInfo l = this.cursors.getLast();
        this.stripCursors(reference);
        if (l != null && l.object == reference) {
            if (this.cursors.isEmpty()) {
                this.setCursor(null);
            } else {
                this.setCursor(this.cursors.getLast().cursor);
            }
        }
    }

    private void stripCursors(Object reference) {
        LinkedList<CursorInfo> c = new LinkedList<CursorInfo>();
        for (CursorInfo i : this.cursors) {
            if (i.object == reference) continue;
            c.add(i);
        }
        this.cursors = c;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paint(Graphics g) {
        Object object = this.paintRequestLock;
        synchronized (object) {
            Graphics g2;
            if (this.paintRect != null) {
                g2 = g.create();
                g2.setColor(Utils.complement(PaintColors.getBackgroundColor()));
                g2.drawRect(this.paintRect.x, this.paintRect.y, this.paintRect.width, this.paintRect.height);
                g2.dispose();
            }
            if (this.paintPoly != null) {
                g2 = g.create();
                g2.setColor(Utils.complement(PaintColors.getBackgroundColor()));
                g2.drawPolyline(this.paintPoly.xpoints, this.paintPoly.ypoints, this.paintPoly.npoints);
                g2.dispose();
            }
        }
        super.paint(g);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestPaintRect(Rectangle r) {
        if (r != null) {
            Object object = this.paintRequestLock;
            synchronized (object) {
                this.paintRect = r;
            }
            this.repaint();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestPaintPoly(Polygon p) {
        if (p != null) {
            Object object = this.paintRequestLock;
            synchronized (object) {
                this.paintPoly = p;
            }
            this.repaint();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestClearRect() {
        Object object = this.paintRequestLock;
        synchronized (object) {
            this.paintRect = null;
        }
        this.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestClearPoly() {
        Object object = this.paintRequestLock;
        synchronized (object) {
            this.paintPoly = null;
        }
        this.repaint();
    }

    private static class CursorInfo {
        final Cursor cursor;
        final Object object;

        public CursorInfo(Cursor c, Object o) {
            this.cursor = c;
            this.object = o;
        }
    }

    private class ZoomData {
        final LatLon center;
        final double scale;

        public ZoomData(EastNorth center, double scale) {
            this.center = Projections.inverseProject(center);
            this.scale = scale;
        }

        public EastNorth getCenterEastNorth() {
            return NavigatableComponent.this.getProjection().latlon2eastNorth(this.center);
        }

        public double getScale() {
            return this.scale;
        }
    }

    public static interface SoMChangeListener {
        public void systemOfMeasurementChanged(String var1, String var2);
    }

    public static interface ZoomChangeListener {
        public void zoomChanged();
    }
}

