/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.Arrays;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.tools.WindowGeometry;

public class MenuScroller {
    private JPopupMenu menu;
    private Component[] menuItems;
    private MenuScrollItem upItem;
    private MenuScrollItem downItem;
    private final MenuScrollListener menuListener = new MenuScrollListener();
    private final MouseWheelListener mouseWheelListener = new MouseScrollListener();
    private int interval;
    private int topFixedCount;
    private int firstIndex = 0;

    private int computeScrollCount(int startIndex) {
        int result = 15;
        if (this.menu != null) {
            int maxHeight = WindowGeometry.getMaxDimensionOnScreen((JComponent)this.menu).height - ((JFrame)Main.parent).getInsets().top;
            if (this.topFixedCount > 0) {
                for (int i = 0; i < this.topFixedCount; ++i) {
                    maxHeight -= this.menuItems[i].getPreferredSize().height;
                }
                maxHeight -= new JSeparator().getPreferredSize().height;
            }
            maxHeight -= this.menu.getInsets().top;
            maxHeight -= this.upItem.getPreferredSize().height;
            maxHeight -= this.downItem.getPreferredSize().height;
            maxHeight -= this.menu.getInsets().bottom;
            result = 0;
            int height = 0;
            int i = startIndex;
            while (i < this.menuItems.length && height <= maxHeight) {
                height += this.menuItems[i].getPreferredSize().height;
                ++i;
                ++result;
            }
            if (height > maxHeight) {
                --result;
            } else {
                i = startIndex - 1;
                while (i >= 0 && height <= maxHeight) {
                    height += this.menuItems[i].getPreferredSize().height;
                    --i;
                    ++result;
                }
                if (height > maxHeight) {
                    --result;
                }
            }
        }
        return result;
    }

    public static MenuScroller setScrollerFor(JMenu menu) {
        return new MenuScroller(menu);
    }

    public static MenuScroller setScrollerFor(JPopupMenu menu) {
        return new MenuScroller(menu);
    }

    public static MenuScroller setScrollerFor(JMenu menu, int interval) {
        return new MenuScroller(menu, interval);
    }

    public static MenuScroller setScrollerFor(JPopupMenu menu, int interval) {
        return new MenuScroller(menu, interval);
    }

    public static MenuScroller setScrollerFor(JMenu menu, int interval, int topFixedCount) {
        return new MenuScroller(menu, interval, topFixedCount);
    }

    public static MenuScroller setScrollerFor(JPopupMenu menu, int interval, int topFixedCount) {
        return new MenuScroller(menu, interval, topFixedCount);
    }

    public MenuScroller(JMenu menu) {
        this(menu, 150);
    }

    public MenuScroller(JPopupMenu menu) {
        this(menu, 150);
    }

    public MenuScroller(JMenu menu, int interval) {
        this(menu, interval, 0);
    }

    public MenuScroller(JPopupMenu menu, int interval) {
        this(menu, interval, 0);
    }

    public MenuScroller(JMenu menu, int interval, int topFixedCount) {
        this(menu.getPopupMenu(), interval, topFixedCount);
    }

    public MenuScroller(JPopupMenu menu, int interval, int topFixedCount) {
        if (interval <= 0) {
            throw new IllegalArgumentException("interval must be greater than 0");
        }
        if (topFixedCount < 0) {
            throw new IllegalArgumentException("topFixedCount cannot be negative");
        }
        this.upItem = new MenuScrollItem(MenuIcon.UP, -1);
        this.downItem = new MenuScrollItem(MenuIcon.DOWN, 1);
        this.setInterval(interval);
        this.setTopFixedCount(topFixedCount);
        this.menu = menu;
        menu.addPopupMenuListener(this.menuListener);
        menu.addMouseWheelListener(this.mouseWheelListener);
    }

    public int getInterval() {
        return this.interval;
    }

    public void setInterval(int interval) {
        if (interval <= 0) {
            throw new IllegalArgumentException("interval must be greater than 0");
        }
        this.upItem.setInterval(interval);
        this.downItem.setInterval(interval);
        this.interval = interval;
    }

    public int getTopFixedCount() {
        return this.topFixedCount;
    }

    public void setTopFixedCount(int topFixedCount) {
        this.firstIndex = this.firstIndex <= topFixedCount ? topFixedCount : (this.firstIndex += topFixedCount - this.topFixedCount);
        this.topFixedCount = topFixedCount;
    }

    public void dispose() {
        if (this.menu != null) {
            this.menu.removePopupMenuListener(this.menuListener);
            this.menu.removeMouseWheelListener(this.mouseWheelListener);
            this.menu.setPreferredSize(null);
            this.menu = null;
        }
    }

    protected void finalize() throws Throwable {
        this.dispose();
        super.finalize();
    }

    private void refreshMenu() {
        if (this.menuItems != null && this.menuItems.length > 0) {
            boolean mustSCroll;
            int allItemsHeight = 0;
            for (Component item : this.menuItems) {
                allItemsHeight += item.getPreferredSize().height;
            }
            int allowedHeight = WindowGeometry.getMaxDimensionOnScreen((JComponent)this.menu).height - ((JFrame)Main.parent).getInsets().top;
            boolean bl = mustSCroll = allItemsHeight > allowedHeight;
            if (mustSCroll) {
                int i;
                this.firstIndex = Math.max(this.topFixedCount, this.firstIndex);
                int scrollCount = this.computeScrollCount(this.firstIndex);
                this.firstIndex = Math.min(this.menuItems.length - scrollCount, this.firstIndex);
                this.upItem.setEnabled(this.firstIndex > this.topFixedCount);
                this.downItem.setEnabled(this.firstIndex + scrollCount < this.menuItems.length);
                this.menu.removeAll();
                for (i = 0; i < this.topFixedCount; ++i) {
                    this.menu.add(this.menuItems[i]);
                }
                if (this.topFixedCount > 0) {
                    this.menu.addSeparator();
                }
                this.menu.add(this.upItem);
                for (i = this.firstIndex; i < scrollCount + this.firstIndex; ++i) {
                    this.menu.add(this.menuItems[i]);
                }
                this.menu.add(this.downItem);
                int preferredWidth = 0;
                for (Component item : this.menuItems) {
                    preferredWidth = Math.max(preferredWidth, item.getPreferredSize().width);
                }
                this.menu.setPreferredSize(new Dimension(preferredWidth, this.menu.getPreferredSize().height));
            } else if (!Arrays.equals(this.menu.getComponents(), this.menuItems)) {
                this.menu.removeAll();
                for (Component item : this.menuItems) {
                    this.menu.add(item);
                }
            }
            this.menu.revalidate();
            this.menu.repaint();
        }
    }

    static /* synthetic */ Component[] access$202(MenuScroller x0, Component[] x1) {
        x0.menuItems = x1;
        return x1;
    }

    private class MouseScrollListener
    implements MouseWheelListener {
        private MouseScrollListener() {
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent mwe) {
            MenuScroller.this.firstIndex += mwe.getWheelRotation();
            MenuScroller.this.refreshMenu();
            mwe.consume();
        }
    }

    private static enum MenuIcon implements Icon
    {
        UP(9, 1, 9),
        DOWN(1, 9, 1);

        static final int[] XPOINTS;
        final int[] yPoints;

        private MenuIcon(int ... yPoints) {
            this.yPoints = yPoints;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            Dimension size = c.getSize();
            Graphics g2 = g.create(size.width / 2 - 5, size.height / 2 - 5, 10, 10);
            g2.setColor(Color.GRAY);
            g2.drawPolygon(XPOINTS, this.yPoints, 3);
            if (c.isEnabled()) {
                g2.setColor(Color.BLACK);
                g2.fillPolygon(XPOINTS, this.yPoints, 3);
            }
            g2.dispose();
        }

        @Override
        public int getIconWidth() {
            return 0;
        }

        @Override
        public int getIconHeight() {
            return 10;
        }

        static {
            XPOINTS = new int[]{1, 5, 9};
        }
    }

    private class MenuScrollItem
    extends JMenuItem
    implements ChangeListener {
        private MenuScrollTimer timer;

        public MenuScrollItem(MenuIcon icon, int increment) {
            this.setIcon(icon);
            this.setDisabledIcon(icon);
            this.timer = new MenuScrollTimer(increment, MenuScroller.this.interval);
            this.addChangeListener(this);
        }

        public void setInterval(int interval) {
            this.timer.setDelay(interval);
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            if (this.isArmed() && !this.timer.isRunning()) {
                this.timer.start();
            }
            if (!this.isArmed() && this.timer.isRunning()) {
                this.timer.stop();
            }
        }
    }

    private class MenuScrollTimer
    extends Timer {
        public MenuScrollTimer(final int increment, int interval) {
            super(interval, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MenuScroller.this.firstIndex += increment;
                    MenuScroller.this.refreshMenu();
                }
            });
        }
    }

    private class MenuScrollListener
    implements PopupMenuListener {
        private MenuScrollListener() {
        }

        @Override
        public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            this.setMenuItems();
        }

        @Override
        public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            this.restoreMenuItems();
        }

        @Override
        public void popupMenuCanceled(PopupMenuEvent e) {
            this.restoreMenuItems();
        }

        private void setMenuItems() {
            MenuScroller.access$202(MenuScroller.this, MenuScroller.this.menu.getComponents());
            MenuScroller.this.refreshMenu();
        }

        private void restoreMenuItems() {
            MenuScroller.this.menu.removeAll();
            for (Component component : MenuScroller.this.menuItems) {
                MenuScroller.this.menu.add(component);
            }
        }
    }
}

