/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.AbstractButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.mapmode.MapMode;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.Preferences;
import org.openstreetmap.josm.data.SelectionChangedListener;
import org.openstreetmap.josm.data.ViewportData;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.imagery.ImageryInfo;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.data.osm.visitor.BoundingXYVisitor;
import org.openstreetmap.josm.data.osm.visitor.paint.PaintColors;
import org.openstreetmap.josm.data.osm.visitor.paint.relations.MultipolygonCache;
import org.openstreetmap.josm.gui.MapMover;
import org.openstreetmap.josm.gui.MapScaler;
import org.openstreetmap.josm.gui.MapSlider;
import org.openstreetmap.josm.gui.NavigatableComponent;
import org.openstreetmap.josm.gui.layer.GpxLayer;
import org.openstreetmap.josm.gui.layer.ImageryLayer;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.MapViewPaintable;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.layer.geoimage.GeoImageLayer;
import org.openstreetmap.josm.gui.layer.markerlayer.MarkerLayer;
import org.openstreetmap.josm.gui.layer.markerlayer.PlayHeadMarker;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.tools.AudioPlayer;
import org.openstreetmap.josm.tools.BugReportExceptionHandler;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;
import org.openstreetmap.josm.tools.Utils;

public class MapView
extends NavigatableComponent
implements PropertyChangeListener,
Preferences.PreferenceChangedListener,
OsmDataLayer.LayerStateChangeListener {
    public boolean viewportFollowing = false;
    private static final CopyOnWriteArrayList<LayerChangeListener> layerChangeListeners = new CopyOnWriteArrayList();
    private static final CopyOnWriteArrayList<EditLayerChangeListener> editLayerChangeListeners = new CopyOnWriteArrayList();
    private final List<Layer> layers = new ArrayList<Layer>();
    public PlayHeadMarker playHeadMarker = null;
    private Layer activeLayer;
    private OsmDataLayer editLayer;
    public MouseEvent lastMEvent = new MouseEvent(this, 0, 0L, 0, 0, 0, 0, false);
    private final List<MapViewPaintable> temporaryLayers = new LinkedList<MapViewPaintable>();
    private BufferedImage nonChangedLayersBuffer;
    private BufferedImage offscreenBuffer;
    private final List<Layer> nonChangedLayers = new ArrayList<Layer>();
    private Layer changedLayer;
    private int lastViewID;
    private boolean paintPreferencesChanged = true;
    private Rectangle lastClipBounds = new Rectangle();
    private MapMover mapMover;
    private Dimension oldSize = null;
    private Point oldLoc = null;
    private boolean virtualNodesEnabled = false;
    private SelectionChangedListener repaintSelectionChangedListener = new SelectionChangedListener(){

        @Override
        public void selectionChanged(Collection<? extends OsmPrimitive> newSelection) {
            MapView.this.repaint();
        }
    };

    public static void removeLayerChangeListener(LayerChangeListener listener) {
        layerChangeListeners.remove(listener);
    }

    public static void removeEditLayerChangeListener(EditLayerChangeListener listener) {
        editLayerChangeListeners.remove(listener);
    }

    public static void addLayerChangeListener(LayerChangeListener listener) {
        if (listener != null) {
            layerChangeListeners.addIfAbsent(listener);
        }
    }

    public static void addLayerChangeListener(LayerChangeListener listener, boolean initialFire) {
        MapView.addLayerChangeListener(listener);
        if (initialFire && Main.isDisplayingMapView()) {
            listener.activeLayerChange(null, Main.map.mapView.getActiveLayer());
        }
    }

    public static void addEditLayerChangeListener(EditLayerChangeListener listener, boolean initialFire) {
        MapView.addEditLayerChangeListener(listener);
        if (initialFire && Main.isDisplayingMapView() && Main.map.mapView.getEditLayer() != null) {
            listener.editLayerChanged(null, Main.map.mapView.getEditLayer());
        }
    }

    public static void addEditLayerChangeListener(EditLayerChangeListener listener) {
        if (listener != null) {
            editLayerChangeListeners.addIfAbsent(listener);
        }
    }

    protected static void fireActiveLayerChanged(Layer oldLayer, Layer newLayer) {
        for (LayerChangeListener l : layerChangeListeners) {
            l.activeLayerChange(oldLayer, newLayer);
        }
    }

    protected static void fireLayerAdded(Layer newLayer) {
        for (LayerChangeListener l : layerChangeListeners) {
            l.layerAdded(newLayer);
        }
    }

    protected static void fireLayerRemoved(Layer layer) {
        for (LayerChangeListener l : layerChangeListeners) {
            l.layerRemoved(layer);
        }
    }

    protected static void fireEditLayerChanged(OsmDataLayer oldLayer, OsmDataLayer newLayer) {
        for (EditLayerChangeListener l : editLayerChangeListeners) {
            l.editLayerChanged(oldLayer, newLayer);
        }
    }

    public MapView(final JPanel contentPane, ViewportData viewportData) {
        this.initialViewport = viewportData;
        Main.pref.addPreferenceChangeListener(this);
        final boolean unregisterTab = Shortcut.findShortcut(9, 0) != null;
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                MapView.this.removeComponentListener(this);
                MapSlider zoomSlider = new MapSlider(MapView.this);
                MapView.this.add(zoomSlider);
                zoomSlider.setBounds(3, 0, 114, 30);
                zoomSlider.setFocusTraversalKeysEnabled(!unregisterTab);
                MapScaler scaler = new MapScaler(MapView.this);
                MapView.this.add(scaler);
                scaler.setLocation(10, 30);
                MapView.this.mapMover = new MapMover(MapView.this, contentPane);
            }
        });
        DataSet.addSelectionListener(this.repaintSelectionChangedListener);
        this.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseDragged(MouseEvent e) {
                this.mouseMoved(e);
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                MapView.this.lastMEvent = e;
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent me) {
                MapView.this.requestFocus();
            }
        });
        if (Shortcut.findShortcut(9, 0) != null) {
            this.setFocusTraversalKeysEnabled(false);
        }
    }

    public void rememberLastPositionOnScreen() {
        this.oldSize = this.getSize();
        this.oldLoc = this.getLocationOnScreen();
    }

    protected void addGpxLayer(GpxLayer layer) {
        if (this.layers.isEmpty()) {
            this.layers.add(layer);
            return;
        }
        for (int i = this.layers.size() - 1; i >= 0; --i) {
            if (!(this.layers.get(i) instanceof OsmDataLayer)) continue;
            if (i == this.layers.size() - 1) {
                this.layers.add(layer);
            } else {
                this.layers.add(i + 1, layer);
            }
            return;
        }
        this.layers.add(0, layer);
    }

    public void addLayer(Layer layer) {
        boolean callSetActiveLayer;
        if (layer instanceof MarkerLayer && this.playHeadMarker == null) {
            this.playHeadMarker = PlayHeadMarker.create();
        }
        if (layer instanceof GpxLayer) {
            this.addGpxLayer((GpxLayer)layer);
        } else if (this.layers.isEmpty()) {
            this.layers.add(layer);
        } else if (layer.isBackgroundLayer()) {
            int i;
            for (i = 0; i < this.layers.size() && !this.layers.get(i).isBackgroundLayer(); ++i) {
            }
            this.layers.add(i, layer);
        } else {
            this.layers.add(0, layer);
        }
        MapView.fireLayerAdded(layer);
        boolean isOsmDataLayer = layer instanceof OsmDataLayer;
        if (isOsmDataLayer) {
            ((OsmDataLayer)layer).addLayerStateChangeListener(this);
        }
        boolean bl = callSetActiveLayer = isOsmDataLayer || this.activeLayer == null;
        if (callSetActiveLayer) {
            this.setActiveLayer(layer);
        }
        layer.addPropertyChangeListener(this);
        Main.addProjectionChangeListener(layer);
        AudioPlayer.reset();
        if (!callSetActiveLayer) {
            this.repaint();
        }
    }

    @Override
    protected DataSet getCurrentDataSet() {
        if (this.editLayer != null) {
            return this.editLayer.data;
        }
        return null;
    }

    public boolean isActiveLayerDrawable() {
        return this.editLayer != null;
    }

    public boolean isActiveLayerVisible() {
        return this.isActiveLayerDrawable() && this.editLayer.isVisible();
    }

    protected Layer determineNextActiveLayer(List<Layer> layersList) {
        for (Layer layer : layersList) {
            if (!(layer instanceof OsmDataLayer)) continue;
            return layer;
        }
        if (!layersList.isEmpty()) {
            return layersList.get(0);
        }
        return null;
    }

    public void removeLayer(Layer layer) {
        ArrayList<Layer> layersList = new ArrayList<Layer>(this.layers);
        if (!layersList.remove(layer)) {
            return;
        }
        this.setEditLayer(layersList);
        if (layer == this.activeLayer) {
            this.setActiveLayer(this.determineNextActiveLayer(layersList), false);
        }
        if (layer instanceof OsmDataLayer) {
            ((OsmDataLayer)layer).removeLayerPropertyChangeListener(this);
        }
        this.layers.remove(layer);
        Main.removeProjectionChangeListener(layer);
        MapView.fireLayerRemoved(layer);
        layer.removePropertyChangeListener(this);
        layer.destroy();
        AudioPlayer.reset();
        this.repaint();
    }

    public void setVirtualNodesEnabled(boolean enabled) {
        if (this.virtualNodesEnabled != enabled) {
            this.virtualNodesEnabled = enabled;
            this.repaint();
        }
    }

    public boolean isVirtualNodesEnabled() {
        return this.virtualNodesEnabled;
    }

    public void moveLayer(Layer layer, int pos) {
        int curLayerPos = this.layers.indexOf(layer);
        if (curLayerPos == -1) {
            throw new IllegalArgumentException(I18n.tr("Layer not in list.", new Object[0]));
        }
        if (pos == curLayerPos) {
            return;
        }
        this.layers.remove(curLayerPos);
        if (pos >= this.layers.size()) {
            this.layers.add(layer);
        } else {
            this.layers.add(pos, layer);
        }
        this.setEditLayer(this.layers);
        AudioPlayer.reset();
        this.repaint();
    }

    public int getLayerPos(Layer layer) {
        int curLayerPos = this.layers.indexOf(layer);
        if (curLayerPos == -1) {
            throw new IllegalArgumentException(I18n.tr("Layer not in list.", new Object[0]));
        }
        return curLayerPos;
    }

    protected List<Layer> getVisibleLayersInZOrder() {
        ArrayList<Layer> ret = new ArrayList<Layer>();
        for (Layer l : this.layers) {
            if (!l.isVisible()) continue;
            ret.add(l);
        }
        Collections.sort(ret, new Comparator<Layer>(){

            @Override
            public int compare(Layer l1, Layer l2) {
                if (l1 instanceof OsmDataLayer && l2 instanceof OsmDataLayer) {
                    if (l1 == MapView.this.getActiveLayer()) {
                        return -1;
                    }
                    if (l2 == MapView.this.getActiveLayer()) {
                        return 1;
                    }
                    return Integer.valueOf(MapView.this.layers.indexOf(l1)).compareTo(MapView.this.layers.indexOf(l2));
                }
                return Integer.valueOf(MapView.this.layers.indexOf(l1)).compareTo(MapView.this.layers.indexOf(l2));
            }
        });
        Collections.reverse(ret);
        return ret;
    }

    private void paintLayer(Layer layer, Graphics2D g, Bounds box) {
        if (layer.getOpacity() < 1.0) {
            g.setComposite(AlphaComposite.getInstance(3, (float)layer.getOpacity()));
        }
        layer.paint(g, this, box);
        g.setPaintMode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public void paint(Graphics g) {
        double lat;
        int i;
        Graphics2D g2;
        boolean canUseBuffer;
        if (this.initialViewport != null) {
            this.zoomTo(this.initialViewport);
            this.initialViewport = null;
        }
        if (BugReportExceptionHandler.exceptionHandlingInProgress()) {
            return;
        }
        if (this.center == null) {
            return;
        }
        if (this.oldLoc != null && this.oldSize != null) {
            Point l1 = this.getLocationOnScreen();
            EastNorth newCenter = new EastNorth(this.center.getX() + ((double)(l1.x - this.oldLoc.x) - (double)(this.oldSize.width - this.getWidth()) / 2.0) * this.getScale(), this.center.getY() + ((double)(this.oldLoc.y - l1.y) + (double)(this.oldSize.height - this.getHeight()) / 2.0) * this.getScale());
            this.oldLoc = null;
            this.oldSize = null;
            this.zoomTo(newCenter);
        }
        List<Layer> visibleLayers = this.getVisibleLayersInZOrder();
        int nonChangedLayersCount = 0;
        for (Layer layer : visibleLayers) {
            if (layer.isChanged() || layer == this.changedLayer) break;
            ++nonChangedLayersCount;
        }
        MapView mapView = this;
        synchronized (mapView) {
            canUseBuffer = !this.paintPreferencesChanged;
            this.paintPreferencesChanged = false;
        }
        boolean bl = canUseBuffer = canUseBuffer && this.nonChangedLayers.size() <= nonChangedLayersCount && this.lastViewID == this.getViewID() && this.lastClipBounds.contains(g.getClipBounds());
        if (canUseBuffer) {
            void var5_10;
            boolean bl2 = false;
            while (var5_10 < this.nonChangedLayers.size()) {
                if (visibleLayers.get((int)var5_10) != this.nonChangedLayers.get((int)var5_10)) {
                    canUseBuffer = false;
                    break;
                }
                ++var5_10;
            }
        }
        if (null == this.offscreenBuffer || this.offscreenBuffer.getWidth() != this.getWidth() || this.offscreenBuffer.getHeight() != this.getHeight()) {
            this.offscreenBuffer = new BufferedImage(this.getWidth(), this.getHeight(), 5);
        }
        Graphics2D graphics2D = this.offscreenBuffer.createGraphics();
        graphics2D.setClip(g.getClip());
        Bounds box = this.getLatLonBounds(g.getClipBounds());
        if (!canUseBuffer || this.nonChangedLayersBuffer == null) {
            if (null == this.nonChangedLayersBuffer || this.nonChangedLayersBuffer.getWidth() != this.getWidth() || this.nonChangedLayersBuffer.getHeight() != this.getHeight()) {
                this.nonChangedLayersBuffer = new BufferedImage(this.getWidth(), this.getHeight(), 5);
            }
            g2 = this.nonChangedLayersBuffer.createGraphics();
            g2.setClip(g.getClip());
            g2.setColor(PaintColors.getBackgroundColor());
            g2.fillRect(0, 0, this.getWidth(), this.getHeight());
            for (int i2 = 0; i2 < nonChangedLayersCount; ++i2) {
                this.paintLayer(visibleLayers.get(i2), g2, box);
            }
        } else if (this.nonChangedLayers.size() != nonChangedLayersCount) {
            g2 = this.nonChangedLayersBuffer.createGraphics();
            g2.setClip(g.getClip());
            for (int i2 = this.nonChangedLayers.size(); i2 < nonChangedLayersCount; ++i2) {
                this.paintLayer(visibleLayers.get(i2), g2, box);
            }
        }
        this.nonChangedLayers.clear();
        this.changedLayer = null;
        for (i = 0; i < nonChangedLayersCount; ++i) {
            this.nonChangedLayers.add(visibleLayers.get(i));
        }
        this.lastViewID = this.getViewID();
        this.lastClipBounds = g.getClipBounds();
        graphics2D.drawImage((Image)this.nonChangedLayersBuffer, 0, 0, null);
        for (i = nonChangedLayersCount; i < visibleLayers.size(); ++i) {
            this.paintLayer(visibleLayers.get(i), graphics2D, box);
        }
        for (MapViewPaintable mvp : this.temporaryLayers) {
            mvp.paint(graphics2D, this, box);
        }
        graphics2D.setColor(Color.WHITE);
        Bounds b = this.getProjection().getWorldBoundsLatLon();
        double lon = b.getMinLon();
        Point p = this.getPoint(b.getMin());
        GeneralPath path = new GeneralPath();
        path.moveTo(p.x, p.y);
        double max = b.getMax().lat();
        for (lat = b.getMinLat(); lat <= max; lat += 1.0) {
            p = this.getPoint(new LatLon(lat >= max ? max : lat, lon));
            path.lineTo(p.x, p.y);
        }
        lat = max;
        max = b.getMax().lon();
        while (lon <= max) {
            p = this.getPoint(new LatLon(lat, lon >= max ? max : lon));
            path.lineTo(p.x, p.y);
            lon += 1.0;
        }
        lon = max;
        max = b.getMinLat();
        while (lat >= max) {
            p = this.getPoint(new LatLon(lat <= max ? max : lat, lon));
            path.lineTo(p.x, p.y);
            lat -= 1.0;
        }
        lat = max;
        max = b.getMinLon();
        while (lon >= max) {
            p = this.getPoint(new LatLon(lat, lon <= max ? max : lon));
            path.lineTo(p.x, p.y);
            lon -= 1.0;
        }
        int w = this.getWidth();
        int h = this.getHeight();
        Area border = new Area(path);
        Area viewport = new Area(new Rectangle(-1, -1, w + 2, h + 2));
        border.intersect(viewport);
        graphics2D.draw(border);
        if (Main.isDisplayingMapView() && Main.map.filterDialog != null) {
            Main.map.filterDialog.drawOSDText(graphics2D);
        }
        if (this.playHeadMarker != null) {
            this.playHeadMarker.paint(graphics2D, this);
        }
        g.drawImage(this.offscreenBuffer, 0, 0, null);
        super.paint(g);
    }

    @Deprecated
    public void recalculateCenterScale(BoundingXYVisitor box) {
        this.zoomTo(box);
    }

    public Collection<Layer> getAllLayers() {
        return Collections.unmodifiableCollection(new ArrayList<Layer>(this.layers));
    }

    public List<Layer> getAllLayersAsList() {
        return Collections.unmodifiableList(new ArrayList<Layer>(this.layers));
    }

    public <T extends Layer> List<T> getLayersOfType(Class<T> ofType) {
        return new ArrayList(Utils.filteredCollection(this.getAllLayers(), ofType));
    }

    public int getNumLayers() {
        return this.layers.size();
    }

    public boolean hasLayers() {
        return this.getNumLayers() > 0;
    }

    private void setEditLayer(List<Layer> layersList) {
        OsmDataLayer newEditLayer = layersList.contains(this.editLayer) ? this.editLayer : null;
        OsmDataLayer oldEditLayer = this.editLayer;
        if (this.activeLayer != this.editLayer || !layersList.contains(this.editLayer)) {
            if (this.activeLayer instanceof OsmDataLayer && layersList.contains(this.activeLayer)) {
                newEditLayer = (OsmDataLayer)this.activeLayer;
            } else {
                for (Layer layer : layersList) {
                    if (!(layer instanceof OsmDataLayer)) continue;
                    newEditLayer = (OsmDataLayer)layer;
                    break;
                }
            }
        }
        if (newEditLayer != this.editLayer) {
            if (newEditLayer == null) {
                this.getCurrentDataSet().setSelected(new PrimitiveId[0]);
            }
            this.editLayer = newEditLayer;
            MapView.fireEditLayerChanged(oldEditLayer, newEditLayer);
            this.refreshTitle();
        }
    }

    public void setActiveLayer(Layer layer) {
        this.setActiveLayer(layer, true);
    }

    private void setActiveLayer(Layer layer, boolean setEditLayer) {
        if (layer != null && !this.layers.contains(layer)) {
            throw new IllegalArgumentException(I18n.tr("Layer ''{0}'' must be in list of layers", layer.toString()));
        }
        if (layer == this.activeLayer) {
            return;
        }
        Layer old = this.activeLayer;
        this.activeLayer = layer;
        if (setEditLayer) {
            this.setEditLayer(this.layers);
        }
        MapView.fireActiveLayerChanged(old, layer);
        for (final AbstractButton abstractButton : Main.map.allMapModeButtons) {
            MapMode mode = (MapMode)abstractButton.getAction();
            if (mode.layerIsSupported(layer)) {
                Main.registerActionShortcut(mode, mode.getShortcut());
                GuiHelper.runInEDTAndWait(new Runnable(){

                    @Override
                    public void run() {
                        abstractButton.setEnabled(true);
                    }
                });
                continue;
            }
            Main.unregisterShortcut(mode.getShortcut());
            GuiHelper.runInEDTAndWait(new Runnable(){

                @Override
                public void run() {
                    abstractButton.setEnabled(false);
                }
            });
        }
        AudioPlayer.reset();
        this.repaint();
    }

    public Layer getActiveLayer() {
        return this.activeLayer;
    }

    public OsmDataLayer getEditLayer() {
        return this.editLayer;
    }

    public boolean hasLayer(Layer layer) {
        return this.layers.contains(layer);
    }

    public boolean addTemporaryLayer(MapViewPaintable mvp) {
        if (this.temporaryLayers.contains(mvp)) {
            return false;
        }
        return this.temporaryLayers.add(mvp);
    }

    public boolean removeTemporaryLayer(MapViewPaintable mvp) {
        return this.temporaryLayers.remove(mvp);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        OsmDataLayer layer;
        if (evt.getPropertyName().equals(Layer.VISIBLE_PROP)) {
            this.repaint();
        } else if (evt.getPropertyName().equals(Layer.OPACITY_PROP)) {
            Layer l = (Layer)evt.getSource();
            if (l.isVisible()) {
                this.changedLayer = l;
                this.repaint();
            }
        } else if ((evt.getPropertyName().equals(OsmDataLayer.REQUIRES_SAVE_TO_DISK_PROP) || evt.getPropertyName().equals(OsmDataLayer.REQUIRES_UPLOAD_TO_SERVER_PROP)) && (layer = (OsmDataLayer)evt.getSource()) == this.getEditLayer()) {
            this.refreshTitle();
        }
    }

    protected void refreshTitle() {
        if (Main.parent != null) {
            boolean dirty = this.editLayer != null && (this.editLayer.requiresSaveToFile() || this.editLayer.requiresUploadToServer() && !this.editLayer.isUploadDiscouraged());
            ((JFrame)Main.parent).setTitle((dirty ? "* " : "") + I18n.tr("Java OpenStreetMap Editor", new Object[0]));
            ((JFrame)Main.parent).getRootPane().putClientProperty("Window.documentModified", dirty);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void preferenceChanged(Preferences.PreferenceChangeEvent e) {
        MapView mapView = this;
        synchronized (mapView) {
            this.paintPreferencesChanged = true;
        }
    }

    public void destroy() {
        Main.pref.removePreferenceChangeListener(this);
        DataSet.removeSelectionListener(this.repaintSelectionChangedListener);
        MultipolygonCache.getInstance().clear(this);
        if (this.mapMover != null) {
            this.mapMover.destroy();
        }
        this.activeLayer = null;
        this.changedLayer = null;
        this.editLayer = null;
        this.layers.clear();
        this.nonChangedLayers.clear();
        this.temporaryLayers.clear();
    }

    @Override
    public void uploadDiscouragedChanged(OsmDataLayer layer, boolean newValue) {
        if (layer == this.getEditLayer()) {
            this.refreshTitle();
        }
    }

    public String getLayerInformationForSourceTag() {
        ArrayList<String> layerInfo = new ArrayList<String>();
        if (!this.getLayersOfType(GpxLayer.class).isEmpty()) {
            layerInfo.add("survey");
        }
        for (GeoImageLayer geoImageLayer : this.getLayersOfType(GeoImageLayer.class)) {
            layerInfo.add(geoImageLayer.getName());
        }
        for (ImageryLayer imageryLayer : this.getLayersOfType(ImageryLayer.class)) {
            layerInfo.add(ImageryInfo.ImageryType.BING.equals((Object)imageryLayer.getInfo().getImageryType()) ? "Bing" : imageryLayer.getName());
        }
        return Utils.join("; ", layerInfo);
    }

    public static interface EditLayerChangeListener {
        public void editLayerChanged(OsmDataLayer var1, OsmDataLayer var2);
    }

    public static interface LayerChangeListener {
        public void activeLayerChange(Layer var1, Layer var2);

        public void layerAdded(Layer var1);

        public void layerRemoved(Layer var1);
    }
}

