/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui;

import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.InputEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.lang.reflect.InvocationTargetException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.List;
import java.util.TreeSet;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.UIManager;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.Preferences;
import org.openstreetmap.josm.data.SystemOfMeasurement;
import org.openstreetmap.josm.data.coor.CoordinateFormat;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.preferences.ColorProperty;
import org.openstreetmap.josm.gui.DefaultNameFormatter;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.NavigatableComponent;
import org.openstreetmap.josm.gui.Notification;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.help.Helpful;
import org.openstreetmap.josm.gui.preferences.projection.ProjectionPreference;
import org.openstreetmap.josm.gui.progress.PleaseWaitProgressMonitor;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.gui.widgets.ImageLabel;
import org.openstreetmap.josm.gui.widgets.JosmTextField;
import org.openstreetmap.josm.tools.Destroyable;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class MapStatus
extends JPanel
implements Preferences.PreferenceChangedListener,
Helpful,
Destroyable {
    private static final DecimalFormat ONE_DECIMAL_PLACE = new DecimalFormat("0.0");
    public static final ColorProperty PROP_BACKGROUND_COLOR = new ColorProperty(I18n.marktr("Status bar background"), Color.decode("#b8cfe5"));
    public static final ColorProperty PROP_ACTIVE_BACKGROUND_COLOR = new ColorProperty(I18n.marktr("Status bar background: active"), Color.decode("#aaff5e"));
    public static final ColorProperty PROP_FOREGROUND_COLOR = new ColorProperty(I18n.marktr("Status bar foreground"), Color.black);
    public static final ColorProperty PROP_ACTIVE_FOREGROUND_COLOR = new ColorProperty(I18n.marktr("Status bar foreground: active"), Color.black);
    private final MapView mv;
    private final Collector collector;
    final ImageLabel latText = new ImageLabel("lat", I18n.tr("The geographic latitude at the mouse pointer.", new Object[0]), 11, PROP_BACKGROUND_COLOR.get());
    final ImageLabel lonText = new ImageLabel("lon", I18n.tr("The geographic longitude at the mouse pointer.", new Object[0]), 11, PROP_BACKGROUND_COLOR.get());
    final ImageLabel headingText = new ImageLabel("heading", I18n.tr("The (compass) heading of the line segment being drawn.", new Object[0]), 6, PROP_BACKGROUND_COLOR.get());
    final ImageLabel angleText = new ImageLabel("angle", I18n.tr("The angle between the previous and the current way segment.", new Object[0]), 6, PROP_BACKGROUND_COLOR.get());
    final ImageLabel distText = new ImageLabel("dist", I18n.tr("The length of the new way segment being drawn.", new Object[0]), 10, PROP_BACKGROUND_COLOR.get());
    final ImageLabel nameText = new ImageLabel("name", I18n.tr("The name of the object at the mouse pointer.", new Object[0]), 20, PROP_BACKGROUND_COLOR.get());
    final JosmTextField helpText = new JosmTextField();
    final JProgressBar progressBar = new JProgressBar();
    public final BackgroundProgressMonitor progressMonitor = new BackgroundProgressMonitor();
    private final NavigatableComponent.SoMChangeListener somListener;
    private double distValue;
    private boolean angleEnabled = false;
    private Thread thread;
    private final List<StatusTextHistory> statusText = new ArrayList<StatusTextHistory>();
    MouseState mouseState = new MouseState();
    private AWTEventListener awtListener = new AWTEventListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void eventDispatched(AWTEvent event) {
            if (event instanceof InputEvent && ((InputEvent)event).getComponent() == MapStatus.this.mv) {
                Collector collector = MapStatus.this.collector;
                synchronized (collector) {
                    MapStatus.this.mouseState.modifiers = ((InputEvent)event).getModifiersEx();
                    if (event instanceof MouseEvent) {
                        MapStatus.this.mouseState.mousePos = ((MouseEvent)event).getPoint();
                    }
                    MapStatus.this.collector.notifyAll();
                }
            }
        }
    };
    private MouseMotionListener mouseMotionListener = new MouseMotionListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void mouseMoved(MouseEvent e) {
            Collector collector = MapStatus.this.collector;
            synchronized (collector) {
                MapStatus.this.mouseState.modifiers = e.getModifiersEx();
                MapStatus.this.mouseState.mousePos = e.getPoint();
                MapStatus.this.collector.notifyAll();
            }
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            this.mouseMoved(e);
        }
    };
    private KeyAdapter keyAdapter = new KeyAdapter(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void keyPressed(KeyEvent e) {
            Collector collector = MapStatus.this.collector;
            synchronized (collector) {
                MapStatus.this.mouseState.modifiers = e.getModifiersEx();
                MapStatus.this.collector.notifyAll();
            }
        }

        @Override
        public void keyReleased(KeyEvent e) {
            this.keyPressed(e);
        }
    };

    private void registerListeners() {
        try {
            Toolkit.getDefaultToolkit().addAWTEventListener(this.awtListener, 56L);
        }
        catch (SecurityException ex) {
            this.mv.addMouseMotionListener(this.mouseMotionListener);
            this.mv.addKeyListener(this.keyAdapter);
        }
    }

    private void unregisterListeners() {
        try {
            Toolkit.getDefaultToolkit().removeAWTEventListener(this.awtListener);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        this.mv.removeMouseMotionListener(this.mouseMotionListener);
        this.mv.removeKeyListener(this.keyAdapter);
    }

    public MapStatus(MapFrame mapFrame) {
        this.mv = mapFrame.mapView;
        this.collector = new Collector(mapFrame);
        this.setComponentPopupMenu(new MapStatusPopupMenu());
        MouseAdapter jumpToOnLeftClick = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getButton() != 3) {
                    Main.main.menu.jumpToAct.showJumpToDialog();
                }
            }
        };
        this.mv.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseDragged(MouseEvent e) {
                this.mouseMoved(e);
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                if (((MapStatus)MapStatus.this).mv.center == null) {
                    return;
                }
                if ((e.getModifiersEx() & 0x80) == 0) {
                    CoordinateFormat mCord = CoordinateFormat.getDefaultFormat();
                    LatLon p = MapStatus.this.mv.getLatLon(e.getX(), e.getY());
                    MapStatus.this.latText.setText(p.latToString(mCord));
                    MapStatus.this.lonText.setText(p.lonToString(mCord));
                }
            }
        });
        this.setLayout(new GridBagLayout());
        this.setBorder(BorderFactory.createEmptyBorder(1, 2, 1, 2));
        this.latText.setInheritsPopupMenu(true);
        this.lonText.setInheritsPopupMenu(true);
        this.headingText.setInheritsPopupMenu(true);
        this.distText.setInheritsPopupMenu(true);
        this.nameText.setInheritsPopupMenu(true);
        this.add((Component)this.latText, GBC.std());
        this.add((Component)this.lonText, GBC.std().insets(3, 0, 0, 0));
        this.add((Component)this.headingText, GBC.std().insets(3, 0, 0, 0));
        this.add((Component)this.angleText, GBC.std().insets(3, 0, 0, 0));
        this.add((Component)this.distText, GBC.std().insets(3, 0, 0, 0));
        if (Main.pref.getBoolean("statusbar.change-system-of-measurement-on-click", true)) {
            this.distText.addMouseListener(new MouseAdapter(){
                private final List<String> soms = new ArrayList<String>(new TreeSet<String>(SystemOfMeasurement.ALL_SYSTEMS.keySet()));

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (!e.isPopupTrigger() && e.getButton() == 1) {
                        String som = ProjectionPreference.PROP_SYSTEM_OF_MEASUREMENT.get();
                        String newsom = this.soms.get((this.soms.indexOf(som) + 1) % this.soms.size());
                        MapStatus.this.updateSystemOfMeasurement(newsom);
                    }
                }
            });
        }
        this.somListener = new NavigatableComponent.SoMChangeListener(){

            @Override
            public void systemOfMeasurementChanged(String oldSoM, String newSoM) {
                MapStatus.this.setDist(MapStatus.this.distValue);
            }
        };
        NavigatableComponent.addSoMChangeListener(this.somListener);
        this.latText.addMouseListener(jumpToOnLeftClick);
        this.lonText.addMouseListener(jumpToOnLeftClick);
        this.helpText.setEditable(false);
        this.add((Component)this.nameText, GBC.std().insets(3, 0, 0, 0));
        this.add((Component)this.helpText, GBC.std().insets(3, 0, 0, 0).fill(2));
        this.progressBar.setMaximum(10000);
        this.progressBar.setVisible(false);
        GBC gbc = GBC.eol();
        gbc.ipadx = 100;
        this.add((Component)this.progressBar, gbc);
        this.progressBar.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                PleaseWaitProgressMonitor monitor = Main.currentProgressMonitor;
                if (monitor != null) {
                    monitor.showForegroundDialog();
                }
            }
        });
        Main.pref.addPreferenceChangeListener(this);
        this.thread = new Thread((Runnable)this.collector, "Map Status Collector");
        this.thread.setDaemon(true);
        this.thread.start();
    }

    public void updateSystemOfMeasurement(String newsom) {
        NavigatableComponent.setSystemOfMeasurement(newsom);
        if (Main.pref.getBoolean("statusbar.notify.change-system-of-measurement", true)) {
            new Notification(I18n.tr("System of measurement changed to {0}", newsom)).setDuration(Notification.TIME_SHORT).show();
        }
    }

    public JPanel getAnglePanel() {
        return this.angleText;
    }

    @Override
    public String helpTopic() {
        return HelpUtil.ht("/StatusBar");
    }

    @Override
    public synchronized void addMouseListener(MouseListener ml) {
        this.lonText.addMouseListener(ml);
        this.latText.addMouseListener(ml);
    }

    public void setHelpText(String t) {
        this.setHelpText(null, t);
    }

    public void setHelpText(Object id, final String text) {
        StatusTextHistory entry = new StatusTextHistory(id, text);
        this.statusText.remove(entry);
        this.statusText.add(entry);
        GuiHelper.runInEDT(new Runnable(){

            @Override
            public void run() {
                MapStatus.this.helpText.setText(text);
                MapStatus.this.helpText.setToolTipText(text);
            }
        });
    }

    public void resetHelpText(Object id) {
        if (this.statusText.isEmpty()) {
            return;
        }
        StatusTextHistory entry = new StatusTextHistory(id, null);
        if (this.statusText.get(this.statusText.size() - 1).equals(entry)) {
            if (this.statusText.size() == 1) {
                this.setHelpText("");
            } else {
                StatusTextHistory history = this.statusText.get(this.statusText.size() - 2);
                this.setHelpText(history.id, history.text);
            }
        }
        this.statusText.remove(entry);
    }

    public void setAngle(double a) {
        this.angleText.setText(a < 0.0 ? "--" : ONE_DECIMAL_PLACE.format(a) + " \u00b0");
    }

    public void setHeading(double h) {
        this.headingText.setText(h < 0.0 ? "--" : ONE_DECIMAL_PLACE.format(h) + " \u00b0");
    }

    public void setDist(double dist) {
        this.distValue = dist;
        this.distText.setText(dist < 0.0 ? "--" : NavigatableComponent.getDistText(dist, ONE_DECIMAL_PLACE, 0.01));
    }

    public void setDist(Collection<Way> ways) {
        double dist = -1.0;
        int maxWays = Math.max(1, Main.pref.getInteger("selection.max-ways-for-statusline", 250));
        if (!ways.isEmpty() && ways.size() <= maxWays) {
            dist = 0.0;
            for (Way w : ways) {
                dist += w.getLength();
            }
        }
        this.setDist(dist);
    }

    public void activateAnglePanel(boolean activeFlag) {
        this.angleEnabled = activeFlag;
        this.refreshAnglePanel();
    }

    private void refreshAnglePanel() {
        this.angleText.setBackground(this.angleEnabled ? PROP_ACTIVE_BACKGROUND_COLOR.get() : PROP_BACKGROUND_COLOR.get());
        this.angleText.setForeground(this.angleEnabled ? PROP_ACTIVE_FOREGROUND_COLOR.get() : PROP_FOREGROUND_COLOR.get());
    }

    @Override
    public void destroy() {
        NavigatableComponent.removeSoMChangeListener(this.somListener);
        Main.pref.removePreferenceChangeListener(this);
        if (this.thread != null) {
            try {
                this.thread.interrupt();
            }
            catch (Exception e) {
                Main.error(e);
            }
        }
    }

    @Override
    public void preferenceChanged(Preferences.PreferenceChangeEvent e) {
        String key = e.getKey();
        if (key.startsWith("color.")) {
            key = key.substring("color.".length());
            if (PROP_BACKGROUND_COLOR.getKey().equals(key) || PROP_FOREGROUND_COLOR.getKey().equals(key)) {
                for (ImageLabel il : new ImageLabel[]{this.latText, this.lonText, this.headingText, this.distText, this.nameText}) {
                    il.setBackground(PROP_BACKGROUND_COLOR.get());
                    il.setForeground(PROP_FOREGROUND_COLOR.get());
                }
                this.refreshAnglePanel();
            } else if (PROP_ACTIVE_BACKGROUND_COLOR.getKey().equals(key) || PROP_ACTIVE_FOREGROUND_COLOR.getKey().equals(key)) {
                this.refreshAnglePanel();
            }
        }
    }

    public static void getColors() {
        PROP_BACKGROUND_COLOR.get();
        PROP_FOREGROUND_COLOR.get();
        PROP_ACTIVE_BACKGROUND_COLOR.get();
        PROP_ACTIVE_FOREGROUND_COLOR.get();
    }

    private class MapStatusPopupMenu
    extends JPopupMenu {
        private final JMenuItem jumpButton;
        private final Collection<JCheckBoxMenuItem> somItems;
        private final JSeparator separator;
        private final JMenuItem doNotHide;

        public MapStatusPopupMenu() {
            this.jumpButton = this.add(Main.main.menu.jumpToAct);
            this.somItems = new ArrayList<JCheckBoxMenuItem>();
            this.separator = new JSeparator();
            this.doNotHide = new JCheckBoxMenuItem(new AbstractAction(I18n.tr("Do not hide status bar", new Object[0])){

                @Override
                public void actionPerformed(ActionEvent e) {
                    boolean sel = ((JCheckBoxMenuItem)e.getSource()).getState();
                    Main.pref.put("statusbar.always-visible", sel);
                }
            });
            for (final String key : new TreeSet<String>(SystemOfMeasurement.ALL_SYSTEMS.keySet())) {
                JCheckBoxMenuItem item = new JCheckBoxMenuItem(new AbstractAction(key){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        MapStatus.this.updateSystemOfMeasurement(key);
                    }
                });
                this.somItems.add(item);
                this.add(item);
            }
            this.add(this.separator);
            this.add(this.doNotHide);
            this.addPopupMenuListener(new PopupMenuListener(){

                @Override
                public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                    Component invoker = ((JPopupMenu)e.getSource()).getInvoker();
                    MapStatusPopupMenu.this.jumpButton.setVisible(MapStatus.this.latText.equals(invoker) || MapStatus.this.lonText.equals(invoker));
                    String currentSOM = ProjectionPreference.PROP_SYSTEM_OF_MEASUREMENT.get();
                    for (JMenuItem item : MapStatusPopupMenu.this.somItems) {
                        item.setSelected(item.getText().equals(currentSOM));
                        item.setVisible(MapStatus.this.distText.equals(invoker));
                    }
                    MapStatusPopupMenu.this.separator.setVisible(MapStatus.this.distText.equals(invoker));
                    MapStatusPopupMenu.this.doNotHide.setSelected(Main.pref.getBoolean("statusbar.always-visible", true));
                }

                @Override
                public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                }

                @Override
                public void popupMenuCanceled(PopupMenuEvent e) {
                }
            });
        }
    }

    static class MouseState {
        Point mousePos;
        int modifiers;

        MouseState() {
        }
    }

    private final class Collector
    implements Runnable {
        private Point oldMousePos;
        private List<JLabel> popupLabels = null;
        private Popup popup;
        private MapFrame parent;

        public Collector(MapFrame parent) {
            this.parent = parent;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            MapStatus.this.registerListeners();
            try {
                while (true) {
                    final MouseState ms = new MouseState();
                    Collector collector = this;
                    synchronized (collector) {
                        try {
                            this.wait(1000L);
                        }
                        catch (InterruptedException e) {
                            Main.trace("InterruptedException in " + MapStatus.class.getSimpleName());
                        }
                        ms.modifiers = MapStatus.this.mouseState.modifiers;
                        ms.mousePos = MapStatus.this.mouseState.mousePos;
                    }
                    if (this.parent != Main.map) {
                        return;
                    }
                    if (ms.mousePos == null || ((MapStatus)MapStatus.this).mv.center == null) continue;
                    try {
                        EventQueue.invokeAndWait(new Runnable(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void run() {
                                if ((ms.modifiers & 0x80) != 0) {
                                    Collector.this.popupUpdateLabels();
                                    return;
                                }
                                DataSet ds = null;
                                boolean mouseNotMoved = Collector.this.oldMousePos != null && Collector.this.oldMousePos.equals(ms.mousePos);
                                boolean isAtOldPosition = mouseNotMoved && Collector.this.popup != null;
                                boolean middleMouseDown = (ms.modifiers & 0x800) != 0;
                                try {
                                    ds = MapStatus.this.mv.getCurrentDataSet();
                                    if (ds != null) {
                                        if (isAtOldPosition && middleMouseDown) {
                                            ds.beginUpdate();
                                        } else {
                                            ds.getReadLock().lock();
                                        }
                                    }
                                    if (!mouseNotMoved) {
                                        Collector.this.statusBarElementUpdate(ms);
                                    }
                                    if (middleMouseDown || isAtOldPosition) {
                                        List<OsmPrimitive> osms = MapStatus.this.mv.getAllNearest(ms.mousePos, OsmPrimitive.isUsablePredicate);
                                        JPanel c = new JPanel(new GridBagLayout());
                                        JLabel lbl = new JLabel("<html>" + I18n.tr("Middle click again to cycle through.<br>Hold CTRL to select directly from this list with the mouse.<hr>", new Object[0]) + "</html>", null, 0);
                                        lbl.setHorizontalAlignment(2);
                                        c.add((Component)lbl, GBC.eol().insets(2, 0, 2, 0));
                                        if (isAtOldPosition && middleMouseDown) {
                                            Collector.this.popupCycleSelection(osms, ms.modifiers);
                                        }
                                        ArrayList<JLabel> lbls = new ArrayList<JLabel>(osms.size());
                                        for (OsmPrimitive osm : osms) {
                                            JLabel l = Collector.this.popupBuildPrimitiveLabels(osm);
                                            lbls.add(l);
                                            c.add((Component)l, GBC.eol().fill(2).insets(2, 0, 2, 2));
                                        }
                                        Collector.this.popupShowPopup(Collector.this.popupCreatePopup(c, ms), lbls);
                                    } else {
                                        Collector.this.popupHidePopup();
                                    }
                                    Collector.this.oldMousePos = ms.mousePos;
                                }
                                catch (ConcurrentModificationException x) {
                                    Main.warn(x);
                                }
                                finally {
                                    if (ds != null) {
                                        if (isAtOldPosition && middleMouseDown) {
                                            ds.endUpdate();
                                        } else {
                                            ds.getReadLock().unlock();
                                        }
                                    }
                                }
                            }
                        });
                    }
                    catch (InterruptedException e) {
                        Main.trace("InterruptedException in " + MapStatus.class.getSimpleName());
                    }
                    catch (InvocationTargetException e) {
                        Main.warn(e);
                    }
                }
            }
            finally {
                MapStatus.this.unregisterListeners();
            }
        }

        private Popup popupCreatePopup(Component content, MouseState ms) {
            int yPos;
            Point p = MapStatus.this.mv.getLocationOnScreen();
            Dimension scrn = Toolkit.getDefaultToolkit().getScreenSize();
            JScrollPane sp = GuiHelper.embedInVerticalScrollPane(content);
            sp.setBorder(BorderFactory.createRaisedBevelBorder());
            Dimension prefsize = sp.getPreferredSize();
            int w = Math.min(prefsize.width, Math.min(800, scrn.width / 2 - 16));
            int h = Math.min(prefsize.height, scrn.height - 10);
            sp.setPreferredSize(new Dimension(w, h));
            int xPos = p.x + ms.mousePos.x + 16;
            if (xPos + w > scrn.width && xPos > scrn.width / 2) {
                xPos = p.x + ms.mousePos.x - 4 - w;
            }
            if ((yPos = p.y + ms.mousePos.y + 16) + h > scrn.height - 5) {
                yPos = Math.max(5, scrn.height - h - 5);
            }
            PopupFactory pf = PopupFactory.getSharedInstance();
            return pf.getPopup(MapStatus.this.mv, sp, xPos, yPos);
        }

        private void statusBarElementUpdate(MouseState ms) {
            OsmPrimitive osmNearest = MapStatus.this.mv.getNearestNodeOrWay(ms.mousePos, OsmPrimitive.isUsablePredicate, false);
            if (osmNearest != null) {
                MapStatus.this.nameText.setText(osmNearest.getDisplayName(DefaultNameFormatter.getInstance()));
            } else {
                MapStatus.this.nameText.setText(I18n.tr("(no object)", new Object[0]));
            }
        }

        private void popupCycleSelection(Collection<OsmPrimitive> osms, int mods) {
            DataSet ds = Main.main.getCurrentDataSet();
            OsmPrimitive firstItem = null;
            OsmPrimitive firstSelected = null;
            OsmPrimitive nextSelected = null;
            for (OsmPrimitive osm : osms) {
                if (firstItem == null) {
                    firstItem = osm;
                }
                if (firstSelected != null && nextSelected == null) {
                    nextSelected = osm;
                }
                if (firstSelected != null || !ds.isSelected(osm)) continue;
                firstSelected = osm;
            }
            if ((mods & 0x40) == 0) {
                ds.clearSelection();
            }
            if (firstSelected != null) {
                ds.clearSelection(firstSelected);
                if (nextSelected != null) {
                    ds.addSelected(nextSelected);
                }
            } else if (firstItem != null) {
                ds.addSelected(firstItem);
            }
        }

        private void popupHidePopup() {
            this.popupLabels = null;
            if (this.popup == null) {
                return;
            }
            final Popup staticPopup = this.popup;
            this.popup = null;
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    staticPopup.hide();
                }
            });
        }

        private void popupShowPopup(Popup newPopup, List<JLabel> lbls) {
            final Popup staticPopup = newPopup;
            if (this.popup != null) {
                final Popup staticOldPopup = this.popup;
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        staticPopup.show();
                        staticOldPopup.hide();
                    }
                });
            } else {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        staticPopup.show();
                    }
                });
            }
            this.popupLabels = lbls;
            this.popup = newPopup;
        }

        private void popupUpdateLabels() {
            if (this.popup == null || this.popupLabels == null) {
                return;
            }
            for (JLabel l : this.popupLabels) {
                l.validate();
            }
        }

        private void popupSetLabelColors(JLabel lbl, OsmPrimitive osm) {
            DataSet ds = Main.main.getCurrentDataSet();
            if (ds.isSelected(osm)) {
                lbl.setBackground(SystemColor.textHighlight);
                lbl.setForeground(SystemColor.textHighlightText);
            } else {
                lbl.setBackground(SystemColor.control);
                lbl.setForeground(SystemColor.controlText);
            }
        }

        private JLabel popupBuildPrimitiveLabels(final OsmPrimitive osm) {
            StringBuilder text = new StringBuilder();
            String name = osm.getDisplayName(DefaultNameFormatter.getInstance());
            if (osm.isNewOrUndeleted() || osm.isModified()) {
                name = "<i><b>" + name + "*</b></i>";
            }
            text.append(name);
            boolean idShown = Main.pref.getBoolean("osm-primitives.showid");
            if (!osm.isNew() && !idShown) {
                text.append(" [id=" + osm.getId() + "]");
            }
            if (osm.getUser() != null) {
                text.append(" [" + I18n.tr("User:", new Object[0]) + " " + osm.getUser().getName() + "]");
            }
            for (String key : osm.keySet()) {
                text.append("<br>" + key + "=" + osm.get(key));
            }
            final JLabel l = new JLabel("<html>" + text.toString() + "</html>", ImageProvider.get(osm.getDisplayType()), 0){

                @Override
                public void validate() {
                    super.validate();
                    Collector.this.popupSetLabelColors(this, osm);
                }
            };
            l.setOpaque(true);
            this.popupSetLabelColors(l, osm);
            l.setFont(l.getFont().deriveFont(0));
            l.setVerticalTextPosition(1);
            l.setHorizontalAlignment(2);
            l.setCursor(Cursor.getPredefinedCursor(12));
            l.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseEntered(MouseEvent e) {
                    l.setBackground(SystemColor.info);
                    l.setForeground(SystemColor.infoText);
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    Collector.this.popupSetLabelColors(l, osm);
                }

                @Override
                public void mouseClicked(MouseEvent e) {
                    DataSet ds = Main.main.getCurrentDataSet();
                    ds.toggleSelected(osm);
                    l.validate();
                }
            });
            l.addMouseMotionListener(new MouseMotionListener(){

                @Override
                public void mouseMoved(MouseEvent e) {
                    l.setBackground(SystemColor.info);
                    l.setForeground(SystemColor.infoText);
                }

                @Override
                public void mouseDragged(MouseEvent e) {
                    l.setBackground(SystemColor.info);
                    l.setForeground(SystemColor.infoText);
                }
            });
            return l;
        }
    }

    private static class StatusTextHistory {
        final Object id;
        final String text;

        public StatusTextHistory(Object id, String text) {
            this.id = id;
            this.text = text;
        }

        public boolean equals(Object obj) {
            return obj instanceof StatusTextHistory && ((StatusTextHistory)obj).id == this.id;
        }

        public int hashCode() {
            return System.identityHashCode(this.id);
        }
    }

    public class BackgroundProgressMonitor
    implements PleaseWaitProgressMonitor.ProgressMonitorDialog {
        private String title;
        private String customText;

        private void updateText() {
            if (this.customText != null && !this.customText.isEmpty()) {
                MapStatus.this.progressBar.setToolTipText(I18n.tr("{0} ({1})", this.title, this.customText));
            } else {
                MapStatus.this.progressBar.setToolTipText(this.title);
            }
        }

        @Override
        public void setVisible(boolean visible) {
            MapStatus.this.progressBar.setVisible(visible);
        }

        @Override
        public void updateProgress(int progress) {
            MapStatus.this.progressBar.setValue(progress);
            MapStatus.this.progressBar.repaint();
            MapStatus.this.doLayout();
        }

        @Override
        public void setCustomText(String text) {
            this.customText = text;
            this.updateText();
        }

        @Override
        public void setCurrentAction(String text) {
            this.title = text;
            this.updateText();
        }

        @Override
        public void setIndeterminate(boolean newValue) {
            UIManager.put("ProgressBar.cycleTime", UIManager.getInt("ProgressBar.repaintInterval") * 100);
            MapStatus.this.progressBar.setIndeterminate(newValue);
        }

        @Override
        public void appendLogMessage(String message) {
            if (message != null && !message.isEmpty()) {
                Main.info("appendLogMessage not implemented for background tasks. Message was: " + message);
            }
        }
    }
}

