/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openstreetmap.josm.data.ProjectionBounds;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.help.Helpful;

class MapSlider
extends JSlider
implements PropertyChangeListener,
ChangeListener,
Helpful {
    private final MapView mv;
    boolean preventChange = false;

    public MapSlider(MapView mv) {
        super(35, 150);
        this.setOpaque(false);
        this.mv = mv;
        mv.addPropertyChangeListener("scale", this);
        this.addChangeListener(this);
        this.propertyChange(null);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        int zoom;
        if (this.getModel().getValueIsAdjusting()) {
            return;
        }
        ProjectionBounds world = this.mv.getMaxProjectionBounds();
        ProjectionBounds current = this.mv.getProjectionBounds();
        double cur_e = current.maxEast - current.minEast;
        double cur_n = current.maxNorth - current.minNorth;
        double e = world.maxEast - world.minEast;
        double n = world.maxNorth - world.minNorth;
        for (zoom = 0; zoom <= 150; ++zoom) {
            if ((e /= 1.1) < cur_e && (n /= 1.1) < cur_n) break;
        }
        this.preventChange = true;
        this.setValue(zoom);
        this.preventChange = false;
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (this.preventChange) {
            return;
        }
        ProjectionBounds world = this.mv.getMaxProjectionBounds();
        double fact = Math.pow(1.1, this.getValue());
        double es = world.maxEast - world.minEast;
        double n = world.maxNorth - world.minNorth;
        this.mv.zoomTo(new ProjectionBounds(this.mv.getCenter(), es / fact, n / fact));
    }

    @Override
    public String helpTopic() {
        return HelpUtil.ht("/MapView/Slider");
    }
}

