/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui;

import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.mapmode.SelectAction;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.gui.NavigatableComponent;
import org.openstreetmap.josm.tools.Destroyable;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

public class MapMover
extends MouseAdapter
implements MouseMotionListener,
MouseWheelListener,
Destroyable {
    private EastNorth mousePosMove;
    private final NavigatableComponent nc;
    private final JPanel contentPane;
    private boolean movementInPlace = false;

    public MapMover(NavigatableComponent navComp, JPanel contentPane) {
        this.nc = navComp;
        this.contentPane = contentPane;
        this.nc.addMouseListener(this);
        this.nc.addMouseMotionListener(this);
        this.nc.addMouseWheelListener(this);
        if (contentPane != null) {
            contentPane.getInputMap(2).put(Shortcut.registerShortcut("system:movefocusright", I18n.tr("Map: {0}", I18n.tr("Move right", new Object[0])), 39, 5006).getKeyStroke(), "MapMover.Zoomer.right");
            contentPane.getActionMap().put("MapMover.Zoomer.right", new ZoomerAction("right"));
            contentPane.getInputMap(2).put(Shortcut.registerShortcut("system:movefocusleft", I18n.tr("Map: {0}", I18n.tr("Move left", new Object[0])), 37, 5006).getKeyStroke(), "MapMover.Zoomer.left");
            contentPane.getActionMap().put("MapMover.Zoomer.left", new ZoomerAction("left"));
            contentPane.getInputMap(2).put(Shortcut.registerShortcut("system:movefocusup", I18n.tr("Map: {0}", I18n.tr("Move up", new Object[0])), 38, 5006).getKeyStroke(), "MapMover.Zoomer.up");
            contentPane.getActionMap().put("MapMover.Zoomer.up", new ZoomerAction("up"));
            contentPane.getInputMap(2).put(Shortcut.registerShortcut("system:movefocusdown", I18n.tr("Map: {0}", I18n.tr("Move down", new Object[0])), 40, 5006).getKeyStroke(), "MapMover.Zoomer.down");
            contentPane.getActionMap().put("MapMover.Zoomer.down", new ZoomerAction("down"));
            if (!Main.isPlatformOsx()) {
                contentPane.getInputMap(2).put(Shortcut.registerShortcut("view:zoominalternate", I18n.tr("Map: {0}", I18n.tr("Zoom in", new Object[0])), 44, 5006).getKeyStroke(), "MapMover.Zoomer.in");
                contentPane.getActionMap().put("MapMover.Zoomer.in", new ZoomerAction(","));
                contentPane.getInputMap(2).put(Shortcut.registerShortcut("view:zoomoutalternate", I18n.tr("Map: {0}", I18n.tr("Zoom out", new Object[0])), 46, 5006).getKeyStroke(), "MapMover.Zoomer.out");
                contentPane.getActionMap().put("MapMover.Zoomer.out", new ZoomerAction("."));
            }
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        boolean allowedMode;
        int offMask = 3072;
        int macMouseMask = 1152;
        boolean stdMovement = (e.getModifiersEx() & (0x1000 | offMask)) == 4096;
        boolean macMovement = Main.isPlatformOsx() && e.getModifiersEx() == macMouseMask;
        boolean bl = allowedMode = !Main.map.mapModeSelect.equals(Main.map.mapMode) || SelectAction.Mode.SELECT.equals((Object)Main.map.mapModeSelect.getMode());
        if (stdMovement || macMovement && allowedMode) {
            if (this.mousePosMove == null) {
                this.startMovement(e);
            }
            EastNorth center = this.nc.getCenter();
            EastNorth mouseCenter = this.nc.getEastNorth(e.getX(), e.getY());
            this.nc.zoomTo(new EastNorth(this.mousePosMove.east() + center.east() - mouseCenter.east(), this.mousePosMove.north() + center.north() - mouseCenter.north()));
        } else {
            this.endMovement();
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        int offMask = 3072;
        int macMouseMask = 1152;
        if (e.getButton() == 3 && (e.getModifiersEx() & offMask) == 0 || Main.isPlatformOsx() && e.getModifiersEx() == macMouseMask) {
            this.startMovement(e);
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (e.getButton() == 3 || Main.isPlatformOsx() && e.getButton() == 1) {
            this.endMovement();
        }
    }

    private void startMovement(MouseEvent e) {
        if (this.movementInPlace) {
            return;
        }
        this.movementInPlace = true;
        this.mousePosMove = this.nc.getEastNorth(e.getX(), e.getY());
        this.nc.setNewCursor(13, (Object)this);
    }

    private void endMovement() {
        if (!this.movementInPlace) {
            return;
        }
        this.movementInPlace = false;
        this.nc.resetCursor(this);
        this.mousePosMove = null;
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        this.nc.zoomToFactor(e.getX(), e.getY(), Math.pow(Math.sqrt(2.0), e.getWheelRotation()));
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        if (!this.movementInPlace) {
            return;
        }
        if (Main.isPlatformOsx()) {
            if (e.getModifiersEx() == 128) {
                if (this.mousePosMove == null) {
                    this.startMovement(e);
                }
                EastNorth center = this.nc.getCenter();
                EastNorth mouseCenter = this.nc.getEastNorth(e.getX(), e.getY());
                this.nc.zoomTo(new EastNorth(this.mousePosMove.east() + center.east() - mouseCenter.east(), this.mousePosMove.north() + center.north() - mouseCenter.north()));
            } else {
                this.endMovement();
            }
        }
    }

    @Override
    public void destroy() {
        if (this.contentPane != null) {
            ActionMap actionMap;
            Object[] actionsKeys;
            InputMap inputMap = this.contentPane.getInputMap();
            KeyStroke[] inputKeys = inputMap.keys();
            if (inputKeys != null) {
                for (KeyStroke key : inputKeys) {
                    Object binding = inputMap.get(key);
                    if (!(binding instanceof String) || !((String)binding).startsWith("MapMover.")) continue;
                    inputMap.remove(key);
                }
            }
            if ((actionsKeys = (actionMap = this.contentPane.getActionMap()).keys()) != null) {
                for (Object key : actionsKeys) {
                    if (!(key instanceof String) || !((String)key).startsWith("MapMover.")) continue;
                    actionMap.remove(key);
                }
            }
        }
    }

    private final class ZoomerAction
    extends AbstractAction {
        private final String action;

        public ZoomerAction(String action) {
            this.action = action;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (".".equals(this.action) || ",".equals(this.action)) {
                Point mouse = MapMover.this.nc.getMousePosition();
                if (mouse == null) {
                    mouse = new Point((int)MapMover.this.nc.getBounds().getCenterX(), (int)MapMover.this.nc.getBounds().getCenterY());
                }
                MouseWheelEvent we = new MouseWheelEvent((Component)MapMover.this.nc, e.getID(), e.getWhen(), e.getModifiers(), mouse.x, mouse.y, 0, false, 0, 1, ",".equals(this.action) ? -1 : 1);
                MapMover.this.mouseWheelMoved(we);
            } else {
                EastNorth center = MapMover.this.nc.getCenter();
                EastNorth newcenter = MapMover.this.nc.getEastNorth(MapMover.this.nc.getWidth() / 2 + MapMover.this.nc.getWidth() / 5, MapMover.this.nc.getHeight() / 2 + MapMover.this.nc.getHeight() / 5);
                switch (this.action) {
                    case "left": {
                        MapMover.this.nc.zoomTo(new EastNorth(2.0 * center.east() - newcenter.east(), center.north()));
                        break;
                    }
                    case "right": {
                        MapMover.this.nc.zoomTo(new EastNorth(newcenter.east(), center.north()));
                        break;
                    }
                    case "up": {
                        MapMover.this.nc.zoomTo(new EastNorth(center.east(), 2.0 * center.north() - newcenter.north()));
                        break;
                    }
                    case "down": {
                        MapMover.this.nc.zoomTo(new EastNorth(center.east(), newcenter.north()));
                    }
                }
            }
        }
    }
}

