/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui;

import java.awt.Component;
import java.awt.DefaultFocusTraversalPolicy;
import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.AboutAction;
import org.openstreetmap.josm.actions.AddNodeAction;
import org.openstreetmap.josm.actions.AlignInCircleAction;
import org.openstreetmap.josm.actions.AlignInLineAction;
import org.openstreetmap.josm.actions.AutoScaleAction;
import org.openstreetmap.josm.actions.ChangesetManagerToggleAction;
import org.openstreetmap.josm.actions.CloseChangesetAction;
import org.openstreetmap.josm.actions.CombineWayAction;
import org.openstreetmap.josm.actions.CopyAction;
import org.openstreetmap.josm.actions.CopyCoordinatesAction;
import org.openstreetmap.josm.actions.CreateCircleAction;
import org.openstreetmap.josm.actions.CreateMultipolygonAction;
import org.openstreetmap.josm.actions.DeleteAction;
import org.openstreetmap.josm.actions.DialogsToggleAction;
import org.openstreetmap.josm.actions.DistributeAction;
import org.openstreetmap.josm.actions.DownloadAction;
import org.openstreetmap.josm.actions.DownloadPrimitiveAction;
import org.openstreetmap.josm.actions.DownloadReferrersAction;
import org.openstreetmap.josm.actions.DuplicateAction;
import org.openstreetmap.josm.actions.ExitAction;
import org.openstreetmap.josm.actions.ExpertToggleAction;
import org.openstreetmap.josm.actions.FollowLineAction;
import org.openstreetmap.josm.actions.FullscreenToggleAction;
import org.openstreetmap.josm.actions.GpxExportAction;
import org.openstreetmap.josm.actions.HelpAction;
import org.openstreetmap.josm.actions.HistoryInfoAction;
import org.openstreetmap.josm.actions.HistoryInfoWebAction;
import org.openstreetmap.josm.actions.InfoAction;
import org.openstreetmap.josm.actions.InfoWebAction;
import org.openstreetmap.josm.actions.JoinAreasAction;
import org.openstreetmap.josm.actions.JoinNodeWayAction;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.actions.JumpToAction;
import org.openstreetmap.josm.actions.MergeLayerAction;
import org.openstreetmap.josm.actions.MergeNodesAction;
import org.openstreetmap.josm.actions.MergeSelectionAction;
import org.openstreetmap.josm.actions.MirrorAction;
import org.openstreetmap.josm.actions.MoveAction;
import org.openstreetmap.josm.actions.MoveNodeAction;
import org.openstreetmap.josm.actions.NewAction;
import org.openstreetmap.josm.actions.OpenFileAction;
import org.openstreetmap.josm.actions.OpenLocationAction;
import org.openstreetmap.josm.actions.OrthogonalizeAction;
import org.openstreetmap.josm.actions.PasteAction;
import org.openstreetmap.josm.actions.PasteTagsAction;
import org.openstreetmap.josm.actions.PreferenceToggleAction;
import org.openstreetmap.josm.actions.PreferencesAction;
import org.openstreetmap.josm.actions.PurgeAction;
import org.openstreetmap.josm.actions.RedoAction;
import org.openstreetmap.josm.actions.ReportBugAction;
import org.openstreetmap.josm.actions.RestartAction;
import org.openstreetmap.josm.actions.ReverseWayAction;
import org.openstreetmap.josm.actions.SaveAction;
import org.openstreetmap.josm.actions.SaveAsAction;
import org.openstreetmap.josm.actions.SearchNotesDownloadAction;
import org.openstreetmap.josm.actions.SelectAllAction;
import org.openstreetmap.josm.actions.SelectNonBranchingWaySequencesAction;
import org.openstreetmap.josm.actions.SessionLoadAction;
import org.openstreetmap.josm.actions.SessionSaveAsAction;
import org.openstreetmap.josm.actions.ShowStatusReportAction;
import org.openstreetmap.josm.actions.SimplifyWayAction;
import org.openstreetmap.josm.actions.SplitWayAction;
import org.openstreetmap.josm.actions.ToggleGPXLinesAction;
import org.openstreetmap.josm.actions.UnGlueAction;
import org.openstreetmap.josm.actions.UnJoinNodeWayAction;
import org.openstreetmap.josm.actions.UndoAction;
import org.openstreetmap.josm.actions.UnselectAllAction;
import org.openstreetmap.josm.actions.UpdateDataAction;
import org.openstreetmap.josm.actions.UpdateModifiedAction;
import org.openstreetmap.josm.actions.UpdateSelectionAction;
import org.openstreetmap.josm.actions.UploadAction;
import org.openstreetmap.josm.actions.UploadSelectionAction;
import org.openstreetmap.josm.actions.ViewportFollowToggleAction;
import org.openstreetmap.josm.actions.WireframeToggleAction;
import org.openstreetmap.josm.actions.ZoomInAction;
import org.openstreetmap.josm.actions.ZoomOutAction;
import org.openstreetmap.josm.actions.audio.AudioBackAction;
import org.openstreetmap.josm.actions.audio.AudioFasterAction;
import org.openstreetmap.josm.actions.audio.AudioFwdAction;
import org.openstreetmap.josm.actions.audio.AudioNextAction;
import org.openstreetmap.josm.actions.audio.AudioPlayPauseAction;
import org.openstreetmap.josm.actions.audio.AudioPrevAction;
import org.openstreetmap.josm.actions.audio.AudioSlowerAction;
import org.openstreetmap.josm.actions.search.SearchAction;
import org.openstreetmap.josm.data.Preferences;
import org.openstreetmap.josm.gui.ImageryMenu;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.MenuScroller;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.io.RecentlyOpenedFilesMenu;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.mappaint.MapPaintMenu;
import org.openstreetmap.josm.gui.preferences.imagery.ImageryPreference;
import org.openstreetmap.josm.gui.preferences.map.TaggingPresetPreference;
import org.openstreetmap.josm.gui.tagging.TaggingPresetSearchAction;
import org.openstreetmap.josm.gui.tagging.TaggingPresetSearchPrimitiveDialog;
import org.openstreetmap.josm.gui.widgets.DisableShortcutsOnFocusGainedTextField;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Shortcut;

public class MainMenu
extends JMenuBar {
    public final NewAction newAction = new NewAction();
    public final OpenFileAction openFile = new OpenFileAction();
    public final RecentlyOpenedFilesMenu recentlyOpened = new RecentlyOpenedFilesMenu();
    public final OpenLocationAction openLocation = new OpenLocationAction();
    public final SaveAction save = SaveAction.getInstance();
    public final SaveAsAction saveAs = SaveAsAction.getInstance();
    public SessionLoadAction sessionLoad;
    public SessionSaveAsAction sessionSaveAs;
    public final GpxExportAction gpxExport = new GpxExportAction();
    public final DownloadAction download = new DownloadAction();
    public final DownloadPrimitiveAction downloadPrimitive = new DownloadPrimitiveAction();
    public final SearchNotesDownloadAction searchNotes = new SearchNotesDownloadAction();
    public final DownloadReferrersAction downloadReferrers = new DownloadReferrersAction();
    public final CloseChangesetAction closeChangesetAction = new CloseChangesetAction();
    public final JosmAction update = new UpdateDataAction();
    public final JosmAction updateSelection = new UpdateSelectionAction();
    public final JosmAction updateModified = new UpdateModifiedAction();
    public final JosmAction upload = new UploadAction();
    public final JosmAction uploadSelection = new UploadSelectionAction();
    public final RestartAction restart = new RestartAction();
    public final ExitAction exit = new ExitAction();
    public final UndoAction undo = new UndoAction();
    public final RedoAction redo = new RedoAction();
    public final CopyAction copy = new CopyAction();
    public final JosmAction copyCoordinates = new CopyCoordinatesAction();
    public final PasteAction paste = new PasteAction();
    public final PasteTagsAction pasteTags = new PasteTagsAction();
    public final DuplicateAction duplicate = new DuplicateAction();
    public final DeleteAction delete = new DeleteAction();
    public final JosmAction purge = new PurgeAction();
    public final MergeLayerAction merge = new MergeLayerAction();
    public final MergeSelectionAction mergeSelected = new MergeSelectionAction();
    public final SearchAction search = new SearchAction();
    public final PreferencesAction preferences = new PreferencesAction();
    public final WireframeToggleAction wireFrameToggleAction = new WireframeToggleAction();
    public final JosmAction toggleGPXLines = new ToggleGPXLinesAction();
    public final InfoAction info = new InfoAction();
    public final InfoWebAction infoweb = new InfoWebAction();
    public final HistoryInfoAction historyinfo = new HistoryInfoAction();
    public final HistoryInfoWebAction historyinfoweb = new HistoryInfoWebAction();
    public final Map<String, AutoScaleAction> autoScaleActions = new HashMap<String, AutoScaleAction>();
    public final JumpToAction jumpToAct = new JumpToAction();
    public final SplitWayAction splitWay = new SplitWayAction();
    public final CombineWayAction combineWay = new CombineWayAction();
    public final ReverseWayAction reverseWay = new ReverseWayAction();
    public final SimplifyWayAction simplifyWay = new SimplifyWayAction();
    public final AlignInCircleAction alignInCircle = new AlignInCircleAction();
    public final AlignInLineAction alignInLine = new AlignInLineAction();
    public final DistributeAction distribute = new DistributeAction();
    public final OrthogonalizeAction ortho = new OrthogonalizeAction();
    public final OrthogonalizeAction.Undo orthoUndo = new OrthogonalizeAction.Undo();
    public final MirrorAction mirror = new MirrorAction();
    public final FollowLineAction followLine = new FollowLineAction();
    public final AddNodeAction addNode = new AddNodeAction();
    public final MoveNodeAction moveNode = new MoveNodeAction();
    public final CreateCircleAction createCircle = new CreateCircleAction();
    public final MergeNodesAction mergeNodes = new MergeNodesAction();
    public final JoinNodeWayAction joinNodeWay = JoinNodeWayAction.createJoinNodeToWayAction();
    public final JoinNodeWayAction moveNodeOntoWay = JoinNodeWayAction.createMoveNodeOntoWayAction();
    public final UnJoinNodeWayAction unJoinNodeWay = new UnJoinNodeWayAction();
    public final UnGlueAction unglueNodes = new UnGlueAction();
    public final JoinAreasAction joinAreas = new JoinAreasAction();
    public final CreateMultipolygonAction createMultipolygon = new CreateMultipolygonAction(false);
    public final CreateMultipolygonAction updateMultipolygon = new CreateMultipolygonAction(true);
    public final SelectAllAction selectAll = new SelectAllAction();
    public final UnselectAllAction unselectAll = new UnselectAllAction();
    public final SelectNonBranchingWaySequencesAction nonBranchingWaySequences = new SelectNonBranchingWaySequencesAction();
    public final JosmAction audioPlayPause = new AudioPlayPauseAction();
    public final JosmAction audioNext = new AudioNextAction();
    public final JosmAction audioPrev = new AudioPrevAction();
    public final JosmAction audioFwd = new AudioFwdAction();
    public final JosmAction audioBack = new AudioBackAction();
    public final JosmAction audioFaster = new AudioFasterAction();
    public final JosmAction audioSlower = new AudioSlowerAction();
    public final ChangesetManagerToggleAction changesetManager = new ChangesetManagerToggleAction();
    public final HelpAction help = new HelpAction();
    public final AboutAction about = new AboutAction();
    public final ShowStatusReportAction statusreport = new ShowStatusReportAction();
    public final ReportBugAction reportbug = new ReportBugAction();
    public final JMenu fileMenu = this.addMenu(I18n.marktr("File"), 70, 0, HelpUtil.ht("/Menu/File"));
    public final JMenu sessionMenu = new JMenu(I18n.tr("Session", new Object[0]));
    public final JMenu editMenu = this.addMenu(I18n.marktr("Edit"), 69, 1, HelpUtil.ht("/Menu/Edit"));
    public final JMenu viewMenu = this.addMenu(I18n.marktr("View"), 86, 2, HelpUtil.ht("/Menu/View"));
    public final JMenu toolsMenu = this.addMenu(I18n.marktr("Tools"), 84, 3, HelpUtil.ht("/Menu/Tools"));
    public final JMenu moreToolsMenu = this.addMenu(I18n.marktr("More tools"), 77, 4, HelpUtil.ht("/Menu/MoreTools"));
    public final JMenu dataMenu = this.addMenu(I18n.marktr("Data"), 68, 5, HelpUtil.ht("/Menu/Data"));
    public final JMenu selectionMenu = this.addMenu(I18n.marktr("Selection"), 78, 6, HelpUtil.ht("/Menu/Selection"));
    public final JMenu presetsMenu = this.addMenu(I18n.marktr("Presets"), 80, 7, HelpUtil.ht("/Menu/Presets"));
    public final JMenu imagerySubMenu = new JMenu(I18n.tr("More...", new Object[0]));
    public final ImageryMenu imageryMenu = this.addMenu(new ImageryMenu(this.imagerySubMenu), I18n.marktr("Imagery"), 73, 8, HelpUtil.ht("/Menu/Imagery"));
    public final JMenu gpsMenu = this.addMenu(I18n.marktr("GPS"), 71, 9, HelpUtil.ht("/Menu/GPS"));
    public final JMenu windowMenu = this.addMenu(I18n.marktr("Windows"), 87, 10, HelpUtil.ht("/Menu/Windows"));
    public JMenu audioMenu = null;
    public final JMenu helpMenu = this.addMenu(I18n.marktr("Help"), 72, 11, HelpUtil.ht("/Menu/Help"));
    public final JosmAction moveUpAction = new MoveAction(MoveAction.Direction.UP);
    public final JosmAction moveDownAction = new MoveAction(MoveAction.Direction.DOWN);
    public final JosmAction moveLeftAction = new MoveAction(MoveAction.Direction.LEFT);
    public final JosmAction moveRightAction = new MoveAction(MoveAction.Direction.RIGHT);
    public final TaggingPresetSearchAction presetSearchAction = new TaggingPresetSearchAction();
    public final TaggingPresetSearchPrimitiveDialog.Action presetSearchPrimitiveAction = new TaggingPresetSearchPrimitiveDialog.Action();
    public final DialogsToggleAction dialogsToggleAction = new DialogsToggleAction();
    public FullscreenToggleAction fullscreenToggleAction = null;
    private JPopupMenu searchResultsMenu = new JPopupMenu();
    public static final MenuListener menuSeparatorHandler = new MenuListener(){

        @Override
        public void menuCanceled(MenuEvent arg0) {
        }

        @Override
        public void menuDeselected(MenuEvent arg0) {
        }

        @Override
        public void menuSelected(MenuEvent a) {
            if (!(a.getSource() instanceof JMenu)) {
                return;
            }
            JPopupMenu m = ((JMenu)a.getSource()).getPopupMenu();
            for (int i = 0; i < m.getComponentCount() - 1; ++i) {
                if (!(m.getComponent(i) instanceof JSeparator)) continue;
                ((JSeparator)m.getComponent(i)).setVisible(!(m.getComponent(i + 1) instanceof JSeparator));
            }
            if (m.getComponent(m.getComponentCount() - 1) instanceof JSeparator) {
                ((JSeparator)m.getComponent(m.getComponentCount() - 1)).setVisible(false);
            }
        }
    };

    public int getDefaultMenuPos() {
        return 11;
    }

    public static JMenuItem add(JMenu menu, JosmAction action) {
        return MainMenu.add(menu, action, false);
    }

    public static JMenuItem add(JMenu menu, JosmAction action, boolean isExpert) {
        return MainMenu.add(menu, action, isExpert, null);
    }

    public static JMenuItem add(JMenu menu, JosmAction action, boolean isExpert, Integer index) {
        KeyStroke ks;
        if (action.getShortcut().getAutomatic()) {
            return null;
        }
        JMenuItem menuitem = index == null ? menu.add(action) : menu.insert(action, (int)index);
        if (isExpert) {
            ExpertToggleAction.addVisibilitySwitcher(menuitem);
        }
        if ((ks = action.getShortcut().getKeyStroke()) != null) {
            menuitem.setAccelerator(ks);
        }
        if (!menu.isVisible()) {
            menu.setVisible(true);
        }
        return menuitem;
    }

    public static JMenuItem addAfter(JMenu menu, JosmAction actionToBeInserted, boolean isExpert, JosmAction existingMenuEntryAction) {
        Component c;
        int i = 0;
        Component[] arr$ = menu.getMenuComponents();
        int len$ = arr$.length;
        for (int i$ = 0; !(i$ >= len$ || (c = arr$[i$]) instanceof JMenuItem && ((JMenuItem)c).getAction() == existingMenuEntryAction); ++i$) {
            ++i;
        }
        return MainMenu.add(menu, actionToBeInserted, isExpert, i + 1);
    }

    public static <E extends Enum<E>> JMenuItem add(JMenu menu, JosmAction action, Enum<E> group) {
        if (action.getShortcut().getAutomatic()) {
            return null;
        }
        int i = MainMenu.getInsertionIndexForGroup(menu, group.ordinal());
        JMenuItem menuitem = (JMenuItem)menu.add((Component)new JMenuItem(action), i);
        KeyStroke ks = action.getShortcut().getKeyStroke();
        if (ks != null) {
            menuitem.setAccelerator(ks);
        }
        return menuitem;
    }

    public static <E extends Enum<E>> JCheckBoxMenuItem addWithCheckbox(JMenu menu, JosmAction action, Enum<E> group) {
        int i = MainMenu.getInsertionIndexForGroup(menu, group.ordinal());
        JCheckBoxMenuItem mi = (JCheckBoxMenuItem)menu.add((Component)new JCheckBoxMenuItem(action), i);
        KeyStroke ks = action.getShortcut().getKeyStroke();
        if (ks != null) {
            mi.setAccelerator(ks);
        }
        return mi;
    }

    private static int getInsertionIndexForGroup(JMenu menu, int group) {
        int i;
        if (group < 0) {
            return -1;
        }
        for (i = 0; i < menu.getItemCount() && group >= 0; ++i) {
            if (menu.getItem(i) != null) continue;
            --group;
        }
        if (group < 0) {
            --i;
        }
        while (group > 0) {
            menu.addSeparator();
            --group;
            ++i;
        }
        return i;
    }

    public JMenu addMenu(String name, int mnemonicKey, int position, String relativeHelpTopic) {
        JMenu menu = new JMenu(I18n.tr(name, new Object[0]));
        if (!GraphicsEnvironment.isHeadless()) {
            MenuScroller.setScrollerFor(menu);
        }
        return this.addMenu(menu, name, mnemonicKey, position, relativeHelpTopic);
    }

    public <T extends JMenu> T addMenu(T menu, String name, int mnemonicKey, int position, String relativeHelpTopic) {
        Shortcut.registerShortcut("menu:" + name, I18n.tr("Menu: {0}", I18n.tr(name, new Object[0])), mnemonicKey, 5001).setMnemonic(menu);
        this.add((Component)menu, position);
        menu.putClientProperty("help", relativeHelpTopic);
        return menu;
    }

    public MainMenu() {
        this.moreToolsMenu.setVisible(false);
        this.dataMenu.setVisible(false);
        this.gpsMenu.setVisible(false);
        MainMenu.add(this.fileMenu, this.newAction);
        MainMenu.add(this.fileMenu, this.openFile);
        this.fileMenu.add(this.recentlyOpened);
        MainMenu.add(this.fileMenu, this.openLocation);
        this.fileMenu.addSeparator();
        MainMenu.add(this.fileMenu, this.save);
        MainMenu.add(this.fileMenu, this.saveAs);
        this.sessionMenu.setToolTipText(I18n.tr("Save and load the current session (list of layers, etc.)", new Object[0]));
        this.sessionMenu.setIcon(new ImageProvider("session").setSize(ImageProvider.ImageSizes.MENU).get());
        this.sessionSaveAs = new SessionSaveAsAction();
        this.sessionLoad = new SessionLoadAction();
        MainMenu.add(this.sessionMenu, this.sessionSaveAs);
        MainMenu.add(this.sessionMenu, this.sessionLoad);
        this.fileMenu.add(this.sessionMenu);
        ExpertToggleAction.addVisibilitySwitcher(this.sessionMenu);
        MainMenu.add(this.fileMenu, (JosmAction)this.gpxExport, true);
        this.fileMenu.addSeparator();
        MainMenu.add(this.fileMenu, this.download);
        MainMenu.add(this.fileMenu, this.downloadPrimitive);
        MainMenu.add(this.fileMenu, this.searchNotes);
        MainMenu.add(this.fileMenu, this.downloadReferrers);
        MainMenu.add(this.fileMenu, this.update);
        MainMenu.add(this.fileMenu, this.updateSelection);
        MainMenu.add(this.fileMenu, this.updateModified);
        this.fileMenu.addSeparator();
        MainMenu.add(this.fileMenu, this.upload);
        MainMenu.add(this.fileMenu, this.uploadSelection);
        JPopupMenu.Separator sep = new JPopupMenu.Separator();
        this.fileMenu.add(sep);
        ExpertToggleAction.addVisibilitySwitcher(sep);
        MainMenu.add(this.fileMenu, (JosmAction)this.closeChangesetAction, true);
        this.fileMenu.addSeparator();
        MainMenu.add(this.fileMenu, this.restart);
        MainMenu.add(this.fileMenu, this.exit);
        MainMenu.add(this.editMenu, this.undo);
        Main.main.undoRedo.addCommandQueueListener(this.undo);
        MainMenu.add(this.editMenu, this.redo);
        Main.main.undoRedo.addCommandQueueListener(this.redo);
        this.editMenu.addSeparator();
        MainMenu.add(this.editMenu, this.copy);
        MainMenu.add(this.editMenu, this.copyCoordinates, true);
        MainMenu.add(this.editMenu, this.paste);
        MainMenu.add(this.editMenu, this.pasteTags);
        MainMenu.add(this.editMenu, this.duplicate);
        MainMenu.add(this.editMenu, this.delete);
        MainMenu.add(this.editMenu, this.purge, true);
        this.editMenu.addSeparator();
        MainMenu.add(this.editMenu, this.merge);
        MainMenu.add(this.editMenu, this.mergeSelected);
        this.editMenu.addSeparator();
        MainMenu.add(this.editMenu, this.search);
        MainMenu.add(this.editMenu, this.presetSearchPrimitiveAction);
        this.editMenu.addSeparator();
        MainMenu.add(this.editMenu, this.preferences);
        JCheckBoxMenuItem wireframe = new JCheckBoxMenuItem(this.wireFrameToggleAction);
        this.viewMenu.add(wireframe);
        wireframe.setAccelerator(this.wireFrameToggleAction.getShortcut().getKeyStroke());
        this.wireFrameToggleAction.addButtonModel(wireframe.getModel());
        this.viewMenu.add(new MapPaintMenu());
        this.viewMenu.addSeparator();
        MainMenu.add(this.viewMenu, new ZoomInAction());
        MainMenu.add(this.viewMenu, new ZoomOutAction());
        this.viewMenu.addSeparator();
        for (String mode : AutoScaleAction.MODES) {
            AutoScaleAction autoScaleAction = new AutoScaleAction(mode);
            this.autoScaleActions.put(mode, autoScaleAction);
            MainMenu.add(this.viewMenu, autoScaleAction);
        }
        ViewportFollowToggleAction viewportFollowToggleAction = new ViewportFollowToggleAction();
        JCheckBoxMenuItem vft = new JCheckBoxMenuItem(viewportFollowToggleAction);
        ExpertToggleAction.addVisibilitySwitcher(vft);
        this.viewMenu.add(vft);
        vft.setAccelerator(viewportFollowToggleAction.getShortcut().getKeyStroke());
        viewportFollowToggleAction.addButtonModel(vft.getModel());
        if (Main.platform.canFullscreen()) {
            this.fullscreenToggleAction = new FullscreenToggleAction();
            JCheckBoxMenuItem fullscreen = new JCheckBoxMenuItem(this.fullscreenToggleAction);
            this.viewMenu.addSeparator();
            this.viewMenu.add(fullscreen);
            fullscreen.setAccelerator(this.fullscreenToggleAction.getShortcut().getKeyStroke());
            this.fullscreenToggleAction.addButtonModel(fullscreen.getModel());
        }
        JCheckBoxMenuItem dialogsToggle = new JCheckBoxMenuItem(this.dialogsToggleAction);
        dialogsToggle.setAccelerator(this.dialogsToggleAction.getShortcut().getKeyStroke());
        this.dialogsToggleAction.addButtonModel(dialogsToggle.getModel());
        this.viewMenu.add(dialogsToggle);
        MainMenu.add(this.viewMenu, (JosmAction)this.jumpToAct, true);
        this.viewMenu.addSeparator();
        MainMenu.add(this.viewMenu, this.info);
        MainMenu.add(this.viewMenu, this.infoweb);
        MainMenu.add(this.viewMenu, this.historyinfo);
        MainMenu.add(this.viewMenu, this.historyinfoweb);
        this.viewMenu.addSeparator();
        this.viewMenu.add(new PreferenceToggleAction(I18n.tr("Edit toolbar", new Object[0]), I18n.tr("Toggles the visibility of the edit toolbar (i.e., the vertical tool)", new Object[0]), "sidetoolbar.visible", true).getCheckbox());
        JCheckBoxMenuItem expertItem = new JCheckBoxMenuItem(ExpertToggleAction.getInstance());
        this.viewMenu.add(expertItem);
        ExpertToggleAction.getInstance().addButtonModel(expertItem.getModel());
        MainMenu.add(this.presetsMenu, this.presetSearchAction);
        MainMenu.add(this.presetsMenu, this.presetSearchPrimitiveAction);
        MainMenu.add(this.presetsMenu, PreferencesAction.forPreferenceSubTab(I18n.tr("Preset preferences", new Object[0]), I18n.tr("Click to open the tagging presets tab in the preferences", new Object[0]), TaggingPresetPreference.class));
        this.presetsMenu.addSeparator();
        MainMenu.add(this.imageryMenu, PreferencesAction.forPreferenceTab(I18n.tr("Imagery preferences", new Object[0]), I18n.tr("Click to open the imagery tab in the preferences", new Object[0]), ImageryPreference.class));
        MainMenu.add(this.selectionMenu, this.selectAll);
        MainMenu.add(this.selectionMenu, this.unselectAll);
        MainMenu.add(this.selectionMenu, this.nonBranchingWaySequences);
        MainMenu.add(this.toolsMenu, this.splitWay);
        MainMenu.add(this.toolsMenu, this.combineWay);
        this.toolsMenu.addSeparator();
        MainMenu.add(this.toolsMenu, this.reverseWay);
        MainMenu.add(this.toolsMenu, this.simplifyWay);
        this.toolsMenu.addSeparator();
        MainMenu.add(this.toolsMenu, this.alignInCircle);
        MainMenu.add(this.toolsMenu, this.alignInLine);
        MainMenu.add(this.toolsMenu, this.distribute);
        MainMenu.add(this.toolsMenu, this.ortho);
        MainMenu.add(this.toolsMenu, (JosmAction)this.mirror, true);
        this.toolsMenu.addSeparator();
        MainMenu.add(this.toolsMenu, (JosmAction)this.followLine, true);
        MainMenu.add(this.toolsMenu, (JosmAction)this.addNode, true);
        MainMenu.add(this.toolsMenu, (JosmAction)this.moveNode, true);
        MainMenu.add(this.toolsMenu, this.createCircle);
        this.toolsMenu.addSeparator();
        MainMenu.add(this.toolsMenu, this.mergeNodes);
        MainMenu.add(this.toolsMenu, this.joinNodeWay);
        MainMenu.add(this.toolsMenu, this.moveNodeOntoWay);
        MainMenu.add(this.toolsMenu, this.unJoinNodeWay);
        MainMenu.add(this.toolsMenu, this.unglueNodes);
        this.toolsMenu.addSeparator();
        MainMenu.add(this.toolsMenu, this.joinAreas);
        MainMenu.add(this.toolsMenu, this.createMultipolygon);
        MainMenu.add(this.toolsMenu, this.updateMultipolygon);
        JCheckBoxMenuItem mi = MainMenu.addWithCheckbox(this.windowMenu, this.changesetManager, WINDOW_MENU_GROUP.ALWAYS);
        this.changesetManager.addButtonModel(mi.getModel());
        if (!Main.pref.getBoolean("audio.menuinvisible", false)) {
            this.showAudioMenu(true);
        }
        Main.pref.addPreferenceChangeListener(new Preferences.PreferenceChangedListener(){

            @Override
            public void preferenceChanged(Preferences.PreferenceChangeEvent e) {
                if ("audio.menuinvisible".equals(e.getKey())) {
                    MainMenu.this.showAudioMenu(!Boolean.parseBoolean(e.getNewValue().toString()));
                }
            }
        });
        this.helpMenu.add(this.statusreport);
        this.helpMenu.add(this.reportbug);
        this.helpMenu.addSeparator();
        JMenuItem current = this.helpMenu.add(this.help);
        current.setAccelerator(Shortcut.registerShortcut("system:help", I18n.tr("Help", new Object[0]), 112, 5003).getKeyStroke());
        MainMenu.add(this.helpMenu, this.about);
        this.add(Box.createHorizontalGlue());
        final DisableShortcutsOnFocusGainedTextField searchField = this.createSearchField();
        this.add(searchField);
        this.setFocusTraversalPolicyProvider(true);
        this.setFocusTraversalPolicy(new DefaultFocusTraversalPolicy(){

            @Override
            protected boolean accept(Component aComponent) {
                return super.accept(aComponent) && !searchField.equals(aComponent);
            }
        });
        this.windowMenu.addMenuListener(menuSeparatorHandler);
        new PresetsMenuEnabler(this.presetsMenu).refreshEnabled();
    }

    private int getMaximumAvailableWidth() {
        int maxWidth = this.getSize().width;
        for (int i = 0; i < this.getMenuCount(); ++i) {
            JMenu menu = this.getMenu(i);
            if (menu == null) continue;
            maxWidth -= menu.getPreferredSize().width;
        }
        return maxWidth;
    }

    private DisableShortcutsOnFocusGainedTextField createSearchField() {
        DisableShortcutsOnFocusGainedTextField searchField = new DisableShortcutsOnFocusGainedTextField(){

            @Override
            public Dimension getPreferredSize() {
                return new Dimension(Math.min(200, Math.max(25, MainMenu.this.getMaximumAvailableWidth())), MainMenu.this.helpMenu.getPreferredSize().height);
            }
        };
        searchField.setEditable(true);
        searchField.setMaximumSize(new Dimension(200, this.helpMenu.getPreferredSize().height));
        searchField.setHint(I18n.tr("Search menu items", new Object[0]));
        searchField.setToolTipText(I18n.tr("Search menu items", new Object[0]));
        searchField.addKeyListener(new SearchFieldKeyListener());
        searchField.getDocument().addDocumentListener(new SearchFieldTextListener(this, searchField));
        return searchField;
    }

    private List<JMenuItem> findMenuItems(String textToFind) {
        textToFind = textToFind.toLowerCase();
        ArrayList<JMenuItem> result = new ArrayList<JMenuItem>();
        for (MenuElement menuElement : this.getSubElements()) {
            if (!(menuElement instanceof JMenu)) continue;
            JMenu mainMenuItem = (JMenu)menuElement;
            if (mainMenuItem.getAction() != null && mainMenuItem.getText().toLowerCase().contains(textToFind)) {
                result.add(mainMenuItem);
            }
            this.findMenuItems(mainMenuItem, textToFind, result);
        }
        return result;
    }

    private void findMenuItems(JMenu menu, String textToFind, List<JMenuItem> result) {
        for (int i = 0; i < menu.getItemCount(); ++i) {
            JMenuItem menuItem = menu.getItem(i);
            if (menuItem == null) continue;
            if (menuItem.getAction() != null && menuItem.getText().toLowerCase().contains(textToFind)) {
                result.add(menuItem);
            }
            if (!(menuItem instanceof JMenu)) continue;
            this.findMenuItems((JMenu)menuItem, textToFind, result);
        }
    }

    protected void showAudioMenu(boolean showMenu) {
        if (showMenu && this.audioMenu == null) {
            this.audioMenu = this.addMenu(I18n.marktr("Audio"), 85, 11, HelpUtil.ht("/Menu/Audio"));
            MainMenu.add(this.audioMenu, this.audioPlayPause);
            MainMenu.add(this.audioMenu, this.audioNext);
            MainMenu.add(this.audioMenu, this.audioPrev);
            MainMenu.add(this.audioMenu, this.audioFwd);
            MainMenu.add(this.audioMenu, this.audioBack);
            MainMenu.add(this.audioMenu, this.audioSlower);
            MainMenu.add(this.audioMenu, this.audioFaster);
            this.validate();
        } else if (!showMenu && this.audioMenu != null) {
            this.remove(this.audioMenu);
            this.audioMenu.removeAll();
            this.audioMenu = null;
            this.validate();
        }
    }

    private class SearchFieldTextListener
    implements DocumentListener {
        private final JTextField searchField;
        private final MainMenu mainMenu;
        private String currentSearchText = null;

        public SearchFieldTextListener(MainMenu mainMenu2, JTextField searchField) {
            this.mainMenu = mainMenu2;
            this.searchField = searchField;
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.doSearch(this.searchField.getText());
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.doSearch(this.searchField.getText());
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.doSearch(this.searchField.getText());
        }

        void doSearch(String searchTerm) {
            if ((searchTerm = searchTerm.trim().toLowerCase()).equals(this.currentSearchText)) {
                return;
            }
            this.currentSearchText = searchTerm;
            if (searchTerm.length() == 0) {
                this.hideMenu();
                return;
            }
            List searchResult = this.mainMenu.findMenuItems(this.currentSearchText);
            if (searchResult.size() == 0) {
                this.hideMenu();
                return;
            }
            if (searchResult.size() > 20) {
                searchResult = searchResult.subList(0, 20);
            }
            MainMenu.this.searchResultsMenu.removeAll();
            for (JMenuItem foundItem : searchResult) {
                MainMenu.this.searchResultsMenu.add(foundItem.getText()).setAction(foundItem.getAction());
            }
            MainMenu.this.searchResultsMenu.pack();
            MainMenu.this.searchResultsMenu.show(this.mainMenu, this.searchField.getX(), this.searchField.getY() + this.searchField.getHeight());
            this.searchField.requestFocusInWindow();
        }

        private void hideMenu() {
            MainMenu.this.searchResultsMenu.setVisible(false);
        }
    }

    private class SearchFieldKeyListener
    implements KeyListener {
        private SearchFieldKeyListener() {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            MenuElement selectedElement;
            MenuElement[] selection;
            if (e.getKeyCode() == 10 && (selection = MenuSelectionManager.defaultManager().getSelectedPath()).length > 1 && (selectedElement = selection[selection.length - 1]) instanceof JMenuItem) {
                JMenuItem selectedItem = (JMenuItem)selectedElement;
                Action menuAction = selectedItem.getAction();
                menuAction.actionPerformed(new ActionEvent(this, 1001, null));
                e.consume();
            }
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }

        @Override
        public void keyReleased(KeyEvent e) {
        }
    }

    static class PresetsMenuEnabler
    implements MapView.LayerChangeListener {
        private JMenu presetsMenu;

        public PresetsMenuEnabler(JMenu presetsMenu) {
            MapView.addLayerChangeListener(this);
            this.presetsMenu = presetsMenu;
        }

        protected void refreshEnabled() {
            this.presetsMenu.setEnabled(Main.main.hasEditLayer());
        }

        @Override
        public void activeLayerChange(Layer oldLayer, Layer newLayer) {
            this.refreshEnabled();
        }

        @Override
        public void layerAdded(Layer newLayer) {
            this.refreshEnabled();
        }

        @Override
        public void layerRemoved(Layer oldLayer) {
            this.refreshEnabled();
        }
    }

    public static enum WINDOW_MENU_GROUP {
        ALWAYS,
        TOGGLE_DIALOG,
        VOLATILE;

    }
}

