/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui;

import gnu.getopt.Getopt;
import gnu.getopt.LongOpt;
import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.Authenticator;
import java.net.ProxySelector;
import java.net.URL;
import java.security.AllPermission;
import java.security.CodeSource;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.Policy;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.JFrame;
import javax.swing.RepaintManager;
import javax.swing.SwingUtilities;
import org.jdesktop.swinghelper.debug.CheckThreadViolationRepaintManager;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.PreferencesAction;
import org.openstreetmap.josm.data.AutosaveTask;
import org.openstreetmap.josm.data.CustomConfigurator;
import org.openstreetmap.josm.data.Version;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.SplashScreen;
import org.openstreetmap.josm.gui.download.DownloadDialog;
import org.openstreetmap.josm.gui.preferences.server.OAuthAccessTokenHolder;
import org.openstreetmap.josm.gui.preferences.server.ProxyPreference;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.io.DefaultProxySelector;
import org.openstreetmap.josm.io.MessageNotifier;
import org.openstreetmap.josm.io.OnlineResource;
import org.openstreetmap.josm.io.auth.CredentialsManager;
import org.openstreetmap.josm.io.auth.DefaultAuthenticator;
import org.openstreetmap.josm.io.remotecontrol.RemoteControl;
import org.openstreetmap.josm.plugins.PluginHandler;
import org.openstreetmap.josm.plugins.PluginInformation;
import org.openstreetmap.josm.tools.BugReportExceptionHandler;
import org.openstreetmap.josm.tools.FontsManager;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.OsmUrlToBounds;
import org.openstreetmap.josm.tools.PlatformHookWindows;
import org.openstreetmap.josm.tools.Utils;

public class MainApplication
extends Main {
    public MainApplication() {
    }

    public MainApplication(JFrame mainFrame) {
        MainApplication.addListener();
        mainFrame.setContentPane(contentPanePrivate);
        mainFrame.setJMenuBar(this.menu);
        geometry.applySafe(mainFrame);
        LinkedList<Image> l = new LinkedList<Image>();
        l.add(ImageProvider.get("logo_16x16x32").getImage());
        l.add(ImageProvider.get("logo_16x16x8").getImage());
        l.add(ImageProvider.get("logo_32x32x32").getImage());
        l.add(ImageProvider.get("logo_32x32x8").getImage());
        l.add(ImageProvider.get("logo_48x48x32").getImage());
        l.add(ImageProvider.get("logo_48x48x8").getImage());
        l.add(ImageProvider.get("logo").getImage());
        mainFrame.setIconImages(l);
        mainFrame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent arg0) {
                Main.exitJosm(true, 0);
            }
        });
        mainFrame.setDefaultCloseOperation(0);
    }

    public static void showHelp() {
        System.out.println(I18n.tr("Java OpenStreetMap Editor", new Object[0]) + " [" + Version.getInstance().getAgentString() + "]\n\n" + I18n.tr("usage", new Object[0]) + ":\n" + "\tjava -jar josm.jar <options>...\n\n" + I18n.tr("options", new Object[0]) + ":\n" + "\t--help|-h                                 " + I18n.tr("Show this help", new Object[0]) + "\n" + "\t--geometry=widthxheight(+|-)x(+|-)y       " + I18n.tr("Standard unix geometry argument", new Object[0]) + "\n" + "\t[--download=]minlat,minlon,maxlat,maxlon  " + I18n.tr("Download the bounding box", new Object[0]) + "\n" + "\t[--download=]<URL>                        " + I18n.tr("Download the location at the URL (with lat=x&lon=y&zoom=z)", new Object[0]) + "\n" + "\t[--download=]<filename>                   " + I18n.tr("Open a file (any file type that can be opened with File/Open)", new Object[0]) + "\n" + "\t--downloadgps=minlat,minlon,maxlat,maxlon " + I18n.tr("Download the bounding box as raw GPS", new Object[0]) + "\n" + "\t--downloadgps=<URL>                       " + I18n.tr("Download the location at the URL (with lat=x&lon=y&zoom=z) as raw GPS", new Object[0]) + "\n" + "\t--selection=<searchstring>                " + I18n.tr("Select with the given search", new Object[0]) + "\n" + "\t--[no-]maximize                           " + I18n.tr("Launch in maximized mode", new Object[0]) + "\n" + "\t--reset-preferences                       " + I18n.tr("Reset the preferences to default", new Object[0]) + "\n\n" + "\t--load-preferences=<url-to-xml>           " + I18n.tr("Changes preferences according to the XML file", new Object[0]) + "\n\n" + "\t--set=<key>=<value>                       " + I18n.tr("Set preference key to value", new Object[0]) + "\n\n" + "\t--language=<language>                     " + I18n.tr("Set the language", new Object[0]) + "\n\n" + "\t--version                                 " + I18n.tr("Displays the JOSM version and exits", new Object[0]) + "\n\n" + "\t--debug                                   " + I18n.tr("Print debugging messages to console", new Object[0]) + "\n\n" + "\t--offline=<osm_api|josm_website|all>      " + I18n.tr("Disable access to the given resource(s), separated by comma", new Object[0]) + "\n\n" + I18n.tr("options provided as Java system properties", new Object[0]) + ":\n" + "\t-Djosm.pref=" + I18n.tr("/PATH/TO/JOSM/PREF    ", new Object[0]) + I18n.tr("Set the preferences directory", new Object[0]) + "\n\n" + "\t-Djosm.userdata=" + I18n.tr("/PATH/TO/JOSM/USERDATA", new Object[0]) + I18n.tr("Set the user data directory", new Object[0]) + "\n\n" + "\t-Djosm.cache=" + I18n.tr("/PATH/TO/JOSM/CACHE   ", new Object[0]) + I18n.tr("Set the cache directory", new Object[0]) + "\n\n" + "\t-Djosm.home=" + I18n.tr("/PATH/TO/JOSM/HOMEDIR ", new Object[0]) + I18n.tr("Relocate all 3 directories to homedir. Cache directory will be in homedir/cache", new Object[0]) + "\n\n" + I18n.tr("-Djosm.home has lower precedence, i.e. the specific setting overrides the general one", new Object[0]) + "\n\n" + I18n.tr("note: For some tasks, JOSM needs a lot of memory. It can be necessary to add the following\n      Java option to specify the maximum size of allocated memory in megabytes", new Object[0]) + ":\n" + "\t-Xmx...m\n\n" + I18n.tr("examples", new Object[0]) + ":\n" + "\tjava -jar josm.jar track1.gpx track2.gpx london.osm\n" + "\tjava -jar josm.jar " + OsmUrlToBounds.getURL(43.2, 11.1, 13) + "\n" + "\tjava -jar josm.jar london.osm --selection=http://www.ostertag.name/osm/OSM_errors_node-duplicate.xml\n" + "\tjava -jar josm.jar 43.2,11.1,43.4,11.4\n" + "\tjava -Djosm.pref=$XDG_CONFIG_HOME -Djosm.userdata=$XDG_DATA_HOME -Djosm.cache=$XDG_CACHE_HOME -jar josm.jar\n" + "\tjava -Djosm.home=/home/user/.josm_dev -jar josm.jar\n" + "\tjava -Xmx1024m -jar josm.jar\n\n" + I18n.tr("Parameters --download, --downloadgps, and --selection are processed in this order.", new Object[0]) + "\n" + I18n.tr("Make sure you load some data if you use --selection.", new Object[0]) + "\n");
    }

    private static Map<Option, Collection<String>> buildCommandLineArgumentMap(String[] args) {
        Collection<String> values;
        int c;
        ArrayList<LongOpt> los = new ArrayList<LongOpt>();
        for (Option o : Option.values()) {
            los.add(new LongOpt(o.getName(), o.requiresArgument() ? 1 : 0, null, 0));
        }
        Getopt g = new Getopt("JOSM", args, "hv", los.toArray(new LongOpt[los.size()]));
        HashMap<Option, Collection<String>> argMap = new HashMap<Option, Collection<String>>();
        while ((c = g.getopt()) != -1) {
            Option opt = null;
            switch (c) {
                case 104: {
                    opt = Option.HELP;
                    break;
                }
                case 118: {
                    opt = Option.VERSION;
                    break;
                }
                case 0: {
                    opt = Option.values()[g.getLongind()];
                }
            }
            if (opt != null) {
                values = (ArrayList<String>)argMap.get((Object)opt);
                if (values == null) {
                    values = new ArrayList<String>();
                    argMap.put(opt, values);
                }
                values.add(g.getOptarg());
                continue;
            }
            throw new IllegalArgumentException("Invalid option: " + c);
        }
        for (int i = g.getOptind(); i < args.length; ++i) {
            values = (Collection)argMap.get((Object)Option.DOWNLOAD);
            if (values == null) {
                values = new ArrayList();
                argMap.put(Option.DOWNLOAD, values);
            }
            values.add(args[i]);
        }
        return argMap;
    }

    public static void main(String[] argArray) {
        I18n.init();
        Main.checkJavaVersion();
        Map<Option, Collection<String>> args = null;
        try {
            args = MainApplication.buildCommandLineArgumentMap(argArray);
        }
        catch (IllegalArgumentException e) {
            System.exit(1);
            return;
        }
        boolean languageGiven = args.containsKey((Object)Option.LANGUAGE);
        if (languageGiven) {
            I18n.set(args.get((Object)Option.LANGUAGE).iterator().next());
        }
        MainApplication.initApplicationPreferences();
        Policy.setPolicy(new Policy(){
            private PermissionCollection pc = new Permissions();
            {
                this.pc.add(new AllPermission());
            }

            @Override
            public void refresh() {
            }

            @Override
            public PermissionCollection getPermissions(CodeSource codesource) {
                return this.pc;
            }
        });
        Thread.setDefaultUncaughtExceptionHandler(new BugReportExceptionHandler());
        Main.determinePlatformHook();
        Main.platform.preStartupHook();
        Main.commandLineArgs = Utils.copyArray(argArray);
        if (args.containsKey((Object)Option.VERSION)) {
            System.out.println(Version.getInstance().getAgentString());
            System.exit(0);
        }
        if (args.containsKey((Object)Option.DEBUG) || args.containsKey((Object)Option.TRACE)) {
            logLevel = 4;
            Main.info(I18n.tr("Printing debugging messages to console", new Object[0]));
        }
        if (args.containsKey((Object)Option.TRACE)) {
            logLevel = 5;
            Utils.updateSystemProperty("debug", "true");
            Main.info(I18n.tr("Enabled detailed debug level (trace)", new Object[0]));
        }
        Main.pref.init(args.containsKey((Object)Option.RESET_PREFERENCES));
        if (!languageGiven) {
            I18n.set(Main.pref.get("language", null));
        }
        Main.pref.updateSystemProperties();
        if (args.containsKey((Object)Option.HELP)) {
            MainApplication.showHelp();
            System.exit(0);
        }
        MainApplication.processOffline(args);
        Main.platform.afterPrefStartupHook();
        FontsManager.initialize();
        MainApplication.handleSpecialLanguages();
        final JFrame mainFrame = new JFrame(I18n.tr("Java OpenStreetMap Editor", new Object[0]));
        Main.parent = mainFrame;
        if (args.containsKey((Object)Option.LOAD_PREFERENCES)) {
            CustomConfigurator.XMLCommandProcessor config = new CustomConfigurator.XMLCommandProcessor(Main.pref);
            for (String i : args.get((Object)Option.LOAD_PREFERENCES)) {
                MainApplication.info("Reading preferences from " + i);
                try {
                    InputStream is = Utils.openURL(new URL(i));
                    Throwable throwable = null;
                    try {
                        config.openAndReadXML(is);
                    }
                    catch (Throwable x2) {
                        throwable = x2;
                        throw x2;
                    }
                    finally {
                        if (is == null) continue;
                        if (throwable != null) {
                            try {
                                is.close();
                            }
                            catch (Throwable x2) {
                                throwable.addSuppressed(x2);
                            }
                            continue;
                        }
                        is.close();
                    }
                }
                catch (Exception ex) {
                    throw new RuntimeException(ex);
                }
            }
        }
        if (args.containsKey((Object)Option.SET)) {
            for (String i : args.get((Object)Option.SET)) {
                String[] kv = i.split("=", 2);
                Main.pref.put(kv[0], "null".equals(kv[1]) ? null : kv[1]);
            }
        }
        DefaultAuthenticator.createInstance();
        Authenticator.setDefault(DefaultAuthenticator.getInstance());
        DefaultProxySelector proxySelector = new DefaultProxySelector(ProxySelector.getDefault());
        ProxySelector.setDefault(proxySelector);
        OAuthAccessTokenHolder.getInstance().init(Main.pref, CredentialsManager.getInstance());
        final SplashScreen splash = new SplashScreen();
        final ProgressMonitor monitor = splash.getProgressMonitor();
        monitor.beginTask(I18n.tr("Initializing", new Object[0]));
        splash.setVisible(Main.pref.getBoolean("draw.splashscreen", true));
        Main.setInitStatusListener(new Main.InitStatusListener(){

            @Override
            public void updateStatus(String event) {
                monitor.indeterminateSubTask(event);
            }
        });
        Collection<PluginInformation> pluginsToLoad = PluginHandler.buildListOfPluginsToLoad(splash, monitor.createSubTaskMonitor(1, false));
        if (!pluginsToLoad.isEmpty() && PluginHandler.checkAndConfirmPluginUpdate(splash)) {
            monitor.subTask(I18n.tr("Updating plugins", new Object[0]));
            pluginsToLoad = PluginHandler.updatePlugins(splash, null, monitor.createSubTaskMonitor(1, false), false);
        }
        monitor.indeterminateSubTask(I18n.tr("Installing updated plugins", new Object[0]));
        PluginHandler.installDownloadedPlugins(true);
        monitor.indeterminateSubTask(I18n.tr("Loading early plugins", new Object[0]));
        PluginHandler.loadEarlyPlugins(splash, pluginsToLoad, monitor.createSubTaskMonitor(1, false));
        monitor.indeterminateSubTask(I18n.tr("Setting defaults", new Object[0]));
        MainApplication.preConstructorInit(args);
        monitor.indeterminateSubTask(I18n.tr("Creating main GUI", new Object[0]));
        final MainApplication main = new MainApplication(mainFrame);
        monitor.indeterminateSubTask(I18n.tr("Loading plugins", new Object[0]));
        PluginHandler.loadLatePlugins(splash, pluginsToLoad, monitor.createSubTaskMonitor(1, false));
        toolbar.refreshToolbarControl();
        GuiHelper.runInEDTAndWait(new Runnable(){

            @Override
            public void run() {
                splash.setVisible(false);
                splash.dispose();
                mainFrame.setVisible(true);
                main.gettingStarted.requestFocusInWindow();
            }
        });
        Main.MasterWindowListener.setup();
        boolean maximized = Main.pref.getBoolean("gui.maximized", false);
        if (!args.containsKey((Object)Option.NO_MAXIMIZE) && maximized || args.containsKey((Object)Option.MAXIMIZE)) {
            if (Toolkit.getDefaultToolkit().isFrameStateSupported(6)) {
                Main.windowState = 6;
                mainFrame.setExtendedState(Main.windowState);
            } else {
                Main.debug("Main window: maximizing not supported");
            }
        }
        if (main.menu.fullscreenToggleAction != null) {
            main.menu.fullscreenToggleAction.initial();
        }
        SwingUtilities.invokeLater(new GuiFinalizationWorker(args, proxySelector));
        if (Main.isPlatformWindows()) {
            try {
                PlatformHookWindows.removeInsecureCertificates();
            }
            catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
                MainApplication.error(e);
            }
        }
        if (RemoteControl.PROP_REMOTECONTROL_ENABLED.get().booleanValue()) {
            RemoteControl.start();
        }
        if (MessageNotifier.PROP_NOTIFIER_ENABLED.get().booleanValue()) {
            MessageNotifier.start();
        }
        if (Main.pref.getBoolean("debug.edt-checker.enable", Version.getInstance().isLocalBuild())) {
            MainApplication.info("Enabled EDT checker, wrongful access to gui from non EDT thread will be printed to console");
            RepaintManager.setCurrentManager(new CheckThreadViolationRepaintManager());
        }
    }

    private static void handleSpecialLanguages() {
        if ("km".equals(Main.pref.get("language"))) {
            List<String> fonts = Arrays.asList(GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames());
            for (String f : new String[]{"Khmer UI", "DaunPenh", "MoolBoran"}) {
                if (!fonts.contains(f)) continue;
                GuiHelper.setUIFont(f);
                break;
            }
        }
    }

    private static void processOffline(Map<Option, Collection<String>> args) {
        if (args.containsKey((Object)Option.OFFLINE)) {
            for (String s : args.get((Object)Option.OFFLINE).iterator().next().split(",")) {
                try {
                    Main.setOffline(OnlineResource.valueOf(s.toUpperCase()));
                }
                catch (IllegalArgumentException e) {
                    Main.error(I18n.tr("''{0}'' is not a valid value for argument ''{1}''. Possible values are {2}, possibly delimited by commas.", s.toUpperCase(), Option.OFFLINE.getName(), Arrays.toString((Object[])OnlineResource.values())));
                    System.exit(1);
                    return;
                }
            }
            Set<OnlineResource> offline = Main.getOfflineResources();
            if (!offline.isEmpty()) {
                Main.warn(I18n.trn("JOSM is running in offline mode. This resource will not be available: {0}", "JOSM is running in offline mode. These resources will not be available: {0}", offline.size(), offline.size() == 1 ? (Serializable)((Object)offline.iterator().next()) : Arrays.toString(offline.toArray())));
            }
        }
    }

    private static class GuiFinalizationWorker
    implements Runnable {
        private final Map<Option, Collection<String>> args;
        private final DefaultProxySelector proxySelector;

        public GuiFinalizationWorker(Map<Option, Collection<String>> args, DefaultProxySelector proxySelector) {
            this.args = args;
            this.proxySelector = proxySelector;
        }

        @Override
        public void run() {
            if (!this.handleProxyErrors()) {
                this.handleNetworkErrors();
            }
            this.handleAutosave();
            MainApplication.postConstructorProcessCmdLine(this.args);
            DownloadDialog.autostartIfNeeded();
        }

        private void handleAutosave() {
            if (AutosaveTask.PROP_AUTOSAVE_ENABLED.get().booleanValue()) {
                AutosaveTask autosaveTask = new AutosaveTask();
                List<File> unsavedLayerFiles = autosaveTask.getUnsavedLayersFiles();
                if (!unsavedLayerFiles.isEmpty()) {
                    ExtendedDialog dialog = new ExtendedDialog(Main.parent, I18n.tr("Unsaved osm data", new Object[0]), new String[]{I18n.tr("Restore", new Object[0]), I18n.tr("Cancel", new Object[0]), I18n.tr("Discard", new Object[0])});
                    dialog.setContent(I18n.trn("JOSM found {0} unsaved osm data layer. ", "JOSM found {0} unsaved osm data layers. ", unsavedLayerFiles.size(), unsavedLayerFiles.size()) + I18n.tr("It looks like JOSM crashed last time. Would you like to restore the data?", new Object[0]));
                    dialog.setButtonIcons(new String[]{"ok", "cancel", "dialogs/delete"});
                    int selection = dialog.showDialog().getValue();
                    if (selection == 1) {
                        autosaveTask.recoverUnsavedLayers();
                    } else if (selection == 3) {
                        autosaveTask.discardUnsavedLayers();
                    }
                }
                autosaveTask.schedule();
            }
        }

        private boolean handleNetworkOrProxyErrors(boolean hasErrors, String title, String message) {
            if (hasErrors) {
                ExtendedDialog ed = new ExtendedDialog(Main.parent, title, new String[]{I18n.tr("Change proxy settings", new Object[0]), I18n.tr("Cancel", new Object[0])});
                ed.setButtonIcons(new String[]{"dialogs/settings", "cancel"}).setCancelButton(2);
                ed.setMinimumSize(new Dimension(460, 260));
                ed.setIcon(2);
                ed.setContent(message);
                if (ed.showDialog().getValue() == 1) {
                    PreferencesAction.forPreferenceSubTab(null, null, ProxyPreference.class).run();
                }
            }
            return hasErrors;
        }

        private boolean handleProxyErrors() {
            return this.handleNetworkOrProxyErrors(this.proxySelector.hasErrors(), I18n.tr("Proxy errors occurred", new Object[0]), I18n.tr("JOSM tried to access the following resources:<br>{0}but <b>failed</b> to do so, because of the following proxy errors:<br>{1}Would you like to change your proxy settings now?", Utils.joinAsHtmlUnorderedList(this.proxySelector.getErrorResources()), Utils.joinAsHtmlUnorderedList(this.proxySelector.getErrorMessages())));
        }

        private boolean handleNetworkErrors() {
            boolean condition;
            boolean bl = condition = !NETWORK_ERRORS.isEmpty();
            if (condition) {
                TreeSet<String> errors = new TreeSet<String>();
                for (Throwable t : NETWORK_ERRORS.values()) {
                    errors.add(t.toString());
                }
                return this.handleNetworkOrProxyErrors(condition, I18n.tr("Network errors occurred", new Object[0]), I18n.tr("JOSM tried to access the following resources:<br>{0}but <b>failed</b> to do so, because of the following network errors:<br>{1}It may be due to a missing proxy configuration.<br>Would you like to change your proxy settings now?", Utils.joinAsHtmlUnorderedList(NETWORK_ERRORS.keySet()), Utils.joinAsHtmlUnorderedList(errors)));
            }
            return false;
        }
    }

    public static enum Option {
        HELP(false),
        VERSION(false),
        DEBUG(false),
        TRACE(false),
        LANGUAGE(true),
        RESET_PREFERENCES(false),
        LOAD_PREFERENCES(true),
        SET(true),
        GEOMETRY(true),
        NO_MAXIMIZE(false),
        MAXIMIZE(false),
        DOWNLOAD(true),
        DOWNLOADGPS(true),
        SELECTION(true),
        OFFLINE(true);

        private String name = this.name().toLowerCase().replace("_", "-");
        private boolean requiresArgument;

        private Option(boolean requiresArgument) {
            this.requiresArgument = requiresArgument;
        }

        public String getName() {
            return this.name;
        }

        public boolean requiresArgument() {
            return this.requiresArgument;
        }

        public static Map<Option, Collection<String>> fromStringMap(Map<String, Collection<String>> opts) {
            HashMap<Option, Collection<String>> res = new HashMap<Option, Collection<String>>();
            for (Map.Entry<String, Collection<String>> e : opts.entrySet()) {
                Option o = Option.valueOf(e.getKey().toUpperCase().replace("-", "_"));
                if (o == null) continue;
                res.put(o, e.getValue());
            }
            return res;
        }
    }
}

