/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui;

import java.awt.Component;
import java.text.MessageFormat;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.Preferences;
import org.openstreetmap.josm.data.osm.UserInfo;
import org.openstreetmap.josm.gui.preferences.server.OAuthAccessTokenHolder;
import org.openstreetmap.josm.gui.progress.NullProgressMonitor;
import org.openstreetmap.josm.io.OnlineResource;
import org.openstreetmap.josm.io.OsmApi;
import org.openstreetmap.josm.io.OsmServerUserInfoReader;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.io.auth.CredentialsManager;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;

public final class JosmUserIdentityManager
implements Preferences.PreferenceChangedListener {
    private static JosmUserIdentityManager instance;
    private String userName;
    private UserInfo userInfo;
    private boolean accessTokenKeyChanged;
    private boolean accessTokenSecretChanged;

    public static synchronized JosmUserIdentityManager getInstance() {
        if (instance == null) {
            instance = new JosmUserIdentityManager();
            if (OsmApi.isUsingOAuth() && OAuthAccessTokenHolder.getInstance().containsAccessToken() && !Main.isOffline(OnlineResource.OSM_API)) {
                try {
                    instance.initFromOAuth(Main.parent);
                }
                catch (Exception e) {
                    Main.error(e);
                    instance.initFromPreferences();
                }
            } else {
                instance.initFromPreferences();
            }
            Main.pref.addPreferenceChangeListener(instance);
        }
        return instance;
    }

    private JosmUserIdentityManager() {
    }

    public void setAnonymous() {
        this.userName = null;
        this.userInfo = null;
    }

    public void setPartiallyIdentified(String userName) throws IllegalArgumentException {
        CheckParameterUtil.ensureParameterNotNull(userName, "userName");
        if (userName.trim().isEmpty()) {
            throw new IllegalArgumentException(MessageFormat.format("Expected non-empty value for parameter ''{0}'', got ''{1}''", "userName", userName));
        }
        this.userName = userName;
        this.userInfo = null;
    }

    public void setFullyIdentified(String username, UserInfo userinfo) throws IllegalArgumentException {
        CheckParameterUtil.ensureParameterNotNull(username, "username");
        if (username.trim().isEmpty()) {
            throw new IllegalArgumentException(I18n.tr("Expected non-empty value for parameter ''{0}'', got ''{1}''", "userName", this.userName));
        }
        CheckParameterUtil.ensureParameterNotNull(userinfo, "userinfo");
        this.userName = username;
        this.userInfo = userinfo;
    }

    public boolean isAnonymous() {
        return this.userName == null && this.userInfo == null;
    }

    public boolean isPartiallyIdentified() {
        return this.userName != null && this.userInfo == null;
    }

    public boolean isFullyIdentified() {
        return this.userName != null && this.userInfo != null;
    }

    public String getUserName() {
        return this.userName;
    }

    public int getUserId() {
        if (this.userInfo == null) {
            return 0;
        }
        return this.userInfo.getId();
    }

    public UserInfo getUserInfo() {
        return this.userInfo;
    }

    public void initFromPreferences() {
        String userName = CredentialsManager.getInstance().getUsername();
        if (this.isAnonymous()) {
            if (userName != null && !userName.trim().isEmpty()) {
                this.setPartiallyIdentified(userName);
            }
        } else if (userName != null && !userName.equals(this.userName)) {
            this.setPartiallyIdentified(userName);
        }
    }

    public void initFromOAuth(Component parent) {
        try {
            UserInfo info = new OsmServerUserInfoReader().fetchUserInfo(NullProgressMonitor.INSTANCE);
            this.setFullyIdentified(info.getDisplayName(), info);
        }
        catch (IllegalArgumentException | OsmTransferException e) {
            Main.error(e);
        }
    }

    public boolean isCurrentUser(String username) {
        if (username == null || this.userName == null) {
            return false;
        }
        return this.userName.equals(username);
    }

    @Override
    public void preferenceChanged(Preferences.PreferenceChangeEvent evt) {
        switch (evt.getKey()) {
            case "osm-server.username": {
                String newUserName = null;
                if (evt.getNewValue() instanceof Preferences.StringSetting) {
                    newUserName = (String)((Preferences.StringSetting)evt.getNewValue()).getValue();
                }
                if (newUserName == null || newUserName.trim().isEmpty()) {
                    this.setAnonymous();
                } else if (!newUserName.equals(this.userName)) {
                    this.setPartiallyIdentified(newUserName);
                }
                return;
            }
            case "osm-server.url": {
                String newUrl = null;
                if (evt.getNewValue() instanceof Preferences.StringSetting) {
                    newUrl = (String)((Preferences.StringSetting)evt.getNewValue()).getValue();
                }
                if (newUrl == null || newUrl.trim().isEmpty()) {
                    this.setAnonymous();
                    break;
                }
                if (!this.isFullyIdentified()) break;
                this.setPartiallyIdentified(this.getUserName());
                break;
            }
            case "oauth.access-token.key": {
                this.accessTokenKeyChanged = true;
                break;
            }
            case "oauth.access-token.secret": {
                this.accessTokenSecretChanged = true;
            }
        }
        if (this.accessTokenKeyChanged && this.accessTokenSecretChanged) {
            this.accessTokenKeyChanged = false;
            this.accessTokenSecretChanged = false;
            if (OsmApi.isUsingOAuth()) {
                try {
                    JosmUserIdentityManager.getInstance().initFromOAuth(Main.parent);
                }
                catch (Exception e) {
                    Main.error(e);
                }
            }
        }
    }
}

