/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.dnd.InvalidDnDOperationException;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.TooManyListenersException;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.border.Border;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.OpenFileAction;

public class FileDrop {
    private transient Border normalBorder;
    private transient DropTargetListener dropListener;
    private static Boolean supportsDnD;
    private static Color defaultBorderColor;

    public FileDrop(Component c) {
        this(c, BorderFactory.createMatteBorder(2, 2, 2, 2, defaultBorderColor), true, new Listener(){

            @Override
            public void filesDropped(File[] files) {
                OpenFileAction.OpenFileTask task = new OpenFileAction.OpenFileTask(Arrays.asList(files), null);
                task.setRecordHistory(true);
                Main.worker.submit(task);
            }
        });
    }

    public FileDrop(final Component c, final Border dragBorder, boolean recursive, final Listener listener) {
        if (FileDrop.supportsDnD()) {
            this.dropListener = new DropTargetListener(){

                @Override
                public void dragEnter(DropTargetDragEvent evt) {
                    Main.trace("FileDrop: dragEnter event.");
                    if (FileDrop.this.isDragOk(evt)) {
                        if (c instanceof JComponent) {
                            JComponent jc = (JComponent)c;
                            FileDrop.this.normalBorder = jc.getBorder();
                            Main.trace("FileDrop: normal border saved.");
                            jc.setBorder(dragBorder);
                            Main.trace("FileDrop: drag border set.");
                        }
                        evt.acceptDrag(1);
                        Main.trace("FileDrop: event accepted.");
                    } else {
                        evt.rejectDrag();
                        Main.trace("FileDrop: event rejected.");
                    }
                }

                @Override
                public void dragOver(DropTargetDragEvent evt) {
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void drop(DropTargetDropEvent evt) {
                    Main.trace("FileDrop: drop event.");
                    try {
                        Transferable tr = evt.getTransferable();
                        if (tr.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                            evt.acceptDrop(1);
                            Main.trace("FileDrop: file list accepted.");
                            List fileList = (List)tr.getTransferData(DataFlavor.javaFileListFlavor);
                            File[] files = fileList.toArray(new File[fileList.size()]);
                            if (listener != null) {
                                listener.filesDropped(files);
                            }
                            evt.getDropTargetContext().dropComplete(true);
                            Main.trace("FileDrop: drop complete.");
                        } else {
                            DataFlavor[] flavors = tr.getTransferDataFlavors();
                            boolean handled = false;
                            for (DataFlavor flavor : flavors) {
                                if (!flavor.isRepresentationClassReader()) continue;
                                evt.acceptDrop(1);
                                Main.trace("FileDrop: reader accepted.");
                                Reader reader = flavor.getReaderForText(tr);
                                BufferedReader br = new BufferedReader(reader);
                                if (listener != null) {
                                    listener.filesDropped(FileDrop.createFileArray(br));
                                }
                                evt.getDropTargetContext().dropComplete(true);
                                Main.trace("FileDrop: drop complete.");
                                handled = true;
                                break;
                            }
                            if (!handled) {
                                Main.trace("FileDrop: not a file list or reader - abort.");
                                evt.rejectDrop();
                            }
                        }
                    }
                    catch (UnsupportedFlavorException | IOException e) {
                        Main.warn("FileDrop: " + e.getClass().getSimpleName() + " - abort:");
                        Main.error(e);
                        try {
                            evt.rejectDrop();
                        }
                        catch (InvalidDnDOperationException ex) {
                            Main.error(ex);
                        }
                    }
                    finally {
                        if (c instanceof JComponent) {
                            JComponent jc = (JComponent)c;
                            jc.setBorder(FileDrop.this.normalBorder);
                            Main.debug("FileDrop: normal border restored.");
                        }
                    }
                }

                @Override
                public void dragExit(DropTargetEvent evt) {
                    Main.debug("FileDrop: dragExit event.");
                    if (c instanceof JComponent) {
                        JComponent jc = (JComponent)c;
                        jc.setBorder(FileDrop.this.normalBorder);
                        Main.debug("FileDrop: normal border restored.");
                    }
                }

                @Override
                public void dropActionChanged(DropTargetDragEvent evt) {
                    Main.debug("FileDrop: dropActionChanged event.");
                    if (FileDrop.this.isDragOk(evt)) {
                        evt.acceptDrag(1);
                        Main.debug("FileDrop: event accepted.");
                    } else {
                        evt.rejectDrag();
                        Main.debug("FileDrop: event rejected.");
                    }
                }
            };
            this.makeDropTarget(c, recursive);
        } else {
            Main.info("FileDrop: Drag and drop is not supported with this JVM");
        }
    }

    private static synchronized boolean supportsDnD() {
        if (supportsDnD == null) {
            boolean support = false;
            try {
                Class.forName("java.awt.dnd.DnDConstants");
                support = true;
            }
            catch (Exception e) {
                support = false;
            }
            supportsDnD = support;
        }
        return supportsDnD;
    }

    private static File[] createFileArray(BufferedReader bReader) {
        try {
            ArrayList<File> list = new ArrayList<File>();
            String line = null;
            while ((line = bReader.readLine()) != null) {
                try {
                    if ("\u0000".equals(line)) continue;
                    File file = new File(new URI(line));
                    list.add(file);
                }
                catch (Exception ex) {
                    Main.warn("Error with " + line + ": " + ex.getMessage());
                }
            }
            return list.toArray(new File[list.size()]);
        }
        catch (IOException ex) {
            Main.warn("FileDrop: IOException");
            return new File[0];
        }
    }

    private void makeDropTarget(final Component c, boolean recursive) {
        DropTarget dt = new DropTarget();
        try {
            dt.addDropTargetListener(this.dropListener);
        }
        catch (TooManyListenersException e) {
            Main.error(e);
            Main.warn("FileDrop: Drop will not work due to previous error. Do you have another listener attached?");
        }
        c.addHierarchyListener(new HierarchyListener(){

            @Override
            public void hierarchyChanged(HierarchyEvent evt) {
                Main.trace("FileDrop: Hierarchy changed.");
                Container parent = c.getParent();
                if (parent == null) {
                    c.setDropTarget(null);
                    Main.trace("FileDrop: Drop target cleared from component.");
                } else {
                    new DropTarget(c, FileDrop.this.dropListener);
                    Main.trace("FileDrop: Drop target added to component.");
                }
            }
        });
        if (c.getParent() != null) {
            new DropTarget(c, this.dropListener);
        }
        if (recursive && c instanceof Container) {
            Component[] comps;
            Container cont = (Container)c;
            for (Component comp : comps = cont.getComponents()) {
                this.makeDropTarget(comp, recursive);
            }
        }
    }

    private boolean isDragOk(DropTargetDragEvent evt) {
        int i;
        boolean ok = false;
        DataFlavor[] flavors = evt.getCurrentDataFlavors();
        for (i = 0; !ok && i < flavors.length; ++i) {
            DataFlavor curFlavor = flavors[i];
            if (!curFlavor.equals(DataFlavor.javaFileListFlavor) && !curFlavor.isRepresentationClassReader()) continue;
            ok = true;
        }
        if (flavors.length == 0) {
            Main.trace("FileDrop: no data flavors.");
        }
        for (i = 0; i < flavors.length; ++i) {
            Main.trace(flavors[i].toString());
        }
        return ok;
    }

    public static boolean remove(Component c) {
        return FileDrop.remove(c, true);
    }

    public static boolean remove(Component c, boolean recursive) {
        if (FileDrop.supportsDnD()) {
            Main.trace("FileDrop: Removing drag-and-drop hooks.");
            c.setDropTarget(null);
            if (recursive && c instanceof Container) {
                for (Component comp : ((Container)c).getComponents()) {
                    FileDrop.remove(comp, recursive);
                }
                return true;
            }
            return false;
        }
        return false;
    }

    static {
        defaultBorderColor = new Color(0.0f, 0.0f, 1.0f, 0.25f);
    }

    public static interface Listener {
        public void filesDropped(File[] var1);
    }
}

