/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui;

import java.awt.ComponentOrientation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.coor.CoordinateFormat;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.Changeset;
import org.openstreetmap.josm.data.osm.IPrimitive;
import org.openstreetmap.josm.data.osm.IRelation;
import org.openstreetmap.josm.data.osm.NameFormatter;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmUtils;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.history.HistoryNameFormatter;
import org.openstreetmap.josm.data.osm.history.HistoryNode;
import org.openstreetmap.josm.data.osm.history.HistoryOsmPrimitive;
import org.openstreetmap.josm.data.osm.history.HistoryRelation;
import org.openstreetmap.josm.data.osm.history.HistoryWay;
import org.openstreetmap.josm.gui.NameFormatterHook;
import org.openstreetmap.josm.gui.tagging.TaggingPreset;
import org.openstreetmap.josm.gui.tagging.TaggingPresetNameTemplateList;
import org.openstreetmap.josm.tools.AlphanumComparator;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Utils;

public class DefaultNameFormatter
implements NameFormatter,
HistoryNameFormatter {
    private static DefaultNameFormatter instance;
    private static final List<NameFormatterHook> formatHooks;
    public static final String[] DEFAULT_NAMING_TAGS_FOR_RELATIONS;
    private static List<String> namingTagsForRelations;
    private final Comparator<Node> nodeComparator = new Comparator<Node>(){

        @Override
        public int compare(Node n1, Node n2) {
            return DefaultNameFormatter.this.format(n1).compareTo(DefaultNameFormatter.this.format(n2));
        }
    };
    private final Comparator<Way> wayComparator = new Comparator<Way>(){

        @Override
        public int compare(Way w1, Way w2) {
            return DefaultNameFormatter.this.format(w1).compareTo(DefaultNameFormatter.this.format(w2));
        }
    };
    private final Comparator<Relation> relationComparator = new Comparator<Relation>(){

        @Override
        public int compare(Relation r1, Relation r2) {
            TaggingPreset preset1 = TaggingPresetNameTemplateList.getInstance().findPresetTemplate(r1);
            TaggingPreset preset2 = TaggingPresetNameTemplateList.getInstance().findPresetTemplate(r2);
            if (preset1 != null || preset2 != null) {
                StringBuilder name1 = new StringBuilder();
                DefaultNameFormatter.this.formatRelationNameAndType(r1, name1, preset1);
                StringBuilder name2 = new StringBuilder();
                DefaultNameFormatter.this.formatRelationNameAndType(r2, name2, preset2);
                int comp = AlphanumComparator.getInstance().compare(name1.toString(), name2.toString());
                if (comp != 0) {
                    return comp;
                }
            } else {
                String type1 = DefaultNameFormatter.this.getRelationTypeName(r1);
                String type2 = DefaultNameFormatter.this.getRelationTypeName(r2);
                int comp = AlphanumComparator.getInstance().compare(type1, type2);
                if (comp != 0) {
                    return comp;
                }
                String name1 = DefaultNameFormatter.this.getRelationName(r1);
                String name2 = DefaultNameFormatter.this.getRelationName(r2);
                comp = AlphanumComparator.getInstance().compare(name1, name2);
                if (comp != 0) {
                    return comp;
                }
            }
            if (r1.getMembersCount() != r2.getMembersCount()) {
                return r1.getMembersCount() > r2.getMembersCount() ? 1 : -1;
            }
            int comp = Boolean.valueOf(r1.hasIncompleteMembers()).compareTo(r2.hasIncompleteMembers());
            if (comp != 0) {
                return comp;
            }
            if (r1.getUniqueId() > r2.getUniqueId()) {
                return 1;
            }
            if (r1.getUniqueId() < r2.getUniqueId()) {
                return -1;
            }
            return 0;
        }
    };

    public static synchronized DefaultNameFormatter getInstance() {
        if (instance == null) {
            instance = new DefaultNameFormatter();
        }
        return instance;
    }

    public static void registerFormatHook(NameFormatterHook hook) {
        if (hook == null) {
            return;
        }
        if (!formatHooks.contains(hook)) {
            formatHooks.add(0, hook);
        }
    }

    public static void unregisterFormatHook(NameFormatterHook hook) {
        if (hook == null) {
            return;
        }
        if (formatHooks.contains(hook)) {
            formatHooks.remove(hook);
        }
    }

    public static synchronized List<String> getNamingtagsForRelations() {
        if (namingTagsForRelations == null) {
            namingTagsForRelations = new ArrayList<String>(Main.pref.getCollection("relation.nameOrder", Arrays.asList(DEFAULT_NAMING_TAGS_FOR_RELATIONS)));
        }
        return namingTagsForRelations;
    }

    protected void decorateNameWithId(StringBuilder name, IPrimitive primitive) {
        if (Main.pref.getBoolean("osm-primitives.showid")) {
            if (Main.pref.getBoolean("osm-primitives.showid.new-primitives")) {
                name.append(I18n.tr(" [id: {0}]", primitive.getUniqueId()));
            } else {
                name.append(I18n.tr(" [id: {0}]", primitive.getId()));
            }
        }
    }

    @Override
    public String format(Node node) {
        StringBuilder name = new StringBuilder();
        if (node.isIncomplete()) {
            name.append(I18n.tr("incomplete", new Object[0]));
        } else {
            TaggingPreset preset = TaggingPresetNameTemplateList.getInstance().findPresetTemplate(node);
            if (preset == null) {
                String n = Main.pref.getBoolean("osm-primitives.localize-name", true) ? node.getLocalName() : node.getName();
                if (n == null) {
                    String s = node.get("addr:housename");
                    if (s != null) {
                        n = I18n.tr("House {0}", s);
                    }
                    if (n == null && (s = node.get("addr:housenumber")) != null) {
                        String t = node.get("addr:street");
                        n = t != null ? I18n.tr("House number {0} at {1}", s, t) : I18n.tr("House number {0}", s);
                    }
                }
                if (n == null) {
                    n = node.isNew() ? I18n.tr("node", new Object[0]) : Long.toString(node.getId());
                }
                name.append(n);
            } else {
                preset.nameTemplate.appendText(name, node);
            }
            if (node.getCoor() != null) {
                name.append(" \u200e(").append(node.getCoor().latToString(CoordinateFormat.getDefaultFormat())).append(", ").append(node.getCoor().lonToString(CoordinateFormat.getDefaultFormat())).append(")");
            }
        }
        this.decorateNameWithId(name, node);
        String result = name.toString();
        for (NameFormatterHook hook : formatHooks) {
            String hookResult = hook.checkFormat(node, result);
            if (hookResult == null) continue;
            return hookResult;
        }
        return result;
    }

    @Override
    public Comparator<Node> getNodeComparator() {
        return this.nodeComparator;
    }

    @Override
    public String format(Way way) {
        StringBuilder name = new StringBuilder();
        char mark = '\u0000';
        mark = ComponentOrientation.getOrientation(Locale.getDefault()).isLeftToRight() ? (char)'\u200e' : '\u200f';
        name.append(mark);
        if (way.isIncomplete()) {
            name.append(I18n.tr("incomplete", new Object[0]));
        } else {
            TaggingPreset preset = TaggingPresetNameTemplateList.getInstance().findPresetTemplate(way);
            if (preset == null) {
                String n = Main.pref.getBoolean("osm-primitives.localize-name", true) ? way.getLocalName() : way.getName();
                if (n == null) {
                    n = way.get("ref");
                }
                if (n == null) {
                    String string = way.get("highway") != null ? I18n.tr("highway", new Object[0]) : (way.get("railway") != null ? I18n.tr("railway", new Object[0]) : (way.get("waterway") != null ? I18n.tr("waterway", new Object[0]) : (n = way.get("landuse") != null ? I18n.tr("landuse", new Object[0]) : null)));
                }
                if (n == null) {
                    String s = way.get("addr:housename");
                    if (s != null) {
                        n = I18n.tr("House {0}", s);
                    }
                    if (n == null && (s = way.get("addr:housenumber")) != null) {
                        String t = way.get("addr:street");
                        n = t != null ? I18n.tr("House number {0} at {1}", s, t) : I18n.tr("House number {0}", s);
                    }
                }
                if (n == null && way.get("building") != null) {
                    n = I18n.tr("building", new Object[0]);
                }
                if (n == null || n.length() == 0) {
                    n = String.valueOf(way.getId());
                }
                name.append(n);
            } else {
                preset.nameTemplate.appendText(name, way);
            }
            int nodesNo = way.getRealNodesCount();
            String nodes = I18n.trn("{0} node", "{0} nodes", nodesNo, nodesNo);
            name.append(mark).append(" (").append(nodes).append(")");
        }
        this.decorateNameWithId(name, way);
        String result = name.toString();
        for (NameFormatterHook hook : formatHooks) {
            String hookResult = hook.checkFormat(way, result);
            if (hookResult == null) continue;
            return hookResult;
        }
        return result;
    }

    @Override
    public Comparator<Way> getWayComparator() {
        return this.wayComparator;
    }

    @Override
    public String format(Relation relation) {
        StringBuilder name = new StringBuilder();
        if (relation.isIncomplete()) {
            name.append(I18n.tr("incomplete", new Object[0]));
        } else {
            TaggingPreset preset = TaggingPresetNameTemplateList.getInstance().findPresetTemplate(relation);
            this.formatRelationNameAndType(relation, name, preset);
            int mbno = relation.getMembersCount();
            name.append(I18n.trn("{0} member", "{0} members", mbno, mbno));
            if (relation.hasIncompleteMembers()) {
                name.append(", ").append(I18n.tr("incomplete", new Object[0]));
            }
            name.append(")");
        }
        this.decorateNameWithId(name, relation);
        String result = name.toString();
        for (NameFormatterHook hook : formatHooks) {
            String hookResult = hook.checkFormat(relation, result);
            if (hookResult == null) continue;
            return hookResult;
        }
        return result;
    }

    private void formatRelationNameAndType(Relation relation, StringBuilder result, TaggingPreset preset) {
        if (preset == null) {
            result.append(this.getRelationTypeName(relation));
            String relationName = this.getRelationName(relation);
            relationName = relationName == null ? Long.toString(relation.getId()) : "\"" + relationName + "\"";
            result.append(" (").append(relationName).append(", ");
        } else {
            preset.nameTemplate.appendText(result, relation);
            result.append("(");
        }
    }

    @Override
    public Comparator<Relation> getRelationComparator() {
        return this.relationComparator;
    }

    private String getRelationTypeName(IRelation relation) {
        String admin_level;
        String name = I18n.trc("Relation type", relation.get("type"));
        if (name == null) {
            String string = name = relation.get("public_transport") != null ? I18n.tr("public transport", new Object[0]) : null;
        }
        if (name == null) {
            String building = relation.get("building");
            if (OsmUtils.isTrue(building)) {
                name = I18n.tr("building", new Object[0]);
            } else if (building != null) {
                name = I18n.tr(building, new Object[0]);
            }
        }
        if (name == null) {
            name = I18n.trc("Place type", relation.get("place"));
        }
        if (name == null) {
            name = I18n.tr("relation", new Object[0]);
        }
        if ((admin_level = relation.get("admin_level")) != null) {
            name = name + "[" + admin_level + "]";
        }
        for (NameFormatterHook hook : formatHooks) {
            String hookResult = hook.checkRelationTypeName(relation, name);
            if (hookResult == null) continue;
            return hookResult;
        }
        return name;
    }

    private String getNameTagValue(IRelation relation, String nameTag) {
        if ("name".equals(nameTag)) {
            if (Main.pref.getBoolean("osm-primitives.localize-name", true)) {
                return relation.getLocalName();
            }
            return relation.getName();
        }
        if (":LocationCode".equals(nameTag)) {
            for (String m : relation.keySet()) {
                if (!m.endsWith(nameTag)) continue;
                return relation.get(m);
            }
            return null;
        }
        if (nameTag.startsWith("?") && OsmUtils.isTrue(relation.get(nameTag.substring(1)))) {
            return I18n.tr(nameTag.substring(1), new Object[0]);
        }
        if (nameTag.startsWith("?") && OsmUtils.isFalse(relation.get(nameTag.substring(1)))) {
            return null;
        }
        if (nameTag.startsWith("?")) {
            return I18n.trc_lazy(nameTag, I18n.escape(relation.get(nameTag.substring(1))));
        }
        return I18n.trc_lazy(nameTag, I18n.escape(relation.get(nameTag)));
    }

    private String getRelationName(IRelation relation) {
        String nameTag = null;
        for (String n : DefaultNameFormatter.getNamingtagsForRelations()) {
            nameTag = this.getNameTagValue(relation, n);
            if (nameTag == null) continue;
            return nameTag;
        }
        return null;
    }

    @Override
    public String format(Changeset changeset) {
        return I18n.tr("Changeset {0}", changeset.getId());
    }

    public String buildDefaultToolTip(IPrimitive primitive) {
        return this.buildDefaultToolTip(primitive.getId(), primitive.getKeys());
    }

    private String buildDefaultToolTip(long id, Map<String, String> tags) {
        StringBuilder sb = new StringBuilder();
        sb.append("<html>");
        sb.append("<strong>id</strong>=").append(id).append("<br>");
        ArrayList<String> keyList = new ArrayList<String>(tags.keySet());
        Collections.sort(keyList);
        for (int i = 0; i < keyList.size(); ++i) {
            if (i > 0) {
                sb.append("<br>");
            }
            String key = (String)keyList.get(i);
            sb.append("<strong>").append(key).append("</strong>").append("=");
            String value = tags.get(key);
            while (value.length() != 0) {
                sb.append(value.substring(0, Math.min(50, value.length())));
                if (value.length() > 50) {
                    sb.append("<br>");
                    value = value.substring(50);
                    continue;
                }
                value = "";
            }
        }
        sb.append("</html>");
        return sb.toString();
    }

    protected void decorateNameWithId(StringBuilder name, HistoryOsmPrimitive primitive) {
        if (Main.pref.getBoolean("osm-primitives.showid")) {
            name.append(I18n.tr(" [id: {0}]", primitive.getId()));
        }
    }

    @Override
    public String format(HistoryNode node) {
        StringBuilder sb = new StringBuilder();
        String name = Main.pref.getBoolean("osm-primitives.localize-name", true) ? node.getLocalName() : node.getName();
        if (name == null) {
            sb.append(node.getId());
        } else {
            sb.append(name);
        }
        LatLon coord = node.getCoords();
        if (coord != null) {
            sb.append(" (").append(coord.latToString(CoordinateFormat.getDefaultFormat())).append(", ").append(coord.lonToString(CoordinateFormat.getDefaultFormat())).append(")");
        }
        this.decorateNameWithId(sb, node);
        return sb.toString();
    }

    @Override
    public String format(HistoryWay way) {
        StringBuilder sb = new StringBuilder();
        String name = Main.pref.getBoolean("osm-primitives.localize-name", true) ? way.getLocalName() : way.getName();
        if (name != null) {
            sb.append(name);
        }
        if (sb.length() == 0 && way.get("ref") != null) {
            sb.append(way.get("ref"));
        }
        if (sb.length() == 0) {
            sb.append(way.get("highway") != null ? I18n.tr("highway", new Object[0]) : (way.get("railway") != null ? I18n.tr("railway", new Object[0]) : (way.get("waterway") != null ? I18n.tr("waterway", new Object[0]) : (way.get("landuse") != null ? I18n.tr("landuse", new Object[0]) : ""))));
        }
        int nodesNo = way.isClosed() ? way.getNumNodes() - 1 : way.getNumNodes();
        String nodes = I18n.trn("{0} node", "{0} nodes", nodesNo, nodesNo);
        if (sb.length() == 0) {
            sb.append(way.getId());
        }
        sb.append(sb.length() > 0 ? " (" + nodes + ")" : nodes);
        this.decorateNameWithId(sb, way);
        return sb.toString();
    }

    @Override
    public String format(HistoryRelation relation) {
        StringBuilder sb = new StringBuilder();
        if (relation.get("type") != null) {
            sb.append(relation.get("type"));
        } else {
            sb.append(I18n.tr("relation", new Object[0]));
        }
        sb.append(" (");
        String nameTag = null;
        HashSet<String> namingTags = new HashSet<String>(DefaultNameFormatter.getNamingtagsForRelations());
        for (String n : relation.getTags().keySet()) {
            if (namingTags.contains(n.trim()) && (nameTag = Main.pref.getBoolean("osm-primitives.localize-name", true) ? relation.getLocalName() : relation.getName()) == null) {
                nameTag = relation.get(n);
            }
            if (nameTag == null) continue;
            break;
        }
        if (nameTag == null) {
            sb.append(Long.toString(relation.getId())).append(", ");
        } else {
            sb.append("\"").append(nameTag).append("\", ");
        }
        int mbno = relation.getNumMembers();
        sb.append(I18n.trn("{0} member", "{0} members", mbno, mbno)).append(")");
        this.decorateNameWithId(sb, relation);
        return sb.toString();
    }

    public String buildDefaultToolTip(HistoryOsmPrimitive primitive) {
        return this.buildDefaultToolTip(primitive.getId(), primitive.getTags());
    }

    public String formatAsHtmlUnorderedList(Collection<? extends OsmPrimitive> primitives) {
        return Utils.joinAsHtmlUnorderedList(Utils.transform(primitives, new Utils.Function<OsmPrimitive, String>(){

            @Override
            public String apply(OsmPrimitive x) {
                return x.getDisplayName(DefaultNameFormatter.this);
            }
        }));
    }

    public String formatAsHtmlUnorderedList(OsmPrimitive ... primitives) {
        return this.formatAsHtmlUnorderedList(Arrays.asList(primitives));
    }

    static {
        formatHooks = new LinkedList<NameFormatterHook>();
        DEFAULT_NAMING_TAGS_FOR_RELATIONS = new String[]{"name", "ref", "restriction", "landuse", "natural", "public_transport", ":LocationCode", "note", "?building"};
        namingTagsForRelations = null;
    }
}

