/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.ButtonGroup;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.widgets.JMultilineLabel;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Utils;

public final class ConditionalOptionPaneUtil {
    public static final int DIALOG_DISABLED_OPTION = Integer.MIN_VALUE;
    protected static final Map<String, Integer> sessionChoices = new HashMap<String, Integer>();
    protected static final Map<String, Integer> immediateChoices = new HashMap<String, Integer>();
    protected static final Set<String> immediateActive = new HashSet<String>();

    public static int getDialogReturnValue(String prefKey) {
        return Utils.firstNonNull(immediateChoices.get(prefKey), sessionChoices.get(prefKey), !Main.pref.getBoolean("message." + prefKey, true) ? Main.pref.getInteger("message." + prefKey + ".value", -1) : -1);
    }

    public static void startBulkOperation(String prefKey) {
        immediateActive.add(prefKey);
    }

    public static boolean isInBulkOperation(String prefKey) {
        return immediateActive.contains(prefKey);
    }

    public static void endBulkOperation(String prefKey) {
        immediateActive.remove(prefKey);
        immediateChoices.remove(prefKey);
    }

    public static int showOptionDialog(String preferenceKey, Component parent, Object message, String title, int optionType, int messageType, Object[] options, Object defaultOption) throws HeadlessException {
        int ret = ConditionalOptionPaneUtil.getDialogReturnValue(preferenceKey);
        if (ConditionalOptionPaneUtil.isYesOrNo(ret)) {
            return ret;
        }
        MessagePanel pnl = new MessagePanel(message, ConditionalOptionPaneUtil.isInBulkOperation(preferenceKey));
        ret = JOptionPane.showOptionDialog(parent, pnl, title, optionType, messageType, null, options, defaultOption);
        if (ConditionalOptionPaneUtil.isYesOrNo(ret)) {
            pnl.getNotShowAgain().store(preferenceKey, ret);
        }
        return ret;
    }

    public static boolean showConfirmationDialog(String preferenceKey, Component parent, Object message, String title, int optionType, int messageType, int trueOption) throws HeadlessException {
        int ret = ConditionalOptionPaneUtil.getDialogReturnValue(preferenceKey);
        if (ConditionalOptionPaneUtil.isYesOrNo(ret)) {
            return ret == trueOption;
        }
        MessagePanel pnl = new MessagePanel(message, ConditionalOptionPaneUtil.isInBulkOperation(preferenceKey));
        ret = JOptionPane.showConfirmDialog(parent, pnl, title, optionType, messageType);
        if (ConditionalOptionPaneUtil.isYesOrNo(ret)) {
            pnl.getNotShowAgain().store(preferenceKey, ret);
        }
        return ret == trueOption;
    }

    private static boolean isYesOrNo(int returnCode) {
        return returnCode == 0 || returnCode == 1;
    }

    public static void showMessageDialog(String preferenceKey, Component parent, Object message, String title, int messageType) {
        if (ConditionalOptionPaneUtil.getDialogReturnValue(preferenceKey) == Integer.MAX_VALUE) {
            return;
        }
        MessagePanel pnl = new MessagePanel(message, ConditionalOptionPaneUtil.isInBulkOperation(preferenceKey));
        JOptionPane.showMessageDialog(parent, pnl, title, messageType);
        pnl.getNotShowAgain().store(preferenceKey, Integer.MAX_VALUE);
    }

    static class MessagePanel
    extends JPanel {
        private final ButtonGroup group = new ButtonGroup();
        private final JRadioButton cbShowPermanentDialog = new JRadioButton(NotShowAgain.PERMANENT.getLabel());
        private final JRadioButton cbShowSessionDialog = new JRadioButton(NotShowAgain.SESSION.getLabel());
        private final JRadioButton cbShowImmediateDialog = new JRadioButton(NotShowAgain.OPERATION.getLabel());
        private final JRadioButton cbStandard = new JRadioButton(NotShowAgain.NO.getLabel());

        public MessagePanel(Object message, boolean displayImmediateOption) {
            this.cbStandard.setSelected(true);
            this.group.add(this.cbShowPermanentDialog);
            this.group.add(this.cbShowSessionDialog);
            this.group.add(this.cbShowImmediateDialog);
            this.group.add(this.cbStandard);
            this.setLayout(new GridBagLayout());
            if (message instanceof Component) {
                this.add((Component)message, GBC.eop());
            } else if (message != null) {
                this.add((Component)new JMultilineLabel(message.toString()), GBC.eop());
            }
            this.add((Component)this.cbShowPermanentDialog, GBC.eol());
            this.add((Component)this.cbShowSessionDialog, GBC.eol());
            if (displayImmediateOption) {
                this.add((Component)this.cbShowImmediateDialog, GBC.eol());
            }
            this.add((Component)this.cbStandard, GBC.eol());
        }

        NotShowAgain getNotShowAgain() {
            return this.cbStandard.isSelected() ? NotShowAgain.NO : (this.cbShowImmediateDialog.isSelected() ? NotShowAgain.OPERATION : (this.cbShowSessionDialog.isSelected() ? NotShowAgain.SESSION : (this.cbShowPermanentDialog.isSelected() ? NotShowAgain.PERMANENT : null)));
        }
    }

    static enum NotShowAgain {
        NO,
        OPERATION,
        SESSION,
        PERMANENT;


        void store(String prefKey, Integer value) {
            switch (this) {
                case NO: {
                    break;
                }
                case OPERATION: {
                    immediateChoices.put(prefKey, value);
                    break;
                }
                case SESSION: {
                    sessionChoices.put(prefKey, value);
                    break;
                }
                case PERMANENT: {
                    Main.pref.put("message." + prefKey, false);
                    Main.pref.putInteger("message." + prefKey + ".value", value);
                }
            }
        }

        String getLabel() {
            switch (this) {
                case NO: {
                    return I18n.tr("Show this dialog again the next time", new Object[0]);
                }
                case OPERATION: {
                    return I18n.tr("Do not show again (this operation)", new Object[0]);
                }
                case SESSION: {
                    return I18n.tr("Do not show again (this session)", new Object[0]);
                }
                case PERMANENT: {
                    return I18n.tr("Do not show again (remembers choice)", new Object[0]);
                }
            }
            throw new IllegalStateException();
        }
    }
}

