/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.validation.util;

import java.util.Collection;
import javax.swing.Icon;
import javax.swing.JLabel;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.validation.util.NameVisitor;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class MultipleNameVisitor
extends NameVisitor {
    public static final int MULTIPLE_NAME_MAX_LENGTH = 80;
    private String multipleClassname;
    private String displayName;
    private int size;

    public void visit(Collection<? extends OsmPrimitive> data) {
        StringBuilder multipleName = new StringBuilder();
        String multiplePluralClassname = null;
        this.size = data.size();
        this.multipleClassname = null;
        for (OsmPrimitive osmPrimitive : data) {
            String name = osmPrimitive.get("name");
            if (name == null) {
                name = osmPrimitive.get("ref");
            }
            if (name != null && !name.isEmpty() && multipleName.length() <= 80) {
                if (multipleName.length() > 0) {
                    multipleName.append(", ");
                }
                multipleName.append(name);
            }
            osmPrimitive.accept(this);
            if (this.multipleClassname == null) {
                this.multipleClassname = this.className;
                multiplePluralClassname = this.classNamePlural;
                continue;
            }
            if (this.multipleClassname.equals(this.className)) continue;
            this.multipleClassname = "object";
            multiplePluralClassname = I18n.trn("object", "objects", 2L, new Object[0]);
        }
        if (this.size <= 1) {
            this.displayName = this.name;
        } else {
            this.displayName = this.size + " " + I18n.trn(this.multipleClassname, multiplePluralClassname, this.size, new Object[0]);
            if (multipleName.length() > 0) {
                this.displayName = multipleName.length() <= 80 ? this.displayName + ": " + multipleName : this.displayName + ": " + multipleName.substring(0, 80) + "...";
            }
        }
    }

    @Override
    public JLabel toLabel() {
        return new JLabel(this.getText(), this.getIcon(), 0);
    }

    public String getText() {
        return this.displayName;
    }

    public Icon getIcon() {
        if (this.size <= 1) {
            return this.icon;
        }
        return ImageProvider.get("data", this.multipleClassname);
    }

    public String toString() {
        return this.getText();
    }
}

