/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.validation.util;

import java.util.Collection;
import java.util.HashSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.visitor.AbstractVisitor;

public class AggregatePrimitivesVisitor
extends AbstractVisitor {
    final Collection<OsmPrimitive> aggregatedData = new HashSet<OsmPrimitive>();

    public Collection<OsmPrimitive> visit(Collection<OsmPrimitive> data) {
        for (OsmPrimitive osm : data) {
            osm.accept(this);
        }
        return this.aggregatedData;
    }

    @Override
    public void visit(Node n) {
        if (!this.aggregatedData.contains(n)) {
            this.aggregatedData.add(n);
        }
    }

    @Override
    public void visit(Way w) {
        if (!this.aggregatedData.contains(w)) {
            this.aggregatedData.add(w);
            for (Node n : w.getNodes()) {
                this.visit(n);
            }
        }
    }

    @Override
    public void visit(Relation r) {
        if (!this.aggregatedData.contains(r)) {
            this.aggregatedData.add(r);
            for (RelationMember m : r.getMembers()) {
                m.getMember().accept(this);
            }
        }
    }
}

