/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.validation.tests;

import java.util.Arrays;
import java.util.List;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.validation.Severity;
import org.openstreetmap.josm.data.validation.Test;
import org.openstreetmap.josm.data.validation.TestError;
import org.openstreetmap.josm.gui.mappaint.ElemStyles;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Predicates;
import org.openstreetmap.josm.tools.Utils;

public class WayConnectedToArea
extends Test {
    public WayConnectedToArea() {
        super(I18n.tr("Way connected to Area", new Object[0]), I18n.tr("Checks for ways connected to areas.", new Object[0]));
    }

    @Override
    public void visit(Way w) {
        if (!w.isUsable() || w.isClosed() || !w.hasKey("highway")) {
            return;
        }
        boolean hasway = false;
        List<OsmPrimitive> r = w.firstNode().getReferrers();
        for (OsmPrimitive p : r) {
            if (p == w || !p.hasKey("highway")) continue;
            hasway = true;
            break;
        }
        if (!hasway) {
            for (OsmPrimitive p : r) {
                this.testForError(w, w.firstNode(), p);
            }
        }
        hasway = false;
        r = w.lastNode().getReferrers();
        for (OsmPrimitive p : r) {
            if (p == w || !p.hasKey("highway")) continue;
            hasway = true;
            break;
        }
        if (!hasway) {
            for (OsmPrimitive p : r) {
                this.testForError(w, w.lastNode(), p);
            }
        }
    }

    private void testForError(Way w, Node wayNode, OsmPrimitive p) {
        if (wayNode.isOutsideDownloadArea()) {
            return;
        }
        if (Utils.exists(wayNode.getReferrers(), Predicates.hasTag("route", "ferry"))) {
            return;
        }
        if (this.isArea(p)) {
            this.addPossibleError(w, wayNode, p, p);
        } else {
            for (OsmPrimitive r : p.getReferrers()) {
                if (!(r instanceof Relation) || !r.hasTag("type", "multipolygon") || !this.isArea(r)) continue;
                this.addPossibleError(w, wayNode, p, r);
                break;
            }
        }
    }

    private boolean isArea(OsmPrimitive p) {
        return (p.hasKey("landuse") || p.hasKey("natural")) && ElemStyles.hasAreaElemStyle(p, false);
    }

    private void addPossibleError(Way w, Node wayNode, OsmPrimitive p, OsmPrimitive area) {
        if (w.hasKey("highway") && wayNode.hasTag("leisure", "slipway") && area.hasTag("natural", "water")) {
            return;
        }
        this.errors.add(new TestError(this, Severity.WARNING, I18n.tr("Way terminates on Area", new Object[0]), 2301, Arrays.asList(w, p), Arrays.asList(wayNode)));
    }
}

