/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.validation.tests;

import java.text.MessageFormat;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.DeleteCommand;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.validation.Severity;
import org.openstreetmap.josm.data.validation.Test;
import org.openstreetmap.josm.data.validation.TestError;
import org.openstreetmap.josm.gui.tagging.TaggingPreset;
import org.openstreetmap.josm.gui.tagging.TaggingPresetItem;
import org.openstreetmap.josm.gui.tagging.TaggingPresetItems;
import org.openstreetmap.josm.gui.tagging.TaggingPresetType;
import org.openstreetmap.josm.gui.tagging.TaggingPresets;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Utils;

public class RelationChecker
extends Test {
    protected static final int ROLE_UNKNOWN = 1701;
    protected static final int ROLE_EMPTY = 1702;
    protected static final int WRONG_TYPE = 1703;
    protected static final int HIGH_COUNT = 1704;
    protected static final int LOW_COUNT = 1705;
    protected static final int ROLE_MISSING = 1706;
    protected static final int RELATION_UNKNOWN = 1707;
    protected static final int RELATION_EMPTY = 1708;
    public static final String ROLE_VERIF_PROBLEM_MSG = I18n.tr("Role verification problem", new Object[0]);
    private static Collection<TaggingPreset> relationpresets = new LinkedList<TaggingPreset>();

    public RelationChecker() {
        super(I18n.tr("Relation checker", new Object[0]), I18n.tr("Checks for errors in relations.", new Object[0]));
    }

    @Override
    public void initialize() {
        RelationChecker.initializePresets();
    }

    public static synchronized void initializePresets() {
        if (!relationpresets.isEmpty()) {
            return;
        }
        block0: for (TaggingPreset p : TaggingPresets.getTaggingPresets()) {
            for (TaggingPresetItem i : p.data) {
                if (!(i instanceof TaggingPresetItems.Roles)) continue;
                relationpresets.add(p);
                continue block0;
            }
        }
    }

    @Override
    public void visit(Relation n) {
        Map<String, RolePreset> allroles = this.buildAllRoles(n);
        if (allroles.isEmpty() && n.hasTag("type", "route") && n.hasTag("route", "train", "subway", "monorail", "tram", "bus", "trolleybus", "aerialway", "ferry")) {
            this.errors.add(new TestError((Test)this, Severity.WARNING, I18n.tr("Route scheme is unspecified. Add {0} ({1}=public_transport; {2}=legacy)", "public_transport:version", "2", "1"), 1707, n));
        } else if (allroles.isEmpty()) {
            this.errors.add(new TestError((Test)this, Severity.WARNING, I18n.tr("Relation type is unknown", new Object[0]), 1707, n));
        }
        Map<String, RoleInfo> map = this.buildRoleInfoMap(n);
        if (map.isEmpty()) {
            this.errors.add(new TestError((Test)this, Severity.ERROR, I18n.tr("Relation is empty", new Object[0]), 1708, n));
        } else if (!allroles.isEmpty()) {
            this.checkRoles(n, allroles, map);
        }
    }

    private Map<String, RoleInfo> buildRoleInfoMap(Relation n) {
        HashMap<String, RoleInfo> map = new HashMap<String, RoleInfo>();
        for (RelationMember m : n.getMembers()) {
            String role = m.getRole();
            RoleInfo ri = (RoleInfo)map.get(role);
            if (ri == null) {
                ri = new RoleInfo();
                map.put(role, ri);
            }
            ri.total++;
        }
        return map;
    }

    private Map<String, RolePreset> buildAllRoles(Relation n) {
        HashMap<String, RolePreset> allroles = new HashMap<String, RolePreset>();
        for (TaggingPreset p : relationpresets) {
            boolean matches = true;
            TaggingPresetItems.Roles r = null;
            for (TaggingPresetItem i : p.data) {
                if (i instanceof TaggingPresetItems.Key) {
                    TaggingPresetItems.Key k = (TaggingPresetItems.Key)i;
                    if (k.value.equals(n.get(k.key))) continue;
                    matches = false;
                    break;
                }
                if (!(i instanceof TaggingPresetItems.Roles)) continue;
                r = (TaggingPresetItems.Roles)i;
            }
            if (!matches || r == null) continue;
            for (TaggingPresetItems.Role role : r.roles) {
                String key = role.key;
                LinkedList roleGroup = null;
                if (allroles.containsKey(key)) {
                    roleGroup = ((RolePreset)allroles.get(key)).roles;
                } else {
                    roleGroup = new LinkedList();
                    allroles.put(key, new RolePreset(roleGroup, p.name));
                }
                roleGroup.add(role);
            }
        }
        return allroles;
    }

    private boolean checkMemberType(TaggingPresetItems.Role r, RelationMember member) {
        if (r.types != null) {
            switch (member.getDisplayType()) {
                case NODE: {
                    return r.types.contains((Object)TaggingPresetType.NODE);
                }
                case CLOSEDWAY: {
                    return r.types.contains((Object)TaggingPresetType.CLOSEDWAY);
                }
                case WAY: {
                    return r.types.contains((Object)TaggingPresetType.WAY);
                }
                case MULTIPOLYGON: 
                case RELATION: {
                    return r.types.contains((Object)TaggingPresetType.RELATION);
                }
            }
            return false;
        }
        return true;
    }

    private boolean checkMemberExpressionAndType(RolePreset rolePreset, RelationMember member, Relation n) {
        TestError possibleMatchError = null;
        if (rolePreset == null || rolePreset.roles == null) {
            return true;
        }
        for (TaggingPresetItems.Role r : rolePreset.roles) {
            if (!this.checkMemberType(r, member)) continue;
            if (r.memberExpression == null) {
                return true;
            }
            OsmPrimitive primitive = member.getMember();
            if (!primitive.isUsable()) {
                return true;
            }
            if (r.memberExpression.match(primitive)) {
                return true;
            }
            String s = I18n.marktr("Role member does not match expression {0} in template {1}");
            possibleMatchError = new TestError((Test)this, Severity.WARNING, ROLE_VERIF_PROBLEM_MSG, I18n.tr(s, r.memberExpression, rolePreset.name), s, 1703, member.getMember().isUsable() ? member.getMember() : n);
        }
        if (possibleMatchError != null) {
            this.errors.add(possibleMatchError);
        } else {
            String s = I18n.marktr("Role member type {0} does not match accepted list of {1} in template {2}");
            EnumSet<TaggingPresetType> types = EnumSet.noneOf(TaggingPresetType.class);
            for (TaggingPresetItems.Role r : rolePreset.roles) {
                types.addAll(r.types);
            }
            String typesStr = Utils.join("/", Utils.transform(types, new Utils.Function<TaggingPresetType, Object>(){

                @Override
                public Object apply(TaggingPresetType x) {
                    return I18n.tr(x.getName(), new Object[0]);
                }
            }));
            this.errors.add(new TestError((Test)this, Severity.WARNING, ROLE_VERIF_PROBLEM_MSG, I18n.tr(s, new Object[]{member.getType(), typesStr, rolePreset.name}), s, 1703, member.getMember().isUsable() ? member.getMember() : n));
        }
        return false;
    }

    private void checkRoles(Relation n, Map<String, RolePreset> allroles, Map<String, RoleInfo> map) {
        for (RelationMember member : n.getMembers()) {
            String role = member.getRole();
            this.checkMemberExpressionAndType(allroles.get(role), member, n);
        }
        for (RolePreset rp : allroles.values()) {
            for (TaggingPresetItems.Role r : rp.roles) {
                String keyname = r.key;
                if (keyname.isEmpty()) {
                    keyname = I18n.tr("<empty>", new Object[0]);
                }
                this.checkRoleCounts(n, r, keyname, map.get(r.key));
            }
        }
        for (String key : map.keySet()) {
            String s;
            if (allroles.containsKey(key)) continue;
            String templates = Utils.join("/", Utils.transform(allroles.keySet(), new Utils.Function<String, Object>(){

                @Override
                public Object apply(String x) {
                    return I18n.tr(x, new Object[0]);
                }
            }));
            if (key.length() > 0) {
                s = I18n.marktr("Role {0} unknown in templates {1}");
                this.errors.add(new TestError((Test)this, Severity.WARNING, ROLE_VERIF_PROBLEM_MSG, I18n.tr(s, key, templates.toString()), MessageFormat.format(s, key), 1701, n));
                continue;
            }
            s = I18n.marktr("Empty role type found when expecting one of {0}");
            this.errors.add(new TestError((Test)this, Severity.WARNING, ROLE_VERIF_PROBLEM_MSG, I18n.tr(s, templates), s, 1702, n));
        }
    }

    private void checkRoleCounts(Relation n, TaggingPresetItems.Role r, String keyname, RoleInfo ri) {
        long vc;
        long count = ri == null ? 0L : (long)ri.total;
        if (count != (vc = r.getValidCount(count))) {
            if (count == 0L) {
                String s = I18n.marktr("Role {0} missing");
                this.errors.add(new TestError((Test)this, Severity.WARNING, ROLE_VERIF_PROBLEM_MSG, I18n.tr(s, keyname), MessageFormat.format(s, keyname), 1706, n));
            } else if (vc > count) {
                String s = I18n.marktr("Number of {0} roles too low ({1})");
                this.errors.add(new TestError((Test)this, Severity.WARNING, ROLE_VERIF_PROBLEM_MSG, I18n.tr(s, keyname, count), MessageFormat.format(s, keyname, count), 1705, n));
            } else {
                String s = I18n.marktr("Number of {0} roles too high ({1})");
                this.errors.add(new TestError((Test)this, Severity.WARNING, ROLE_VERIF_PROBLEM_MSG, I18n.tr(s, keyname, count), MessageFormat.format(s, keyname, count), 1704, n));
            }
        }
    }

    @Override
    public Command fixError(TestError testError) {
        if (this.isFixable(testError)) {
            return new DeleteCommand(testError.getPrimitives());
        }
        return null;
    }

    @Override
    public boolean isFixable(TestError testError) {
        Collection<? extends OsmPrimitive> primitives = testError.getPrimitives();
        return testError.getCode() == 1708 && !primitives.isEmpty() && primitives.iterator().next().isNew();
    }

    private static class RoleInfo {
        private int total = 0;

        private RoleInfo() {
        }
    }

    private static class RolePreset {
        private final LinkedList<TaggingPresetItems.Role> roles;
        private final String name;

        public RolePreset(LinkedList<TaggingPresetItems.Role> roles, String name) {
            this.roles = roles;
            this.name = name;
        }
    }
}

