/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.validation.tests;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.command.ChangePropertyCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.visitor.paint.relations.Multipolygon;
import org.openstreetmap.josm.data.osm.visitor.paint.relations.MultipolygonCache;
import org.openstreetmap.josm.data.validation.Severity;
import org.openstreetmap.josm.data.validation.Test;
import org.openstreetmap.josm.data.validation.TestError;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.tools.Geometry;
import org.openstreetmap.josm.tools.I18n;

public class PowerLines
extends Test {
    protected static final int POWER_LINES = 2501;
    public static final Collection<String> POWER_LINE_TAGS = Arrays.asList("line", "minor_line");
    public static final Collection<String> POWER_TOWER_TAGS = Arrays.asList("tower", "pole");
    public static final Collection<String> POWER_STATION_TAGS = Arrays.asList("station", "sub_station", "substation", "plant", "generator");
    public static final Collection<String> POWER_ALLOWED_TAGS = Arrays.asList("switch", "transformer", "busbar", "generator", "switchgear");
    private final Map<Way, String> towerPoleTagMap = new HashMap<Way, String>();
    private final List<PowerLineError> potentialErrors = new ArrayList<PowerLineError>();
    private final List<OsmPrimitive> powerStations = new ArrayList<OsmPrimitive>();

    public PowerLines() {
        super(I18n.tr("Power lines", new Object[0]), I18n.tr("Checks for nodes in power lines that do not have a power=tower/pole tag.", new Object[0]));
    }

    @Override
    public void visit(Way w) {
        if (w.isUsable()) {
            if (PowerLines.isPowerLine(w) && !w.hasTag("location", "underground")) {
                String fixValue = null;
                boolean erroneous = false;
                boolean canFix = false;
                for (Node n : w.getNodes()) {
                    if (!PowerLines.isPowerTower(n)) {
                        if (PowerLines.isPowerAllowed(n) || w.isFirstLastNode(n) && PowerLines.isPowerStation(n)) continue;
                        this.potentialErrors.add(new PowerLineError(n, w));
                        erroneous = true;
                        continue;
                    }
                    if (fixValue == null) {
                        fixValue = n.get("power");
                        canFix = true;
                        continue;
                    }
                    if (fixValue.equals(n.get("power"))) continue;
                    canFix = false;
                }
                if (erroneous && canFix) {
                    this.towerPoleTagMap.put(w, fixValue);
                }
            } else if (w.isClosed() && PowerLines.isPowerStation(w)) {
                this.powerStations.add(w);
            }
        }
    }

    @Override
    public void visit(Relation r) {
        if (r.isMultipolygon() && PowerLines.isPowerStation(r)) {
            this.powerStations.add(r);
        }
    }

    @Override
    public void startTest(ProgressMonitor progressMonitor) {
        super.startTest(progressMonitor);
        this.towerPoleTagMap.clear();
        this.powerStations.clear();
        this.potentialErrors.clear();
    }

    @Override
    public void endTest() {
        for (PowerLineError e : this.potentialErrors) {
            Node n = e.getNode();
            if (n == null || this.isInPowerStation(n)) continue;
            this.errors.add(e);
        }
        this.potentialErrors.clear();
        super.endTest();
    }

    protected final boolean isInPowerStation(Node n) {
        for (OsmPrimitive station : this.powerStations) {
            Multipolygon polygon;
            ArrayList<List<Node>> nodesLists = new ArrayList<List<Node>>();
            if (station instanceof Way) {
                nodesLists.add(((Way)station).getNodes());
            } else if (station instanceof Relation && (polygon = MultipolygonCache.getInstance().get(Main.map.mapView, (Relation)station)) != null) {
                for (Multipolygon.JoinedWay outer : Multipolygon.joinWays(polygon.getOuterWays())) {
                    nodesLists.add(outer.getNodes());
                }
            }
            for (List list : nodesLists) {
                if (!Geometry.nodeInsidePolygon(n, list)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public Command fixError(TestError testError) {
        Iterator<? extends OsmPrimitive> it;
        if (testError instanceof PowerLineError && this.isFixable(testError) && (it = testError.getPrimitives().iterator()).hasNext()) {
            return new ChangePropertyCommand(it.next(), "power", this.towerPoleTagMap.get(((PowerLineError)testError).line));
        }
        return null;
    }

    @Override
    public boolean isFixable(TestError testError) {
        return testError instanceof PowerLineError && this.towerPoleTagMap.containsKey(((PowerLineError)testError).line);
    }

    protected static final boolean isPowerLine(Way w) {
        return PowerLines.isPowerIn(w, POWER_LINE_TAGS);
    }

    protected static final boolean isPowerStation(OsmPrimitive p) {
        return PowerLines.isPowerIn(p, POWER_STATION_TAGS);
    }

    protected static final boolean isPowerTower(Node n) {
        return PowerLines.isPowerIn(n, POWER_TOWER_TAGS);
    }

    protected static final boolean isPowerAllowed(Node n) {
        return PowerLines.isPowerIn(n, POWER_ALLOWED_TAGS);
    }

    private static final boolean isPowerIn(OsmPrimitive p, Collection<String> values) {
        String v = p.get("power");
        return v != null && values != null && values.contains(v);
    }

    protected class PowerLineError
    extends TestError {
        private final Way line;

        public PowerLineError(Node n, Way line) {
            super((Test)PowerLines.this, Severity.WARNING, I18n.tr("Missing power tower/pole within power line", new Object[0]), 2501, n);
            this.line = line;
        }

        public final Node getNode() {
            Iterator<? extends OsmPrimitive> it = this.getPrimitives().iterator();
            return it.hasNext() ? (Node)it.next() : null;
        }
    }
}

