/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.validation.tests;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmUtils;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.WaySegment;
import org.openstreetmap.josm.data.preferences.CollectionProperty;
import org.openstreetmap.josm.data.validation.Severity;
import org.openstreetmap.josm.data.validation.Test;
import org.openstreetmap.josm.data.validation.TestError;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.MultiMap;
import org.openstreetmap.josm.tools.Pair;
import org.openstreetmap.josm.tools.Predicates;
import org.openstreetmap.josm.tools.Utils;

public class OverlappingWays
extends Test {
    private MultiMap<Pair<Node, Node>, WaySegment> nodePairs;
    protected static final int OVERLAPPING_HIGHWAY = 101;
    protected static final int OVERLAPPING_RAILWAY = 102;
    protected static final int OVERLAPPING_WAY = 103;
    protected static final int OVERLAPPING_HIGHWAY_AREA = 111;
    protected static final int OVERLAPPING_RAILWAY_AREA = 112;
    protected static final int OVERLAPPING_WAY_AREA = 113;
    protected static final int OVERLAPPING_AREA = 120;
    protected static final int DUPLICATE_WAY_SEGMENT = 121;
    protected static final CollectionProperty IGNORED_KEYS = new CollectionProperty("overlapping-ways.ignored-keys", (Collection<String>)Arrays.asList("barrier", "building", "historic:building"));

    public OverlappingWays() {
        super(I18n.tr("Overlapping ways", new Object[0]), I18n.tr("This test checks that a connection between two nodes is not used by more than one way.", new Object[0]));
    }

    @Override
    public void startTest(ProgressMonitor monitor) {
        super.startTest(monitor);
        this.nodePairs = new MultiMap(1000);
    }

    private boolean parentMultipolygonConcernsArea(OsmPrimitive p) {
        for (Relation r : OsmPrimitive.getFilteredList(p.getReferrers(), Relation.class)) {
            if (!r.concernsArea()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void endTest() {
        HashMap seenWays = new HashMap(500);
        ArrayList<TestError> preliminaryErrors = new ArrayList<TestError>();
        for (Set<WaySegment> duplicated : this.nodePairs.values()) {
            int ways = duplicated.size();
            if (ways <= 1) continue;
            ArrayList<Way> prims = new ArrayList<Way>();
            ArrayList<Way> currentWays = new ArrayList<Way>();
            int highway = 0;
            int railway = 0;
            int area = 0;
            for (WaySegment ws : duplicated) {
                if (ws.way.get("highway") != null) {
                    ++highway;
                } else if (ws.way.get("railway") != null) {
                    ++railway;
                }
                Boolean ar = OsmUtils.getOsmBoolean(ws.way.get("area"));
                if (ar != null && ar.booleanValue()) {
                    ++area;
                }
                if (ws.way.concernsArea() || this.parentMultipolygonConcernsArea(ws.way)) {
                    ++area;
                    --ways;
                }
                prims.add(ws.way);
                currentWays.add(ws.way);
            }
            Collection highlight = (Collection)seenWays.get(currentWays);
            if (highlight == null) {
                int type;
                String errortype;
                if (area > 0) {
                    if (ways == 0 || duplicated.size() == area) {
                        errortype = I18n.tr("Areas share segment", new Object[0]);
                        type = 120;
                    } else if (highway == ways) {
                        errortype = I18n.tr("Highways share segment with area", new Object[0]);
                        type = 111;
                    } else if (railway == ways) {
                        errortype = I18n.tr("Railways share segment with area", new Object[0]);
                        type = 112;
                    } else {
                        errortype = I18n.tr("Ways share segment with area", new Object[0]);
                        type = 113;
                    }
                } else if (highway == ways) {
                    errortype = I18n.tr("Overlapping highways", new Object[0]);
                    type = 101;
                } else if (railway == ways) {
                    errortype = I18n.tr("Overlapping railways", new Object[0]);
                    type = 102;
                } else {
                    errortype = I18n.tr("Overlapping ways", new Object[0]);
                    type = 103;
                }
                preliminaryErrors.add(new TestError(this, type < 111 ? Severity.WARNING : Severity.OTHER, errortype, type, prims, duplicated));
                seenWays.put(currentWays, duplicated);
                continue;
            }
            for (WaySegment ws : duplicated) {
                highlight.add(ws);
            }
        }
        for (TestError error : preliminaryErrors) {
            if (!error.getSeverity().equals((Object)Severity.WARNING) && error.getHighlighted().size() / error.getPrimitives().size() < 3) continue;
            boolean ignore = false;
            Iterator i$ = IGNORED_KEYS.get().iterator();
            while (i$.hasNext()) {
                String ignoredKey = (String)i$.next();
                if (!Utils.exists(error.getPrimitives(), Predicates.hasKey(ignoredKey))) continue;
                ignore = true;
                break;
            }
            if (ignore) continue;
            this.errors.add(error);
        }
        super.endTest();
        this.nodePairs = null;
    }

    protected static Set<WaySegment> checkDuplicateWaySegment(Way w) {
        TreeSet<WaySegment> segments = new TreeSet<WaySegment>(new Comparator<WaySegment>(){

            @Override
            public int compare(WaySegment o1, WaySegment o2) {
                List<Node> n1 = Arrays.asList(o1.getFirstNode(), o1.getSecondNode());
                List<Node> n2 = Arrays.asList(o2.getFirstNode(), o2.getSecondNode());
                Collections.sort(n1);
                Collections.sort(n2);
                int first = n1.get(0).compareTo(n2.get(0));
                int second = n1.get(1).compareTo(n2.get(1));
                return first != 0 ? first : second;
            }
        });
        HashSet<WaySegment> duplicateWaySegments = new HashSet<WaySegment>();
        for (int i = 0; i < w.getNodesCount() - 1; ++i) {
            boolean wasInSet;
            WaySegment segment = new WaySegment(w, i);
            boolean bl = wasInSet = !segments.add(segment);
            if (!wasInSet) continue;
            duplicateWaySegments.add(segment);
        }
        if (duplicateWaySegments.size() > 1) {
            return duplicateWaySegments;
        }
        return null;
    }

    @Override
    public void visit(Way w) {
        Set<WaySegment> duplicateWaySegment = OverlappingWays.checkDuplicateWaySegment(w);
        if (duplicateWaySegment != null) {
            this.errors.add(new TestError(this, Severity.ERROR, I18n.tr("Way contains segment twice", new Object[0]), 121, Collections.singleton(w), duplicateWaySegment));
            return;
        }
        Node lastN = null;
        int i = -2;
        for (Node n : w.getNodes()) {
            ++i;
            if (lastN == null) {
                lastN = n;
                continue;
            }
            this.nodePairs.put(Pair.sort(new Pair<Node, Node>(lastN, n)), new WaySegment(w, i));
            lastN = n;
        }
    }
}

