/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.validation.tests;

import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.script.Invocable;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.command.ChangePropertyCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.validation.FixableTestError;
import org.openstreetmap.josm.data.validation.Severity;
import org.openstreetmap.josm.data.validation.Test;
import org.openstreetmap.josm.data.validation.TestError;
import org.openstreetmap.josm.io.CachedFile;
import org.openstreetmap.josm.tools.I18n;

public class OpeningHourTest
extends Test.TagTest {
    public static final ScriptEngine ENGINE = new ScriptEngineManager().getEngineByName("JavaScript");

    public OpeningHourTest() {
        super(I18n.tr("Opening hours syntax", new Object[0]), I18n.tr("This test checks the correct usage of the opening hours syntax.", new Object[0]));
    }

    @Override
    public void initialize() throws Exception {
        super.initialize();
        if (ENGINE != null) {
            try (InputStreamReader reader = new InputStreamReader(new CachedFile("resource://data/validator/opening_hours.js").getInputStream(), StandardCharsets.UTF_8);){
                ENGINE.eval(reader);
                ENGINE.eval("var nominatimJSON = {address: {state: 'Bayern', country_code: 'de'}};");
                ENGINE.eval("var oh = function (value, mode) { try {    var r= new opening_hours(value, nominatimJSON, mode);    r.getErrors = function() {return [];};    return r;  } catch(err) {    return {      getWarnings: function() {return [];},      getErrors: function() {return [err.toString()]}    };  }};");
            }
        } else {
            Main.warn("Unable to initialize OpeningHourTest because no JavaScript engine has been found");
        }
    }

    protected Object parse(String value, CheckMode mode) throws ScriptException, NoSuchMethodException {
        return ((Invocable)((Object)ENGINE)).invokeFunction("oh", value, mode.code);
    }

    protected List<Object> getList(Object obj) throws ScriptException, NoSuchMethodException {
        if (obj == null || "".equals(obj)) {
            return Arrays.asList(new Object[0]);
        }
        if (obj instanceof String) {
            String[] strings = ((String)obj).split("\\\\n");
            return Arrays.asList(strings);
        }
        if (obj instanceof List) {
            return (List)obj;
        }
        return this.getList(((Invocable)((Object)ENGINE)).invokeMethod(obj, "join", "\\n"));
    }

    public List<OpeningHoursTestError> checkOpeningHourSyntax(String key, String value, CheckMode mode) {
        return this.checkOpeningHourSyntax(key, value, mode, false);
    }

    public List<OpeningHoursTestError> checkOpeningHourSyntax(String key, String value, CheckMode mode, boolean ignoreOtherSeverity) {
        if (ENGINE == null || value == null || value.trim().isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<OpeningHoursTestError> errors = new ArrayList<OpeningHoursTestError>();
        try {
            Object r = this.parse(value, mode);
            String prettifiedValue = null;
            try {
                prettifiedValue = (String)((Invocable)((Object)ENGINE)).invokeMethod(r, "prettifyValue", new Object[0]);
            }
            catch (Exception e) {
                Main.debug(e.getMessage());
            }
            for (Object i : this.getList(((Invocable)((Object)ENGINE)).invokeMethod(r, "getErrors", new Object[0]))) {
                errors.add(new OpeningHoursTestError(this.getErrorMessage(key, i), Severity.ERROR, prettifiedValue));
            }
            for (Object i : this.getList(((Invocable)((Object)ENGINE)).invokeMethod(r, "getWarnings", new Object[0]))) {
                errors.add(new OpeningHoursTestError(this.getErrorMessage(key, i), Severity.WARNING, prettifiedValue));
            }
            if (!ignoreOtherSeverity && errors.isEmpty() && prettifiedValue != null && !value.equals(prettifiedValue)) {
                errors.add(new OpeningHoursTestError(I18n.tr("opening_hours value can be prettified", new Object[0]), Severity.OTHER, prettifiedValue));
            }
        }
        catch (NoSuchMethodException | ScriptException ex) {
            Main.error(ex);
        }
        return errors;
    }

    private String getErrorMessage(String key, Object o) {
        String msg = o.toString().trim().replace("Unexpected token:", I18n.tr("Unexpected token:", new Object[0])).replace("Unexpected token (school holiday parser):", I18n.tr("Unexpected token (school holiday parser):", new Object[0])).replace("Unexpected token in number range:", I18n.tr("Unexpected token in number range:", new Object[0])).replace("Unexpected token in week range:", I18n.tr("Unexpected token in week range:", new Object[0])).replace("Unexpected token in weekday range:", I18n.tr("Unexpected token in weekday range:", new Object[0])).replace("Unexpected token in month range:", I18n.tr("Unexpected token in month range:", new Object[0])).replace("Unexpected token in year range:", I18n.tr("Unexpected token in year range:", new Object[0])).replace("This means that the syntax is not valid at that point or it is currently not supported.", I18n.tr("Invalid/unsupported syntax.", new Object[0]));
        return key + " - " + msg;
    }

    public List<OpeningHoursTestError> checkOpeningHourSyntax(String key, String value) {
        return this.checkOpeningHourSyntax(key, value, "opening_hours".equals(key) ? CheckMode.TIME_RANGE : CheckMode.BOTH);
    }

    protected void check(OsmPrimitive p, String key, CheckMode mode) {
        for (OpeningHoursTestError e : this.checkOpeningHourSyntax(key, p.get(key), mode)) {
            this.errors.add(e.getTestError(p, key));
        }
    }

    @Override
    public void check(OsmPrimitive p) {
        this.check(p, "opening_hours", CheckMode.TIME_RANGE);
        this.check(p, "collection_times", CheckMode.BOTH);
        this.check(p, "service_times", CheckMode.BOTH);
    }

    public class OpeningHoursTestError {
        final Severity severity;
        final String message;
        final String prettifiedValue;

        public OpeningHoursTestError(String message, Severity severity, String prettifiedValue) {
            this.message = message;
            this.severity = severity;
            this.prettifiedValue = prettifiedValue;
        }

        public TestError getTestError(OsmPrimitive p, String key) {
            if (this.prettifiedValue == null) {
                return new TestError((Test)OpeningHourTest.this, this.severity, this.message, 2901, p);
            }
            return new FixableTestError((Test)OpeningHourTest.this, this.severity, this.message, 2901, p, (Command)new ChangePropertyCommand(p, key, this.prettifiedValue));
        }

        public String getMessage() {
            return this.message;
        }

        public String getPrettifiedValue() {
            return this.prettifiedValue;
        }

        public Severity getSeverity() {
            return this.severity;
        }

        public String toString() {
            return this.getMessage() + " => " + this.getPrettifiedValue();
        }
    }

    static enum CheckMode {
        TIME_RANGE(0),
        POINTS_IN_TIME(1),
        BOTH(2);

        final int code;

        private CheckMode(int code) {
            this.code = code;
        }
    }
}

