/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.validation.tests;

import java.util.HashSet;
import java.util.Map;
import java.util.regex.Pattern;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.validation.Severity;
import org.openstreetmap.josm.data.validation.Test;
import org.openstreetmap.josm.data.validation.TestError;
import org.openstreetmap.josm.tools.I18n;

public class NameMismatch
extends Test.TagTest {
    protected static final int NAME_MISSING = 1501;
    protected static final int NAME_TRANSLATION_MISSING = 1502;
    private static final Pattern NAME_SPLIT_PATTERN = Pattern.compile(" - ");

    public NameMismatch() {
        super(I18n.tr("Missing name:* translation", new Object[0]), I18n.tr("This test finds multilingual objects whose ''name'' attribute is not equal to some ''name:*'' attribute and not a composition of ''name:*'' attributes, e.g., Italia - Italien - Italy.", new Object[0]));
    }

    private void missingTranslation(OsmPrimitive p) {
        this.errors.add(new TestError((Test)this, Severity.OTHER, I18n.tr("A name:* translation is missing.", new Object[0]), 1502, p));
    }

    @Override
    public void check(OsmPrimitive p) {
        HashSet<String> names = new HashSet<String>();
        for (Map.Entry<String, String> entry : p.getKeys().entrySet()) {
            String n;
            if (!entry.getKey().startsWith("name:") || (n = entry.getValue()) == null) continue;
            names.add(n);
        }
        if (names.isEmpty()) {
            return;
        }
        String name = p.get("name");
        if (name == null) {
            this.errors.add(new TestError((Test)this, Severity.OTHER, I18n.tr("A name is missing, even though name:* exists.", new Object[0]), 1501, p));
            return;
        }
        if (names.contains(name)) {
            return;
        }
        String[] splitNames = NAME_SPLIT_PATTERN.split(name);
        if (splitNames.length == 1) {
            this.missingTranslation(p);
            return;
        }
        for (String n : splitNames) {
            if (names.contains(n)) continue;
            this.missingTranslation(p);
            return;
        }
    }
}

