/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.validation.tests;

import java.awt.geom.GeneralPath;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.CreateMultipolygonAction;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.visitor.paint.relations.Multipolygon;
import org.openstreetmap.josm.data.osm.visitor.paint.relations.MultipolygonCache;
import org.openstreetmap.josm.data.validation.OsmValidator;
import org.openstreetmap.josm.data.validation.Severity;
import org.openstreetmap.josm.data.validation.Test;
import org.openstreetmap.josm.data.validation.TestError;
import org.openstreetmap.josm.data.validation.tests.RelationChecker;
import org.openstreetmap.josm.data.validation.tests.UnclosedWays;
import org.openstreetmap.josm.gui.DefaultNameFormatter;
import org.openstreetmap.josm.gui.mappaint.AreaElemStyle;
import org.openstreetmap.josm.gui.mappaint.ElemStyles;
import org.openstreetmap.josm.gui.mappaint.MapPaintStyles;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Pair;

public class MultipolygonTest
extends Test {
    protected static final int WRONG_MEMBER_TYPE = 1601;
    protected static final int WRONG_MEMBER_ROLE = 1602;
    protected static final int NON_CLOSED_WAY = 1603;
    protected static final int MISSING_OUTER_WAY = 1604;
    protected static final int INNER_WAY_OUTSIDE = 1605;
    protected static final int CROSSING_WAYS = 1606;
    protected static final int OUTER_STYLE_MISMATCH = 1607;
    protected static final int INNER_STYLE_MISMATCH = 1608;
    protected static final int NOT_CLOSED = 1609;
    protected static final int NO_STYLE = 1610;
    protected static final int NO_STYLE_POLYGON = 1611;
    protected static final int OUTER_STYLE = 1613;
    private static volatile ElemStyles styles;
    private final List<List<Node>> nonClosedWays = new ArrayList<List<Node>>();
    private final Set<String> keysCheckedByAnotherTest = new HashSet<String>();

    public MultipolygonTest() {
        super(I18n.tr("Multipolygon", new Object[0]), I18n.tr("This test checks if multipolygons are valid.", new Object[0]));
    }

    @Override
    public void initialize() {
        styles = MapPaintStyles.getStyles();
    }

    @Override
    public void startTest(ProgressMonitor progressMonitor) {
        super.startTest(progressMonitor);
        this.keysCheckedByAnotherTest.clear();
        for (Test t : OsmValidator.getEnabledTests(false)) {
            if (!(t instanceof UnclosedWays)) continue;
            this.keysCheckedByAnotherTest.addAll(((UnclosedWays)t).getCheckedKeys());
            break;
        }
    }

    @Override
    public void endTest() {
        this.keysCheckedByAnotherTest.clear();
        super.endTest();
    }

    private List<List<Node>> joinWays(Collection<Way> ways) {
        ArrayList<List<Node>> result = new ArrayList<List<Node>>();
        ArrayList<Way> waysToJoin = new ArrayList<Way>();
        for (Way way : ways) {
            if (way.isClosed()) {
                result.add(way.getNodes());
                continue;
            }
            waysToJoin.add(way);
        }
        for (Multipolygon.JoinedWay jw : Multipolygon.joinWays(waysToJoin)) {
            if (!jw.isClosed()) {
                this.nonClosedWays.add(jw.getNodes());
                continue;
            }
            result.add(jw.getNodes());
        }
        return result;
    }

    private GeneralPath createPath(List<Node> nodes) {
        GeneralPath result = new GeneralPath();
        result.moveTo((float)nodes.get(0).getCoor().lat(), (float)nodes.get(0).getCoor().lon());
        for (int i = 1; i < nodes.size(); ++i) {
            Node n = nodes.get(i);
            result.lineTo((float)n.getCoor().lat(), (float)n.getCoor().lon());
        }
        return result;
    }

    private List<GeneralPath> createPolygons(List<List<Node>> joinedWays) {
        ArrayList<GeneralPath> result = new ArrayList<GeneralPath>();
        for (List<Node> way : joinedWays) {
            result.add(this.createPath(way));
        }
        return result;
    }

    private Multipolygon.PolyData.Intersection getPolygonIntersection(GeneralPath outer, List<Node> inner) {
        boolean inside = false;
        boolean outside = false;
        for (Node n : inner) {
            boolean contains = outer.contains(n.getCoor().lat(), n.getCoor().lon());
            if (!((inside |= contains) & (outside |= !contains))) continue;
            return Multipolygon.PolyData.Intersection.CROSSING;
        }
        return inside ? Multipolygon.PolyData.Intersection.INSIDE : Multipolygon.PolyData.Intersection.OUTSIDE;
    }

    @Override
    public void visit(Way w) {
        if (!w.isArea() && ElemStyles.hasOnlyAreaElemStyle(w)) {
            List<Node> nodes = w.getNodes();
            if (nodes.size() < 1) {
                return;
            }
            for (String key : this.keysCheckedByAnotherTest) {
                if (!w.hasKey(key)) continue;
                return;
            }
            this.errors.add(new TestError(this, Severity.WARNING, I18n.tr("Area style way is not closed", new Object[0]), 1609, Collections.singletonList(w), Arrays.asList(nodes.get(0), nodes.get(nodes.size() - 1))));
        }
    }

    @Override
    public void visit(Relation r) {
        this.nonClosedWays.clear();
        if (r.isMultipolygon()) {
            this.checkMembersAndRoles(r);
            Multipolygon polygon = MultipolygonCache.getInstance().get(Main.map.mapView, r);
            boolean hasOuterWay = false;
            for (RelationMember m : r.getMembers()) {
                if (!"outer".equals(m.getRole())) continue;
                hasOuterWay = true;
                break;
            }
            if (!hasOuterWay) {
                this.addError(r, new TestError((Test)this, Severity.WARNING, I18n.tr("No outer way for multipolygon", new Object[0]), 1604, r));
            }
            if (r.hasIncompleteMembers()) {
                return;
            }
            Pair<Relation, Relation> newMP = CreateMultipolygonAction.createMultipolygonRelation(r.getMemberPrimitives(Way.class), false);
            if (newMP != null) {
                for (RelationMember member : r.getMembers()) {
                    Collection<RelationMember> memberInNewMP = ((Relation)newMP.b).getMembersFor(Collections.singleton(member.getMember()));
                    if (memberInNewMP == null || memberInNewMP.isEmpty()) continue;
                    String roleInNewMP = memberInNewMP.iterator().next().getRole();
                    if (member.getRole().equals(roleInNewMP)) continue;
                    this.addError(r, new TestError(this, Severity.WARNING, RelationChecker.ROLE_VERIF_PROBLEM_MSG, I18n.tr("Role for ''{0}'' should be ''{1}''", member.getMember().getDisplayName(DefaultNameFormatter.getInstance()), roleInNewMP), MessageFormat.format("Role for ''{0}'' should be ''{1}''", member.getMember().getDisplayName(DefaultNameFormatter.getInstance()), roleInNewMP), 1602, Collections.singleton(r), Collections.singleton(member.getMember())));
                }
            }
            List<List<Node>> innerWays = this.joinWays(polygon.getInnerWays());
            List<List<Node>> outerWays = this.joinWays(polygon.getOuterWays());
            if (styles != null && !"boundary".equals(r.get("type"))) {
                boolean areaStyle;
                AreaElemStyle area = ElemStyles.getAreaElemStyle(r, false);
                boolean bl = areaStyle = area != null;
                if (area == null) {
                    Way way;
                    Iterator<Object> i$ = polygon.getOuterWays().iterator();
                    while (i$.hasNext() && (area = ElemStyles.getAreaElemStyle(way = (Way)i$.next(), true)) == null) {
                    }
                    if (area == null) {
                        this.addError(r, new TestError((Test)this, Severity.OTHER, I18n.tr("No area style for multipolygon", new Object[0]), 1610, r));
                    } else {
                        this.addError(r, new TestError((Test)this, Severity.WARNING, I18n.trn("Multipolygon relation should be tagged with area tags and not the outer way", "Multipolygon relation should be tagged with area tags and not the outer ways", polygon.getOuterWays().size(), new Object[0]), 1611, r));
                    }
                }
                if (area != null) {
                    ArrayList<OsmPrimitive> l;
                    for (Way way : polygon.getInnerWays()) {
                        AreaElemStyle areaInner = ElemStyles.getAreaElemStyle(way, false);
                        if (areaInner == null || !area.equals(areaInner)) continue;
                        l = new ArrayList<OsmPrimitive>();
                        l.add(r);
                        l.add(way);
                        this.addError(r, new TestError(this, Severity.OTHER, I18n.tr("With the currently used mappaint style the style for inner way equals the multipolygon style", new Object[0]), 1608, l, Collections.singletonList(way)));
                    }
                    for (Way way : polygon.getOuterWays()) {
                        AreaElemStyle areaOuter = ElemStyles.getAreaElemStyle(way, false);
                        if (areaOuter == null) continue;
                        l = new ArrayList();
                        l.add(r);
                        l.add(way);
                        if (!area.equals(areaOuter)) {
                            this.addError(r, new TestError(this, Severity.WARNING, !areaStyle ? I18n.tr("Style for outer way mismatches", new Object[0]) : I18n.tr("With the currently used mappaint style(s) the style for outer way mismatches polygon", new Object[0]), 1607, l, Collections.singletonList(way)));
                            continue;
                        }
                        if (!areaStyle) continue;
                        this.addError(r, new TestError(this, Severity.WARNING, I18n.tr("Area style on outer way", new Object[0]), 1613, l, Collections.singletonList(way)));
                    }
                }
            }
            LinkedList<Node> openNodes = new LinkedList<Node>();
            for (List<Node> w : this.nonClosedWays) {
                if (w.size() < 1) continue;
                openNodes.add(w.get(0));
                openNodes.add(w.get(w.size() - 1));
            }
            if (!openNodes.isEmpty()) {
                LinkedList<OsmPrimitive> primitives = new LinkedList<OsmPrimitive>();
                primitives.add(r);
                primitives.addAll(openNodes);
                Arrays.asList(openNodes, r);
                this.addError(r, new TestError(this, Severity.WARNING, I18n.tr("Multipolygon is not closed", new Object[0]), 1603, primitives, openNodes));
            }
            List<GeneralPath> outerPolygons = this.createPolygons(outerWays);
            for (List list : innerWays) {
                boolean outside = true;
                boolean crossing = false;
                List<Node> outerWay = null;
                for (int i = 0; i < outerWays.size(); ++i) {
                    GeneralPath outer = outerPolygons.get(i);
                    Multipolygon.PolyData.Intersection intersection = this.getPolygonIntersection(outer, list);
                    outside &= intersection == Multipolygon.PolyData.Intersection.OUTSIDE;
                    if (intersection != Multipolygon.PolyData.Intersection.CROSSING) continue;
                    crossing = true;
                    outerWay = outerWays.get(i);
                }
                if (!outside && !crossing) continue;
                ArrayList<List<Node>> highlights = new ArrayList<List<Node>>();
                highlights.add(list);
                if (outside) {
                    this.addError(r, new TestError(this, Severity.WARNING, I18n.tr("Multipolygon inner way is outside", new Object[0]), 1605, Collections.singletonList(r), highlights));
                    continue;
                }
                if (!crossing) continue;
                highlights.add(outerWay);
                this.addError(r, new TestError(this, Severity.WARNING, I18n.tr("Intersection between multipolygon ways", new Object[0]), 1606, Collections.singletonList(r), highlights));
            }
        }
    }

    private void checkMembersAndRoles(Relation r) {
        for (RelationMember rm : r.getMembers()) {
            if (rm.isWay()) {
                if (rm.hasRole("inner", "outer") || !rm.hasRole()) continue;
                this.addError(r, new TestError((Test)this, Severity.WARNING, I18n.tr("No useful role for multipolygon member", new Object[0]), 1602, rm.getMember()));
                continue;
            }
            if (rm.hasRole("admin_centre", "label", "subarea", "land_area")) continue;
            this.addError(r, new TestError((Test)this, Severity.WARNING, I18n.tr("Non-Way in multipolygon", new Object[0]), 1601, rm.getMember()));
        }
    }

    private void addRelationIfNeeded(TestError error, Relation r) {
        Collection<? extends OsmPrimitive> primitives = error.getPrimitives();
        if (!primitives.contains(r)) {
            for (OsmPrimitive osmPrimitive : primitives) {
                if (osmPrimitive.isIncomplete()) continue;
                return;
            }
            ArrayList<OsmPrimitive> newPrimitives = new ArrayList<OsmPrimitive>(primitives);
            newPrimitives.add(0, r);
            error.setPrimitives(newPrimitives);
        }
    }

    private void addError(Relation r, TestError error) {
        this.addRelationIfNeeded(error, r);
        this.errors.add(error);
    }
}

