/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.validation.tests;

import java.net.IDN;
import java.util.regex.Pattern;
import org.openstreetmap.josm.command.ChangePropertyCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.validation.FixableTestError;
import org.openstreetmap.josm.data.validation.Severity;
import org.openstreetmap.josm.data.validation.Test;
import org.openstreetmap.josm.data.validation.TestError;
import org.openstreetmap.josm.data.validation.routines.AbstractValidator;
import org.openstreetmap.josm.data.validation.routines.EmailValidator;
import org.openstreetmap.josm.data.validation.routines.UrlValidator;
import org.openstreetmap.josm.tools.I18n;

public class InternetTags
extends Test {
    public static final int INVALID_URL = 3301;
    public static final int INVALID_EMAIL = 3302;
    private static final Pattern ASCII_PATTERN = Pattern.compile("^\\p{ASCII}+$");
    private static String[] URL_KEYS = new String[]{"url", "source:url", "website", "contact:website", "heritage:website", "source:website"};
    private static String[] EMAIL_KEYS = new String[]{"email", "contact:email"};

    public InternetTags() {
        super(I18n.tr("Internet tags", new Object[0]), I18n.tr("Checks for errors in internet-related tags.", new Object[0]));
    }

    private boolean doTest(OsmPrimitive p, String k, String[] keys, AbstractValidator validator, int code) {
        for (String i : keys) {
            if (!i.equals(k)) continue;
            TestError error = this.validateTag(p, k, validator, code);
            if (error == null) break;
            this.errors.add(error);
            break;
        }
        return false;
    }

    public TestError validateTag(OsmPrimitive p, String k, AbstractValidator validator, int code) {
        String v;
        TestError error = this.doValidateTag(p, k, null, validator, code);
        if (error != null && !ASCII_PATTERN.matcher(v = p.get(k)).matches()) {
            try {
                String protocol = "";
                if (v.contains("://")) {
                    protocol = v.substring(0, v.indexOf("://") + 3);
                }
                String domain = !protocol.isEmpty() ? v.substring(protocol.length(), v.length()) : v;
                String ending = "";
                if (domain.contains("/")) {
                    int idx = domain.indexOf("/");
                    ending = domain.substring(idx, domain.length());
                    domain = domain.substring(0, idx);
                }
                error = this.doValidateTag(p, k, protocol + IDN.toASCII(domain) + ending, validator, code);
            }
            catch (IllegalArgumentException e) {
                error.setMessage(error.getMessage() + I18n.tr(" URL cannot be converted to ASCII: {0}", e.getMessage()));
            }
        }
        return error;
    }

    private TestError doValidateTag(OsmPrimitive p, String k, String v, AbstractValidator validator, int code) {
        String value;
        TestError error = null;
        String string = value = v != null ? v : p.get(k);
        if (!validator.isValid(value)) {
            String errMsg = validator.getErrorMessage();
            if (I18n.tr("URL contains an invalid protocol: {0}", new Object[]{null}).equals(errMsg)) {
                String proto = validator instanceof EmailValidator ? "mailto://" : "http://";
                return this.doValidateTag(p, k, proto + value, validator, code);
            }
            String msg = I18n.tr("''{0}'': {1}", k, errMsg);
            String fix = validator.getFix();
            error = fix != null ? new FixableTestError((Test)this, Severity.WARNING, msg, code, p, (Command)new ChangePropertyCommand(p, k, fix)) : new TestError((Test)this, Severity.WARNING, msg, code, p);
        }
        return error;
    }

    private void test(OsmPrimitive p) {
        for (String k : p.keySet()) {
            if (this.doTest(p, k, URL_KEYS, UrlValidator.getInstance(), 3301)) continue;
            this.doTest(p, k, EMAIL_KEYS, EmailValidator.getInstance(), 3302);
        }
    }

    @Override
    public void visit(Node n) {
        this.test(n);
    }

    @Override
    public void visit(Way w) {
        this.test(w);
    }

    @Override
    public void visit(Relation r) {
        this.test(r);
    }
}

