/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.validation.tests;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.openstreetmap.josm.command.ChangePropertyCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmUtils;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.validation.Severity;
import org.openstreetmap.josm.data.validation.Test;
import org.openstreetmap.josm.data.validation.TestError;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Predicate;
import org.openstreetmap.josm.tools.Utils;

public class Highways
extends Test {
    protected static final int WRONG_ROUNDABOUT_HIGHWAY = 2701;
    protected static final int MISSING_PEDESTRIAN_CROSSING = 2702;
    protected static final int SOURCE_MAXSPEED_UNKNOWN_COUNTRY_CODE = 2703;
    protected static final int SOURCE_MAXSPEED_UNKNOWN_CONTEXT = 2704;
    protected static final int SOURCE_MAXSPEED_CONTEXT_MISMATCH_VS_MAXSPEED = 2705;
    protected static final int SOURCE_MAXSPEED_CONTEXT_MISMATCH_VS_HIGHWAY = 2706;
    protected static final int SOURCE_WRONG_LINK = 2707;
    protected static final List<String> CLASSIFIED_HIGHWAYS = Arrays.asList("motorway", "motorway_link", "trunk", "trunk_link", "primary", "primary_link", "secondary", "secondary_link", "tertiary", "tertiary_link", "unclassified", "residential", "living_street");
    protected static final List<String> KNOWN_SOURCE_MAXSPEED_CONTEXTS = Arrays.asList("urban", "rural", "zone", "zone30", "zone:30", "nsl_single", "nsl_dual", "motorway", "trunk", "living_street", "bicycle_road");
    protected static final List<String> ISO_COUNTRIES = Arrays.asList(Locale.getISOCountries());
    boolean leftByPedestrians = false;
    boolean leftByCyclists = false;
    boolean leftByCars = false;
    int pedestrianWays = 0;
    int cyclistWays = 0;
    int carsWays = 0;

    public Highways() {
        super(I18n.tr("Highways", new Object[0]), I18n.tr("Performs semantic checks on highways.", new Object[0]));
    }

    @Override
    public void visit(Node n) {
        if (n.isUsable()) {
            if (!(n.hasTag("crossing", "no") || n.hasKey("crossing") && (n.hasTag("highway", "crossing") || n.hasTag("highway", "traffic_signals")) || !n.isReferredByWays(2))) {
                this.testMissingPedestrianCrossing(n);
            }
            if (n.hasKey("source:maxspeed")) {
                this.testSourceMaxspeed(n, false);
            }
        }
    }

    @Override
    public void visit(Way w) {
        if (w.isUsable()) {
            if (w.hasKey("highway") && CLASSIFIED_HIGHWAYS.contains(w.get("highway")) && w.hasKey("junction") && "roundabout".equals(w.get("junction"))) {
                this.testWrongRoundabout(w);
            }
            if (w.hasKey("source:maxspeed")) {
                this.testSourceMaxspeed(w, true);
            }
            this.testHighwayLink(w);
        }
    }

    private void testWrongRoundabout(Way w) {
        HashMap<String, ArrayList<Way>> map = new HashMap<String, ArrayList<Way>>();
        for (Node n : new HashSet<Node>(w.getNodes())) {
            for (Way h : Utils.filteredCollection(n.getReferrers(), Way.class)) {
                String value = h.get("highway");
                if (h == w || value == null || value.endsWith("_link")) continue;
                ArrayList<Way> list = (ArrayList<Way>)map.get(value);
                if (list == null) {
                    list = new ArrayList<Way>();
                    map.put(value, list);
                }
                list.add(h);
            }
        }
        for (String s : CLASSIFIED_HIGHWAYS) {
            List list = (List)map.get(s);
            if (list == null || list.size() < 2) continue;
            Boolean oneway1 = OsmUtils.getOsmBoolean(((Way)list.get(0)).get("oneway"));
            Boolean oneway2 = OsmUtils.getOsmBoolean(((Way)list.get(1)).get("oneway"));
            if (list.size() <= 2 && oneway1 != null && oneway2 != null && oneway1.booleanValue() && oneway2.booleanValue()) continue;
            if (w.get("highway").equals(s)) break;
            this.errors.add(new WrongRoundaboutHighway(w, s));
            break;
        }
    }

    public static boolean isHighwayLinkOkay(final Way way) {
        final String highway = way.get("highway");
        if (highway == null || !highway.endsWith("_link")) {
            return true;
        }
        HashSet<OsmPrimitive> referrers = new HashSet<OsmPrimitive>();
        if (way.isClosed()) {
            for (Node n : way.getNodes()) {
                referrers.addAll(n.getReferrers());
            }
        } else {
            referrers.addAll(way.firstNode().getReferrers());
            referrers.addAll(way.lastNode().getReferrers());
        }
        return Utils.exists(Utils.filteredCollection(referrers, Way.class), new Predicate<Way>(){

            @Override
            public boolean evaluate(Way otherWay) {
                return !way.equals(otherWay) && otherWay.hasTag("highway", highway, highway.replaceAll("_link$", ""));
            }
        });
    }

    private void testHighwayLink(Way way) {
        if (!Highways.isHighwayLinkOkay(way)) {
            this.errors.add(new TestError((Test)this, Severity.WARNING, I18n.tr("Highway link is not linked to adequate highway/link", new Object[0]), 2707, way));
        }
    }

    private void testMissingPedestrianCrossing(Node n) {
        this.leftByPedestrians = false;
        this.leftByCyclists = false;
        this.leftByCars = false;
        this.pedestrianWays = 0;
        this.cyclistWays = 0;
        this.carsWays = 0;
        for (Way w : OsmPrimitive.getFilteredList(n.getReferrers(), Way.class)) {
            String highway = w.get("highway");
            if (highway == null) continue;
            if ("footway".equals(highway) || "path".equals(highway)) {
                this.handlePedestrianWay(n, w);
                if (w.hasTag("bicycle", "yes", "designated")) {
                    this.handleCyclistWay(n, w);
                }
            } else if ("cycleway".equals(highway)) {
                this.handleCyclistWay(n, w);
                if (w.hasTag("foot", "yes", "designated")) {
                    this.handlePedestrianWay(n, w);
                }
            } else if (CLASSIFIED_HIGHWAYS.contains(highway)) {
                this.handleCarWay(n, w);
            }
            if (!this.leftByPedestrians && !this.leftByCyclists || !this.leftByCars) continue;
            this.errors.add(new TestError((Test)this, Severity.OTHER, I18n.tr("Missing pedestrian crossing information", new Object[0]), 2702, n));
            return;
        }
    }

    private void handleCarWay(Node n, Way w) {
        ++this.carsWays;
        if (!w.isFirstLastNode(n) || this.carsWays > 1) {
            this.leftByCars = true;
        }
    }

    private void handleCyclistWay(Node n, Way w) {
        ++this.cyclistWays;
        if (!w.isFirstLastNode(n) || this.cyclistWays > 1) {
            this.leftByCyclists = true;
        }
    }

    private void handlePedestrianWay(Node n, Way w) {
        ++this.pedestrianWays;
        if (!w.isFirstLastNode(n) || this.pedestrianWays > 1) {
            this.leftByPedestrians = true;
        }
    }

    private void testSourceMaxspeed(OsmPrimitive p, boolean testContextHighway) {
        String value = p.get("source:maxspeed");
        if (value.matches("[A-Z]{2}:.+")) {
            String context;
            int index = value.indexOf(58);
            String country = value.substring(0, index);
            if (!ISO_COUNTRIES.contains(country)) {
                this.errors.add(new TestError((Test)this, Severity.WARNING, I18n.tr("Unknown country code: {0}", country), 2703, p));
            }
            if (!KNOWN_SOURCE_MAXSPEED_CONTEXTS.contains(context = value.substring(index + 1))) {
                this.errors.add(new TestError((Test)this, Severity.WARNING, I18n.tr("Unknown source:maxspeed context: {0}", context), 2704, p));
            }
        }
    }

    @Override
    public boolean isFixable(TestError testError) {
        return testError instanceof WrongRoundaboutHighway;
    }

    @Override
    public Command fixError(TestError testError) {
        Iterator<? extends OsmPrimitive> it;
        if (testError instanceof WrongRoundaboutHighway && (it = testError.getPrimitives().iterator()).hasNext()) {
            return new ChangePropertyCommand(it.next(), "highway", ((WrongRoundaboutHighway)testError).correctValue);
        }
        return null;
    }

    protected class WrongRoundaboutHighway
    extends TestError {
        public final String correctValue;

        public WrongRoundaboutHighway(Way w, String key) {
            super((Test)Highways.this, Severity.WARNING, I18n.tr("Incorrect roundabout (highway: {0} instead of {1})", w.get("highway"), key), 2701, w);
            this.correctValue = key;
        }
    }
}

