/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.validation.tests;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openstreetmap.josm.command.ChangeCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.DeleteCommand;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.validation.Severity;
import org.openstreetmap.josm.data.validation.Test;
import org.openstreetmap.josm.data.validation.TestError;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.MultiMap;

public class DuplicateRelation
extends Test {
    protected static final int DUPLICATE_RELATION = 1901;
    protected static final int SAME_RELATION = 1902;
    private MultiMap<RelationPair, OsmPrimitive> relations;
    private MultiMap<List<RelationMember>, OsmPrimitive> relations_nokeys;
    private final Set<String> ignoreKeys = new HashSet<String>(OsmPrimitive.getUninterestingKeys());

    public DuplicateRelation() {
        super(I18n.tr("Duplicated relations", new Object[0]), I18n.tr("This test checks that there are no relations with same tags and same members with same roles.", new Object[0]));
    }

    @Override
    public void startTest(ProgressMonitor monitor) {
        super.startTest(monitor);
        this.relations = new MultiMap(1000);
        this.relations_nokeys = new MultiMap(1000);
    }

    @Override
    public void endTest() {
        TestError testError;
        super.endTest();
        for (Set<OsmPrimitive> duplicated : this.relations.values()) {
            if (duplicated.size() <= 1) continue;
            testError = new TestError((Test)this, Severity.ERROR, I18n.tr("Duplicated relations", new Object[0]), 1901, duplicated);
            this.errors.add(testError);
        }
        this.relations = null;
        for (Set<OsmPrimitive> duplicated : this.relations_nokeys.values()) {
            if (duplicated.size() <= 1) continue;
            testError = new TestError((Test)this, Severity.WARNING, I18n.tr("Relations with same members", new Object[0]), 1902, duplicated);
            this.errors.add(testError);
        }
        this.relations_nokeys = null;
    }

    @Override
    public void visit(Relation r) {
        if (!r.isUsable() || r.hasIncompleteMembers()) {
            return;
        }
        List<RelationMember> rMembers = r.getMembers();
        Map<String, String> rkeys = r.getKeys();
        for (String key : this.ignoreKeys) {
            rkeys.remove(key);
        }
        RelationPair rKey = new RelationPair(rMembers, rkeys);
        this.relations.put(rKey, r);
        this.relations_nokeys.put(rMembers, r);
    }

    @Override
    public Command fixError(TestError testError) {
        if (testError.getCode() == 1902) {
            return null;
        }
        Collection<? extends OsmPrimitive> sel = testError.getPrimitives();
        HashSet<Relation> relFix = new HashSet<Relation>();
        for (OsmPrimitive osmPrimitive : sel) {
            if (!(osmPrimitive instanceof Relation) || osmPrimitive.isDeleted()) continue;
            relFix.add((Relation)osmPrimitive);
        }
        if (relFix.size() < 2) {
            return null;
        }
        long idToKeep = 0L;
        Relation relationToKeep = (Relation)relFix.iterator().next();
        for (Relation w : relFix) {
            if (w.isNew() || idToKeep != 0L && w.getId() >= idToKeep) continue;
            idToKeep = w.getId();
            relationToKeep = w;
        }
        Relation relationWithRelations = null;
        List<Relation> relRef = null;
        for (Relation w : relFix) {
            List<Relation> list = OsmPrimitive.getFilteredList(w.getReferrers(), Relation.class);
            if (list.isEmpty()) continue;
            if (relationWithRelations != null) {
                throw new AssertionError((Object)"Cannot fix duplicate relations: More than one relation is member of another relation.");
            }
            relationWithRelations = w;
            relRef = list;
        }
        LinkedList<Command> commands = new LinkedList<Command>();
        if (relationWithRelations != null && relationToKeep != relationWithRelations) {
            for (Relation relation : relRef) {
                Relation newRel = new Relation(relation);
                for (int i = 0; i < newRel.getMembers().size(); ++i) {
                    RelationMember m = newRel.getMember(i);
                    if (!relationWithRelations.equals(m.getMember())) continue;
                    newRel.setMember(i, new RelationMember(m.getRole(), relationToKeep));
                }
                commands.add(new ChangeCommand(relation, newRel));
            }
        }
        relFix.remove(relationToKeep);
        commands.add(new DeleteCommand(relFix));
        return new SequenceCommand(I18n.tr("Delete duplicate relations", new Object[0]), commands);
    }

    @Override
    public boolean isFixable(TestError testError) {
        if (!(testError.getTester() instanceof DuplicateRelation) || testError.getCode() == 1902) {
            return false;
        }
        Collection<? extends OsmPrimitive> sel = testError.getPrimitives();
        HashSet<Relation> relations = new HashSet<Relation>();
        for (OsmPrimitive osmPrimitive : sel) {
            if (!(osmPrimitive instanceof Relation)) continue;
            relations.add((Relation)osmPrimitive);
        }
        if (relations.size() < 2) {
            return false;
        }
        int relationsWithRelations = 0;
        for (Relation w : relations) {
            List<Relation> rel = OsmPrimitive.getFilteredList(w.getReferrers(), Relation.class);
            if (rel.isEmpty()) continue;
            ++relationsWithRelations;
        }
        return relationsWithRelations <= 1;
    }

    private class RelationPair {
        private RelationMembers members;
        private Map<String, String> keys;

        public RelationPair(List<RelationMember> members, Map<String, String> keys) {
            this.members = new RelationMembers(members);
            this.keys = keys;
        }

        public int hashCode() {
            return this.members.hashCode() + this.keys.hashCode();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof RelationPair)) {
                return false;
            }
            RelationPair rp = (RelationPair)obj;
            return rp.members.equals(this.members) && rp.keys.equals(this.keys);
        }
    }

    private static class RelationMembers {
        private List<RelMember> members;

        public RelationMembers(List<RelationMember> members) {
            this.members = new ArrayList<RelMember>(members.size());
            for (RelationMember member : members) {
                this.members.add(new RelMember(member));
            }
        }

        public int hashCode() {
            return this.members.hashCode();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof RelationMembers)) {
                return false;
            }
            RelationMembers rm = (RelationMembers)obj;
            return rm.members.equals(this.members);
        }
    }

    public static class RelMember {
        private String role;
        private OsmPrimitiveType type;
        private Map<String, String> tags;
        private List<LatLon> coor;
        private long relId;

        public int hashCode() {
            return this.role.hashCode() + (int)this.relId + this.tags.hashCode() + this.type.hashCode() + this.coor.hashCode();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof RelMember)) {
                return false;
            }
            RelMember rm = (RelMember)obj;
            return rm.role.equals(this.role) && rm.type.equals((Object)this.type) && rm.relId == this.relId && rm.tags.equals(this.tags) && rm.coor.equals(this.coor);
        }

        public RelMember(RelationMember src) {
            OsmPrimitive r;
            this.role = src.getRole();
            this.type = src.getType();
            this.relId = 0L;
            this.coor = new ArrayList<LatLon>();
            if (src.isNode()) {
                r = src.getNode();
                this.tags = r.getKeys();
                this.coor = new ArrayList<LatLon>(1);
                this.coor.add(((Node)r).getCoor());
            }
            if (src.isWay()) {
                r = src.getWay();
                this.tags = r.getKeys();
                List<Node> wNodes = ((Way)r).getNodes();
                this.coor = new ArrayList<LatLon>(wNodes.size());
                for (Node wNode : wNodes) {
                    this.coor.add(wNode.getCoor());
                }
            }
            if (src.isRelation()) {
                r = src.getRelation();
                this.tags = r.getKeys();
                this.relId = r.getId();
                this.coor = new ArrayList<LatLon>();
            }
        }
    }
}

