/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.validation.tests;

import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.WaySegment;
import org.openstreetmap.josm.data.validation.OsmValidator;
import org.openstreetmap.josm.data.validation.Severity;
import org.openstreetmap.josm.data.validation.Test;
import org.openstreetmap.josm.data.validation.TestError;
import org.openstreetmap.josm.data.validation.util.ValUtil;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.tools.I18n;

public abstract class CrossingWays
extends Test {
    protected static final int CROSSING_WAYS = 601;
    private Map<Point2D, List<WaySegment>> cellSegments;
    private Set<WaySegment> errorSegments;
    private Map<List<Way>, List<WaySegment>> seenWays;

    public CrossingWays(String title) {
        super(title, I18n.tr("This test checks if two roads, railways, waterways or buildings crosses in the same layer, but are not connected by a node.", new Object[0]));
    }

    @Override
    public void startTest(ProgressMonitor monitor) {
        super.startTest(monitor);
        this.cellSegments = new HashMap<Point2D, List<WaySegment>>(1000);
        this.errorSegments = new HashSet<WaySegment>();
        this.seenWays = new HashMap<List<Way>, List<WaySegment>>(50);
    }

    @Override
    public void endTest() {
        super.endTest();
        this.cellSegments = null;
        this.errorSegments = null;
        this.seenWays = null;
    }

    static String getLayer(OsmPrimitive w) {
        String layer1 = w.get("layer");
        if ("0".equals(layer1)) {
            layer1 = null;
        }
        return layer1;
    }

    static boolean isCoastline(OsmPrimitive w) {
        return w.hasTag("natural", "water", "coastline") || w.hasTag("landuse", "reservoir");
    }

    static boolean isSubwayOrTram(OsmPrimitive w) {
        return w.hasTag("railway", "subway", "tram");
    }

    static boolean isProposedOrAbandoned(OsmPrimitive w) {
        return w.hasTag("highway", "proposed") || w.hasTag("railway", "proposed", "abandoned");
    }

    abstract boolean ignoreWaySegmentCombination(Way var1, Way var2);

    abstract String createMessage(Way var1, Way var2);

    @Override
    public void visit(Way w) {
        int nodesSize = w.getNodesCount();
        for (int i = 0; i < nodesSize - 1; ++i) {
            WaySegment es1 = new WaySegment(w, i);
            EastNorth en1 = es1.getFirstNode().getEastNorth();
            EastNorth en2 = es1.getSecondNode().getEastNorth();
            if (en1 == null || en2 == null) {
                Main.warn("Crossing ways test skipped " + es1);
                continue;
            }
            for (List<WaySegment> segments : this.getSegments(en1, en2)) {
                for (WaySegment es2 : segments) {
                    if (this.errorSegments.contains(es1) && this.errorSegments.contains(es2) || !es1.intersects(es2) || this.ignoreWaySegmentCombination(es1.way, es2.way)) continue;
                    List<Way> prims = Arrays.asList(es1.way, es2.way);
                    List<WaySegment> highlight = this.seenWays.get(prims);
                    if (highlight == null) {
                        highlight = new ArrayList<WaySegment>();
                        highlight.add(es1);
                        highlight.add(es2);
                        String message = this.createMessage(es1.way, es2.way);
                        this.errors.add(new TestError(this, Severity.WARNING, message, 601, prims, highlight));
                        this.seenWays.put(prims, highlight);
                        continue;
                    }
                    highlight.add(es1);
                    highlight.add(es2);
                }
                segments.add(es1);
            }
        }
    }

    public List<List<WaySegment>> getSegments(EastNorth n1, EastNorth n2) {
        ArrayList<List<WaySegment>> cells = new ArrayList<List<WaySegment>>();
        for (Point2D cell : ValUtil.getSegmentCells(n1, n2, OsmValidator.griddetail)) {
            List<WaySegment> segments = this.cellSegments.get(cell);
            if (segments == null) {
                segments = new ArrayList<WaySegment>();
                this.cellSegments.put(cell, segments);
            }
            cells.add(segments);
        }
        return cells;
    }

    public static class Barrier
    extends CrossingWays {
        public Barrier() {
            super(I18n.tr("Crossing barriers", new Object[0]));
        }

        @Override
        public boolean isPrimitiveUsable(OsmPrimitive p) {
            return super.isPrimitiveUsable(p) && p.hasKey("barrier");
        }

        @Override
        boolean ignoreWaySegmentCombination(Way w1, Way w2) {
            return !Objects.equals(Barrier.getLayer(w1), Barrier.getLayer(w2));
        }

        @Override
        String createMessage(Way w1, Way w2) {
            return I18n.tr("Crossing barriers", new Object[0]);
        }
    }

    public static class Boundaries
    extends CrossingWays {
        public Boundaries() {
            super(I18n.tr("Crossing boundaries", new Object[0]));
        }

        @Override
        public boolean isPrimitiveUsable(OsmPrimitive p) {
            return super.isPrimitiveUsable(p) && p.hasKey("boundary") && (!(p instanceof Relation) || ((Relation)p).isMultipolygon() && !((Relation)p).hasIncompleteMembers());
        }

        @Override
        boolean ignoreWaySegmentCombination(Way w1, Way w2) {
            return !Objects.equals(w1.get("boundary"), w2.get("boundary"));
        }

        @Override
        String createMessage(Way w1, Way w2) {
            return I18n.tr("Crossing boundaries", new Object[0]);
        }

        @Override
        public void visit(Relation r) {
            for (Way w : r.getMemberPrimitives(Way.class)) {
                this.visit(w);
            }
        }
    }

    public static class Ways
    extends CrossingWays {
        public Ways() {
            super(I18n.tr("Crossing ways", new Object[0]));
        }

        @Override
        public boolean isPrimitiveUsable(OsmPrimitive w) {
            return super.isPrimitiveUsable(w) && !Ways.isProposedOrAbandoned(w) && (w.hasKey("highway") || w.hasKey("waterway") || w.hasKey("railway") && !Ways.isSubwayOrTram(w) || Ways.isCoastline(w) || Ways.isBuilding(w));
        }

        @Override
        boolean ignoreWaySegmentCombination(Way w1, Way w2) {
            if (!Objects.equals(Ways.getLayer(w1), Ways.getLayer(w2))) {
                return true;
            }
            if (w1.hasKey("highway") && w2.hasKey("highway") && !Objects.equals(w1.get("level"), w2.get("level"))) {
                return true;
            }
            if (Ways.isSubwayOrTram(w2)) {
                return true;
            }
            if (Ways.isCoastline(w1) != Ways.isCoastline(w2)) {
                return true;
            }
            if (w1.hasTag("waterway", "river") && w2.hasTag("waterway", "riverbank") || w2.hasTag("waterway", "river") && w1.hasTag("waterway", "riverbank")) {
                return true;
            }
            return Ways.isProposedOrAbandoned(w2);
        }

        @Override
        String createMessage(Way w1, Way w2) {
            if (Ways.isBuilding(w1)) {
                return I18n.tr("Crossing buildings", new Object[0]);
            }
            if (w1.hasKey("waterway") && w2.hasKey("waterway")) {
                return I18n.tr("Crossing waterways", new Object[0]);
            }
            if (w1.hasKey("highway") && w2.hasKey("waterway") || w2.hasKey("highway") && w1.hasKey("waterway")) {
                return I18n.tr("Crossing waterway/highway", new Object[0]);
            }
            return I18n.tr("Crossing ways", new Object[0]);
        }
    }
}

