/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.validation.tests;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.validation.Severity;
import org.openstreetmap.josm.data.validation.Test;
import org.openstreetmap.josm.data.validation.TestError;
import org.openstreetmap.josm.data.validation.tests.OpeningHourTest;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Predicates;
import org.openstreetmap.josm.tools.Utils;

public class ConditionalKeys
extends Test.TagTest {
    final OpeningHourTest openingHourTest = new OpeningHourTest();
    static final Set<String> RESTRICTION_TYPES = new HashSet<String>(Arrays.asList("oneway", "toll", "noexit", "maxspeed", "minspeed", "maxstay", "maxweight", "maxaxleload", "maxheight", "maxwidth", "maxlength", "overtaking", "maxgcweight", "maxgcweightrating", "fee"));
    static final Set<String> RESTRICTION_VALUES = new HashSet<String>(Arrays.asList("yes", "official", "designated", "destination", "delivery", "permissive", "private", "agricultural", "forestry", "no"));
    static final Set<String> TRANSPORT_MODES = new HashSet<String>(Arrays.asList("access", "foot", "ski", "inline_skates", "ice_skates", "horse", "vehicle", "bicycle", "carriage", "trailer", "caravan", "motor_vehicle", "motorcycle", "moped", "mofa", "motorcar", "motorhome", "psv", "bus", "taxi", "tourist_bus", "goods", "hgv", "agricultural", "atv", "snowmobile"));

    public ConditionalKeys() {
        super(I18n.tr("Conditional Keys", new Object[0]), I18n.tr("Tests for the correct usage of ''*:conditional'' tags.", new Object[0]));
    }

    @Override
    public void initialize() throws Exception {
        super.initialize();
        this.openingHourTest.initialize();
    }

    public static boolean isRestrictionType(String part) {
        return RESTRICTION_TYPES.contains(part);
    }

    public static boolean isRestrictionValue(String part) {
        return RESTRICTION_VALUES.contains(part);
    }

    public static boolean isTransportationMode(String part) {
        return TRANSPORT_MODES.contains(part);
    }

    public static boolean isDirection(String part) {
        return "forward".equals(part) || "backward".equals(part);
    }

    public boolean isKeyValid(String key) {
        if (!key.endsWith(":conditional")) {
            return false;
        }
        String[] parts = key.replaceAll(":conditional", "").split(":");
        return parts.length == 3 && ConditionalKeys.isRestrictionType(parts[0]) && ConditionalKeys.isTransportationMode(parts[1]) && ConditionalKeys.isDirection(parts[2]) || parts.length == 1 && (ConditionalKeys.isRestrictionType(parts[0]) || ConditionalKeys.isTransportationMode(parts[0])) || parts.length == 2 && (ConditionalKeys.isRestrictionType(parts[0]) && (ConditionalKeys.isTransportationMode(parts[1]) || ConditionalKeys.isDirection(parts[1])) || ConditionalKeys.isTransportationMode(parts[0]) && ConditionalKeys.isDirection(parts[1]));
    }

    public boolean isValueValid(String key, String value) {
        return this.validateValue(key, value) == null;
    }

    public String validateValue(String key, String value) {
        try {
            for (ConditionalValue conditional : ConditionalValue.parse(value)) {
                if (ConditionalKeys.isTransportationMode(key.split(":")[0]) && !ConditionalKeys.isRestrictionValue(conditional.restrictionValue)) {
                    return I18n.tr("{0} is not a valid restriction value", conditional.restrictionValue);
                }
                for (String condition : conditional.conditions) {
                    List<OpeningHourTest.OpeningHoursTestError> errors;
                    if (!condition.matches(".*[0-9]:[0-9]{2}.*") || (errors = this.openingHourTest.checkOpeningHourSyntax("", condition, OpeningHourTest.CheckMode.TIME_RANGE, true)).isEmpty()) continue;
                    return errors.get(0).getMessage();
                }
            }
        }
        catch (ConditionalParsingException ex) {
            return ex.getMessage();
        }
        return null;
    }

    public List<TestError> validatePrimitive(OsmPrimitive p) {
        ArrayList<TestError> errors = new ArrayList<TestError>();
        for (String key : Utils.filter(p.keySet(), Predicates.stringMatchesPattern(Pattern.compile(".*:conditional(:.*)?$")))) {
            if (!this.isKeyValid(key)) {
                errors.add(new TestError((Test)this, Severity.WARNING, I18n.tr("Wrong syntax in {0} key", key), 3201, p));
                continue;
            }
            String value = p.get(key);
            String error = this.validateValue(key, value);
            if (error == null) continue;
            errors.add(new TestError((Test)this, Severity.WARNING, I18n.tr("Error in {0} value: {1}", key, error), 3202, p));
        }
        return errors;
    }

    @Override
    public void check(OsmPrimitive p) {
        this.errors.addAll(this.validatePrimitive(p));
    }

    public static class ConditionalValue {
        public final String restrictionValue;
        public final Collection<String> conditions;

        public ConditionalValue(String restrictionValue, Collection<String> conditions) {
            this.restrictionValue = restrictionValue;
            this.conditions = conditions;
        }

        public static List<ConditionalValue> parse(String value) throws ConditionalParsingException {
            ArrayList<ConditionalValue> r = new ArrayList<ConditionalValue>();
            Pattern part = Pattern.compile("([^@\\p{Space}][^@]*?)\\s*@\\s*(\\([^)\\p{Space}][^)]+?\\)|[^();\\p{Space}][^();]*?)\\s*");
            Matcher m = Pattern.compile("(" + part + ")(;\\s*" + part + ")*").matcher(value);
            if (!m.matches()) {
                throw new ConditionalParsingException(I18n.tr("Does not match pattern ''restriction value @ condition''", new Object[0]));
            }
            int i = 2;
            while (i + 1 <= m.groupCount() && m.group(i + 1) != null) {
                String restrictionValue = m.group(i);
                String[] conditions = m.group(i + 1).replace("(", "").replace(")", "").split("\\s+(AND|and)\\s+");
                r.add(new ConditionalValue(restrictionValue, Arrays.asList(conditions)));
                i += 3;
            }
            return r;
        }
    }

    static class ConditionalParsingException
    extends RuntimeException {
        ConditionalParsingException(String message) {
            super(message);
        }
    }
}

