/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.validation.tests;

import java.awt.geom.Area;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.command.ChangeCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.validation.Severity;
import org.openstreetmap.josm.data.validation.Test;
import org.openstreetmap.josm.data.validation.TestError;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.tools.I18n;

public class Coastlines
extends Test {
    protected static final int UNORDERED_COASTLINE = 901;
    protected static final int REVERSED_COASTLINE = 902;
    protected static final int UNCONNECTED_COASTLINE = 903;
    private List<Way> coastlines;
    private Area downloadedArea = null;

    public Coastlines() {
        super(I18n.tr("Coastlines", new Object[0]), I18n.tr("This test checks that coastlines are correct.", new Object[0]));
    }

    @Override
    public void startTest(ProgressMonitor monitor) {
        super.startTest(monitor);
        OsmDataLayer layer = Main.main.getEditLayer();
        if (layer != null) {
            this.downloadedArea = layer.data.getDataSourceArea();
        }
        this.coastlines = new LinkedList<Way>();
    }

    @Override
    public void endTest() {
        for (Way c1 : this.coastlines) {
            boolean reversed;
            List<OsmPrimitive> refs;
            Node head = c1.firstNode();
            Node tail = c1.lastNode();
            if (c1.getNodesCount() == 0 || head.equals(tail)) continue;
            int headWays = 0;
            int tailWays = 0;
            boolean headReversed = false;
            boolean tailReversed = false;
            boolean headUnordered = false;
            boolean tailUnordered = false;
            Way next = null;
            Way prev = null;
            for (Way c2 : this.coastlines) {
                if (c1 == c2) continue;
                if (c2.containsNode(head)) {
                    ++headWays;
                    next = c2;
                    if (head.equals(c2.firstNode())) {
                        headReversed = true;
                    } else if (!head.equals(c2.lastNode())) {
                        headUnordered = true;
                    }
                }
                if (!c2.containsNode(tail)) continue;
                ++tailWays;
                prev = c2;
                if (tail.equals(c2.lastNode())) {
                    tailReversed = true;
                    continue;
                }
                if (tail.equals(c2.firstNode())) continue;
                tailUnordered = true;
            }
            if (headWays == 0) {
                refs = head.getReferrers();
                for (OsmPrimitive ref : refs) {
                    if (ref == c1 || !Coastlines.isCoastline(ref)) continue;
                    ++headWays;
                    next = (Way)ref;
                    if (head.equals(next.firstNode())) {
                        headReversed = true;
                        continue;
                    }
                    if (head.equals(next.lastNode())) continue;
                    headUnordered = true;
                }
            }
            if (tailWays == 0) {
                refs = tail.getReferrers();
                for (OsmPrimitive ref : refs) {
                    if (ref == c1 || !Coastlines.isCoastline(ref)) continue;
                    ++tailWays;
                    prev = (Way)ref;
                    if (tail.equals(prev.lastNode())) {
                        tailReversed = true;
                        continue;
                    }
                    if (tail.equals(prev.firstNode())) continue;
                    tailUnordered = true;
                }
            }
            ArrayList<Way> primitives = new ArrayList<Way>();
            primitives.add(c1);
            if (headWays == 0 || tailWays == 0) {
                ArrayList<Node> highlight = new ArrayList<Node>();
                if (headWays == 0 && head.getCoor().isIn(this.downloadedArea)) {
                    highlight.add(head);
                }
                if (tailWays == 0 && tail.getCoor().isIn(this.downloadedArea)) {
                    highlight.add(tail);
                }
                if (!highlight.isEmpty()) {
                    this.errors.add(new TestError(this, Severity.ERROR, I18n.tr("Unconnected coastline", new Object[0]), 903, primitives, highlight));
                }
            }
            boolean unordered = false;
            boolean bl = reversed = headWays == 1 && headReversed && tailWays == 1 && tailReversed;
            if (headWays > 1 || tailWays > 1) {
                unordered = true;
            } else if (headUnordered || tailUnordered) {
                unordered = true;
            } else if (reversed && next == prev) {
                unordered = true;
            } else if ((headReversed || tailReversed) && headReversed != tailReversed) {
                unordered = true;
            }
            if (unordered) {
                ArrayList<Node> highlight = new ArrayList<Node>();
                if (headWays > 1 || headUnordered || headReversed || reversed) {
                    highlight.add(head);
                }
                if (tailWays > 1 || tailUnordered || tailReversed || reversed) {
                    highlight.add(tail);
                }
                this.errors.add(new TestError(this, Severity.ERROR, I18n.tr("Unordered coastline", new Object[0]), 901, primitives, highlight));
                continue;
            }
            if (!reversed) continue;
            this.errors.add(new TestError((Test)this, Severity.ERROR, I18n.tr("Reversed coastline", new Object[0]), 902, primitives));
        }
        this.coastlines = null;
        this.downloadedArea = null;
        super.endTest();
    }

    @Override
    public void visit(Way way) {
        if (!way.isUsable()) {
            return;
        }
        if (Coastlines.isCoastline(way)) {
            this.coastlines.add(way);
        }
    }

    private static boolean isCoastline(OsmPrimitive osm) {
        return osm instanceof Way && "coastline".equals(osm.get("natural"));
    }

    @Override
    public Command fixError(TestError testError) {
        Iterator<? extends OsmPrimitive> it;
        if (this.isFixable(testError) && (it = testError.getPrimitives().iterator()).hasNext()) {
            Way way = (Way)it.next();
            Way newWay = new Way(way);
            List<Node> nodesCopy = newWay.getNodes();
            Collections.reverse(nodesCopy);
            newWay.setNodes(nodesCopy);
            return new ChangeCommand(way, newWay);
        }
        return null;
    }

    @Override
    public boolean isFixable(TestError testError) {
        if (testError.getTester() instanceof Coastlines) {
            return testError.getCode() == 902;
        }
        return false;
    }
}

