/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.validation.tests;

import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.validation.Severity;
import org.openstreetmap.josm.data.validation.Test;
import org.openstreetmap.josm.data.validation.TestError;
import org.openstreetmap.josm.tools.I18n;

public class BarriersEntrances
extends Test {
    protected static final int BARRIER_ENTRANCE_WITHOUT_BARRIER = 2801;

    public BarriersEntrances() {
        super(I18n.tr("Barriers and entrances", new Object[0]), I18n.tr("Checks for errors in barriers and entrances.", new Object[0]));
    }

    @Override
    public void visit(Node n) {
        if (n.hasTag("barrier", "entrance") && !n.isOutsideDownloadArea()) {
            for (OsmPrimitive p : n.getReferrers()) {
                if (!p.hasKey("barrier")) continue;
                return;
            }
            this.errors.add(new TestError((Test)this, Severity.WARNING, I18n.tr("Barrier entrance not set on a barrier", new Object[0]), 2801, n));
        }
    }
}

