/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.validation.tests;

import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.validation.Severity;
import org.openstreetmap.josm.data.validation.Test;
import org.openstreetmap.josm.data.validation.TestError;
import org.openstreetmap.josm.gui.progress.NullProgressMonitor;
import org.openstreetmap.josm.io.Capabilities;
import org.openstreetmap.josm.io.OsmApi;
import org.openstreetmap.josm.tools.I18n;

public class ApiCapabilitiesTest
extends Test {
    private long maxNodes = -1L;

    public ApiCapabilitiesTest() {
        super(I18n.tr("API Capabilities", new Object[0]), I18n.tr("Checks for errors against API capabilities", new Object[0]));
    }

    @Override
    public void initialize() throws Exception {
        super.initialize();
        OsmApi api = OsmApi.getOsmApi();
        api.initialize(NullProgressMonitor.INSTANCE);
        Capabilities capabilities = api.getCapabilities();
        if (capabilities != null) {
            this.maxNodes = capabilities.getMaxWayNodes();
        }
    }

    @Override
    public void visit(Way w) {
        if (this.maxNodes > 1L && (long)w.getNodesCount() > this.maxNodes) {
            String message = w.isClosed() ? I18n.tr("Way contains more than {0} nodes. It should be replaced by a multipolygon", this.maxNodes) : I18n.tr("Way contains more than {0} nodes. It should be split or simplified", this.maxNodes);
            this.errors.add(new TestError((Test)this, Severity.ERROR, message, 3401, w));
        }
    }
}

