/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.validation.routines;

import org.openstreetmap.josm.data.validation.routines.AbstractValidator;
import org.openstreetmap.josm.data.validation.routines.RegexValidator;

public class InetAddressValidator
extends AbstractValidator {
    private static final InetAddressValidator VALIDATOR = new InetAddressValidator();
    private final RegexValidator ipv4Validator = new RegexValidator("^(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})$");

    public static InetAddressValidator getInstance() {
        return VALIDATOR;
    }

    @Override
    public boolean isValid(String inetAddress) {
        return this.isValidInet4Address(inetAddress);
    }

    public boolean isValidInet4Address(String inet4Address) {
        String[] groups = this.ipv4Validator.match(inet4Address);
        if (groups == null) {
            return false;
        }
        for (int i = 0; i <= 3; ++i) {
            String ipSegment = groups[i];
            if (ipSegment == null || ipSegment.length() <= 0) {
                return false;
            }
            int iIpSegment = 0;
            try {
                iIpSegment = Integer.parseInt(ipSegment);
            }
            catch (NumberFormatException e) {
                return false;
            }
            if (iIpSegment <= 255) continue;
            return false;
        }
        return true;
    }
}

