/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.validation.routines;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openstreetmap.josm.data.validation.routines.AbstractValidator;
import org.openstreetmap.josm.data.validation.routines.DomainValidator;
import org.openstreetmap.josm.data.validation.routines.InetAddressValidator;
import org.openstreetmap.josm.tools.I18n;

public class EmailValidator
extends AbstractValidator {
    private static final Pattern MATCH_ASCII_PATTERN = Pattern.compile("^\\p{ASCII}+$");
    private static final Pattern EMAIL_PATTERN = Pattern.compile("^\\s*?(.+)@(.+?)\\s*$");
    private static final Pattern IP_DOMAIN_PATTERN = Pattern.compile("^\\[(.*)\\]$");
    private static final Pattern USER_PATTERN = Pattern.compile("^\\s*(([^\\s\\p{Cntrl}\\(\\)<>@,;:'\\\\\\\"\\.\\[\\]]|')+|(\"[^\"]*\"))(\\.(([^\\s\\p{Cntrl}\\(\\)<>@,;:'\\\\\\\"\\.\\[\\]]|')+|(\"[^\"]*\")))*$");
    private final boolean allowLocal;
    private static final EmailValidator EMAIL_VALIDATOR = new EmailValidator(false);
    private static final EmailValidator EMAIL_VALIDATOR_WITH_LOCAL = new EmailValidator(true);

    public static EmailValidator getInstance() {
        return EMAIL_VALIDATOR;
    }

    public static EmailValidator getInstance(boolean allowLocal) {
        if (allowLocal) {
            return EMAIL_VALIDATOR_WITH_LOCAL;
        }
        return EMAIL_VALIDATOR;
    }

    protected EmailValidator(boolean allowLocal) {
        this.allowLocal = allowLocal;
    }

    @Override
    public boolean isValid(String email) {
        if (email == null) {
            return false;
        }
        Matcher asciiMatcher = MATCH_ASCII_PATTERN.matcher(email);
        if (!asciiMatcher.matches()) {
            this.setErrorMessage(I18n.tr("E-mail address contains non-ascii characters", new Object[0]));
            this.setFix(email.replaceAll("[^\\p{ASCII}]+", ""));
            return false;
        }
        Matcher emailMatcher = EMAIL_PATTERN.matcher(email);
        if (!emailMatcher.matches()) {
            this.setErrorMessage(I18n.tr("E-mail address is invalid", new Object[0]));
            return false;
        }
        if (email.endsWith(".")) {
            this.setErrorMessage(I18n.tr("E-mail address is invalid", new Object[0]));
            return false;
        }
        String username = emailMatcher.group(1);
        if (!this.isValidUser(username)) {
            this.setErrorMessage(I18n.tr("E-mail address contains an invalid username: {0}", username));
            return false;
        }
        String domain = emailMatcher.group(2);
        if (!this.isValidDomain(domain)) {
            this.setErrorMessage(I18n.tr("E-mail address contains an invalid domain: {0}", domain));
            return false;
        }
        return true;
    }

    protected boolean isValidDomain(String domain) {
        Matcher ipDomainMatcher = IP_DOMAIN_PATTERN.matcher(domain);
        if (ipDomainMatcher.matches()) {
            InetAddressValidator inetAddressValidator = InetAddressValidator.getInstance();
            return inetAddressValidator.isValid(ipDomainMatcher.group(1));
        }
        DomainValidator domainValidator = DomainValidator.getInstance(this.allowLocal);
        return domainValidator.isValid(domain) || domainValidator.isValidTld(domain);
    }

    protected boolean isValidUser(String user) {
        return USER_PATTERN.matcher(user).matches();
    }
}

